package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartImageScan invokes the cr.StartImageScan API synchronously
// api document: https://help.aliyun.com/api/cr/startimagescan.html
func (client *Client) StartImageScan(request *StartImageScanRequest) (response *StartImageScanResponse, err error) {
	response = CreateStartImageScanResponse()
	err = client.DoAction(request, response)
	return
}

// StartImageScanWithChan invokes the cr.StartImageScan API asynchronously
// api document: https://help.aliyun.com/api/cr/startimagescan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartImageScanWithChan(request *StartImageScanRequest) (<-chan *StartImageScanResponse, <-chan error) {
	responseChan := make(chan *StartImageScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartImageScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartImageScanWithCallback invokes the cr.StartImageScan API asynchronously
// api document: https://help.aliyun.com/api/cr/startimagescan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartImageScanWithCallback(request *StartImageScanRequest, callback func(response *StartImageScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartImageScanResponse
		var err error
		defer close(result)
		response, err = client.StartImageScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartImageScanRequest is the request struct for api StartImageScan
type StartImageScanRequest struct {
	*requests.RoaRequest
	RepoNamespace string `position:"Path" name:"RepoNamespace"`
	RepoName      string `position:"Path" name:"RepoName"`
	Tag           string `position:"Path" name:"Tag"`
}

// StartImageScanResponse is the response struct for api StartImageScan
type StartImageScanResponse struct {
	*responses.BaseResponse
}

// CreateStartImageScanRequest creates a request to invoke StartImageScan API
func CreateStartImageScanRequest() (request *StartImageScanRequest) {
	request = &StartImageScanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "StartImageScan", "/repos/[RepoNamespace]/[RepoName]/tags/[Tag]/scan", "cr", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateStartImageScanResponse creates a response to parse from StartImageScan response
func CreateStartImageScanResponse() (response *StartImageScanResponse) {
	response = &StartImageScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
