package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeReplicaInitializeProgress invokes the dds.DescribeReplicaInitializeProgress API synchronously
// api document: https://help.aliyun.com/api/dds/describereplicainitializeprogress.html
func (client *Client) DescribeReplicaInitializeProgress(request *DescribeReplicaInitializeProgressRequest) (response *DescribeReplicaInitializeProgressResponse, err error) {
	response = CreateDescribeReplicaInitializeProgressResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeReplicaInitializeProgressWithChan invokes the dds.DescribeReplicaInitializeProgress API asynchronously
// api document: https://help.aliyun.com/api/dds/describereplicainitializeprogress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeReplicaInitializeProgressWithChan(request *DescribeReplicaInitializeProgressRequest) (<-chan *DescribeReplicaInitializeProgressResponse, <-chan error) {
	responseChan := make(chan *DescribeReplicaInitializeProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeReplicaInitializeProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeReplicaInitializeProgressWithCallback invokes the dds.DescribeReplicaInitializeProgress API asynchronously
// api document: https://help.aliyun.com/api/dds/describereplicainitializeprogress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeReplicaInitializeProgressWithCallback(request *DescribeReplicaInitializeProgressRequest, callback func(response *DescribeReplicaInitializeProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeReplicaInitializeProgressResponse
		var err error
		defer close(result)
		response, err = client.DescribeReplicaInitializeProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeReplicaInitializeProgressRequest is the request struct for api DescribeReplicaInitializeProgress
type DescribeReplicaInitializeProgressRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	ReplicaId            string           `position:"Query" name:"ReplicaId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeReplicaInitializeProgressResponse is the response struct for api DescribeReplicaInitializeProgress
type DescribeReplicaInitializeProgressResponse struct {
	*responses.BaseResponse
	RequestId string                                         `json:"RequestId" xml:"RequestId"`
	Items     []ItemsItemInDescribeReplicaInitializeProgress `json:"Items" xml:"Items"`
}

// CreateDescribeReplicaInitializeProgressRequest creates a request to invoke DescribeReplicaInitializeProgress API
func CreateDescribeReplicaInitializeProgressRequest() (request *DescribeReplicaInitializeProgressRequest) {
	request = &DescribeReplicaInitializeProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DescribeReplicaInitializeProgress", "dds", "openAPI")
	return
}

// CreateDescribeReplicaInitializeProgressResponse creates a response to parse from DescribeReplicaInitializeProgress response
func CreateDescribeReplicaInitializeProgressResponse() (response *DescribeReplicaInitializeProgressResponse) {
	response = &DescribeReplicaInitializeProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
