package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRdsList invokes the drds.DescribeRdsList API synchronously
// api document: https://help.aliyun.com/api/drds/describerdslist.html
func (client *Client) DescribeRdsList(request *DescribeRdsListRequest) (response *DescribeRdsListResponse, err error) {
	response = CreateDescribeRdsListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRdsListWithChan invokes the drds.DescribeRdsList API asynchronously
// api document: https://help.aliyun.com/api/drds/describerdslist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRdsListWithChan(request *DescribeRdsListRequest) (<-chan *DescribeRdsListResponse, <-chan error) {
	responseChan := make(chan *DescribeRdsListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRdsList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRdsListWithCallback invokes the drds.DescribeRdsList API asynchronously
// api document: https://help.aliyun.com/api/drds/describerdslist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRdsListWithCallback(request *DescribeRdsListRequest, callback func(response *DescribeRdsListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRdsListResponse
		var err error
		defer close(result)
		response, err = client.DescribeRdsList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRdsListRequest is the request struct for api DescribeRdsList
type DescribeRdsListRequest struct {
	*requests.RpcRequest
	DbName         string `position:"Query" name:"DbName"`
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
}

// DescribeRdsListResponse is the response struct for api DescribeRdsList
type DescribeRdsListResponse struct {
	*responses.BaseResponse
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Success   bool                  `json:"Success" xml:"Success"`
	Data      DataInDescribeRdsList `json:"Data" xml:"Data"`
}

// CreateDescribeRdsListRequest creates a request to invoke DescribeRdsList API
func CreateDescribeRdsListRequest() (request *DescribeRdsListRequest) {
	request = &DescribeRdsListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2017-10-16", "DescribeRdsList", "", "")
	return
}

// CreateDescribeRdsListResponse creates a response to parse from DescribeRdsList response
func CreateDescribeRdsListResponse() (response *DescribeRdsListResponse) {
	response = &DescribeRdsListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
