package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAlertDingDingGroups invokes the emr.DeleteAlertDingDingGroups API synchronously
// api document: https://help.aliyun.com/api/emr/deletealertdingdinggroups.html
func (client *Client) DeleteAlertDingDingGroups(request *DeleteAlertDingDingGroupsRequest) (response *DeleteAlertDingDingGroupsResponse, err error) {
	response = CreateDeleteAlertDingDingGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAlertDingDingGroupsWithChan invokes the emr.DeleteAlertDingDingGroups API asynchronously
// api document: https://help.aliyun.com/api/emr/deletealertdingdinggroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAlertDingDingGroupsWithChan(request *DeleteAlertDingDingGroupsRequest) (<-chan *DeleteAlertDingDingGroupsResponse, <-chan error) {
	responseChan := make(chan *DeleteAlertDingDingGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAlertDingDingGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAlertDingDingGroupsWithCallback invokes the emr.DeleteAlertDingDingGroups API asynchronously
// api document: https://help.aliyun.com/api/emr/deletealertdingdinggroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAlertDingDingGroupsWithCallback(request *DeleteAlertDingDingGroupsRequest, callback func(response *DeleteAlertDingDingGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAlertDingDingGroupsResponse
		var err error
		defer close(result)
		response, err = client.DeleteAlertDingDingGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAlertDingDingGroupsRequest is the request struct for api DeleteAlertDingDingGroups
type DeleteAlertDingDingGroupsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Ids             string           `position:"Query" name:"Ids"`
}

// DeleteAlertDingDingGroupsResponse is the response struct for api DeleteAlertDingDingGroups
type DeleteAlertDingDingGroupsResponse struct {
	*responses.BaseResponse
	Done bool `json:"Done" xml:"Done"`
}

// CreateDeleteAlertDingDingGroupsRequest creates a request to invoke DeleteAlertDingDingGroups API
func CreateDeleteAlertDingDingGroupsRequest() (request *DeleteAlertDingDingGroupsRequest) {
	request = &DeleteAlertDingDingGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteAlertDingDingGroups", "emr", "openAPI")
	return
}

// CreateDeleteAlertDingDingGroupsResponse creates a response to parse from DeleteAlertDingDingGroups response
func CreateDeleteAlertDingDingGroupsResponse() (response *DeleteAlertDingDingGroupsResponse) {
	response = &DeleteAlertDingDingGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
