package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQueueSubmissionStatisticInfo invokes the emr.GetQueueSubmissionStatisticInfo API synchronously
// api document: https://help.aliyun.com/api/emr/getqueuesubmissionstatisticinfo.html
func (client *Client) GetQueueSubmissionStatisticInfo(request *GetQueueSubmissionStatisticInfoRequest) (response *GetQueueSubmissionStatisticInfoResponse, err error) {
	response = CreateGetQueueSubmissionStatisticInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetQueueSubmissionStatisticInfoWithChan invokes the emr.GetQueueSubmissionStatisticInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getqueuesubmissionstatisticinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetQueueSubmissionStatisticInfoWithChan(request *GetQueueSubmissionStatisticInfoRequest) (<-chan *GetQueueSubmissionStatisticInfoResponse, <-chan error) {
	responseChan := make(chan *GetQueueSubmissionStatisticInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQueueSubmissionStatisticInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQueueSubmissionStatisticInfoWithCallback invokes the emr.GetQueueSubmissionStatisticInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getqueuesubmissionstatisticinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetQueueSubmissionStatisticInfoWithCallback(request *GetQueueSubmissionStatisticInfoRequest, callback func(response *GetQueueSubmissionStatisticInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQueueSubmissionStatisticInfoResponse
		var err error
		defer close(result)
		response, err = client.GetQueueSubmissionStatisticInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQueueSubmissionStatisticInfoRequest is the request struct for api GetQueueSubmissionStatisticInfo
type GetQueueSubmissionStatisticInfoRequest struct {
	*requests.RpcRequest
	FromDatetime    string           `position:"Query" name:"FromDatetime"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ToDatetime      string           `position:"Query" name:"ToDatetime"`
	ApplicationType string           `position:"Query" name:"ApplicationType"`
	FinalStatus     string           `position:"Query" name:"FinalStatus"`
}

// GetQueueSubmissionStatisticInfoResponse is the response struct for api GetQueueSubmissionStatisticInfo
type GetQueueSubmissionStatisticInfoResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	QueueSubmissionList QueueSubmissionList `json:"QueueSubmissionList" xml:"QueueSubmissionList"`
}

// CreateGetQueueSubmissionStatisticInfoRequest creates a request to invoke GetQueueSubmissionStatisticInfo API
func CreateGetQueueSubmissionStatisticInfoRequest() (request *GetQueueSubmissionStatisticInfoRequest) {
	request = &GetQueueSubmissionStatisticInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetQueueSubmissionStatisticInfo", "emr", "openAPI")
	return
}

// CreateGetQueueSubmissionStatisticInfoResponse creates a response to parse from GetQueueSubmissionStatisticInfo response
func CreateGetQueueSubmissionStatisticInfoResponse() (response *GetQueueSubmissionStatisticInfoResponse) {
	response = &GetQueueSubmissionStatisticInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
