package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterServiceCustomActionSupportConfig invokes the emr.ListClusterServiceCustomActionSupportConfig API synchronously
// api document: https://help.aliyun.com/api/emr/listclusterservicecustomactionsupportconfig.html
func (client *Client) ListClusterServiceCustomActionSupportConfig(request *ListClusterServiceCustomActionSupportConfigRequest) (response *ListClusterServiceCustomActionSupportConfigResponse, err error) {
	response = CreateListClusterServiceCustomActionSupportConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterServiceCustomActionSupportConfigWithChan invokes the emr.ListClusterServiceCustomActionSupportConfig API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusterservicecustomactionsupportconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterServiceCustomActionSupportConfigWithChan(request *ListClusterServiceCustomActionSupportConfigRequest) (<-chan *ListClusterServiceCustomActionSupportConfigResponse, <-chan error) {
	responseChan := make(chan *ListClusterServiceCustomActionSupportConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterServiceCustomActionSupportConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterServiceCustomActionSupportConfigWithCallback invokes the emr.ListClusterServiceCustomActionSupportConfig API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusterservicecustomactionsupportconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterServiceCustomActionSupportConfigWithCallback(request *ListClusterServiceCustomActionSupportConfigRequest, callback func(response *ListClusterServiceCustomActionSupportConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterServiceCustomActionSupportConfigResponse
		var err error
		defer close(result)
		response, err = client.ListClusterServiceCustomActionSupportConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterServiceCustomActionSupportConfigRequest is the request struct for api ListClusterServiceCustomActionSupportConfig
type ListClusterServiceCustomActionSupportConfigRequest struct {
	*requests.RpcRequest
	ServiceCustomActionName string           `position:"Query" name:"ServiceCustomActionName"`
	ResourceOwnerId         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ServiceName             string           `position:"Query" name:"ServiceName"`
	ClusterId               string           `position:"Query" name:"ClusterId"`
}

// ListClusterServiceCustomActionSupportConfigResponse is the response struct for api ListClusterServiceCustomActionSupportConfig
type ListClusterServiceCustomActionSupportConfigResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	SupportedConfigList SupportedConfigList `json:"SupportedConfigList" xml:"SupportedConfigList"`
}

// CreateListClusterServiceCustomActionSupportConfigRequest creates a request to invoke ListClusterServiceCustomActionSupportConfig API
func CreateListClusterServiceCustomActionSupportConfigRequest() (request *ListClusterServiceCustomActionSupportConfigRequest) {
	request = &ListClusterServiceCustomActionSupportConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListClusterServiceCustomActionSupportConfig", "emr", "openAPI")
	return
}

// CreateListClusterServiceCustomActionSupportConfigResponse creates a response to parse from ListClusterServiceCustomActionSupportConfig response
func CreateListClusterServiceCustomActionSupportConfigResponse() (response *ListClusterServiceCustomActionSupportConfigResponse) {
	response = &ListClusterServiceCustomActionSupportConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
