package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreDeleteKafkaTopic invokes the emr.MetastoreDeleteKafkaTopic API synchronously
// api document: https://help.aliyun.com/api/emr/metastoredeletekafkatopic.html
func (client *Client) MetastoreDeleteKafkaTopic(request *MetastoreDeleteKafkaTopicRequest) (response *MetastoreDeleteKafkaTopicResponse, err error) {
	response = CreateMetastoreDeleteKafkaTopicResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreDeleteKafkaTopicWithChan invokes the emr.MetastoreDeleteKafkaTopic API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredeletekafkatopic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDeleteKafkaTopicWithChan(request *MetastoreDeleteKafkaTopicRequest) (<-chan *MetastoreDeleteKafkaTopicResponse, <-chan error) {
	responseChan := make(chan *MetastoreDeleteKafkaTopicResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreDeleteKafkaTopic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreDeleteKafkaTopicWithCallback invokes the emr.MetastoreDeleteKafkaTopic API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredeletekafkatopic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDeleteKafkaTopicWithCallback(request *MetastoreDeleteKafkaTopicRequest, callback func(response *MetastoreDeleteKafkaTopicResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreDeleteKafkaTopicResponse
		var err error
		defer close(result)
		response, err = client.MetastoreDeleteKafkaTopic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreDeleteKafkaTopicRequest is the request struct for api MetastoreDeleteKafkaTopic
type MetastoreDeleteKafkaTopicRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TopicId         string           `position:"Query" name:"TopicId"`
}

// MetastoreDeleteKafkaTopicResponse is the response struct for api MetastoreDeleteKafkaTopic
type MetastoreDeleteKafkaTopicResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateMetastoreDeleteKafkaTopicRequest creates a request to invoke MetastoreDeleteKafkaTopic API
func CreateMetastoreDeleteKafkaTopicRequest() (request *MetastoreDeleteKafkaTopicRequest) {
	request = &MetastoreDeleteKafkaTopicRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreDeleteKafkaTopic", "emr", "openAPI")
	return
}

// CreateMetastoreDeleteKafkaTopicResponse creates a response to parse from MetastoreDeleteKafkaTopic response
func CreateMetastoreDeleteKafkaTopicResponse() (response *MetastoreDeleteKafkaTopicResponse) {
	response = &MetastoreDeleteKafkaTopicResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
