package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreListDataResources invokes the emr.MetastoreListDataResources API synchronously
// api document: https://help.aliyun.com/api/emr/metastorelistdataresources.html
func (client *Client) MetastoreListDataResources(request *MetastoreListDataResourcesRequest) (response *MetastoreListDataResourcesResponse, err error) {
	response = CreateMetastoreListDataResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreListDataResourcesWithChan invokes the emr.MetastoreListDataResources API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorelistdataresources.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreListDataResourcesWithChan(request *MetastoreListDataResourcesRequest) (<-chan *MetastoreListDataResourcesResponse, <-chan error) {
	responseChan := make(chan *MetastoreListDataResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreListDataResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreListDataResourcesWithCallback invokes the emr.MetastoreListDataResources API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorelistdataresources.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreListDataResourcesWithCallback(request *MetastoreListDataResourcesRequest, callback func(response *MetastoreListDataResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreListDataResourcesResponse
		var err error
		defer close(result)
		response, err = client.MetastoreListDataResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreListDataResourcesRequest is the request struct for api MetastoreListDataResources
type MetastoreListDataResourcesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// MetastoreListDataResourcesResponse is the response struct for api MetastoreListDataResources
type MetastoreListDataResourcesResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	DataResources DataResources `json:"DataResources" xml:"DataResources"`
}

// CreateMetastoreListDataResourcesRequest creates a request to invoke MetastoreListDataResources API
func CreateMetastoreListDataResourcesRequest() (request *MetastoreListDataResourcesRequest) {
	request = &MetastoreListDataResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreListDataResources", "emr", "openAPI")
	return
}

// CreateMetastoreListDataResourcesResponse creates a response to parse from MetastoreListDataResources response
func CreateMetastoreListDataResourcesResponse() (response *MetastoreListDataResourcesResponse) {
	response = &MetastoreListDataResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
