package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyExecutionPlanJobInfo invokes the emr.ModifyExecutionPlanJobInfo API synchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanjobinfo.html
func (client *Client) ModifyExecutionPlanJobInfo(request *ModifyExecutionPlanJobInfoRequest) (response *ModifyExecutionPlanJobInfoResponse, err error) {
	response = CreateModifyExecutionPlanJobInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyExecutionPlanJobInfoWithChan invokes the emr.ModifyExecutionPlanJobInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanjobinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExecutionPlanJobInfoWithChan(request *ModifyExecutionPlanJobInfoRequest) (<-chan *ModifyExecutionPlanJobInfoResponse, <-chan error) {
	responseChan := make(chan *ModifyExecutionPlanJobInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyExecutionPlanJobInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyExecutionPlanJobInfoWithCallback invokes the emr.ModifyExecutionPlanJobInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanjobinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExecutionPlanJobInfoWithCallback(request *ModifyExecutionPlanJobInfoRequest, callback func(response *ModifyExecutionPlanJobInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyExecutionPlanJobInfoResponse
		var err error
		defer close(result)
		response, err = client.ModifyExecutionPlanJobInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyExecutionPlanJobInfoRequest is the request struct for api ModifyExecutionPlanJobInfo
type ModifyExecutionPlanJobInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
	JobIdList       *[]string        `position:"Query" name:"JobIdList"  type:"Repeated"`
}

// ModifyExecutionPlanJobInfoResponse is the response struct for api ModifyExecutionPlanJobInfo
type ModifyExecutionPlanJobInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyExecutionPlanJobInfoRequest creates a request to invoke ModifyExecutionPlanJobInfo API
func CreateModifyExecutionPlanJobInfoRequest() (request *ModifyExecutionPlanJobInfoRequest) {
	request = &ModifyExecutionPlanJobInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyExecutionPlanJobInfo", "emr", "openAPI")
	return
}

// CreateModifyExecutionPlanJobInfoResponse creates a response to parse from ModifyExecutionPlanJobInfo response
func CreateModifyExecutionPlanJobInfoResponse() (response *ModifyExecutionPlanJobInfoResponse) {
	response = &ModifyExecutionPlanJobInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
