package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResumeExecutionPlanInstance invokes the emr.ResumeExecutionPlanInstance API synchronously
// api document: https://help.aliyun.com/api/emr/resumeexecutionplaninstance.html
func (client *Client) ResumeExecutionPlanInstance(request *ResumeExecutionPlanInstanceRequest) (response *ResumeExecutionPlanInstanceResponse, err error) {
	response = CreateResumeExecutionPlanInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ResumeExecutionPlanInstanceWithChan invokes the emr.ResumeExecutionPlanInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/resumeexecutionplaninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResumeExecutionPlanInstanceWithChan(request *ResumeExecutionPlanInstanceRequest) (<-chan *ResumeExecutionPlanInstanceResponse, <-chan error) {
	responseChan := make(chan *ResumeExecutionPlanInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResumeExecutionPlanInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResumeExecutionPlanInstanceWithCallback invokes the emr.ResumeExecutionPlanInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/resumeexecutionplaninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResumeExecutionPlanInstanceWithCallback(request *ResumeExecutionPlanInstanceRequest, callback func(response *ResumeExecutionPlanInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResumeExecutionPlanInstanceResponse
		var err error
		defer close(result)
		response, err = client.ResumeExecutionPlanInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResumeExecutionPlanInstanceRequest is the request struct for api ResumeExecutionPlanInstance
type ResumeExecutionPlanInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
}

// ResumeExecutionPlanInstanceResponse is the response struct for api ResumeExecutionPlanInstance
type ResumeExecutionPlanInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResumeExecutionPlanInstanceRequest creates a request to invoke ResumeExecutionPlanInstance API
func CreateResumeExecutionPlanInstanceRequest() (request *ResumeExecutionPlanInstanceRequest) {
	request = &ResumeExecutionPlanInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ResumeExecutionPlanInstance", "emr", "openAPI")
	return
}

// CreateResumeExecutionPlanInstanceResponse creates a response to parse from ResumeExecutionPlanInstance response
func CreateResumeExecutionPlanInstanceResponse() (response *ResumeExecutionPlanInstanceResponse) {
	response = &ResumeExecutionPlanInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
