package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncDataSourceSchemaTable invokes the emr.SyncDataSourceSchemaTable API synchronously
// api document: https://help.aliyun.com/api/emr/syncdatasourceschematable.html
func (client *Client) SyncDataSourceSchemaTable(request *SyncDataSourceSchemaTableRequest) (response *SyncDataSourceSchemaTableResponse, err error) {
	response = CreateSyncDataSourceSchemaTableResponse()
	err = client.DoAction(request, response)
	return
}

// SyncDataSourceSchemaTableWithChan invokes the emr.SyncDataSourceSchemaTable API asynchronously
// api document: https://help.aliyun.com/api/emr/syncdatasourceschematable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SyncDataSourceSchemaTableWithChan(request *SyncDataSourceSchemaTableRequest) (<-chan *SyncDataSourceSchemaTableResponse, <-chan error) {
	responseChan := make(chan *SyncDataSourceSchemaTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncDataSourceSchemaTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncDataSourceSchemaTableWithCallback invokes the emr.SyncDataSourceSchemaTable API asynchronously
// api document: https://help.aliyun.com/api/emr/syncdatasourceschematable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SyncDataSourceSchemaTableWithCallback(request *SyncDataSourceSchemaTableRequest, callback func(response *SyncDataSourceSchemaTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncDataSourceSchemaTableResponse
		var err error
		defer close(result)
		response, err = client.SyncDataSourceSchemaTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncDataSourceSchemaTableRequest is the request struct for api SyncDataSourceSchemaTable
type SyncDataSourceSchemaTableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbName          string           `position:"Query" name:"DbName"`
	EtlJobId        string           `position:"Query" name:"EtlJobId"`
	DataSourceId    string           `position:"Query" name:"DataSourceId"`
	TableName       string           `position:"Query" name:"TableName"`
}

// SyncDataSourceSchemaTableResponse is the response struct for api SyncDataSourceSchemaTable
type SyncDataSourceSchemaTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CommandId string `json:"CommandId" xml:"CommandId"`
}

// CreateSyncDataSourceSchemaTableRequest creates a request to invoke SyncDataSourceSchemaTable API
func CreateSyncDataSourceSchemaTableRequest() (request *SyncDataSourceSchemaTableRequest) {
	request = &SyncDataSourceSchemaTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "SyncDataSourceSchemaTable", "emr", "openAPI")
	return
}

// CreateSyncDataSourceSchemaTableResponse creates a response to parse from SyncDataSourceSchemaTable response
func CreateSyncDataSourceSchemaTableResponse() (response *SyncDataSourceSchemaTableResponse) {
	response = &SyncDataSourceSchemaTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
