package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CompleteLifecycleAction invokes the ess.CompleteLifecycleAction API synchronously
// api document: https://help.aliyun.com/api/ess/completelifecycleaction.html
func (client *Client) CompleteLifecycleAction(request *CompleteLifecycleActionRequest) (response *CompleteLifecycleActionResponse, err error) {
	response = CreateCompleteLifecycleActionResponse()
	err = client.DoAction(request, response)
	return
}

// CompleteLifecycleActionWithChan invokes the ess.CompleteLifecycleAction API asynchronously
// api document: https://help.aliyun.com/api/ess/completelifecycleaction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CompleteLifecycleActionWithChan(request *CompleteLifecycleActionRequest) (<-chan *CompleteLifecycleActionResponse, <-chan error) {
	responseChan := make(chan *CompleteLifecycleActionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CompleteLifecycleAction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CompleteLifecycleActionWithCallback invokes the ess.CompleteLifecycleAction API asynchronously
// api document: https://help.aliyun.com/api/ess/completelifecycleaction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CompleteLifecycleActionWithCallback(request *CompleteLifecycleActionRequest, callback func(response *CompleteLifecycleActionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CompleteLifecycleActionResponse
		var err error
		defer close(result)
		response, err = client.CompleteLifecycleAction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CompleteLifecycleActionRequest is the request struct for api CompleteLifecycleAction
type CompleteLifecycleActionRequest struct {
	*requests.RpcRequest
	LifecycleActionToken  string           `position:"Query" name:"LifecycleActionToken"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	LifecycleHookId       string           `position:"Query" name:"LifecycleHookId"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	LifecycleActionResult string           `position:"Query" name:"LifecycleActionResult"`
}

// CompleteLifecycleActionResponse is the response struct for api CompleteLifecycleAction
type CompleteLifecycleActionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCompleteLifecycleActionRequest creates a request to invoke CompleteLifecycleAction API
func CreateCompleteLifecycleActionRequest() (request *CompleteLifecycleActionRequest) {
	request = &CompleteLifecycleActionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "CompleteLifecycleAction", "ess", "openAPI")
	return
}

// CreateCompleteLifecycleActionResponse creates a response to parse from CompleteLifecycleAction response
func CreateCompleteLifecycleActionResponse() (response *CompleteLifecycleActionResponse) {
	response = &CompleteLifecycleActionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
