package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScheduledTasks invokes the ess.DescribeScheduledTasks API synchronously
// api document: https://help.aliyun.com/api/ess/describescheduledtasks.html
func (client *Client) DescribeScheduledTasks(request *DescribeScheduledTasksRequest) (response *DescribeScheduledTasksResponse, err error) {
	response = CreateDescribeScheduledTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScheduledTasksWithChan invokes the ess.DescribeScheduledTasks API asynchronously
// api document: https://help.aliyun.com/api/ess/describescheduledtasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScheduledTasksWithChan(request *DescribeScheduledTasksRequest) (<-chan *DescribeScheduledTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeScheduledTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScheduledTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScheduledTasksWithCallback invokes the ess.DescribeScheduledTasks API asynchronously
// api document: https://help.aliyun.com/api/ess/describescheduledtasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScheduledTasksWithCallback(request *DescribeScheduledTasksRequest, callback func(response *DescribeScheduledTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScheduledTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeScheduledTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScheduledTasksRequest is the request struct for api DescribeScheduledTasks
type DescribeScheduledTasksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ScheduledAction2     string           `position:"Query" name:"ScheduledAction.2"`
	ScheduledAction1     string           `position:"Query" name:"ScheduledAction.1"`
	ScheduledAction6     string           `position:"Query" name:"ScheduledAction.6"`
	ScheduledAction5     string           `position:"Query" name:"ScheduledAction.5"`
	ScheduledAction4     string           `position:"Query" name:"ScheduledAction.4"`
	ScheduledAction3     string           `position:"Query" name:"ScheduledAction.3"`
	ScheduledAction9     string           `position:"Query" name:"ScheduledAction.9"`
	ScheduledAction8     string           `position:"Query" name:"ScheduledAction.8"`
	ScheduledAction7     string           `position:"Query" name:"ScheduledAction.7"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ScheduledTaskName20  string           `position:"Query" name:"ScheduledTaskName.20"`
	ScheduledTaskName19  string           `position:"Query" name:"ScheduledTaskName.19"`
	ScheduledTaskName18  string           `position:"Query" name:"ScheduledTaskName.18"`
	ScheduledTaskId20    string           `position:"Query" name:"ScheduledTaskId.20"`
	ScheduledTaskName13  string           `position:"Query" name:"ScheduledTaskName.13"`
	ScheduledTaskName12  string           `position:"Query" name:"ScheduledTaskName.12"`
	ScheduledTaskName11  string           `position:"Query" name:"ScheduledTaskName.11"`
	ScheduledTaskName10  string           `position:"Query" name:"ScheduledTaskName.10"`
	ScheduledTaskName17  string           `position:"Query" name:"ScheduledTaskName.17"`
	ScheduledTaskName16  string           `position:"Query" name:"ScheduledTaskName.16"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	ScheduledTaskName15  string           `position:"Query" name:"ScheduledTaskName.15"`
	ScheduledTaskName14  string           `position:"Query" name:"ScheduledTaskName.14"`
	ScheduledTaskId2     string           `position:"Query" name:"ScheduledTaskId.2"`
	ScheduledTaskId1     string           `position:"Query" name:"ScheduledTaskId.1"`
	ScheduledTaskId4     string           `position:"Query" name:"ScheduledTaskId.4"`
	ScheduledTaskId18    string           `position:"Query" name:"ScheduledTaskId.18"`
	ScheduledTaskId3     string           `position:"Query" name:"ScheduledTaskId.3"`
	ScheduledTaskId19    string           `position:"Query" name:"ScheduledTaskId.19"`
	ScheduledTaskId6     string           `position:"Query" name:"ScheduledTaskId.6"`
	ScheduledTaskId5     string           `position:"Query" name:"ScheduledTaskId.5"`
	ScheduledTaskId8     string           `position:"Query" name:"ScheduledTaskId.8"`
	ScheduledTaskName9   string           `position:"Query" name:"ScheduledTaskName.9"`
	ScheduledAction20    string           `position:"Query" name:"ScheduledAction.20"`
	ScheduledTaskId7     string           `position:"Query" name:"ScheduledTaskId.7"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ScheduledTaskId12    string           `position:"Query" name:"ScheduledTaskId.12"`
	ScheduledTaskName7   string           `position:"Query" name:"ScheduledTaskName.7"`
	ScheduledTaskId9     string           `position:"Query" name:"ScheduledTaskId.9"`
	ScheduledTaskId13    string           `position:"Query" name:"ScheduledTaskId.13"`
	ScheduledTaskName8   string           `position:"Query" name:"ScheduledTaskName.8"`
	ScheduledTaskId10    string           `position:"Query" name:"ScheduledTaskId.10"`
	ScheduledTaskName5   string           `position:"Query" name:"ScheduledTaskName.5"`
	ScheduledTaskId11    string           `position:"Query" name:"ScheduledTaskId.11"`
	ScheduledTaskName6   string           `position:"Query" name:"ScheduledTaskName.6"`
	ScheduledTaskId16    string           `position:"Query" name:"ScheduledTaskId.16"`
	ScheduledTaskName3   string           `position:"Query" name:"ScheduledTaskName.3"`
	ScheduledTaskId17    string           `position:"Query" name:"ScheduledTaskId.17"`
	ScheduledTaskName4   string           `position:"Query" name:"ScheduledTaskName.4"`
	ScheduledTaskId14    string           `position:"Query" name:"ScheduledTaskId.14"`
	ScheduledTaskName1   string           `position:"Query" name:"ScheduledTaskName.1"`
	ScheduledTaskId15    string           `position:"Query" name:"ScheduledTaskId.15"`
	ScheduledTaskName2   string           `position:"Query" name:"ScheduledTaskName.2"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	ScheduledAction18    string           `position:"Query" name:"ScheduledAction.18"`
	ScheduledAction19    string           `position:"Query" name:"ScheduledAction.19"`
	ScheduledAction16    string           `position:"Query" name:"ScheduledAction.16"`
	ScheduledAction17    string           `position:"Query" name:"ScheduledAction.17"`
	ScheduledAction14    string           `position:"Query" name:"ScheduledAction.14"`
	ScheduledAction15    string           `position:"Query" name:"ScheduledAction.15"`
	ScheduledAction12    string           `position:"Query" name:"ScheduledAction.12"`
	ScheduledAction13    string           `position:"Query" name:"ScheduledAction.13"`
	ScheduledAction10    string           `position:"Query" name:"ScheduledAction.10"`
	ScheduledAction11    string           `position:"Query" name:"ScheduledAction.11"`
}

// DescribeScheduledTasksResponse is the response struct for api DescribeScheduledTasks
type DescribeScheduledTasksResponse struct {
	*responses.BaseResponse
	TotalCount     int            `json:"TotalCount" xml:"TotalCount"`
	PageNumber     int            `json:"PageNumber" xml:"PageNumber"`
	PageSize       int            `json:"PageSize" xml:"PageSize"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	ScheduledTasks ScheduledTasks `json:"ScheduledTasks" xml:"ScheduledTasks"`
}

// CreateDescribeScheduledTasksRequest creates a request to invoke DescribeScheduledTasks API
func CreateDescribeScheduledTasksRequest() (request *DescribeScheduledTasksRequest) {
	request = &DescribeScheduledTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "DescribeScheduledTasks", "ess", "openAPI")
	return
}

// CreateDescribeScheduledTasksResponse creates a response to parse from DescribeScheduledTasks response
func CreateDescribeScheduledTasksResponse() (response *DescribeScheduledTasksResponse) {
	response = &DescribeScheduledTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
