package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCreditList invokes the finmall.GetCreditList API synchronously
// api document: https://help.aliyun.com/api/finmall/getcreditlist.html
func (client *Client) GetCreditList(request *GetCreditListRequest) (response *GetCreditListResponse, err error) {
	response = CreateGetCreditListResponse()
	err = client.DoAction(request, response)
	return
}

// GetCreditListWithChan invokes the finmall.GetCreditList API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcreditlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCreditListWithChan(request *GetCreditListRequest) (<-chan *GetCreditListResponse, <-chan error) {
	responseChan := make(chan *GetCreditListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCreditList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCreditListWithCallback invokes the finmall.GetCreditList API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcreditlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCreditListWithCallback(request *GetCreditListRequest, callback func(response *GetCreditListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCreditListResponse
		var err error
		defer close(result)
		response, err = client.GetCreditList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCreditListRequest is the request struct for api GetCreditList
type GetCreditListRequest struct {
	*requests.RpcRequest
	QueryExpression string           `position:"Query" name:"QueryExpression"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	UserId          string           `position:"Query" name:"UserId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// GetCreditListResponse is the response struct for api GetCreditList
type GetCreditListResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetCreditListRequest creates a request to invoke GetCreditList API
func CreateGetCreditListRequest() (request *GetCreditListRequest) {
	request = &GetCreditListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetCreditList", "finmall", "openAPI")
	return
}

// CreateGetCreditListResponse creates a response to parse from GetCreditList response
func CreateGetCreditListResponse() (response *GetCreditListResponse) {
	response = &GetCreditListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
