package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCustomerVerifyInfo invokes the finmall.GetCustomerVerifyInfo API synchronously
// api document: https://help.aliyun.com/api/finmall/getcustomerverifyinfo.html
func (client *Client) GetCustomerVerifyInfo(request *GetCustomerVerifyInfoRequest) (response *GetCustomerVerifyInfoResponse, err error) {
	response = CreateGetCustomerVerifyInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetCustomerVerifyInfoWithChan invokes the finmall.GetCustomerVerifyInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcustomerverifyinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCustomerVerifyInfoWithChan(request *GetCustomerVerifyInfoRequest) (<-chan *GetCustomerVerifyInfoResponse, <-chan error) {
	responseChan := make(chan *GetCustomerVerifyInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCustomerVerifyInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCustomerVerifyInfoWithCallback invokes the finmall.GetCustomerVerifyInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcustomerverifyinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCustomerVerifyInfoWithCallback(request *GetCustomerVerifyInfoRequest, callback func(response *GetCustomerVerifyInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCustomerVerifyInfoResponse
		var err error
		defer close(result)
		response, err = client.GetCustomerVerifyInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCustomerVerifyInfoRequest is the request struct for api GetCustomerVerifyInfo
type GetCustomerVerifyInfoRequest struct {
	*requests.RpcRequest
	UserId string `position:"Query" name:"UserId"`
}

// GetCustomerVerifyInfoResponse is the response struct for api GetCustomerVerifyInfo
type GetCustomerVerifyInfoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetCustomerVerifyInfoRequest creates a request to invoke GetCustomerVerifyInfo API
func CreateGetCustomerVerifyInfoRequest() (request *GetCustomerVerifyInfoRequest) {
	request = &GetCustomerVerifyInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetCustomerVerifyInfo", "finmall", "openAPI")
	return
}

// CreateGetCustomerVerifyInfoResponse creates a response to parse from GetCustomerVerifyInfo response
func CreateGetCustomerVerifyInfoResponse() (response *GetCustomerVerifyInfoResponse) {
	response = &GetCustomerVerifyInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
