package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SignLoanAgreement invokes the finmall.SignLoanAgreement API synchronously
// api document: https://help.aliyun.com/api/finmall/signloanagreement.html
func (client *Client) SignLoanAgreement(request *SignLoanAgreementRequest) (response *SignLoanAgreementResponse, err error) {
	response = CreateSignLoanAgreementResponse()
	err = client.DoAction(request, response)
	return
}

// SignLoanAgreementWithChan invokes the finmall.SignLoanAgreement API asynchronously
// api document: https://help.aliyun.com/api/finmall/signloanagreement.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SignLoanAgreementWithChan(request *SignLoanAgreementRequest) (<-chan *SignLoanAgreementResponse, <-chan error) {
	responseChan := make(chan *SignLoanAgreementResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SignLoanAgreement(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SignLoanAgreementWithCallback invokes the finmall.SignLoanAgreement API asynchronously
// api document: https://help.aliyun.com/api/finmall/signloanagreement.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SignLoanAgreementWithCallback(request *SignLoanAgreementRequest, callback func(response *SignLoanAgreementResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SignLoanAgreementResponse
		var err error
		defer close(result)
		response, err = client.SignLoanAgreement(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SignLoanAgreementRequest is the request struct for api SignLoanAgreement
type SignLoanAgreementRequest struct {
	*requests.RpcRequest
	CreditId string `position:"Query" name:"CreditId"`
	Reserved string `position:"Query" name:"Reserved"`
	UserId   string `position:"Query" name:"UserId"`
}

// SignLoanAgreementResponse is the response struct for api SignLoanAgreement
type SignLoanAgreementResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSignLoanAgreementRequest creates a request to invoke SignLoanAgreement API
func CreateSignLoanAgreementRequest() (request *SignLoanAgreementRequest) {
	request = &SignLoanAgreementRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "SignLoanAgreement", "finmall", "openAPI")
	return
}

// CreateSignLoanAgreementResponse creates a response to parse from SignLoanAgreement response
func CreateSignLoanAgreementResponse() (response *SignLoanAgreementResponse) {
	response = &SignLoanAgreementResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
