package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadCustomIDImage invokes the finmall.UploadCustomIDImage API synchronously
// api document: https://help.aliyun.com/api/finmall/uploadcustomidimage.html
func (client *Client) UploadCustomIDImage(request *UploadCustomIDImageRequest) (response *UploadCustomIDImageResponse, err error) {
	response = CreateUploadCustomIDImageResponse()
	err = client.DoAction(request, response)
	return
}

// UploadCustomIDImageWithChan invokes the finmall.UploadCustomIDImage API asynchronously
// api document: https://help.aliyun.com/api/finmall/uploadcustomidimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadCustomIDImageWithChan(request *UploadCustomIDImageRequest) (<-chan *UploadCustomIDImageResponse, <-chan error) {
	responseChan := make(chan *UploadCustomIDImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadCustomIDImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadCustomIDImageWithCallback invokes the finmall.UploadCustomIDImage API asynchronously
// api document: https://help.aliyun.com/api/finmall/uploadcustomidimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadCustomIDImageWithCallback(request *UploadCustomIDImageRequest, callback func(response *UploadCustomIDImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadCustomIDImageResponse
		var err error
		defer close(result)
		response, err = client.UploadCustomIDImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadCustomIDImageRequest is the request struct for api UploadCustomIDImage
type UploadCustomIDImageRequest struct {
	*requests.RpcRequest
	ImageType string `position:"Body" name:"ImageType"`
	Side      string `position:"Body" name:"Side"`
	ImageFile string `position:"Body" name:"ImageFile"`
	UserId    string `position:"Body" name:"UserId"`
}

// UploadCustomIDImageResponse is the response struct for api UploadCustomIDImage
type UploadCustomIDImageResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUploadCustomIDImageRequest creates a request to invoke UploadCustomIDImage API
func CreateUploadCustomIDImageRequest() (request *UploadCustomIDImageRequest) {
	request = &UploadCustomIDImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "UploadCustomIDImage", "finmall", "openAPI")
	return
}

// CreateUploadCustomIDImageResponse creates a response to parse from UploadCustomIDImage response
func CreateUploadCustomIDImageResponse() (response *UploadCustomIDImageResponse) {
	response = &UploadCustomIDImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
