package industry_brain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAlgorithmList invokes the industry_brain.GetAlgorithmList API synchronously
// api document: https://help.aliyun.com/api/industry-brain/getalgorithmlist.html
func (client *Client) GetAlgorithmList(request *GetAlgorithmListRequest) (response *GetAlgorithmListResponse, err error) {
	response = CreateGetAlgorithmListResponse()
	err = client.DoAction(request, response)
	return
}

// GetAlgorithmListWithChan invokes the industry_brain.GetAlgorithmList API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getalgorithmlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAlgorithmListWithChan(request *GetAlgorithmListRequest) (<-chan *GetAlgorithmListResponse, <-chan error) {
	responseChan := make(chan *GetAlgorithmListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAlgorithmList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAlgorithmListWithCallback invokes the industry_brain.GetAlgorithmList API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getalgorithmlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAlgorithmListWithCallback(request *GetAlgorithmListRequest, callback func(response *GetAlgorithmListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAlgorithmListResponse
		var err error
		defer close(result)
		response, err = client.GetAlgorithmList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAlgorithmListRequest is the request struct for api GetAlgorithmList
type GetAlgorithmListRequest struct {
	*requests.RpcRequest
	ServiceId string `position:"Query" name:"ServiceId"`
}

// GetAlgorithmListResponse is the response struct for api GetAlgorithmList
type GetAlgorithmListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateGetAlgorithmListRequest creates a request to invoke GetAlgorithmList API
func CreateGetAlgorithmListRequest() (request *GetAlgorithmListRequest) {
	request = &GetAlgorithmListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("industry-brain", "2018-07-12", "GetAlgorithmList", "", "")
	return
}

// CreateGetAlgorithmListResponse creates a response to parse from GetAlgorithmList response
func CreateGetAlgorithmListResponse() (response *GetAlgorithmListResponse) {
	response = &GetAlgorithmListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
