package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTrainDatasByIds invokes the ivision.DescribeTrainDatasByIds API synchronously
// api document: https://help.aliyun.com/api/ivision/describetraindatasbyids.html
func (client *Client) DescribeTrainDatasByIds(request *DescribeTrainDatasByIdsRequest) (response *DescribeTrainDatasByIdsResponse, err error) {
	response = CreateDescribeTrainDatasByIdsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTrainDatasByIdsWithChan invokes the ivision.DescribeTrainDatasByIds API asynchronously
// api document: https://help.aliyun.com/api/ivision/describetraindatasbyids.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTrainDatasByIdsWithChan(request *DescribeTrainDatasByIdsRequest) (<-chan *DescribeTrainDatasByIdsResponse, <-chan error) {
	responseChan := make(chan *DescribeTrainDatasByIdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTrainDatasByIds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTrainDatasByIdsWithCallback invokes the ivision.DescribeTrainDatasByIds API asynchronously
// api document: https://help.aliyun.com/api/ivision/describetraindatasbyids.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTrainDatasByIdsWithCallback(request *DescribeTrainDatasByIdsRequest, callback func(response *DescribeTrainDatasByIdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTrainDatasByIdsResponse
		var err error
		defer close(result)
		response, err = client.DescribeTrainDatasByIds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTrainDatasByIdsRequest is the request struct for api DescribeTrainDatasByIds
type DescribeTrainDatasByIdsRequest struct {
	*requests.RpcRequest
	DataIds     string           `position:"Query" name:"DataIds"`
	ProjectId   string           `position:"Query" name:"ProjectId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	IterationId string           `position:"Query" name:"IterationId"`
}

// DescribeTrainDatasByIdsResponse is the response struct for api DescribeTrainDatasByIds
type DescribeTrainDatasByIdsResponse struct {
	*responses.BaseResponse
	RequestId  string                              `json:"RequestId" xml:"RequestId"`
	TrainDatas TrainDatasInDescribeTrainDatasByIds `json:"TrainDatas" xml:"TrainDatas"`
}

// CreateDescribeTrainDatasByIdsRequest creates a request to invoke DescribeTrainDatasByIds API
func CreateDescribeTrainDatasByIdsRequest() (request *DescribeTrainDatasByIdsRequest) {
	request = &DescribeTrainDatasByIdsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "DescribeTrainDatasByIds", "ivision", "openAPI")
	return
}

// CreateDescribeTrainDatasByIdsResponse creates a response to parse from DescribeTrainDatasByIds response
func CreateDescribeTrainDatasByIdsResponse() (response *DescribeTrainDatasByIdsResponse) {
	response = &DescribeTrainDatasByIdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
