package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLoadBalancersRelatedEcs invokes the slb.DescribeLoadBalancersRelatedEcs API synchronously
// api document: https://help.aliyun.com/api/slb/describeloadbalancersrelatedecs.html
func (client *Client) DescribeLoadBalancersRelatedEcs(request *DescribeLoadBalancersRelatedEcsRequest) (response *DescribeLoadBalancersRelatedEcsResponse, err error) {
	response = CreateDescribeLoadBalancersRelatedEcsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLoadBalancersRelatedEcsWithChan invokes the slb.DescribeLoadBalancersRelatedEcs API asynchronously
// api document: https://help.aliyun.com/api/slb/describeloadbalancersrelatedecs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLoadBalancersRelatedEcsWithChan(request *DescribeLoadBalancersRelatedEcsRequest) (<-chan *DescribeLoadBalancersRelatedEcsResponse, <-chan error) {
	responseChan := make(chan *DescribeLoadBalancersRelatedEcsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLoadBalancersRelatedEcs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLoadBalancersRelatedEcsWithCallback invokes the slb.DescribeLoadBalancersRelatedEcs API asynchronously
// api document: https://help.aliyun.com/api/slb/describeloadbalancersrelatedecs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLoadBalancersRelatedEcsWithCallback(request *DescribeLoadBalancersRelatedEcsRequest, callback func(response *DescribeLoadBalancersRelatedEcsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLoadBalancersRelatedEcsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLoadBalancersRelatedEcs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLoadBalancersRelatedEcsRequest is the request struct for api DescribeLoadBalancersRelatedEcs
type DescribeLoadBalancersRelatedEcsRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LoadBalancerId       string           `position:"Query" name:"LoadBalancerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Tags                 string           `position:"Query" name:"Tags"`
}

// DescribeLoadBalancersRelatedEcsResponse is the response struct for api DescribeLoadBalancersRelatedEcs
type DescribeLoadBalancersRelatedEcsResponse struct {
	*responses.BaseResponse
	Message       string                                         `json:"Message" xml:"Message"`
	Success       bool                                           `json:"Success" xml:"Success"`
	RequestId     string                                         `json:"RequestId" xml:"RequestId"`
	LoadBalancers LoadBalancersInDescribeLoadBalancersRelatedEcs `json:"LoadBalancers" xml:"LoadBalancers"`
}

// CreateDescribeLoadBalancersRelatedEcsRequest creates a request to invoke DescribeLoadBalancersRelatedEcs API
func CreateDescribeLoadBalancersRelatedEcsRequest() (request *DescribeLoadBalancersRelatedEcsRequest) {
	request = &DescribeLoadBalancersRelatedEcsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "DescribeLoadBalancersRelatedEcs", "slb", "openAPI")
	return
}

// CreateDescribeLoadBalancersRelatedEcsResponse creates a response to parse from DescribeLoadBalancersRelatedEcs response
func CreateDescribeLoadBalancersRelatedEcsResponse() (response *DescribeLoadBalancersRelatedEcsResponse) {
	response = &DescribeLoadBalancersRelatedEcsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
