package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateForwardEntry invokes the vpc.CreateForwardEntry API synchronously
// api document: https://help.aliyun.com/api/vpc/createforwardentry.html
func (client *Client) CreateForwardEntry(request *CreateForwardEntryRequest) (response *CreateForwardEntryResponse, err error) {
	response = CreateCreateForwardEntryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateForwardEntryWithChan invokes the vpc.CreateForwardEntry API asynchronously
// api document: https://help.aliyun.com/api/vpc/createforwardentry.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateForwardEntryWithChan(request *CreateForwardEntryRequest) (<-chan *CreateForwardEntryResponse, <-chan error) {
	responseChan := make(chan *CreateForwardEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateForwardEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateForwardEntryWithCallback invokes the vpc.CreateForwardEntry API asynchronously
// api document: https://help.aliyun.com/api/vpc/createforwardentry.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateForwardEntryWithCallback(request *CreateForwardEntryRequest, callback func(response *CreateForwardEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateForwardEntryResponse
		var err error
		defer close(result)
		response, err = client.CreateForwardEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateForwardEntryRequest is the request struct for api CreateForwardEntry
type CreateForwardEntryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	IpProtocol           string           `position:"Query" name:"IpProtocol"`
	ForwardEntryName     string           `position:"Query" name:"ForwardEntryName"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	ForwardTableId       string           `position:"Query" name:"ForwardTableId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InternalIp           string           `position:"Query" name:"InternalIp"`
	InternalPort         string           `position:"Query" name:"InternalPort"`
	ExternalIp           string           `position:"Query" name:"ExternalIp"`
	ExternalPort         string           `position:"Query" name:"ExternalPort"`
}

// CreateForwardEntryResponse is the response struct for api CreateForwardEntry
type CreateForwardEntryResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ForwardEntryId string `json:"ForwardEntryId" xml:"ForwardEntryId"`
}

// CreateCreateForwardEntryRequest creates a request to invoke CreateForwardEntry API
func CreateCreateForwardEntryRequest() (request *CreateForwardEntryRequest) {
	request = &CreateForwardEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateForwardEntry", "vpc", "openAPI")
	return
}

// CreateCreateForwardEntryResponse creates a response to parse from CreateForwardEntry response
func CreateCreateForwardEntryResponse() (response *CreateForwardEntryResponse) {
	response = &CreateForwardEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
