// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package accesscontextmanager

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	accesscontextmanagerpb "cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb"
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListAccessPolicies         []gax.CallOption
	GetAccessPolicy            []gax.CallOption
	CreateAccessPolicy         []gax.CallOption
	UpdateAccessPolicy         []gax.CallOption
	DeleteAccessPolicy         []gax.CallOption
	ListAccessLevels           []gax.CallOption
	GetAccessLevel             []gax.CallOption
	CreateAccessLevel          []gax.CallOption
	UpdateAccessLevel          []gax.CallOption
	DeleteAccessLevel          []gax.CallOption
	ReplaceAccessLevels        []gax.CallOption
	ListServicePerimeters      []gax.CallOption
	GetServicePerimeter        []gax.CallOption
	CreateServicePerimeter     []gax.CallOption
	UpdateServicePerimeter     []gax.CallOption
	DeleteServicePerimeter     []gax.CallOption
	ReplaceServicePerimeters   []gax.CallOption
	CommitServicePerimeters    []gax.CallOption
	ListGcpUserAccessBindings  []gax.CallOption
	GetGcpUserAccessBinding    []gax.CallOption
	CreateGcpUserAccessBinding []gax.CallOption
	UpdateGcpUserAccessBinding []gax.CallOption
	DeleteGcpUserAccessBinding []gax.CallOption
	SetIamPolicy               []gax.CallOption
	GetIamPolicy               []gax.CallOption
	TestIamPermissions         []gax.CallOption
	GetOperation               []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("accesscontextmanager.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("accesscontextmanager.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("accesscontextmanager.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://accesscontextmanager.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListAccessPolicies: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAccessPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateAccessPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAccessPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteAccessPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListAccessLevels: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAccessLevel: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateAccessLevel: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAccessLevel: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteAccessLevel: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReplaceAccessLevels: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListServicePerimeters: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetServicePerimeter: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateServicePerimeter: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateServicePerimeter: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteServicePerimeter: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReplaceServicePerimeters: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CommitServicePerimeters: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListGcpUserAccessBindings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetGcpUserAccessBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateGcpUserAccessBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateGcpUserAccessBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteGcpUserAccessBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SetIamPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetIamPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		TestIamPermissions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetOperation: []gax.CallOption{},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		ListAccessPolicies: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAccessPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateAccessPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAccessPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteAccessPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListAccessLevels: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAccessLevel: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateAccessLevel: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAccessLevel: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteAccessLevel: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReplaceAccessLevels: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListServicePerimeters: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetServicePerimeter: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateServicePerimeter: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateServicePerimeter: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteServicePerimeter: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReplaceServicePerimeters: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CommitServicePerimeters: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListGcpUserAccessBindings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetGcpUserAccessBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateGcpUserAccessBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateGcpUserAccessBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteGcpUserAccessBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SetIamPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetIamPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		TestIamPermissions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetOperation: []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from Access Context Manager API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListAccessPolicies(context.Context, *accesscontextmanagerpb.ListAccessPoliciesRequest, ...gax.CallOption) *AccessPolicyIterator
	GetAccessPolicy(context.Context, *accesscontextmanagerpb.GetAccessPolicyRequest, ...gax.CallOption) (*accesscontextmanagerpb.AccessPolicy, error)
	CreateAccessPolicy(context.Context, *accesscontextmanagerpb.AccessPolicy, ...gax.CallOption) (*CreateAccessPolicyOperation, error)
	CreateAccessPolicyOperation(name string) *CreateAccessPolicyOperation
	UpdateAccessPolicy(context.Context, *accesscontextmanagerpb.UpdateAccessPolicyRequest, ...gax.CallOption) (*UpdateAccessPolicyOperation, error)
	UpdateAccessPolicyOperation(name string) *UpdateAccessPolicyOperation
	DeleteAccessPolicy(context.Context, *accesscontextmanagerpb.DeleteAccessPolicyRequest, ...gax.CallOption) (*DeleteAccessPolicyOperation, error)
	DeleteAccessPolicyOperation(name string) *DeleteAccessPolicyOperation
	ListAccessLevels(context.Context, *accesscontextmanagerpb.ListAccessLevelsRequest, ...gax.CallOption) *AccessLevelIterator
	GetAccessLevel(context.Context, *accesscontextmanagerpb.GetAccessLevelRequest, ...gax.CallOption) (*accesscontextmanagerpb.AccessLevel, error)
	CreateAccessLevel(context.Context, *accesscontextmanagerpb.CreateAccessLevelRequest, ...gax.CallOption) (*CreateAccessLevelOperation, error)
	CreateAccessLevelOperation(name string) *CreateAccessLevelOperation
	UpdateAccessLevel(context.Context, *accesscontextmanagerpb.UpdateAccessLevelRequest, ...gax.CallOption) (*UpdateAccessLevelOperation, error)
	UpdateAccessLevelOperation(name string) *UpdateAccessLevelOperation
	DeleteAccessLevel(context.Context, *accesscontextmanagerpb.DeleteAccessLevelRequest, ...gax.CallOption) (*DeleteAccessLevelOperation, error)
	DeleteAccessLevelOperation(name string) *DeleteAccessLevelOperation
	ReplaceAccessLevels(context.Context, *accesscontextmanagerpb.ReplaceAccessLevelsRequest, ...gax.CallOption) (*ReplaceAccessLevelsOperation, error)
	ReplaceAccessLevelsOperation(name string) *ReplaceAccessLevelsOperation
	ListServicePerimeters(context.Context, *accesscontextmanagerpb.ListServicePerimetersRequest, ...gax.CallOption) *ServicePerimeterIterator
	GetServicePerimeter(context.Context, *accesscontextmanagerpb.GetServicePerimeterRequest, ...gax.CallOption) (*accesscontextmanagerpb.ServicePerimeter, error)
	CreateServicePerimeter(context.Context, *accesscontextmanagerpb.CreateServicePerimeterRequest, ...gax.CallOption) (*CreateServicePerimeterOperation, error)
	CreateServicePerimeterOperation(name string) *CreateServicePerimeterOperation
	UpdateServicePerimeter(context.Context, *accesscontextmanagerpb.UpdateServicePerimeterRequest, ...gax.CallOption) (*UpdateServicePerimeterOperation, error)
	UpdateServicePerimeterOperation(name string) *UpdateServicePerimeterOperation
	DeleteServicePerimeter(context.Context, *accesscontextmanagerpb.DeleteServicePerimeterRequest, ...gax.CallOption) (*DeleteServicePerimeterOperation, error)
	DeleteServicePerimeterOperation(name string) *DeleteServicePerimeterOperation
	ReplaceServicePerimeters(context.Context, *accesscontextmanagerpb.ReplaceServicePerimetersRequest, ...gax.CallOption) (*ReplaceServicePerimetersOperation, error)
	ReplaceServicePerimetersOperation(name string) *ReplaceServicePerimetersOperation
	CommitServicePerimeters(context.Context, *accesscontextmanagerpb.CommitServicePerimetersRequest, ...gax.CallOption) (*CommitServicePerimetersOperation, error)
	CommitServicePerimetersOperation(name string) *CommitServicePerimetersOperation
	ListGcpUserAccessBindings(context.Context, *accesscontextmanagerpb.ListGcpUserAccessBindingsRequest, ...gax.CallOption) *GcpUserAccessBindingIterator
	GetGcpUserAccessBinding(context.Context, *accesscontextmanagerpb.GetGcpUserAccessBindingRequest, ...gax.CallOption) (*accesscontextmanagerpb.GcpUserAccessBinding, error)
	CreateGcpUserAccessBinding(context.Context, *accesscontextmanagerpb.CreateGcpUserAccessBindingRequest, ...gax.CallOption) (*CreateGcpUserAccessBindingOperation, error)
	CreateGcpUserAccessBindingOperation(name string) *CreateGcpUserAccessBindingOperation
	UpdateGcpUserAccessBinding(context.Context, *accesscontextmanagerpb.UpdateGcpUserAccessBindingRequest, ...gax.CallOption) (*UpdateGcpUserAccessBindingOperation, error)
	UpdateGcpUserAccessBindingOperation(name string) *UpdateGcpUserAccessBindingOperation
	DeleteGcpUserAccessBinding(context.Context, *accesscontextmanagerpb.DeleteGcpUserAccessBindingRequest, ...gax.CallOption) (*DeleteGcpUserAccessBindingOperation, error)
	DeleteGcpUserAccessBindingOperation(name string) *DeleteGcpUserAccessBindingOperation
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
}

// Client is a client for interacting with Access Context Manager API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// API for setting [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] and [service
// perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
// for Google Cloud projects. Each organization has one [access policy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] that contains the
// [access levels] [google.identity.accesscontextmanager.v1.AccessLevel]
// and [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
// [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
// applicable to all resources in the organization.
// AccessPolicies
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListAccessPolicies lists all [access policies]
// [google.identity.accesscontextmanager.v1.AccessPolicy] in an
// organization.
func (c *Client) ListAccessPolicies(ctx context.Context, req *accesscontextmanagerpb.ListAccessPoliciesRequest, opts ...gax.CallOption) *AccessPolicyIterator {
	return c.internalClient.ListAccessPolicies(ctx, req, opts...)
}

// GetAccessPolicy returns an [access policy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the name.
func (c *Client) GetAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.GetAccessPolicyRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessPolicy, error) {
	return c.internalClient.GetAccessPolicy(ctx, req, opts...)
}

// CreateAccessPolicy creates an access policy. This method fails if the organization already has
// an access policy. The long-running operation has a successful status
// after the access policy propagates to long-lasting storage.
// Syntactic and basic semantic errors are returned in metadata as a
// BadRequest proto.
func (c *Client) CreateAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.AccessPolicy, opts ...gax.CallOption) (*CreateAccessPolicyOperation, error) {
	return c.internalClient.CreateAccessPolicy(ctx, req, opts...)
}

// CreateAccessPolicyOperation returns a new CreateAccessPolicyOperation from a given name.
// The name must be that of a previously created CreateAccessPolicyOperation, possibly from a different process.
func (c *Client) CreateAccessPolicyOperation(name string) *CreateAccessPolicyOperation {
	return c.internalClient.CreateAccessPolicyOperation(name)
}

// UpdateAccessPolicy updates an [access policy]
// [google.identity.accesscontextmanager.v1.AccessPolicy]. The
// long-running operation from this RPC has a successful status after the
// changes to the [access policy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] propagate
// to long-lasting storage.
func (c *Client) UpdateAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.UpdateAccessPolicyRequest, opts ...gax.CallOption) (*UpdateAccessPolicyOperation, error) {
	return c.internalClient.UpdateAccessPolicy(ctx, req, opts...)
}

// UpdateAccessPolicyOperation returns a new UpdateAccessPolicyOperation from a given name.
// The name must be that of a previously created UpdateAccessPolicyOperation, possibly from a different process.
func (c *Client) UpdateAccessPolicyOperation(name string) *UpdateAccessPolicyOperation {
	return c.internalClient.UpdateAccessPolicyOperation(name)
}

// DeleteAccessPolicy deletes an [access policy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the
// resource name. The long-running operation has a successful status after the
// [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
// is removed from long-lasting storage.
func (c *Client) DeleteAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.DeleteAccessPolicyRequest, opts ...gax.CallOption) (*DeleteAccessPolicyOperation, error) {
	return c.internalClient.DeleteAccessPolicy(ctx, req, opts...)
}

// DeleteAccessPolicyOperation returns a new DeleteAccessPolicyOperation from a given name.
// The name must be that of a previously created DeleteAccessPolicyOperation, possibly from a different process.
func (c *Client) DeleteAccessPolicyOperation(name string) *DeleteAccessPolicyOperation {
	return c.internalClient.DeleteAccessPolicyOperation(name)
}

// ListAccessLevels lists all [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] for an access
// policy.
func (c *Client) ListAccessLevels(ctx context.Context, req *accesscontextmanagerpb.ListAccessLevelsRequest, opts ...gax.CallOption) *AccessLevelIterator {
	return c.internalClient.ListAccessLevels(ctx, req, opts...)
}

// GetAccessLevel gets an [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
// name.
func (c *Client) GetAccessLevel(ctx context.Context, req *accesscontextmanagerpb.GetAccessLevelRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessLevel, error) {
	return c.internalClient.GetAccessLevel(ctx, req, opts...)
}

// CreateAccessLevel creates an [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
// operation from this RPC has a successful status after the [access
// level] [google.identity.accesscontextmanager.v1.AccessLevel]
// propagates to long-lasting storage. If [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] contain
// errors, an error response is returned for the first error encountered.
func (c *Client) CreateAccessLevel(ctx context.Context, req *accesscontextmanagerpb.CreateAccessLevelRequest, opts ...gax.CallOption) (*CreateAccessLevelOperation, error) {
	return c.internalClient.CreateAccessLevel(ctx, req, opts...)
}

// CreateAccessLevelOperation returns a new CreateAccessLevelOperation from a given name.
// The name must be that of a previously created CreateAccessLevelOperation, possibly from a different process.
func (c *Client) CreateAccessLevelOperation(name string) *CreateAccessLevelOperation {
	return c.internalClient.CreateAccessLevelOperation(name)
}

// UpdateAccessLevel updates an [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
// operation from this RPC has a successful status after the changes to
// the [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel] propagate
// to long-lasting storage. If [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] contain
// errors, an error response is returned for the first error encountered.
func (c *Client) UpdateAccessLevel(ctx context.Context, req *accesscontextmanagerpb.UpdateAccessLevelRequest, opts ...gax.CallOption) (*UpdateAccessLevelOperation, error) {
	return c.internalClient.UpdateAccessLevel(ctx, req, opts...)
}

// UpdateAccessLevelOperation returns a new UpdateAccessLevelOperation from a given name.
// The name must be that of a previously created UpdateAccessLevelOperation, possibly from a different process.
func (c *Client) UpdateAccessLevelOperation(name string) *UpdateAccessLevelOperation {
	return c.internalClient.UpdateAccessLevelOperation(name)
}

// DeleteAccessLevel deletes an [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
// name. The long-running operation from this RPC has a successful status
// after the [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
// from long-lasting storage.
func (c *Client) DeleteAccessLevel(ctx context.Context, req *accesscontextmanagerpb.DeleteAccessLevelRequest, opts ...gax.CallOption) (*DeleteAccessLevelOperation, error) {
	return c.internalClient.DeleteAccessLevel(ctx, req, opts...)
}

// DeleteAccessLevelOperation returns a new DeleteAccessLevelOperation from a given name.
// The name must be that of a previously created DeleteAccessLevelOperation, possibly from a different process.
func (c *Client) DeleteAccessLevelOperation(name string) *DeleteAccessLevelOperation {
	return c.internalClient.DeleteAccessLevelOperation(name)
}

// ReplaceAccessLevels replaces all existing [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] in an [access
// policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
// the [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
// is done atomically. The long-running operation from this RPC has a
// successful status after all replacements propagate to long-lasting
// storage. If the replacement contains errors, an error response is returned
// for the first error encountered.  Upon error, the replacement is cancelled,
// and existing [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] are not
// affected. The Operation.response field contains
// ReplaceAccessLevelsResponse. Removing [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] contained in existing
// [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] result in an
// error.
func (c *Client) ReplaceAccessLevels(ctx context.Context, req *accesscontextmanagerpb.ReplaceAccessLevelsRequest, opts ...gax.CallOption) (*ReplaceAccessLevelsOperation, error) {
	return c.internalClient.ReplaceAccessLevels(ctx, req, opts...)
}

// ReplaceAccessLevelsOperation returns a new ReplaceAccessLevelsOperation from a given name.
// The name must be that of a previously created ReplaceAccessLevelsOperation, possibly from a different process.
func (c *Client) ReplaceAccessLevelsOperation(name string) *ReplaceAccessLevelsOperation {
	return c.internalClient.ReplaceAccessLevelsOperation(name)
}

// ListServicePerimeters lists all [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
// access policy.
func (c *Client) ListServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.ListServicePerimetersRequest, opts ...gax.CallOption) *ServicePerimeterIterator {
	return c.internalClient.ListServicePerimeters(ctx, req, opts...)
}

// GetServicePerimeter gets a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
// resource name.
func (c *Client) GetServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.GetServicePerimeterRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.ServicePerimeter, error) {
	return c.internalClient.GetServicePerimeter(ctx, req, opts...)
}

// CreateServicePerimeter creates a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
// long-running operation from this RPC has a successful status after the
// [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]
// propagates to long-lasting storage. If a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
// errors, an error response is returned for the first error encountered.
func (c *Client) CreateServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.CreateServicePerimeterRequest, opts ...gax.CallOption) (*CreateServicePerimeterOperation, error) {
	return c.internalClient.CreateServicePerimeter(ctx, req, opts...)
}

// CreateServicePerimeterOperation returns a new CreateServicePerimeterOperation from a given name.
// The name must be that of a previously created CreateServicePerimeterOperation, possibly from a different process.
func (c *Client) CreateServicePerimeterOperation(name string) *CreateServicePerimeterOperation {
	return c.internalClient.CreateServicePerimeterOperation(name)
}

// UpdateServicePerimeter updates a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
// long-running operation from this RPC has a successful status after the
// [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]
// propagates to long-lasting storage. If a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
// errors, an error response is returned for the first error encountered.
func (c *Client) UpdateServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.UpdateServicePerimeterRequest, opts ...gax.CallOption) (*UpdateServicePerimeterOperation, error) {
	return c.internalClient.UpdateServicePerimeter(ctx, req, opts...)
}

// UpdateServicePerimeterOperation returns a new UpdateServicePerimeterOperation from a given name.
// The name must be that of a previously created UpdateServicePerimeterOperation, possibly from a different process.
func (c *Client) UpdateServicePerimeterOperation(name string) *UpdateServicePerimeterOperation {
	return c.internalClient.UpdateServicePerimeterOperation(name)
}

// DeleteServicePerimeter deletes a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
// resource name. The long-running operation from this RPC has a successful
// status after the [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] is removed from
// long-lasting storage.
func (c *Client) DeleteServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.DeleteServicePerimeterRequest, opts ...gax.CallOption) (*DeleteServicePerimeterOperation, error) {
	return c.internalClient.DeleteServicePerimeter(ctx, req, opts...)
}

// DeleteServicePerimeterOperation returns a new DeleteServicePerimeterOperation from a given name.
// The name must be that of a previously created DeleteServicePerimeterOperation, possibly from a different process.
func (c *Client) DeleteServicePerimeterOperation(name string) *DeleteServicePerimeterOperation {
	return c.internalClient.DeleteServicePerimeterOperation(name)
}

// ReplaceServicePerimeters replace all existing [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an [access
// policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with the
// [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] provided. This
// is done atomically. The long-running operation from this RPC has a
// successful status after all replacements propagate to long-lasting storage.
// Replacements containing errors result in an error response for the first
// error encountered. Upon an error, replacement are cancelled and existing
// [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] are not
// affected. The Operation.response field contains
// ReplaceServicePerimetersResponse.
func (c *Client) ReplaceServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.ReplaceServicePerimetersRequest, opts ...gax.CallOption) (*ReplaceServicePerimetersOperation, error) {
	return c.internalClient.ReplaceServicePerimeters(ctx, req, opts...)
}

// ReplaceServicePerimetersOperation returns a new ReplaceServicePerimetersOperation from a given name.
// The name must be that of a previously created ReplaceServicePerimetersOperation, possibly from a different process.
func (c *Client) ReplaceServicePerimetersOperation(name string) *ReplaceServicePerimetersOperation {
	return c.internalClient.ReplaceServicePerimetersOperation(name)
}

// CommitServicePerimeters commits the dry-run specification for all the [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
// A commit operation on a service perimeter involves copying its spec field
// to the status field of the service perimeter. Only [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] with
// use_explicit_dry_run_spec field set to true are affected by a commit
// operation. The long-running operation from this RPC has a successful
// status after the dry-run specifications for all the [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
// committed. If a commit fails, it causes the long-running operation to
// return an error response and the entire commit operation is cancelled.
// When successful, the Operation.response field contains
// CommitServicePerimetersResponse. The dry_run and the spec fields are
// cleared after a successful commit operation.
func (c *Client) CommitServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.CommitServicePerimetersRequest, opts ...gax.CallOption) (*CommitServicePerimetersOperation, error) {
	return c.internalClient.CommitServicePerimeters(ctx, req, opts...)
}

// CommitServicePerimetersOperation returns a new CommitServicePerimetersOperation from a given name.
// The name must be that of a previously created CommitServicePerimetersOperation, possibly from a different process.
func (c *Client) CommitServicePerimetersOperation(name string) *CommitServicePerimetersOperation {
	return c.internalClient.CommitServicePerimetersOperation(name)
}

// ListGcpUserAccessBindings lists all [GcpUserAccessBindings]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
// Google Cloud organization.
func (c *Client) ListGcpUserAccessBindings(ctx context.Context, req *accesscontextmanagerpb.ListGcpUserAccessBindingsRequest, opts ...gax.CallOption) *GcpUserAccessBindingIterator {
	return c.internalClient.ListGcpUserAccessBindings(ctx, req, opts...)
}

// GetGcpUserAccessBinding gets the [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
// the given name.
func (c *Client) GetGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.GetGcpUserAccessBindingRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.GcpUserAccessBinding, error) {
	return c.internalClient.GetGcpUserAccessBinding(ctx, req, opts...)
}

// CreateGcpUserAccessBinding creates a [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
// client specifies a [name]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name (at http://google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name)],
// the server ignores it. Fails if a resource already exists with the same
// [group_key]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
// Completion of this long-running operation does not necessarily signify that
// the new binding is deployed onto all affected users, which may take more
// time.
func (c *Client) CreateGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.CreateGcpUserAccessBindingRequest, opts ...gax.CallOption) (*CreateGcpUserAccessBindingOperation, error) {
	return c.internalClient.CreateGcpUserAccessBinding(ctx, req, opts...)
}

// CreateGcpUserAccessBindingOperation returns a new CreateGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created CreateGcpUserAccessBindingOperation, possibly from a different process.
func (c *Client) CreateGcpUserAccessBindingOperation(name string) *CreateGcpUserAccessBindingOperation {
	return c.internalClient.CreateGcpUserAccessBindingOperation(name)
}

// UpdateGcpUserAccessBinding updates a [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
// Completion of this long-running operation does not necessarily signify that
// the changed binding is deployed onto all affected users, which may take
// more time.
func (c *Client) UpdateGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.UpdateGcpUserAccessBindingRequest, opts ...gax.CallOption) (*UpdateGcpUserAccessBindingOperation, error) {
	return c.internalClient.UpdateGcpUserAccessBinding(ctx, req, opts...)
}

// UpdateGcpUserAccessBindingOperation returns a new UpdateGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created UpdateGcpUserAccessBindingOperation, possibly from a different process.
func (c *Client) UpdateGcpUserAccessBindingOperation(name string) *UpdateGcpUserAccessBindingOperation {
	return c.internalClient.UpdateGcpUserAccessBindingOperation(name)
}

// DeleteGcpUserAccessBinding deletes a [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
// Completion of this long-running operation does not necessarily signify that
// the binding deletion is deployed onto all affected users, which may take
// more time.
func (c *Client) DeleteGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.DeleteGcpUserAccessBindingRequest, opts ...gax.CallOption) (*DeleteGcpUserAccessBindingOperation, error) {
	return c.internalClient.DeleteGcpUserAccessBinding(ctx, req, opts...)
}

// DeleteGcpUserAccessBindingOperation returns a new DeleteGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created DeleteGcpUserAccessBindingOperation, possibly from a different process.
func (c *Client) DeleteGcpUserAccessBindingOperation(name string) *DeleteGcpUserAccessBindingOperation {
	return c.internalClient.DeleteGcpUserAccessBindingOperation(name)
}

// SetIamPolicy sets the IAM policy for the specified Access Context Manager
// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
// This method replaces the existing IAM policy on the access policy. The IAM
// policy controls the set of users who can perform specific operations on the
// Access Context Manager [access
// policy][google.identity.accesscontextmanager.v1.AccessPolicy].
func (c *Client) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.SetIamPolicy(ctx, req, opts...)
}

// GetIamPolicy gets the IAM policy for the specified Access Context Manager
// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
func (c *Client) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.GetIamPolicy(ctx, req, opts...)
}

// TestIamPermissions returns the IAM permissions that the caller has on the specified Access
// Context Manager resource. The resource can be an
// AccessPolicy,
// AccessLevel, or
// [ServicePerimeter][google.identity.accesscontextmanager.v1.ServicePerimeter
// ]. This method does not support other resources.
func (c *Client) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *Client) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// gRPCClient is a client for interacting with Access Context Manager API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client accesscontextmanagerpb.AccessContextManagerClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewClient creates a new access context manager client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// API for setting [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] and [service
// perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
// for Google Cloud projects. Each organization has one [access policy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] that contains the
// [access levels] [google.identity.accesscontextmanager.v1.AccessLevel]
// and [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
// [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
// applicable to all resources in the organization.
// AccessPolicies
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:         connPool,
		client:           accesscontextmanagerpb.NewAccessContextManagerClient(connPool),
		CallOptions:      &client.CallOptions,
		logger:           internaloption.GetLogger(opts),
		operationsClient: longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version, "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	logger *slog.Logger
}

// NewRESTClient creates a new access context manager rest client.
//
// API for setting [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] and [service
// perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
// for Google Cloud projects. Each organization has one [access policy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] that contains the
// [access levels] [google.identity.accesscontextmanager.v1.AccessLevel]
// and [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
// [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
// applicable to all resources in the organization.
// AccessPolicies
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://accesscontextmanager.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://accesscontextmanager.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://accesscontextmanager.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://accesscontextmanager.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN", "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) ListAccessPolicies(ctx context.Context, req *accesscontextmanagerpb.ListAccessPoliciesRequest, opts ...gax.CallOption) *AccessPolicyIterator {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).ListAccessPolicies[0:len((*c.CallOptions).ListAccessPolicies):len((*c.CallOptions).ListAccessPolicies)], opts...)
	it := &AccessPolicyIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListAccessPoliciesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.AccessPolicy, string, error) {
		resp := &accesscontextmanagerpb.ListAccessPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListAccessPolicies, req, settings.GRPC, c.logger, "ListAccessPolicies")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAccessPolicies(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.GetAccessPolicyRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessPolicy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAccessPolicy[0:len((*c.CallOptions).GetAccessPolicy):len((*c.CallOptions).GetAccessPolicy)], opts...)
	var resp *accesscontextmanagerpb.AccessPolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetAccessPolicy, req, settings.GRPC, c.logger, "GetAccessPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.AccessPolicy, opts ...gax.CallOption) (*CreateAccessPolicyOperation, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).CreateAccessPolicy[0:len((*c.CallOptions).CreateAccessPolicy):len((*c.CallOptions).CreateAccessPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateAccessPolicy, req, settings.GRPC, c.logger, "CreateAccessPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.UpdateAccessPolicyRequest, opts ...gax.CallOption) (*UpdateAccessPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "policy.name", url.QueryEscape(req.GetPolicy().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAccessPolicy[0:len((*c.CallOptions).UpdateAccessPolicy):len((*c.CallOptions).UpdateAccessPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateAccessPolicy, req, settings.GRPC, c.logger, "UpdateAccessPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.DeleteAccessPolicyRequest, opts ...gax.CallOption) (*DeleteAccessPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteAccessPolicy[0:len((*c.CallOptions).DeleteAccessPolicy):len((*c.CallOptions).DeleteAccessPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteAccessPolicy, req, settings.GRPC, c.logger, "DeleteAccessPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListAccessLevels(ctx context.Context, req *accesscontextmanagerpb.ListAccessLevelsRequest, opts ...gax.CallOption) *AccessLevelIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListAccessLevels[0:len((*c.CallOptions).ListAccessLevels):len((*c.CallOptions).ListAccessLevels)], opts...)
	it := &AccessLevelIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListAccessLevelsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.AccessLevel, string, error) {
		resp := &accesscontextmanagerpb.ListAccessLevelsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListAccessLevels, req, settings.GRPC, c.logger, "ListAccessLevels")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAccessLevels(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetAccessLevel(ctx context.Context, req *accesscontextmanagerpb.GetAccessLevelRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessLevel, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAccessLevel[0:len((*c.CallOptions).GetAccessLevel):len((*c.CallOptions).GetAccessLevel)], opts...)
	var resp *accesscontextmanagerpb.AccessLevel
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetAccessLevel, req, settings.GRPC, c.logger, "GetAccessLevel")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateAccessLevel(ctx context.Context, req *accesscontextmanagerpb.CreateAccessLevelRequest, opts ...gax.CallOption) (*CreateAccessLevelOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateAccessLevel[0:len((*c.CallOptions).CreateAccessLevel):len((*c.CallOptions).CreateAccessLevel)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateAccessLevel, req, settings.GRPC, c.logger, "CreateAccessLevel")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateAccessLevel(ctx context.Context, req *accesscontextmanagerpb.UpdateAccessLevelRequest, opts ...gax.CallOption) (*UpdateAccessLevelOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "access_level.name", url.QueryEscape(req.GetAccessLevel().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAccessLevel[0:len((*c.CallOptions).UpdateAccessLevel):len((*c.CallOptions).UpdateAccessLevel)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateAccessLevel, req, settings.GRPC, c.logger, "UpdateAccessLevel")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteAccessLevel(ctx context.Context, req *accesscontextmanagerpb.DeleteAccessLevelRequest, opts ...gax.CallOption) (*DeleteAccessLevelOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteAccessLevel[0:len((*c.CallOptions).DeleteAccessLevel):len((*c.CallOptions).DeleteAccessLevel)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteAccessLevel, req, settings.GRPC, c.logger, "DeleteAccessLevel")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ReplaceAccessLevels(ctx context.Context, req *accesscontextmanagerpb.ReplaceAccessLevelsRequest, opts ...gax.CallOption) (*ReplaceAccessLevelsOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ReplaceAccessLevels[0:len((*c.CallOptions).ReplaceAccessLevels):len((*c.CallOptions).ReplaceAccessLevels)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ReplaceAccessLevels, req, settings.GRPC, c.logger, "ReplaceAccessLevels")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ReplaceAccessLevelsOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.ListServicePerimetersRequest, opts ...gax.CallOption) *ServicePerimeterIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListServicePerimeters[0:len((*c.CallOptions).ListServicePerimeters):len((*c.CallOptions).ListServicePerimeters)], opts...)
	it := &ServicePerimeterIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListServicePerimetersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.ServicePerimeter, string, error) {
		resp := &accesscontextmanagerpb.ListServicePerimetersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListServicePerimeters, req, settings.GRPC, c.logger, "ListServicePerimeters")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetServicePerimeters(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.GetServicePerimeterRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.ServicePerimeter, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetServicePerimeter[0:len((*c.CallOptions).GetServicePerimeter):len((*c.CallOptions).GetServicePerimeter)], opts...)
	var resp *accesscontextmanagerpb.ServicePerimeter
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetServicePerimeter, req, settings.GRPC, c.logger, "GetServicePerimeter")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.CreateServicePerimeterRequest, opts ...gax.CallOption) (*CreateServicePerimeterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateServicePerimeter[0:len((*c.CallOptions).CreateServicePerimeter):len((*c.CallOptions).CreateServicePerimeter)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateServicePerimeter, req, settings.GRPC, c.logger, "CreateServicePerimeter")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.UpdateServicePerimeterRequest, opts ...gax.CallOption) (*UpdateServicePerimeterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "service_perimeter.name", url.QueryEscape(req.GetServicePerimeter().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateServicePerimeter[0:len((*c.CallOptions).UpdateServicePerimeter):len((*c.CallOptions).UpdateServicePerimeter)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateServicePerimeter, req, settings.GRPC, c.logger, "UpdateServicePerimeter")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.DeleteServicePerimeterRequest, opts ...gax.CallOption) (*DeleteServicePerimeterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteServicePerimeter[0:len((*c.CallOptions).DeleteServicePerimeter):len((*c.CallOptions).DeleteServicePerimeter)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteServicePerimeter, req, settings.GRPC, c.logger, "DeleteServicePerimeter")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ReplaceServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.ReplaceServicePerimetersRequest, opts ...gax.CallOption) (*ReplaceServicePerimetersOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ReplaceServicePerimeters[0:len((*c.CallOptions).ReplaceServicePerimeters):len((*c.CallOptions).ReplaceServicePerimeters)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ReplaceServicePerimeters, req, settings.GRPC, c.logger, "ReplaceServicePerimeters")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ReplaceServicePerimetersOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CommitServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.CommitServicePerimetersRequest, opts ...gax.CallOption) (*CommitServicePerimetersOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CommitServicePerimeters[0:len((*c.CallOptions).CommitServicePerimeters):len((*c.CallOptions).CommitServicePerimeters)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CommitServicePerimeters, req, settings.GRPC, c.logger, "CommitServicePerimeters")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CommitServicePerimetersOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListGcpUserAccessBindings(ctx context.Context, req *accesscontextmanagerpb.ListGcpUserAccessBindingsRequest, opts ...gax.CallOption) *GcpUserAccessBindingIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListGcpUserAccessBindings[0:len((*c.CallOptions).ListGcpUserAccessBindings):len((*c.CallOptions).ListGcpUserAccessBindings)], opts...)
	it := &GcpUserAccessBindingIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListGcpUserAccessBindingsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.GcpUserAccessBinding, string, error) {
		resp := &accesscontextmanagerpb.ListGcpUserAccessBindingsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListGcpUserAccessBindings, req, settings.GRPC, c.logger, "ListGcpUserAccessBindings")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetGcpUserAccessBindings(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.GetGcpUserAccessBindingRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.GcpUserAccessBinding, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetGcpUserAccessBinding[0:len((*c.CallOptions).GetGcpUserAccessBinding):len((*c.CallOptions).GetGcpUserAccessBinding)], opts...)
	var resp *accesscontextmanagerpb.GcpUserAccessBinding
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetGcpUserAccessBinding, req, settings.GRPC, c.logger, "GetGcpUserAccessBinding")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.CreateGcpUserAccessBindingRequest, opts ...gax.CallOption) (*CreateGcpUserAccessBindingOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateGcpUserAccessBinding[0:len((*c.CallOptions).CreateGcpUserAccessBinding):len((*c.CallOptions).CreateGcpUserAccessBinding)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateGcpUserAccessBinding, req, settings.GRPC, c.logger, "CreateGcpUserAccessBinding")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.UpdateGcpUserAccessBindingRequest, opts ...gax.CallOption) (*UpdateGcpUserAccessBindingOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "gcp_user_access_binding.name", url.QueryEscape(req.GetGcpUserAccessBinding().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateGcpUserAccessBinding[0:len((*c.CallOptions).UpdateGcpUserAccessBinding):len((*c.CallOptions).UpdateGcpUserAccessBinding)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateGcpUserAccessBinding, req, settings.GRPC, c.logger, "UpdateGcpUserAccessBinding")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.DeleteGcpUserAccessBindingRequest, opts ...gax.CallOption) (*DeleteGcpUserAccessBindingOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteGcpUserAccessBinding[0:len((*c.CallOptions).DeleteGcpUserAccessBinding):len((*c.CallOptions).DeleteGcpUserAccessBinding)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteGcpUserAccessBinding, req, settings.GRPC, c.logger, "DeleteGcpUserAccessBinding")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.SetIamPolicy, req, settings.GRPC, c.logger, "SetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetIamPolicy, req, settings.GRPC, c.logger, "GetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.TestIamPermissions, req, settings.GRPC, c.logger, "TestIamPermissions")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// ListAccessPolicies lists all [access policies]
// [google.identity.accesscontextmanager.v1.AccessPolicy] in an
// organization.
func (c *restClient) ListAccessPolicies(ctx context.Context, req *accesscontextmanagerpb.ListAccessPoliciesRequest, opts ...gax.CallOption) *AccessPolicyIterator {
	it := &AccessPolicyIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListAccessPoliciesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.AccessPolicy, string, error) {
		resp := &accesscontextmanagerpb.ListAccessPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/accessPolicies")

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		params.Add("parent", fmt.Sprintf("%v", req.GetParent()))

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListAccessPolicies")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetAccessPolicies(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetAccessPolicy returns an [access policy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the name.
func (c *restClient) GetAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.GetAccessPolicyRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessPolicy, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetAccessPolicy[0:len((*c.CallOptions).GetAccessPolicy):len((*c.CallOptions).GetAccessPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accesscontextmanagerpb.AccessPolicy{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetAccessPolicy")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateAccessPolicy creates an access policy. This method fails if the organization already has
// an access policy. The long-running operation has a successful status
// after the access policy propagates to long-lasting storage.
// Syntactic and basic semantic errors are returned in metadata as a
// BadRequest proto.
func (c *restClient) CreateAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.AccessPolicy, opts ...gax.CallOption) (*CreateAccessPolicyOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/accessPolicies")

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := append(c.xGoogHeaders, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateAccessPolicy")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateAccessPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateAccessPolicy updates an [access policy]
// [google.identity.accesscontextmanager.v1.AccessPolicy]. The
// long-running operation from this RPC has a successful status after the
// changes to the [access policy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] propagate
// to long-lasting storage.
func (c *restClient) UpdateAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.UpdateAccessPolicyRequest, opts ...gax.CallOption) (*UpdateAccessPolicyOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetPolicy()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetPolicy().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "policy.name", url.QueryEscape(req.GetPolicy().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateAccessPolicy")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateAccessPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteAccessPolicy deletes an [access policy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the
// resource name. The long-running operation has a successful status after the
// [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
// is removed from long-lasting storage.
func (c *restClient) DeleteAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.DeleteAccessPolicyRequest, opts ...gax.CallOption) (*DeleteAccessPolicyOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteAccessPolicy")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteAccessPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListAccessLevels lists all [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] for an access
// policy.
func (c *restClient) ListAccessLevels(ctx context.Context, req *accesscontextmanagerpb.ListAccessLevelsRequest, opts ...gax.CallOption) *AccessLevelIterator {
	it := &AccessLevelIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListAccessLevelsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.AccessLevel, string, error) {
		resp := &accesscontextmanagerpb.ListAccessLevelsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/accessLevels", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetAccessLevelFormat() != 0 {
			params.Add("accessLevelFormat", fmt.Sprintf("%v", req.GetAccessLevelFormat()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListAccessLevels")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetAccessLevels(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetAccessLevel gets an [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
// name.
func (c *restClient) GetAccessLevel(ctx context.Context, req *accesscontextmanagerpb.GetAccessLevelRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessLevel, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetAccessLevelFormat() != 0 {
		params.Add("accessLevelFormat", fmt.Sprintf("%v", req.GetAccessLevelFormat()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetAccessLevel[0:len((*c.CallOptions).GetAccessLevel):len((*c.CallOptions).GetAccessLevel)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accesscontextmanagerpb.AccessLevel{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetAccessLevel")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateAccessLevel creates an [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
// operation from this RPC has a successful status after the [access
// level] [google.identity.accesscontextmanager.v1.AccessLevel]
// propagates to long-lasting storage. If [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] contain
// errors, an error response is returned for the first error encountered.
func (c *restClient) CreateAccessLevel(ctx context.Context, req *accesscontextmanagerpb.CreateAccessLevelRequest, opts ...gax.CallOption) (*CreateAccessLevelOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetAccessLevel()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/accessLevels", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateAccessLevel")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateAccessLevelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateAccessLevel updates an [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
// operation from this RPC has a successful status after the changes to
// the [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel] propagate
// to long-lasting storage. If [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] contain
// errors, an error response is returned for the first error encountered.
func (c *restClient) UpdateAccessLevel(ctx context.Context, req *accesscontextmanagerpb.UpdateAccessLevelRequest, opts ...gax.CallOption) (*UpdateAccessLevelOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetAccessLevel()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetAccessLevel().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "access_level.name", url.QueryEscape(req.GetAccessLevel().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateAccessLevel")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateAccessLevelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteAccessLevel deletes an [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
// name. The long-running operation from this RPC has a successful status
// after the [access level]
// [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
// from long-lasting storage.
func (c *restClient) DeleteAccessLevel(ctx context.Context, req *accesscontextmanagerpb.DeleteAccessLevelRequest, opts ...gax.CallOption) (*DeleteAccessLevelOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteAccessLevel")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteAccessLevelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ReplaceAccessLevels replaces all existing [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] in an [access
// policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
// the [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
// is done atomically. The long-running operation from this RPC has a
// successful status after all replacements propagate to long-lasting
// storage. If the replacement contains errors, an error response is returned
// for the first error encountered.  Upon error, the replacement is cancelled,
// and existing [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] are not
// affected. The Operation.response field contains
// ReplaceAccessLevelsResponse. Removing [access levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] contained in existing
// [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] result in an
// error.
func (c *restClient) ReplaceAccessLevels(ctx context.Context, req *accesscontextmanagerpb.ReplaceAccessLevelsRequest, opts ...gax.CallOption) (*ReplaceAccessLevelsOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/accessLevels:replaceAll", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ReplaceAccessLevels")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ReplaceAccessLevelsOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListServicePerimeters lists all [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
// access policy.
func (c *restClient) ListServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.ListServicePerimetersRequest, opts ...gax.CallOption) *ServicePerimeterIterator {
	it := &ServicePerimeterIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListServicePerimetersRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.ServicePerimeter, string, error) {
		resp := &accesscontextmanagerpb.ListServicePerimetersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/servicePerimeters", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListServicePerimeters")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetServicePerimeters(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetServicePerimeter gets a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
// resource name.
func (c *restClient) GetServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.GetServicePerimeterRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.ServicePerimeter, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetServicePerimeter[0:len((*c.CallOptions).GetServicePerimeter):len((*c.CallOptions).GetServicePerimeter)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accesscontextmanagerpb.ServicePerimeter{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetServicePerimeter")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateServicePerimeter creates a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
// long-running operation from this RPC has a successful status after the
// [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]
// propagates to long-lasting storage. If a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
// errors, an error response is returned for the first error encountered.
func (c *restClient) CreateServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.CreateServicePerimeterRequest, opts ...gax.CallOption) (*CreateServicePerimeterOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetServicePerimeter()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/servicePerimeters", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateServicePerimeter")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateServicePerimeterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateServicePerimeter updates a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
// long-running operation from this RPC has a successful status after the
// [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]
// propagates to long-lasting storage. If a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
// errors, an error response is returned for the first error encountered.
func (c *restClient) UpdateServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.UpdateServicePerimeterRequest, opts ...gax.CallOption) (*UpdateServicePerimeterOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetServicePerimeter()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetServicePerimeter().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "service_perimeter.name", url.QueryEscape(req.GetServicePerimeter().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateServicePerimeter")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateServicePerimeterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteServicePerimeter deletes a [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
// resource name. The long-running operation from this RPC has a successful
// status after the [service perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] is removed from
// long-lasting storage.
func (c *restClient) DeleteServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.DeleteServicePerimeterRequest, opts ...gax.CallOption) (*DeleteServicePerimeterOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteServicePerimeter")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteServicePerimeterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ReplaceServicePerimeters replace all existing [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an [access
// policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with the
// [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] provided. This
// is done atomically. The long-running operation from this RPC has a
// successful status after all replacements propagate to long-lasting storage.
// Replacements containing errors result in an error response for the first
// error encountered. Upon an error, replacement are cancelled and existing
// [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] are not
// affected. The Operation.response field contains
// ReplaceServicePerimetersResponse.
func (c *restClient) ReplaceServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.ReplaceServicePerimetersRequest, opts ...gax.CallOption) (*ReplaceServicePerimetersOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/servicePerimeters:replaceAll", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ReplaceServicePerimeters")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ReplaceServicePerimetersOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CommitServicePerimeters commits the dry-run specification for all the [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
// A commit operation on a service perimeter involves copying its spec field
// to the status field of the service perimeter. Only [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] with
// use_explicit_dry_run_spec field set to true are affected by a commit
// operation. The long-running operation from this RPC has a successful
// status after the dry-run specifications for all the [service perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
// committed. If a commit fails, it causes the long-running operation to
// return an error response and the entire commit operation is cancelled.
// When successful, the Operation.response field contains
// CommitServicePerimetersResponse. The dry_run and the spec fields are
// cleared after a successful commit operation.
func (c *restClient) CommitServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.CommitServicePerimetersRequest, opts ...gax.CallOption) (*CommitServicePerimetersOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/servicePerimeters:commit", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CommitServicePerimeters")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CommitServicePerimetersOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListGcpUserAccessBindings lists all [GcpUserAccessBindings]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
// Google Cloud organization.
func (c *restClient) ListGcpUserAccessBindings(ctx context.Context, req *accesscontextmanagerpb.ListGcpUserAccessBindingsRequest, opts ...gax.CallOption) *GcpUserAccessBindingIterator {
	it := &GcpUserAccessBindingIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListGcpUserAccessBindingsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.GcpUserAccessBinding, string, error) {
		resp := &accesscontextmanagerpb.ListGcpUserAccessBindingsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/gcpUserAccessBindings", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListGcpUserAccessBindings")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetGcpUserAccessBindings(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetGcpUserAccessBinding gets the [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
// the given name.
func (c *restClient) GetGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.GetGcpUserAccessBindingRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.GcpUserAccessBinding, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetGcpUserAccessBinding[0:len((*c.CallOptions).GetGcpUserAccessBinding):len((*c.CallOptions).GetGcpUserAccessBinding)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accesscontextmanagerpb.GcpUserAccessBinding{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetGcpUserAccessBinding")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateGcpUserAccessBinding creates a [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
// client specifies a [name]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name (at http://google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name)],
// the server ignores it. Fails if a resource already exists with the same
// [group_key]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
// Completion of this long-running operation does not necessarily signify that
// the new binding is deployed onto all affected users, which may take more
// time.
func (c *restClient) CreateGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.CreateGcpUserAccessBindingRequest, opts ...gax.CallOption) (*CreateGcpUserAccessBindingOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGcpUserAccessBinding()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/gcpUserAccessBindings", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateGcpUserAccessBinding")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateGcpUserAccessBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateGcpUserAccessBinding updates a [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
// Completion of this long-running operation does not necessarily signify that
// the changed binding is deployed onto all affected users, which may take
// more time.
func (c *restClient) UpdateGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.UpdateGcpUserAccessBindingRequest, opts ...gax.CallOption) (*UpdateGcpUserAccessBindingOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGcpUserAccessBinding()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetGcpUserAccessBinding().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "gcp_user_access_binding.name", url.QueryEscape(req.GetGcpUserAccessBinding().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateGcpUserAccessBinding")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateGcpUserAccessBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteGcpUserAccessBinding deletes a [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
// Completion of this long-running operation does not necessarily signify that
// the binding deletion is deployed onto all affected users, which may take
// more time.
func (c *restClient) DeleteGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.DeleteGcpUserAccessBindingRequest, opts ...gax.CallOption) (*DeleteGcpUserAccessBindingOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteGcpUserAccessBinding")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteGcpUserAccessBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// SetIamPolicy sets the IAM policy for the specified Access Context Manager
// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
// This method replaces the existing IAM policy on the access policy. The IAM
// policy controls the set of users who can perform specific operations on the
// Access Context Manager [access
// policy][google.identity.accesscontextmanager.v1.AccessPolicy].
func (c *restClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:setIamPolicy", req.GetResource())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.Policy{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "SetIamPolicy")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetIamPolicy gets the IAM policy for the specified Access Context Manager
// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
func (c *restClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:getIamPolicy", req.GetResource())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.Policy{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "GetIamPolicy")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// TestIamPermissions returns the IAM permissions that the caller has on the specified Access
// Context Manager resource. The resource can be an
// AccessPolicy,
// AccessLevel, or
// [ServicePerimeter][google.identity.accesscontextmanager.v1.ServicePerimeter
// ]. This method does not support other resources.
func (c *restClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:testIamPermissions", req.GetResource())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.TestIamPermissionsResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "TestIamPermissions")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *restClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CommitServicePerimetersOperation returns a new CommitServicePerimetersOperation from a given name.
// The name must be that of a previously created CommitServicePerimetersOperation, possibly from a different process.
func (c *gRPCClient) CommitServicePerimetersOperation(name string) *CommitServicePerimetersOperation {
	return &CommitServicePerimetersOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CommitServicePerimetersOperation returns a new CommitServicePerimetersOperation from a given name.
// The name must be that of a previously created CommitServicePerimetersOperation, possibly from a different process.
func (c *restClient) CommitServicePerimetersOperation(name string) *CommitServicePerimetersOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CommitServicePerimetersOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateAccessLevelOperation returns a new CreateAccessLevelOperation from a given name.
// The name must be that of a previously created CreateAccessLevelOperation, possibly from a different process.
func (c *gRPCClient) CreateAccessLevelOperation(name string) *CreateAccessLevelOperation {
	return &CreateAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateAccessLevelOperation returns a new CreateAccessLevelOperation from a given name.
// The name must be that of a previously created CreateAccessLevelOperation, possibly from a different process.
func (c *restClient) CreateAccessLevelOperation(name string) *CreateAccessLevelOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateAccessLevelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateAccessPolicyOperation returns a new CreateAccessPolicyOperation from a given name.
// The name must be that of a previously created CreateAccessPolicyOperation, possibly from a different process.
func (c *gRPCClient) CreateAccessPolicyOperation(name string) *CreateAccessPolicyOperation {
	return &CreateAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateAccessPolicyOperation returns a new CreateAccessPolicyOperation from a given name.
// The name must be that of a previously created CreateAccessPolicyOperation, possibly from a different process.
func (c *restClient) CreateAccessPolicyOperation(name string) *CreateAccessPolicyOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateAccessPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateGcpUserAccessBindingOperation returns a new CreateGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created CreateGcpUserAccessBindingOperation, possibly from a different process.
func (c *gRPCClient) CreateGcpUserAccessBindingOperation(name string) *CreateGcpUserAccessBindingOperation {
	return &CreateGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateGcpUserAccessBindingOperation returns a new CreateGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created CreateGcpUserAccessBindingOperation, possibly from a different process.
func (c *restClient) CreateGcpUserAccessBindingOperation(name string) *CreateGcpUserAccessBindingOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateGcpUserAccessBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateServicePerimeterOperation returns a new CreateServicePerimeterOperation from a given name.
// The name must be that of a previously created CreateServicePerimeterOperation, possibly from a different process.
func (c *gRPCClient) CreateServicePerimeterOperation(name string) *CreateServicePerimeterOperation {
	return &CreateServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateServicePerimeterOperation returns a new CreateServicePerimeterOperation from a given name.
// The name must be that of a previously created CreateServicePerimeterOperation, possibly from a different process.
func (c *restClient) CreateServicePerimeterOperation(name string) *CreateServicePerimeterOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateServicePerimeterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteAccessLevelOperation returns a new DeleteAccessLevelOperation from a given name.
// The name must be that of a previously created DeleteAccessLevelOperation, possibly from a different process.
func (c *gRPCClient) DeleteAccessLevelOperation(name string) *DeleteAccessLevelOperation {
	return &DeleteAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteAccessLevelOperation returns a new DeleteAccessLevelOperation from a given name.
// The name must be that of a previously created DeleteAccessLevelOperation, possibly from a different process.
func (c *restClient) DeleteAccessLevelOperation(name string) *DeleteAccessLevelOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteAccessLevelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteAccessPolicyOperation returns a new DeleteAccessPolicyOperation from a given name.
// The name must be that of a previously created DeleteAccessPolicyOperation, possibly from a different process.
func (c *gRPCClient) DeleteAccessPolicyOperation(name string) *DeleteAccessPolicyOperation {
	return &DeleteAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteAccessPolicyOperation returns a new DeleteAccessPolicyOperation from a given name.
// The name must be that of a previously created DeleteAccessPolicyOperation, possibly from a different process.
func (c *restClient) DeleteAccessPolicyOperation(name string) *DeleteAccessPolicyOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteAccessPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteGcpUserAccessBindingOperation returns a new DeleteGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created DeleteGcpUserAccessBindingOperation, possibly from a different process.
func (c *gRPCClient) DeleteGcpUserAccessBindingOperation(name string) *DeleteGcpUserAccessBindingOperation {
	return &DeleteGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteGcpUserAccessBindingOperation returns a new DeleteGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created DeleteGcpUserAccessBindingOperation, possibly from a different process.
func (c *restClient) DeleteGcpUserAccessBindingOperation(name string) *DeleteGcpUserAccessBindingOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteGcpUserAccessBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteServicePerimeterOperation returns a new DeleteServicePerimeterOperation from a given name.
// The name must be that of a previously created DeleteServicePerimeterOperation, possibly from a different process.
func (c *gRPCClient) DeleteServicePerimeterOperation(name string) *DeleteServicePerimeterOperation {
	return &DeleteServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteServicePerimeterOperation returns a new DeleteServicePerimeterOperation from a given name.
// The name must be that of a previously created DeleteServicePerimeterOperation, possibly from a different process.
func (c *restClient) DeleteServicePerimeterOperation(name string) *DeleteServicePerimeterOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteServicePerimeterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ReplaceAccessLevelsOperation returns a new ReplaceAccessLevelsOperation from a given name.
// The name must be that of a previously created ReplaceAccessLevelsOperation, possibly from a different process.
func (c *gRPCClient) ReplaceAccessLevelsOperation(name string) *ReplaceAccessLevelsOperation {
	return &ReplaceAccessLevelsOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ReplaceAccessLevelsOperation returns a new ReplaceAccessLevelsOperation from a given name.
// The name must be that of a previously created ReplaceAccessLevelsOperation, possibly from a different process.
func (c *restClient) ReplaceAccessLevelsOperation(name string) *ReplaceAccessLevelsOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ReplaceAccessLevelsOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ReplaceServicePerimetersOperation returns a new ReplaceServicePerimetersOperation from a given name.
// The name must be that of a previously created ReplaceServicePerimetersOperation, possibly from a different process.
func (c *gRPCClient) ReplaceServicePerimetersOperation(name string) *ReplaceServicePerimetersOperation {
	return &ReplaceServicePerimetersOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ReplaceServicePerimetersOperation returns a new ReplaceServicePerimetersOperation from a given name.
// The name must be that of a previously created ReplaceServicePerimetersOperation, possibly from a different process.
func (c *restClient) ReplaceServicePerimetersOperation(name string) *ReplaceServicePerimetersOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ReplaceServicePerimetersOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateAccessLevelOperation returns a new UpdateAccessLevelOperation from a given name.
// The name must be that of a previously created UpdateAccessLevelOperation, possibly from a different process.
func (c *gRPCClient) UpdateAccessLevelOperation(name string) *UpdateAccessLevelOperation {
	return &UpdateAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateAccessLevelOperation returns a new UpdateAccessLevelOperation from a given name.
// The name must be that of a previously created UpdateAccessLevelOperation, possibly from a different process.
func (c *restClient) UpdateAccessLevelOperation(name string) *UpdateAccessLevelOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateAccessLevelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateAccessPolicyOperation returns a new UpdateAccessPolicyOperation from a given name.
// The name must be that of a previously created UpdateAccessPolicyOperation, possibly from a different process.
func (c *gRPCClient) UpdateAccessPolicyOperation(name string) *UpdateAccessPolicyOperation {
	return &UpdateAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateAccessPolicyOperation returns a new UpdateAccessPolicyOperation from a given name.
// The name must be that of a previously created UpdateAccessPolicyOperation, possibly from a different process.
func (c *restClient) UpdateAccessPolicyOperation(name string) *UpdateAccessPolicyOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateAccessPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateGcpUserAccessBindingOperation returns a new UpdateGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created UpdateGcpUserAccessBindingOperation, possibly from a different process.
func (c *gRPCClient) UpdateGcpUserAccessBindingOperation(name string) *UpdateGcpUserAccessBindingOperation {
	return &UpdateGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateGcpUserAccessBindingOperation returns a new UpdateGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created UpdateGcpUserAccessBindingOperation, possibly from a different process.
func (c *restClient) UpdateGcpUserAccessBindingOperation(name string) *UpdateGcpUserAccessBindingOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateGcpUserAccessBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateServicePerimeterOperation returns a new UpdateServicePerimeterOperation from a given name.
// The name must be that of a previously created UpdateServicePerimeterOperation, possibly from a different process.
func (c *gRPCClient) UpdateServicePerimeterOperation(name string) *UpdateServicePerimeterOperation {
	return &UpdateServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateServicePerimeterOperation returns a new UpdateServicePerimeterOperation from a given name.
// The name must be that of a previously created UpdateServicePerimeterOperation, possibly from a different process.
func (c *restClient) UpdateServicePerimeterOperation(name string) *UpdateServicePerimeterOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateServicePerimeterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
