/*
Package uexampleoc is a generated package which contains definitions
of structs which represent a YANG schema. The generated schema can be
compressed by a series of transformations (compression was false
in this case).

NOTE WELL: This is an example code file that is distributed with ygot.
It should not be used within your application, as it WILL change,
without warning. Rather, you should generate structs directly from
OpenConfig models using the ygot package.

This package was generated by github.com/openconfig/ygot
using the following YANG input files:
  - public/release/models/system/openconfig-system.yang
  - public/release/models/platform/openconfig-platform.yang
  - public/release/models/optical-transport/openconfig-terminal-device.yang

Imported modules were sourced from:
  - public/...
  - deps/...
*/
package uexampleoc

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/ygot/ytypes"
)

// Binary is a type that is used for fields that have a YANG type of
// binary. It is used such that binary fields can be distinguished from
// leaf-lists of uint8s (which are mapped to []uint8, equivalent to
// []byte in reflection).
type Binary []byte

// YANGEmpty is a type that is used for fields that have a YANG type of
// empty. It is used such that empty fields can be distinguished from boolean fields
// in the generated code.
type YANGEmpty bool

// UnionInt8 is an int8 type assignable to unions of which it is a subtype.
type UnionInt8 int8

// UnionInt16 is an int16 type assignable to unions of which it is a subtype.
type UnionInt16 int16

// UnionInt32 is an int32 type assignable to unions of which it is a subtype.
type UnionInt32 int32

// UnionInt64 is an int64 type assignable to unions of which it is a subtype.
type UnionInt64 int64

// UnionUint8 is a uint8 type assignable to unions of which it is a subtype.
type UnionUint8 uint8

// UnionUint16 is a uint16 type assignable to unions of which it is a subtype.
type UnionUint16 uint16

// UnionUint32 is a uint32 type assignable to unions of which it is a subtype.
type UnionUint32 uint32

// UnionUint64 is a uint64 type assignable to unions of which it is a subtype.
type UnionUint64 uint64

// UnionFloat64 is a float64 type assignable to unions of which it is a subtype.
type UnionFloat64 float64

// UnionString is a string type assignable to unions of which it is a subtype.
type UnionString string

// UnionBool is a bool type assignable to unions of which it is a subtype.
type UnionBool bool

// UnionUnsupported is an interface{} wrapper type for unsupported types. It is
// assignable to unions of which it is a subtype.
type UnionUnsupported struct {
	Value interface{}
}

var (
	SchemaTree map[string]*yang.Entry
	ΛEnumTypes map[string][]reflect.Type
)

func init() {
	var err error
	initΛEnumTypes()
	if SchemaTree, err = UnzipSchema(); err != nil {
		panic("schema error: " + err.Error())
	}
}

// Schema returns the details of the generated schema.
func Schema() (*ytypes.Schema, error) {
	uzp, err := UnzipSchema()
	if err != nil {
		return nil, fmt.Errorf("cannot unzip schema, %v", err)
	}

	return &ytypes.Schema{
		Root:       &Device{},
		SchemaTree: uzp,
		Unmarshal:  Unmarshal,
	}, nil
}

// UnzipSchema unzips the zipped schema and returns a map of yang.Entry nodes,
// keyed by the name of the struct that the yang.Entry describes the schema for.
func UnzipSchema() (map[string]*yang.Entry, error) {
	var schemaTree map[string]*yang.Entry
	var err error
	if schemaTree, err = ygot.GzipToSchema(ySchema); err != nil {
		return nil, fmt.Errorf("could not unzip the schema; %v", err)
	}
	return schemaTree, nil
}

// Unmarshal unmarshals data, which must be RFC7951 JSON format, into
// destStruct, which must be non-nil and the correct GoStruct type. It returns
// an error if the destStruct is not found in the schema or the data cannot be
// unmarshaled. The supplied options (opts) are used to control the behaviour
// of the unmarshal function - for example, determining whether errors are
// thrown for unknown fields in the input JSON.
func Unmarshal(data []byte, destStruct ygot.GoStruct, opts ...ytypes.UnmarshalOpt) error {
	tn := reflect.TypeOf(destStruct).Elem().Name()
	schema, ok := SchemaTree[tn]
	if !ok {
		return fmt.Errorf("could not find schema for type %s", tn)
	}
	var jsonTree interface{}
	if err := json.Unmarshal([]byte(data), &jsonTree); err != nil {
		return err
	}
	return ytypes.Unmarshal(schema, destStruct, jsonTree, opts...)
}

// Device represents the /device YANG schema element.
type Device struct {
	ΛMetadata         []ygot.Annotation                           `path:"@" ygotAnnotation:"true"`
	Acl               *OpenconfigAcl_Acl                          `path:"acl" module:"openconfig-acl"`
	ΛAcl              []ygot.Annotation                           `path:"@acl" ygotAnnotation:"true"`
	Bfd               *OpenconfigBfd_Bfd                          `path:"bfd" module:"openconfig-bfd"`
	ΛBfd              []ygot.Annotation                           `path:"@bfd" ygotAnnotation:"true"`
	Components        *OpenconfigPlatform_Components              `path:"components" module:"openconfig-platform"`
	ΛComponents       []ygot.Annotation                           `path:"@components" ygotAnnotation:"true"`
	DefinedSets       *OpenconfigDefinedSets_DefinedSets          `path:"defined-sets" module:"openconfig-defined-sets"`
	ΛDefinedSets      []ygot.Annotation                           `path:"@defined-sets" ygotAnnotation:"true"`
	Interfaces        *OpenconfigInterfaces_Interfaces            `path:"interfaces" module:"openconfig-interfaces"`
	ΛInterfaces       []ygot.Annotation                           `path:"@interfaces" ygotAnnotation:"true"`
	Keychains         *OpenconfigKeychain_Keychains               `path:"keychains" module:"openconfig-keychain"`
	ΛKeychains        []ygot.Annotation                           `path:"@keychains" ygotAnnotation:"true"`
	Lldp              *OpenconfigLldp_Lldp                        `path:"lldp" module:"openconfig-lldp"`
	ΛLldp             []ygot.Annotation                           `path:"@lldp" ygotAnnotation:"true"`
	Messages          *OpenconfigMessages_Messages                `path:"messages" module:"openconfig-messages"`
	ΛMessages         []ygot.Annotation                           `path:"@messages" ygotAnnotation:"true"`
	NetworkInstances  *OpenconfigNetworkInstance_NetworkInstances `path:"network-instances" module:"openconfig-network-instance"`
	ΛNetworkInstances []ygot.Annotation                           `path:"@network-instances" ygotAnnotation:"true"`
	RoutingPolicy     *OpenconfigRoutingPolicy_RoutingPolicy      `path:"routing-policy" module:"openconfig-routing-policy"`
	ΛRoutingPolicy    []ygot.Annotation                           `path:"@routing-policy" ygotAnnotation:"true"`
	System            *OpenconfigSystem_System                    `path:"system" module:"openconfig-system"`
	ΛSystem           []ygot.Annotation                           `path:"@system" ygotAnnotation:"true"`
	TerminalDevice    *OpenconfigTerminalDevice_TerminalDevice    `path:"terminal-device" module:"openconfig-terminal-device"`
	ΛTerminalDevice   []ygot.Annotation                           `path:"@terminal-device" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Device implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Device) IsYANGGoStruct() {}

// GetOrCreateAcl retrieves the value of the Acl field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateAcl() *OpenconfigAcl_Acl {
	if t.Acl != nil {
		return t.Acl
	}
	t.Acl = &OpenconfigAcl_Acl{}
	return t.Acl
}

// GetOrCreateBfd retrieves the value of the Bfd field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateBfd() *OpenconfigBfd_Bfd {
	if t.Bfd != nil {
		return t.Bfd
	}
	t.Bfd = &OpenconfigBfd_Bfd{}
	return t.Bfd
}

// GetOrCreateComponents retrieves the value of the Components field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateComponents() *OpenconfigPlatform_Components {
	if t.Components != nil {
		return t.Components
	}
	t.Components = &OpenconfigPlatform_Components{}
	return t.Components
}

// GetOrCreateDefinedSets retrieves the value of the DefinedSets field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateDefinedSets() *OpenconfigDefinedSets_DefinedSets {
	if t.DefinedSets != nil {
		return t.DefinedSets
	}
	t.DefinedSets = &OpenconfigDefinedSets_DefinedSets{}
	return t.DefinedSets
}

// GetOrCreateInterfaces retrieves the value of the Interfaces field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateInterfaces() *OpenconfigInterfaces_Interfaces {
	if t.Interfaces != nil {
		return t.Interfaces
	}
	t.Interfaces = &OpenconfigInterfaces_Interfaces{}
	return t.Interfaces
}

// GetOrCreateKeychains retrieves the value of the Keychains field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateKeychains() *OpenconfigKeychain_Keychains {
	if t.Keychains != nil {
		return t.Keychains
	}
	t.Keychains = &OpenconfigKeychain_Keychains{}
	return t.Keychains
}

// GetOrCreateLldp retrieves the value of the Lldp field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateLldp() *OpenconfigLldp_Lldp {
	if t.Lldp != nil {
		return t.Lldp
	}
	t.Lldp = &OpenconfigLldp_Lldp{}
	return t.Lldp
}

// GetOrCreateMessages retrieves the value of the Messages field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateMessages() *OpenconfigMessages_Messages {
	if t.Messages != nil {
		return t.Messages
	}
	t.Messages = &OpenconfigMessages_Messages{}
	return t.Messages
}

// GetOrCreateNetworkInstances retrieves the value of the NetworkInstances field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateNetworkInstances() *OpenconfigNetworkInstance_NetworkInstances {
	if t.NetworkInstances != nil {
		return t.NetworkInstances
	}
	t.NetworkInstances = &OpenconfigNetworkInstance_NetworkInstances{}
	return t.NetworkInstances
}

// GetOrCreateRoutingPolicy retrieves the value of the RoutingPolicy field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateRoutingPolicy() *OpenconfigRoutingPolicy_RoutingPolicy {
	if t.RoutingPolicy != nil {
		return t.RoutingPolicy
	}
	t.RoutingPolicy = &OpenconfigRoutingPolicy_RoutingPolicy{}
	return t.RoutingPolicy
}

// GetOrCreateSystem retrieves the value of the System field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateSystem() *OpenconfigSystem_System {
	if t.System != nil {
		return t.System
	}
	t.System = &OpenconfigSystem_System{}
	return t.System
}

// GetOrCreateTerminalDevice retrieves the value of the TerminalDevice field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateTerminalDevice() *OpenconfigTerminalDevice_TerminalDevice {
	if t.TerminalDevice != nil {
		return t.TerminalDevice
	}
	t.TerminalDevice = &OpenconfigTerminalDevice_TerminalDevice{}
	return t.TerminalDevice
}

// GetAcl returns the value of the Acl struct pointer
// from Device. If the receiver or the field Acl is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetAcl() *OpenconfigAcl_Acl {
	if t != nil && t.Acl != nil {
		return t.Acl
	}
	return nil
}

// GetBfd returns the value of the Bfd struct pointer
// from Device. If the receiver or the field Bfd is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetBfd() *OpenconfigBfd_Bfd {
	if t != nil && t.Bfd != nil {
		return t.Bfd
	}
	return nil
}

// GetComponents returns the value of the Components struct pointer
// from Device. If the receiver or the field Components is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetComponents() *OpenconfigPlatform_Components {
	if t != nil && t.Components != nil {
		return t.Components
	}
	return nil
}

// GetDefinedSets returns the value of the DefinedSets struct pointer
// from Device. If the receiver or the field DefinedSets is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetDefinedSets() *OpenconfigDefinedSets_DefinedSets {
	if t != nil && t.DefinedSets != nil {
		return t.DefinedSets
	}
	return nil
}

// GetInterfaces returns the value of the Interfaces struct pointer
// from Device. If the receiver or the field Interfaces is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetInterfaces() *OpenconfigInterfaces_Interfaces {
	if t != nil && t.Interfaces != nil {
		return t.Interfaces
	}
	return nil
}

// GetKeychains returns the value of the Keychains struct pointer
// from Device. If the receiver or the field Keychains is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetKeychains() *OpenconfigKeychain_Keychains {
	if t != nil && t.Keychains != nil {
		return t.Keychains
	}
	return nil
}

// GetLldp returns the value of the Lldp struct pointer
// from Device. If the receiver or the field Lldp is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetLldp() *OpenconfigLldp_Lldp {
	if t != nil && t.Lldp != nil {
		return t.Lldp
	}
	return nil
}

// GetMessages returns the value of the Messages struct pointer
// from Device. If the receiver or the field Messages is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetMessages() *OpenconfigMessages_Messages {
	if t != nil && t.Messages != nil {
		return t.Messages
	}
	return nil
}

// GetNetworkInstances returns the value of the NetworkInstances struct pointer
// from Device. If the receiver or the field NetworkInstances is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetNetworkInstances() *OpenconfigNetworkInstance_NetworkInstances {
	if t != nil && t.NetworkInstances != nil {
		return t.NetworkInstances
	}
	return nil
}

// GetRoutingPolicy returns the value of the RoutingPolicy struct pointer
// from Device. If the receiver or the field RoutingPolicy is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetRoutingPolicy() *OpenconfigRoutingPolicy_RoutingPolicy {
	if t != nil && t.RoutingPolicy != nil {
		return t.RoutingPolicy
	}
	return nil
}

// GetSystem returns the value of the System struct pointer
// from Device. If the receiver or the field System is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetSystem() *OpenconfigSystem_System {
	if t != nil && t.System != nil {
		return t.System
	}
	return nil
}

// GetTerminalDevice returns the value of the TerminalDevice struct pointer
// from Device. If the receiver or the field TerminalDevice is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetTerminalDevice() *OpenconfigTerminalDevice_TerminalDevice {
	if t != nil && t.TerminalDevice != nil {
		return t.TerminalDevice
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the Device
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Device) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Acl.PopulateDefaults()
	t.Bfd.PopulateDefaults()
	t.Components.PopulateDefaults()
	t.DefinedSets.PopulateDefaults()
	t.Interfaces.PopulateDefaults()
	t.Keychains.PopulateDefaults()
	t.Lldp.PopulateDefaults()
	t.Messages.PopulateDefaults()
	t.NetworkInstances.PopulateDefaults()
	t.RoutingPolicy.PopulateDefaults()
	t.System.PopulateDefaults()
	t.TerminalDevice.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Device"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Device) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Device.
func (*Device) ΛBelongingModule() string {
	return ""
}

// OpenconfigAcl_Acl represents the /openconfig-acl/acl YANG schema element.
type OpenconfigAcl_Acl struct {
	ΛMetadata   []ygot.Annotation             `path:"@" ygotAnnotation:"true"`
	AclSets     *OpenconfigAcl_Acl_AclSets    `path:"acl-sets" module:"openconfig-acl"`
	ΛAclSets    []ygot.Annotation             `path:"@acl-sets" ygotAnnotation:"true"`
	Config      *OpenconfigAcl_Acl_Config     `path:"config" module:"openconfig-acl"`
	ΛConfig     []ygot.Annotation             `path:"@config" ygotAnnotation:"true"`
	Interfaces  *OpenconfigAcl_Acl_Interfaces `path:"interfaces" module:"openconfig-acl"`
	ΛInterfaces []ygot.Annotation             `path:"@interfaces" ygotAnnotation:"true"`
	State       *OpenconfigAcl_Acl_State      `path:"state" module:"openconfig-acl"`
	ΛState      []ygot.Annotation             `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl) IsYANGGoStruct() {}

// GetOrCreateAclSets retrieves the value of the AclSets field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl) GetOrCreateAclSets() *OpenconfigAcl_Acl_AclSets {
	if t.AclSets != nil {
		return t.AclSets
	}
	t.AclSets = &OpenconfigAcl_Acl_AclSets{}
	return t.AclSets
}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl) GetOrCreateConfig() *OpenconfigAcl_Acl_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_Config{}
	return t.Config
}

// GetOrCreateInterfaces retrieves the value of the Interfaces field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl) GetOrCreateInterfaces() *OpenconfigAcl_Acl_Interfaces {
	if t.Interfaces != nil {
		return t.Interfaces
	}
	t.Interfaces = &OpenconfigAcl_Acl_Interfaces{}
	return t.Interfaces
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl) GetOrCreateState() *OpenconfigAcl_Acl_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_State{}
	return t.State
}

// GetAclSets returns the value of the AclSets struct pointer
// from OpenconfigAcl_Acl. If the receiver or the field AclSets is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl) GetAclSets() *OpenconfigAcl_Acl_AclSets {
	if t != nil && t.AclSets != nil {
		return t.AclSets
	}
	return nil
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl) GetConfig() *OpenconfigAcl_Acl_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetInterfaces returns the value of the Interfaces struct pointer
// from OpenconfigAcl_Acl. If the receiver or the field Interfaces is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl) GetInterfaces() *OpenconfigAcl_Acl_Interfaces {
	if t != nil && t.Interfaces != nil {
		return t.Interfaces
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl) GetState() *OpenconfigAcl_Acl_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.AclSets.PopulateDefaults()
	t.Config.PopulateDefaults()
	t.Interfaces.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl.
func (*OpenconfigAcl_Acl) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets represents the /openconfig-acl/acl/acl-sets YANG schema element.
type OpenconfigAcl_Acl_AclSets struct {
	ΛMetadata []ygot.Annotation                                                          `path:"@" ygotAnnotation:"true"`
	AclSet    map[OpenconfigAcl_Acl_AclSets_AclSet_Key]*OpenconfigAcl_Acl_AclSets_AclSet `path:"acl-set" module:"openconfig-acl"`
	ΛAclSet   []ygot.Annotation                                                          `path:"@acl-set" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_AclSets_AclSet_Key represents the key for list AclSet of element /openconfig-acl/acl/acl-sets.
type OpenconfigAcl_Acl_AclSets_AclSet_Key struct {
	Name string                   `path:"name"`
	Type E_OpenconfigAcl_ACL_TYPE `path:"type"`
}

// IsYANGGoKeyStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigAcl_Acl_AclSets_AclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigAcl_Acl_AclSets_AclSet_Key key struct.
func (t OpenconfigAcl_Acl_AclSets_AclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"name": t.Name,
		"type": t.Type,
	}, nil
}

// NewAclSet creates a new entry in the AclSet list of the
// OpenconfigAcl_Acl_AclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_AclSets) NewAclSet(Name string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_AclSets_AclSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclSet == nil {
		t.AclSet = make(map[OpenconfigAcl_Acl_AclSets_AclSet_Key]*OpenconfigAcl_Acl_AclSets_AclSet)
	}

	key := OpenconfigAcl_Acl_AclSets_AclSet_Key{
		Name: Name,
		Type: Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclSet", key)
	}

	t.AclSet[key] = &OpenconfigAcl_Acl_AclSets_AclSet{
		Name: &Name,
		Type: Type,
	}

	return t.AclSet[key], nil
}

// RenameAclSet renames an entry in the list AclSet within
// the OpenconfigAcl_Acl_AclSets struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigAcl_Acl_AclSets) RenameAclSet(oldK, newK OpenconfigAcl_Acl_AclSets_AclSet_Key) error {
	if _, ok := t.AclSet[newK]; ok {
		return fmt.Errorf("key %v already exists in AclSet", newK)
	}

	e, ok := t.AclSet[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in AclSet", oldK)
	}
	e.Name = &newK.Name
	e.Type = newK.Type

	t.AclSet[newK] = e
	delete(t.AclSet, oldK)
	return nil
}

// GetOrCreateAclSetMap returns the list (map) from OpenconfigAcl_Acl_AclSets.
//
// It initializes the field if not already initialized.
func (t *OpenconfigAcl_Acl_AclSets) GetOrCreateAclSetMap() map[OpenconfigAcl_Acl_AclSets_AclSet_Key]*OpenconfigAcl_Acl_AclSets_AclSet {
	if t.AclSet == nil {
		t.AclSet = make(map[OpenconfigAcl_Acl_AclSets_AclSet_Key]*OpenconfigAcl_Acl_AclSets_AclSet)
	}
	return t.AclSet
}

// GetOrCreateAclSet retrieves the value with the specified keys from
// the receiver OpenconfigAcl_Acl_AclSets. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigAcl_Acl_AclSets) GetOrCreateAclSet(Name string, Type E_OpenconfigAcl_ACL_TYPE) *OpenconfigAcl_Acl_AclSets_AclSet {

	key := OpenconfigAcl_Acl_AclSets_AclSet_Key{
		Name: Name,
		Type: Type,
	}

	if v, ok := t.AclSet[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewAclSet(Name, Type)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateAclSet got unexpected error: %v", err))
	}
	return v
}

// GetAclSet retrieves the value with the specified key from
// the AclSet map field of OpenconfigAcl_Acl_AclSets. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigAcl_Acl_AclSets) GetAclSet(Name string, Type E_OpenconfigAcl_ACL_TYPE) *OpenconfigAcl_Acl_AclSets_AclSet {

	if t == nil {
		return nil
	}

	key := OpenconfigAcl_Acl_AclSets_AclSet_Key{
		Name: Name,
		Type: Type,
	}

	if lm, ok := t.AclSet[key]; ok {
		return lm
	}
	return nil
}

// AppendAclSet appends the supplied OpenconfigAcl_Acl_AclSets_AclSet struct to the
// list AclSet of OpenconfigAcl_Acl_AclSets. If the key value(s) specified in
// the supplied OpenconfigAcl_Acl_AclSets_AclSet already exist in the list, an error is
// returned.
func (t *OpenconfigAcl_Acl_AclSets) AppendAclSet(v *OpenconfigAcl_Acl_AclSets_AclSet) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key for Name")
	}

	key := OpenconfigAcl_Acl_AclSets_AclSet_Key{
		Name: *v.Name,
		Type: v.Type,
	}

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclSet == nil {
		t.AclSet = make(map[OpenconfigAcl_Acl_AclSets_AclSet_Key]*OpenconfigAcl_Acl_AclSets_AclSet)
	}

	if _, ok := t.AclSet[key]; ok {
		return fmt.Errorf("duplicate key for list AclSet %v", key)
	}

	t.AclSet[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.AclSet {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets.
func (*OpenconfigAcl_Acl_AclSets) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet represents the /openconfig-acl/acl/acl-sets/acl-set YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet struct {
	ΛMetadata   []ygot.Annotation                            `path:"@" ygotAnnotation:"true"`
	AclEntries  *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries `path:"acl-entries" module:"openconfig-acl"`
	ΛAclEntries []ygot.Annotation                            `path:"@acl-entries" ygotAnnotation:"true"`
	Config      *OpenconfigAcl_Acl_AclSets_AclSet_Config     `path:"config" module:"openconfig-acl"`
	ΛConfig     []ygot.Annotation                            `path:"@config" ygotAnnotation:"true"`
	Name        *string                                      `path:"name" module:"openconfig-acl"`
	ΛName       []ygot.Annotation                            `path:"@name" ygotAnnotation:"true"`
	State       *OpenconfigAcl_Acl_AclSets_AclSet_State      `path:"state" module:"openconfig-acl"`
	ΛState      []ygot.Annotation                            `path:"@state" ygotAnnotation:"true"`
	Type        E_OpenconfigAcl_ACL_TYPE                     `path:"type" module:"openconfig-acl"`
	ΛType       []ygot.Annotation                            `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet) IsYANGGoStruct() {}

// GetOrCreateAclEntries retrieves the value of the AclEntries field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) GetOrCreateAclEntries() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries {
	if t.AclEntries != nil {
		return t.AclEntries
	}
	t.AclEntries = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries{}
	return t.AclEntries
}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_State{}
	return t.State
}

// GetAclEntries returns the value of the AclEntries struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet. If the receiver or the field AclEntries is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) GetAclEntries() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries {
	if t != nil && t.AclEntries != nil {
		return t.AclEntries
	}
	return nil
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetName retrieves the value of the leaf Name from the OpenconfigAcl_Acl_AclSets_AclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_AclSets_AclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) GetType() E_OpenconfigAcl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.AclEntries.PopulateDefaults()
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_AclSets_AclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
		"type": t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet.
func (*OpenconfigAcl_Acl_AclSets_AclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries struct {
	ΛMetadata []ygot.Annotation                                                `path:"@" ygotAnnotation:"true"`
	AclEntry  map[uint32]*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry `path:"acl-entry" module:"openconfig-acl"`
	ΛAclEntry []ygot.Annotation                                                `path:"@acl-entry" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) IsYANGGoStruct() {}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// RenameAclEntry renames an entry in the list AclEntry within
// the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) RenameAclEntry(oldK, newK uint32) error {
	if _, ok := t.AclEntry[newK]; ok {
		return fmt.Errorf("key %v already exists in AclEntry", newK)
	}

	e, ok := t.AclEntry[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in AclEntry", oldK)
	}
	e.SequenceId = &newK

	t.AclEntry[newK] = e
	delete(t.AclEntry, oldK)
	return nil
}

// GetOrCreateAclEntryMap returns the list (map) from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries.
//
// It initializes the field if not already initialized.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) GetOrCreateAclEntryMap() map[uint32]*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry {
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry)
	}
	return t.AclEntry
}

// GetOrCreateAclEntry retrieves the value with the specified keys from
// the receiver OpenconfigAcl_Acl_AclSets_AclSet_AclEntries. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) GetOrCreateAclEntry(SequenceId uint32) *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry {

	key := SequenceId

	if v, ok := t.AclEntry[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewAclEntry(SequenceId)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateAclEntry got unexpected error: %v", err))
	}
	return v
}

// GetAclEntry retrieves the value with the specified key from
// the AclEntry map field of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) GetAclEntry(SequenceId uint32) *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry {

	if t == nil {
		return nil
	}

	key := SequenceId

	if lm, ok := t.AclEntry[key]; ok {
		return lm
	}
	return nil
}

// AppendAclEntry appends the supplied OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry struct to the
// list AclEntry of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries. If the key value(s) specified in
// the supplied OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry already exist in the list, an error is
// returned.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) AppendAclEntry(v *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) error {
	if v.SequenceId == nil {
		return fmt.Errorf("invalid nil key received for SequenceId")
	}

	key := *v.SequenceId

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry)
	}

	if _, ok := t.AclEntry[key]; ok {
		return fmt.Errorf("duplicate key for list AclEntry %v", key)
	}

	t.AclEntry[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.AclEntry {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry struct {
	ΛMetadata       []ygot.Annotation                                                    `path:"@" ygotAnnotation:"true"`
	Actions         *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions        `path:"actions" module:"openconfig-acl"`
	ΛActions        []ygot.Annotation                                                    `path:"@actions" ygotAnnotation:"true"`
	Config          *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config         `path:"config" module:"openconfig-acl"`
	ΛConfig         []ygot.Annotation                                                    `path:"@config" ygotAnnotation:"true"`
	InputInterface  *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface `path:"input-interface" module:"openconfig-acl"`
	ΛInputInterface []ygot.Annotation                                                    `path:"@input-interface" ygotAnnotation:"true"`
	Ipv4            *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4           `path:"ipv4" module:"openconfig-acl"`
	ΛIpv4           []ygot.Annotation                                                    `path:"@ipv4" ygotAnnotation:"true"`
	Ipv6            *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6           `path:"ipv6" module:"openconfig-acl"`
	ΛIpv6           []ygot.Annotation                                                    `path:"@ipv6" ygotAnnotation:"true"`
	L2              *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2             `path:"l2" module:"openconfig-acl"`
	ΛL2             []ygot.Annotation                                                    `path:"@l2" ygotAnnotation:"true"`
	Mpls            *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls           `path:"mpls" module:"openconfig-acl"`
	ΛMpls           []ygot.Annotation                                                    `path:"@mpls" ygotAnnotation:"true"`
	SequenceId      *uint32                                                              `path:"sequence-id" module:"openconfig-acl"`
	ΛSequenceId     []ygot.Annotation                                                    `path:"@sequence-id" ygotAnnotation:"true"`
	State           *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State          `path:"state" module:"openconfig-acl"`
	ΛState          []ygot.Annotation                                                    `path:"@state" ygotAnnotation:"true"`
	Transport       *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport      `path:"transport" module:"openconfig-acl"`
	ΛTransport      []ygot.Annotation                                                    `path:"@transport" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) IsYANGGoStruct() {}

// GetOrCreateActions retrieves the value of the Actions field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetOrCreateActions() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions {
	if t.Actions != nil {
		return t.Actions
	}
	t.Actions = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions{}
	return t.Actions
}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config{}
	return t.Config
}

// GetOrCreateInputInterface retrieves the value of the InputInterface field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetOrCreateInputInterface() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface {
	if t.InputInterface != nil {
		return t.InputInterface
	}
	t.InputInterface = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface{}
	return t.InputInterface
}

// GetOrCreateIpv4 retrieves the value of the Ipv4 field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetOrCreateIpv4() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 {
	if t.Ipv4 != nil {
		return t.Ipv4
	}
	t.Ipv4 = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4{}
	return t.Ipv4
}

// GetOrCreateIpv6 retrieves the value of the Ipv6 field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetOrCreateIpv6() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 {
	if t.Ipv6 != nil {
		return t.Ipv6
	}
	t.Ipv6 = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6{}
	return t.Ipv6
}

// GetOrCreateL2 retrieves the value of the L2 field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetOrCreateL2() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 {
	if t.L2 != nil {
		return t.L2
	}
	t.L2 = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2{}
	return t.L2
}

// GetOrCreateMpls retrieves the value of the Mpls field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetOrCreateMpls() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls {
	if t.Mpls != nil {
		return t.Mpls
	}
	t.Mpls = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls{}
	return t.Mpls
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State{}
	return t.State
}

// GetOrCreateTransport retrieves the value of the Transport field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetOrCreateTransport() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport {
	if t.Transport != nil {
		return t.Transport
	}
	t.Transport = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport{}
	return t.Transport
}

// GetActions returns the value of the Actions struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry. If the receiver or the field Actions is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetActions() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions {
	if t != nil && t.Actions != nil {
		return t.Actions
	}
	return nil
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetInputInterface returns the value of the InputInterface struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry. If the receiver or the field InputInterface is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetInputInterface() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface {
	if t != nil && t.InputInterface != nil {
		return t.InputInterface
	}
	return nil
}

// GetIpv4 returns the value of the Ipv4 struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry. If the receiver or the field Ipv4 is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetIpv4() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 {
	if t != nil && t.Ipv4 != nil {
		return t.Ipv4
	}
	return nil
}

// GetIpv6 returns the value of the Ipv6 struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry. If the receiver or the field Ipv6 is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetIpv6() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 {
	if t != nil && t.Ipv6 != nil {
		return t.Ipv6
	}
	return nil
}

// GetL2 returns the value of the L2 struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry. If the receiver or the field L2 is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetL2() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 {
	if t != nil && t.L2 != nil {
		return t.L2
	}
	return nil
}

// GetMpls returns the value of the Mpls struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry. If the receiver or the field Mpls is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetMpls() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls {
	if t != nil && t.Mpls != nil {
		return t.Mpls
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetTransport returns the value of the Transport struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry. If the receiver or the field Transport is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetTransport() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport {
	if t != nil && t.Transport != nil {
		return t.Transport
	}
	return nil
}

// GetSequenceId retrieves the value of the leaf SequenceId from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SequenceId is set, it can
// safely use t.GetSequenceId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SequenceId == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) GetSequenceId() uint32 {
	if t == nil || t.SequenceId == nil {
		return 0
	}
	return *t.SequenceId
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Actions.PopulateDefaults()
	t.Config.PopulateDefaults()
	t.InputInterface.PopulateDefaults()
	t.Ipv4.PopulateDefaults()
	t.Ipv6.PopulateDefaults()
	t.L2.PopulateDefaults()
	t.Mpls.PopulateDefaults()
	t.State.PopulateDefaults()
	t.Transport.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions struct {
	ΛMetadata []ygot.Annotation                                                    `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config `path:"config" module:"openconfig-acl"`
	ΛConfig   []ygot.Annotation                                                    `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State  `path:"state" module:"openconfig-acl"`
	ΛState    []ygot.Annotation                                                    `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config struct {
	ΛMetadata         []ygot.Annotation                 `path:"@" ygotAnnotation:"true"`
	ForwardingAction  E_OpenconfigAcl_FORWARDING_ACTION `path:"forwarding-action" module:"openconfig-acl"`
	ΛForwardingAction []ygot.Annotation                 `path:"@forwarding-action" ygotAnnotation:"true"`
	LogAction         E_OpenconfigAcl_LOG_ACTION        `path:"log-action" module:"openconfig-acl"`
	ΛLogAction        []ygot.Annotation                 `path:"@log-action" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) IsYANGGoStruct() {}

// GetForwardingAction retrieves the value of the leaf ForwardingAction from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ForwardingAction is set, it can
// safely use t.GetForwardingAction() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ForwardingAction == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) GetForwardingAction() E_OpenconfigAcl_FORWARDING_ACTION {
	if t == nil || t.ForwardingAction == 0 {
		return 0
	}
	return t.ForwardingAction
}

// GetLogAction retrieves the value of the leaf LogAction from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LogAction is set, it can
// safely use t.GetLogAction() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LogAction == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) GetLogAction() E_OpenconfigAcl_LOG_ACTION {
	if t == nil || t.LogAction == 0 {
		return OpenconfigAcl_LOG_ACTION_LOG_NONE
	}
	return t.LogAction
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.LogAction == 0 {
		t.LogAction = OpenconfigAcl_LOG_ACTION_LOG_NONE
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State struct {
	ΛMetadata         []ygot.Annotation                 `path:"@" ygotAnnotation:"true"`
	ForwardingAction  E_OpenconfigAcl_FORWARDING_ACTION `path:"forwarding-action" module:"openconfig-acl"`
	ΛForwardingAction []ygot.Annotation                 `path:"@forwarding-action" ygotAnnotation:"true"`
	LogAction         E_OpenconfigAcl_LOG_ACTION        `path:"log-action" module:"openconfig-acl"`
	ΛLogAction        []ygot.Annotation                 `path:"@log-action" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) IsYANGGoStruct() {}

// GetForwardingAction retrieves the value of the leaf ForwardingAction from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ForwardingAction is set, it can
// safely use t.GetForwardingAction() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ForwardingAction == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) GetForwardingAction() E_OpenconfigAcl_FORWARDING_ACTION {
	if t == nil || t.ForwardingAction == 0 {
		return 0
	}
	return t.ForwardingAction
}

// GetLogAction retrieves the value of the leaf LogAction from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LogAction is set, it can
// safely use t.GetLogAction() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LogAction == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) GetLogAction() E_OpenconfigAcl_LOG_ACTION {
	if t == nil || t.LogAction == 0 {
		return OpenconfigAcl_LOG_ACTION_LOG_NONE
	}
	return t.LogAction
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.LogAction == 0 {
		t.LogAction = OpenconfigAcl_LOG_ACTION_LOG_NONE
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config struct {
	ΛMetadata    []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Description  *string           `path:"description" module:"openconfig-acl"`
	ΛDescription []ygot.Annotation `path:"@description" ygotAnnotation:"true"`
	SequenceId   *uint32           `path:"sequence-id" module:"openconfig-acl"`
	ΛSequenceId  []ygot.Annotation `path:"@sequence-id" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) IsYANGGoStruct() {}

// GetDescription retrieves the value of the leaf Description from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetSequenceId retrieves the value of the leaf SequenceId from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SequenceId is set, it can
// safely use t.GetSequenceId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SequenceId == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) GetSequenceId() uint32 {
	if t == nil || t.SequenceId == nil {
		return 0
	}
	return *t.SequenceId
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface struct {
	ΛMetadata     []ygot.Annotation                                                                 `path:"@" ygotAnnotation:"true"`
	Config        *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config       `path:"config" module:"openconfig-acl"`
	ΛConfig       []ygot.Annotation                                                                 `path:"@config" ygotAnnotation:"true"`
	InterfaceRef  *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef `path:"interface-ref" module:"openconfig-acl"`
	ΛInterfaceRef []ygot.Annotation                                                                 `path:"@interface-ref" ygotAnnotation:"true"`
	State         *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State        `path:"state" module:"openconfig-acl"`
	ΛState        []ygot.Annotation                                                                 `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config{}
	return t.Config
}

// GetOrCreateInterfaceRef retrieves the value of the InterfaceRef field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) GetOrCreateInterfaceRef() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef {
	if t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	t.InterfaceRef = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef{}
	return t.InterfaceRef
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetInterfaceRef returns the value of the InterfaceRef struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface. If the receiver or the field InterfaceRef is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) GetInterfaceRef() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef {
	if t != nil && t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.InterfaceRef.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) IsYANGGoStruct() {}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef struct {
	ΛMetadata []ygot.Annotation                                                                        `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config `path:"config" module:"openconfig-acl"`
	ΛConfig   []ygot.Annotation                                                                        `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State  `path:"state" module:"openconfig-acl"`
	ΛState    []ygot.Annotation                                                                        `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) IsYANGGoStruct() {
}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config struct {
	ΛMetadata     []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Interface     *string           `path:"interface" module:"openconfig-acl"`
	ΛInterface    []ygot.Annotation `path:"@interface" ygotAnnotation:"true"`
	Subinterface  *uint32           `path:"subinterface" module:"openconfig-acl"`
	ΛSubinterface []ygot.Annotation `path:"@subinterface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) IsYANGGoStruct() {
}

// GetInterface retrieves the value of the leaf Interface from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interface is set, it can
// safely use t.GetInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interface == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) GetInterface() string {
	if t == nil || t.Interface == nil {
		return ""
	}
	return *t.Interface
}

// GetSubinterface retrieves the value of the leaf Subinterface from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Subinterface is set, it can
// safely use t.GetSubinterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Subinterface == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) GetSubinterface() uint32 {
	if t == nil || t.Subinterface == nil {
		return 0
	}
	return *t.Subinterface
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State struct {
	ΛMetadata     []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Interface     *string           `path:"interface" module:"openconfig-acl"`
	ΛInterface    []ygot.Annotation `path:"@interface" ygotAnnotation:"true"`
	Subinterface  *uint32           `path:"subinterface" module:"openconfig-acl"`
	ΛSubinterface []ygot.Annotation `path:"@subinterface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) IsYANGGoStruct() {
}

// GetInterface retrieves the value of the leaf Interface from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interface is set, it can
// safely use t.GetInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interface == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) GetInterface() string {
	if t == nil || t.Interface == nil {
		return ""
	}
	return *t.Interface
}

// GetSubinterface retrieves the value of the leaf Subinterface from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Subinterface is set, it can
// safely use t.GetSubinterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Subinterface == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) GetSubinterface() uint32 {
	if t == nil || t.Subinterface == nil {
		return 0
	}
	return *t.Subinterface
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) IsYANGGoStruct() {}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 struct {
	ΛMetadata []ygot.Annotation                                                 `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config `path:"config" module:"openconfig-acl"`
	ΛConfig   []ygot.Annotation                                                 `path:"@config" ygotAnnotation:"true"`
	Icmpv4    *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4 `path:"icmpv4" module:"openconfig-acl"`
	ΛIcmpv4   []ygot.Annotation                                                 `path:"@icmpv4" ygotAnnotation:"true"`
	State     *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State  `path:"state" module:"openconfig-acl"`
	ΛState    []ygot.Annotation                                                 `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config{}
	return t.Config
}

// GetOrCreateIcmpv4 retrieves the value of the Icmpv4 field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) GetOrCreateIcmpv4() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4 {
	if t.Icmpv4 != nil {
		return t.Icmpv4
	}
	t.Icmpv4 = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4{}
	return t.Icmpv4
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetIcmpv4 returns the value of the Icmpv4 struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4. If the receiver or the field Icmpv4 is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) GetIcmpv4() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4 {
	if t != nil && t.Icmpv4 != nil {
		return t.Icmpv4
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.Icmpv4.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config struct {
	ΛMetadata                    []ygot.Annotation                                                               `path:"@" ygotAnnotation:"true"`
	DestinationAddress           *string                                                                         `path:"destination-address" module:"openconfig-acl"`
	ΛDestinationAddress          []ygot.Annotation                                                               `path:"@destination-address" ygotAnnotation:"true"`
	DestinationAddressPrefixSet  *string                                                                         `path:"destination-address-prefix-set" module:"openconfig-acl"`
	ΛDestinationAddressPrefixSet []ygot.Annotation                                                               `path:"@destination-address-prefix-set" ygotAnnotation:"true"`
	Dscp                         *uint8                                                                          `path:"dscp" module:"openconfig-acl"`
	ΛDscp                        []ygot.Annotation                                                               `path:"@dscp" ygotAnnotation:"true"`
	DscpSet                      []uint8                                                                         `path:"dscp-set" module:"openconfig-acl"`
	ΛDscpSet                     []ygot.Annotation                                                               `path:"@dscp-set" ygotAnnotation:"true"`
	HopLimit                     *uint8                                                                          `path:"hop-limit" module:"openconfig-acl"`
	ΛHopLimit                    []ygot.Annotation                                                               `path:"@hop-limit" ygotAnnotation:"true"`
	Length                       *uint16                                                                         `path:"length" module:"openconfig-acl"`
	ΛLength                      []ygot.Annotation                                                               `path:"@length" ygotAnnotation:"true"`
	Protocol                     OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union `path:"protocol" module:"openconfig-acl"`
	ΛProtocol                    []ygot.Annotation                                                               `path:"@protocol" ygotAnnotation:"true"`
	SourceAddress                *string                                                                         `path:"source-address" module:"openconfig-acl"`
	ΛSourceAddress               []ygot.Annotation                                                               `path:"@source-address" ygotAnnotation:"true"`
	SourceAddressPrefixSet       *string                                                                         `path:"source-address-prefix-set" module:"openconfig-acl"`
	ΛSourceAddressPrefixSet      []ygot.Annotation                                                               `path:"@source-address-prefix-set" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) IsYANGGoStruct() {}

// GetDestinationAddress retrieves the value of the leaf DestinationAddress from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationAddress is set, it can
// safely use t.GetDestinationAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) GetDestinationAddress() string {
	if t == nil || t.DestinationAddress == nil {
		return ""
	}
	return *t.DestinationAddress
}

// GetDestinationAddressPrefixSet retrieves the value of the leaf DestinationAddressPrefixSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationAddressPrefixSet is set, it can
// safely use t.GetDestinationAddressPrefixSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationAddressPrefixSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) GetDestinationAddressPrefixSet() string {
	if t == nil || t.DestinationAddressPrefixSet == nil {
		return ""
	}
	return *t.DestinationAddressPrefixSet
}

// GetDscp retrieves the value of the leaf Dscp from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Dscp is set, it can
// safely use t.GetDscp() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Dscp == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) GetDscp() uint8 {
	if t == nil || t.Dscp == nil {
		return 0
	}
	return *t.Dscp
}

// GetDscpSet retrieves the value of the leaf DscpSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DscpSet is set, it can
// safely use t.GetDscpSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DscpSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) GetDscpSet() []uint8 {
	if t == nil || t.DscpSet == nil {
		return nil
	}
	return t.DscpSet
}

// GetHopLimit retrieves the value of the leaf HopLimit from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HopLimit is set, it can
// safely use t.GetHopLimit() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HopLimit == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) GetHopLimit() uint8 {
	if t == nil || t.HopLimit == nil {
		return 0
	}
	return *t.HopLimit
}

// GetLength retrieves the value of the leaf Length from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Length is set, it can
// safely use t.GetLength() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Length == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) GetLength() uint16 {
	if t == nil || t.Length == nil {
		return 0
	}
	return *t.Length
}

// GetProtocol retrieves the value of the leaf Protocol from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Protocol is set, it can
// safely use t.GetProtocol() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Protocol == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) GetProtocol() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union {
	if t == nil || t.Protocol == nil {
		return nil
	}
	return t.Protocol
}

// GetSourceAddress retrieves the value of the leaf SourceAddress from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceAddress is set, it can
// safely use t.GetSourceAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) GetSourceAddress() string {
	if t == nil || t.SourceAddress == nil {
		return ""
	}
	return *t.SourceAddress
}

// GetSourceAddressPrefixSet retrieves the value of the leaf SourceAddressPrefixSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceAddressPrefixSet is set, it can
// safely use t.GetSourceAddressPrefixSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceAddressPrefixSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) GetSourceAddressPrefixSet() string {
	if t == nil || t.SourceAddressPrefixSet == nil {
		return ""
	}
	return *t.SourceAddressPrefixSet
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4 struct {
	ΛMetadata []ygot.Annotation                                                        `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config `path:"config" module:"openconfig-acl"`
	ΛConfig   []ygot.Annotation                                                        `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State  `path:"state" module:"openconfig-acl"`
	ΛState    []ygot.Annotation                                                        `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config struct {
	ΛMetadata []ygot.Annotation            `path:"@" ygotAnnotation:"true"`
	Code      E_OpenconfigIcmpv4Types_CODE `path:"code" module:"openconfig-acl"`
	ΛCode     []ygot.Annotation            `path:"@code" ygotAnnotation:"true"`
	Type      E_OpenconfigIcmpv4Types_TYPE `path:"type" module:"openconfig-acl"`
	ΛType     []ygot.Annotation            `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config) IsYANGGoStruct() {}

// GetCode retrieves the value of the leaf Code from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Code is set, it can
// safely use t.GetCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Code == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config) GetCode() E_OpenconfigIcmpv4Types_CODE {
	if t == nil || t.Code == 0 {
		return 0
	}
	return t.Code
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config) GetType() E_OpenconfigIcmpv4Types_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State struct {
	ΛMetadata []ygot.Annotation            `path:"@" ygotAnnotation:"true"`
	Code      E_OpenconfigIcmpv4Types_CODE `path:"code" module:"openconfig-acl"`
	ΛCode     []ygot.Annotation            `path:"@code" ygotAnnotation:"true"`
	Type      E_OpenconfigIcmpv4Types_TYPE `path:"type" module:"openconfig-acl"`
	ΛType     []ygot.Annotation            `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State) IsYANGGoStruct() {}

// GetCode retrieves the value of the leaf Code from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Code is set, it can
// safely use t.GetCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Code == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State) GetCode() E_OpenconfigIcmpv4Types_CODE {
	if t == nil || t.Code == 0 {
		return 0
	}
	return t.Code
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State) GetType() E_OpenconfigIcmpv4Types_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Icmpv4_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State struct {
	ΛMetadata                    []ygot.Annotation                                                              `path:"@" ygotAnnotation:"true"`
	DestinationAddress           *string                                                                        `path:"destination-address" module:"openconfig-acl"`
	ΛDestinationAddress          []ygot.Annotation                                                              `path:"@destination-address" ygotAnnotation:"true"`
	DestinationAddressPrefixSet  *string                                                                        `path:"destination-address-prefix-set" module:"openconfig-acl"`
	ΛDestinationAddressPrefixSet []ygot.Annotation                                                              `path:"@destination-address-prefix-set" ygotAnnotation:"true"`
	Dscp                         *uint8                                                                         `path:"dscp" module:"openconfig-acl"`
	ΛDscp                        []ygot.Annotation                                                              `path:"@dscp" ygotAnnotation:"true"`
	DscpSet                      []uint8                                                                        `path:"dscp-set" module:"openconfig-acl"`
	ΛDscpSet                     []ygot.Annotation                                                              `path:"@dscp-set" ygotAnnotation:"true"`
	HopLimit                     *uint8                                                                         `path:"hop-limit" module:"openconfig-acl"`
	ΛHopLimit                    []ygot.Annotation                                                              `path:"@hop-limit" ygotAnnotation:"true"`
	Length                       *uint16                                                                        `path:"length" module:"openconfig-acl"`
	ΛLength                      []ygot.Annotation                                                              `path:"@length" ygotAnnotation:"true"`
	Protocol                     OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union `path:"protocol" module:"openconfig-acl"`
	ΛProtocol                    []ygot.Annotation                                                              `path:"@protocol" ygotAnnotation:"true"`
	SourceAddress                *string                                                                        `path:"source-address" module:"openconfig-acl"`
	ΛSourceAddress               []ygot.Annotation                                                              `path:"@source-address" ygotAnnotation:"true"`
	SourceAddressPrefixSet       *string                                                                        `path:"source-address-prefix-set" module:"openconfig-acl"`
	ΛSourceAddressPrefixSet      []ygot.Annotation                                                              `path:"@source-address-prefix-set" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) IsYANGGoStruct() {}

// GetDestinationAddress retrieves the value of the leaf DestinationAddress from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationAddress is set, it can
// safely use t.GetDestinationAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) GetDestinationAddress() string {
	if t == nil || t.DestinationAddress == nil {
		return ""
	}
	return *t.DestinationAddress
}

// GetDestinationAddressPrefixSet retrieves the value of the leaf DestinationAddressPrefixSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationAddressPrefixSet is set, it can
// safely use t.GetDestinationAddressPrefixSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationAddressPrefixSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) GetDestinationAddressPrefixSet() string {
	if t == nil || t.DestinationAddressPrefixSet == nil {
		return ""
	}
	return *t.DestinationAddressPrefixSet
}

// GetDscp retrieves the value of the leaf Dscp from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Dscp is set, it can
// safely use t.GetDscp() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Dscp == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) GetDscp() uint8 {
	if t == nil || t.Dscp == nil {
		return 0
	}
	return *t.Dscp
}

// GetDscpSet retrieves the value of the leaf DscpSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DscpSet is set, it can
// safely use t.GetDscpSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DscpSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) GetDscpSet() []uint8 {
	if t == nil || t.DscpSet == nil {
		return nil
	}
	return t.DscpSet
}

// GetHopLimit retrieves the value of the leaf HopLimit from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HopLimit is set, it can
// safely use t.GetHopLimit() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HopLimit == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) GetHopLimit() uint8 {
	if t == nil || t.HopLimit == nil {
		return 0
	}
	return *t.HopLimit
}

// GetLength retrieves the value of the leaf Length from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Length is set, it can
// safely use t.GetLength() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Length == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) GetLength() uint16 {
	if t == nil || t.Length == nil {
		return 0
	}
	return *t.Length
}

// GetProtocol retrieves the value of the leaf Protocol from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Protocol is set, it can
// safely use t.GetProtocol() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Protocol == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) GetProtocol() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union {
	if t == nil || t.Protocol == nil {
		return nil
	}
	return t.Protocol
}

// GetSourceAddress retrieves the value of the leaf SourceAddress from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceAddress is set, it can
// safely use t.GetSourceAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) GetSourceAddress() string {
	if t == nil || t.SourceAddress == nil {
		return ""
	}
	return *t.SourceAddress
}

// GetSourceAddressPrefixSet retrieves the value of the leaf SourceAddressPrefixSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceAddressPrefixSet is set, it can
// safely use t.GetSourceAddressPrefixSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceAddressPrefixSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) GetSourceAddressPrefixSet() string {
	if t == nil || t.SourceAddressPrefixSet == nil {
		return ""
	}
	return *t.SourceAddressPrefixSet
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 struct {
	ΛMetadata []ygot.Annotation                                                 `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config `path:"config" module:"openconfig-acl"`
	ΛConfig   []ygot.Annotation                                                 `path:"@config" ygotAnnotation:"true"`
	Icmpv6    *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6 `path:"icmpv6" module:"openconfig-acl"`
	ΛIcmpv6   []ygot.Annotation                                                 `path:"@icmpv6" ygotAnnotation:"true"`
	State     *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State  `path:"state" module:"openconfig-acl"`
	ΛState    []ygot.Annotation                                                 `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config{}
	return t.Config
}

// GetOrCreateIcmpv6 retrieves the value of the Icmpv6 field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) GetOrCreateIcmpv6() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6 {
	if t.Icmpv6 != nil {
		return t.Icmpv6
	}
	t.Icmpv6 = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6{}
	return t.Icmpv6
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetIcmpv6 returns the value of the Icmpv6 struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6. If the receiver or the field Icmpv6 is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) GetIcmpv6() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6 {
	if t != nil && t.Icmpv6 != nil {
		return t.Icmpv6
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.Icmpv6.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config struct {
	ΛMetadata                    []ygot.Annotation                                                               `path:"@" ygotAnnotation:"true"`
	DestinationAddress           *string                                                                         `path:"destination-address" module:"openconfig-acl"`
	ΛDestinationAddress          []ygot.Annotation                                                               `path:"@destination-address" ygotAnnotation:"true"`
	DestinationAddressPrefixSet  *string                                                                         `path:"destination-address-prefix-set" module:"openconfig-acl"`
	ΛDestinationAddressPrefixSet []ygot.Annotation                                                               `path:"@destination-address-prefix-set" ygotAnnotation:"true"`
	DestinationFlowLabel         *uint32                                                                         `path:"destination-flow-label" module:"openconfig-acl"`
	ΛDestinationFlowLabel        []ygot.Annotation                                                               `path:"@destination-flow-label" ygotAnnotation:"true"`
	Dscp                         *uint8                                                                          `path:"dscp" module:"openconfig-acl"`
	ΛDscp                        []ygot.Annotation                                                               `path:"@dscp" ygotAnnotation:"true"`
	DscpSet                      []uint8                                                                         `path:"dscp-set" module:"openconfig-acl"`
	ΛDscpSet                     []ygot.Annotation                                                               `path:"@dscp-set" ygotAnnotation:"true"`
	HopLimit                     *uint8                                                                          `path:"hop-limit" module:"openconfig-acl"`
	ΛHopLimit                    []ygot.Annotation                                                               `path:"@hop-limit" ygotAnnotation:"true"`
	Length                       *uint16                                                                         `path:"length" module:"openconfig-acl"`
	ΛLength                      []ygot.Annotation                                                               `path:"@length" ygotAnnotation:"true"`
	Protocol                     OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union `path:"protocol" module:"openconfig-acl"`
	ΛProtocol                    []ygot.Annotation                                                               `path:"@protocol" ygotAnnotation:"true"`
	SourceAddress                *string                                                                         `path:"source-address" module:"openconfig-acl"`
	ΛSourceAddress               []ygot.Annotation                                                               `path:"@source-address" ygotAnnotation:"true"`
	SourceAddressPrefixSet       *string                                                                         `path:"source-address-prefix-set" module:"openconfig-acl"`
	ΛSourceAddressPrefixSet      []ygot.Annotation                                                               `path:"@source-address-prefix-set" ygotAnnotation:"true"`
	SourceFlowLabel              *uint32                                                                         `path:"source-flow-label" module:"openconfig-acl"`
	ΛSourceFlowLabel             []ygot.Annotation                                                               `path:"@source-flow-label" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) IsYANGGoStruct() {}

// GetDestinationAddress retrieves the value of the leaf DestinationAddress from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationAddress is set, it can
// safely use t.GetDestinationAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) GetDestinationAddress() string {
	if t == nil || t.DestinationAddress == nil {
		return ""
	}
	return *t.DestinationAddress
}

// GetDestinationAddressPrefixSet retrieves the value of the leaf DestinationAddressPrefixSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationAddressPrefixSet is set, it can
// safely use t.GetDestinationAddressPrefixSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationAddressPrefixSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) GetDestinationAddressPrefixSet() string {
	if t == nil || t.DestinationAddressPrefixSet == nil {
		return ""
	}
	return *t.DestinationAddressPrefixSet
}

// GetDestinationFlowLabel retrieves the value of the leaf DestinationFlowLabel from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationFlowLabel is set, it can
// safely use t.GetDestinationFlowLabel() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationFlowLabel == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) GetDestinationFlowLabel() uint32 {
	if t == nil || t.DestinationFlowLabel == nil {
		return 0
	}
	return *t.DestinationFlowLabel
}

// GetDscp retrieves the value of the leaf Dscp from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Dscp is set, it can
// safely use t.GetDscp() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Dscp == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) GetDscp() uint8 {
	if t == nil || t.Dscp == nil {
		return 0
	}
	return *t.Dscp
}

// GetDscpSet retrieves the value of the leaf DscpSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DscpSet is set, it can
// safely use t.GetDscpSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DscpSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) GetDscpSet() []uint8 {
	if t == nil || t.DscpSet == nil {
		return nil
	}
	return t.DscpSet
}

// GetHopLimit retrieves the value of the leaf HopLimit from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HopLimit is set, it can
// safely use t.GetHopLimit() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HopLimit == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) GetHopLimit() uint8 {
	if t == nil || t.HopLimit == nil {
		return 0
	}
	return *t.HopLimit
}

// GetLength retrieves the value of the leaf Length from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Length is set, it can
// safely use t.GetLength() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Length == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) GetLength() uint16 {
	if t == nil || t.Length == nil {
		return 0
	}
	return *t.Length
}

// GetProtocol retrieves the value of the leaf Protocol from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Protocol is set, it can
// safely use t.GetProtocol() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Protocol == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) GetProtocol() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union {
	if t == nil || t.Protocol == nil {
		return nil
	}
	return t.Protocol
}

// GetSourceAddress retrieves the value of the leaf SourceAddress from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceAddress is set, it can
// safely use t.GetSourceAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) GetSourceAddress() string {
	if t == nil || t.SourceAddress == nil {
		return ""
	}
	return *t.SourceAddress
}

// GetSourceAddressPrefixSet retrieves the value of the leaf SourceAddressPrefixSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceAddressPrefixSet is set, it can
// safely use t.GetSourceAddressPrefixSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceAddressPrefixSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) GetSourceAddressPrefixSet() string {
	if t == nil || t.SourceAddressPrefixSet == nil {
		return ""
	}
	return *t.SourceAddressPrefixSet
}

// GetSourceFlowLabel retrieves the value of the leaf SourceFlowLabel from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceFlowLabel is set, it can
// safely use t.GetSourceFlowLabel() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceFlowLabel == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) GetSourceFlowLabel() uint32 {
	if t == nil || t.SourceFlowLabel == nil {
		return 0
	}
	return *t.SourceFlowLabel
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6 struct {
	ΛMetadata []ygot.Annotation                                                        `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config `path:"config" module:"openconfig-acl"`
	ΛConfig   []ygot.Annotation                                                        `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State  `path:"state" module:"openconfig-acl"`
	ΛState    []ygot.Annotation                                                        `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config struct {
	ΛMetadata []ygot.Annotation            `path:"@" ygotAnnotation:"true"`
	Code      E_OpenconfigIcmpv6Types_CODE `path:"code" module:"openconfig-acl"`
	ΛCode     []ygot.Annotation            `path:"@code" ygotAnnotation:"true"`
	Type      E_OpenconfigIcmpv6Types_TYPE `path:"type" module:"openconfig-acl"`
	ΛType     []ygot.Annotation            `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config) IsYANGGoStruct() {}

// GetCode retrieves the value of the leaf Code from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Code is set, it can
// safely use t.GetCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Code == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config) GetCode() E_OpenconfigIcmpv6Types_CODE {
	if t == nil || t.Code == 0 {
		return 0
	}
	return t.Code
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config) GetType() E_OpenconfigIcmpv6Types_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State struct {
	ΛMetadata []ygot.Annotation            `path:"@" ygotAnnotation:"true"`
	Code      E_OpenconfigIcmpv6Types_CODE `path:"code" module:"openconfig-acl"`
	ΛCode     []ygot.Annotation            `path:"@code" ygotAnnotation:"true"`
	Type      E_OpenconfigIcmpv6Types_TYPE `path:"type" module:"openconfig-acl"`
	ΛType     []ygot.Annotation            `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State) IsYANGGoStruct() {}

// GetCode retrieves the value of the leaf Code from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Code is set, it can
// safely use t.GetCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Code == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State) GetCode() E_OpenconfigIcmpv6Types_CODE {
	if t == nil || t.Code == 0 {
		return 0
	}
	return t.Code
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State) GetType() E_OpenconfigIcmpv6Types_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Icmpv6_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State struct {
	ΛMetadata                    []ygot.Annotation                                                              `path:"@" ygotAnnotation:"true"`
	DestinationAddress           *string                                                                        `path:"destination-address" module:"openconfig-acl"`
	ΛDestinationAddress          []ygot.Annotation                                                              `path:"@destination-address" ygotAnnotation:"true"`
	DestinationAddressPrefixSet  *string                                                                        `path:"destination-address-prefix-set" module:"openconfig-acl"`
	ΛDestinationAddressPrefixSet []ygot.Annotation                                                              `path:"@destination-address-prefix-set" ygotAnnotation:"true"`
	DestinationFlowLabel         *uint32                                                                        `path:"destination-flow-label" module:"openconfig-acl"`
	ΛDestinationFlowLabel        []ygot.Annotation                                                              `path:"@destination-flow-label" ygotAnnotation:"true"`
	Dscp                         *uint8                                                                         `path:"dscp" module:"openconfig-acl"`
	ΛDscp                        []ygot.Annotation                                                              `path:"@dscp" ygotAnnotation:"true"`
	DscpSet                      []uint8                                                                        `path:"dscp-set" module:"openconfig-acl"`
	ΛDscpSet                     []ygot.Annotation                                                              `path:"@dscp-set" ygotAnnotation:"true"`
	HopLimit                     *uint8                                                                         `path:"hop-limit" module:"openconfig-acl"`
	ΛHopLimit                    []ygot.Annotation                                                              `path:"@hop-limit" ygotAnnotation:"true"`
	Length                       *uint16                                                                        `path:"length" module:"openconfig-acl"`
	ΛLength                      []ygot.Annotation                                                              `path:"@length" ygotAnnotation:"true"`
	Protocol                     OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union `path:"protocol" module:"openconfig-acl"`
	ΛProtocol                    []ygot.Annotation                                                              `path:"@protocol" ygotAnnotation:"true"`
	SourceAddress                *string                                                                        `path:"source-address" module:"openconfig-acl"`
	ΛSourceAddress               []ygot.Annotation                                                              `path:"@source-address" ygotAnnotation:"true"`
	SourceAddressPrefixSet       *string                                                                        `path:"source-address-prefix-set" module:"openconfig-acl"`
	ΛSourceAddressPrefixSet      []ygot.Annotation                                                              `path:"@source-address-prefix-set" ygotAnnotation:"true"`
	SourceFlowLabel              *uint32                                                                        `path:"source-flow-label" module:"openconfig-acl"`
	ΛSourceFlowLabel             []ygot.Annotation                                                              `path:"@source-flow-label" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) IsYANGGoStruct() {}

// GetDestinationAddress retrieves the value of the leaf DestinationAddress from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationAddress is set, it can
// safely use t.GetDestinationAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) GetDestinationAddress() string {
	if t == nil || t.DestinationAddress == nil {
		return ""
	}
	return *t.DestinationAddress
}

// GetDestinationAddressPrefixSet retrieves the value of the leaf DestinationAddressPrefixSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationAddressPrefixSet is set, it can
// safely use t.GetDestinationAddressPrefixSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationAddressPrefixSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) GetDestinationAddressPrefixSet() string {
	if t == nil || t.DestinationAddressPrefixSet == nil {
		return ""
	}
	return *t.DestinationAddressPrefixSet
}

// GetDestinationFlowLabel retrieves the value of the leaf DestinationFlowLabel from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationFlowLabel is set, it can
// safely use t.GetDestinationFlowLabel() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationFlowLabel == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) GetDestinationFlowLabel() uint32 {
	if t == nil || t.DestinationFlowLabel == nil {
		return 0
	}
	return *t.DestinationFlowLabel
}

// GetDscp retrieves the value of the leaf Dscp from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Dscp is set, it can
// safely use t.GetDscp() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Dscp == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) GetDscp() uint8 {
	if t == nil || t.Dscp == nil {
		return 0
	}
	return *t.Dscp
}

// GetDscpSet retrieves the value of the leaf DscpSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DscpSet is set, it can
// safely use t.GetDscpSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DscpSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) GetDscpSet() []uint8 {
	if t == nil || t.DscpSet == nil {
		return nil
	}
	return t.DscpSet
}

// GetHopLimit retrieves the value of the leaf HopLimit from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HopLimit is set, it can
// safely use t.GetHopLimit() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HopLimit == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) GetHopLimit() uint8 {
	if t == nil || t.HopLimit == nil {
		return 0
	}
	return *t.HopLimit
}

// GetLength retrieves the value of the leaf Length from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Length is set, it can
// safely use t.GetLength() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Length == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) GetLength() uint16 {
	if t == nil || t.Length == nil {
		return 0
	}
	return *t.Length
}

// GetProtocol retrieves the value of the leaf Protocol from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Protocol is set, it can
// safely use t.GetProtocol() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Protocol == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) GetProtocol() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union {
	if t == nil || t.Protocol == nil {
		return nil
	}
	return t.Protocol
}

// GetSourceAddress retrieves the value of the leaf SourceAddress from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceAddress is set, it can
// safely use t.GetSourceAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) GetSourceAddress() string {
	if t == nil || t.SourceAddress == nil {
		return ""
	}
	return *t.SourceAddress
}

// GetSourceAddressPrefixSet retrieves the value of the leaf SourceAddressPrefixSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceAddressPrefixSet is set, it can
// safely use t.GetSourceAddressPrefixSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceAddressPrefixSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) GetSourceAddressPrefixSet() string {
	if t == nil || t.SourceAddressPrefixSet == nil {
		return ""
	}
	return *t.SourceAddressPrefixSet
}

// GetSourceFlowLabel retrieves the value of the leaf SourceFlowLabel from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceFlowLabel is set, it can
// safely use t.GetSourceFlowLabel() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceFlowLabel == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) GetSourceFlowLabel() uint32 {
	if t == nil || t.SourceFlowLabel == nil {
		return 0
	}
	return *t.SourceFlowLabel
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 struct {
	ΛMetadata []ygot.Annotation                                               `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config `path:"config" module:"openconfig-acl"`
	ΛConfig   []ygot.Annotation                                               `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State  `path:"state" module:"openconfig-acl"`
	ΛState    []ygot.Annotation                                               `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config struct {
	ΛMetadata           []ygot.Annotation                                                              `path:"@" ygotAnnotation:"true"`
	DestinationMac      *string                                                                        `path:"destination-mac" module:"openconfig-acl"`
	ΛDestinationMac     []ygot.Annotation                                                              `path:"@destination-mac" ygotAnnotation:"true"`
	DestinationMacMask  *string                                                                        `path:"destination-mac-mask" module:"openconfig-acl"`
	ΛDestinationMacMask []ygot.Annotation                                                              `path:"@destination-mac-mask" ygotAnnotation:"true"`
	Ethertype           OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union `path:"ethertype" module:"openconfig-acl"`
	ΛEthertype          []ygot.Annotation                                                              `path:"@ethertype" ygotAnnotation:"true"`
	SourceMac           *string                                                                        `path:"source-mac" module:"openconfig-acl"`
	ΛSourceMac          []ygot.Annotation                                                              `path:"@source-mac" ygotAnnotation:"true"`
	SourceMacMask       *string                                                                        `path:"source-mac-mask" module:"openconfig-acl"`
	ΛSourceMacMask      []ygot.Annotation                                                              `path:"@source-mac-mask" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) IsYANGGoStruct() {}

// GetDestinationMac retrieves the value of the leaf DestinationMac from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationMac is set, it can
// safely use t.GetDestinationMac() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationMac == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) GetDestinationMac() string {
	if t == nil || t.DestinationMac == nil {
		return ""
	}
	return *t.DestinationMac
}

// GetDestinationMacMask retrieves the value of the leaf DestinationMacMask from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationMacMask is set, it can
// safely use t.GetDestinationMacMask() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationMacMask == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) GetDestinationMacMask() string {
	if t == nil || t.DestinationMacMask == nil {
		return ""
	}
	return *t.DestinationMacMask
}

// GetEthertype retrieves the value of the leaf Ethertype from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Ethertype is set, it can
// safely use t.GetEthertype() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Ethertype == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) GetEthertype() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union {
	if t == nil || t.Ethertype == nil {
		return nil
	}
	return t.Ethertype
}

// GetSourceMac retrieves the value of the leaf SourceMac from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceMac is set, it can
// safely use t.GetSourceMac() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceMac == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) GetSourceMac() string {
	if t == nil || t.SourceMac == nil {
		return ""
	}
	return *t.SourceMac
}

// GetSourceMacMask retrieves the value of the leaf SourceMacMask from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceMacMask is set, it can
// safely use t.GetSourceMacMask() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceMacMask == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) GetSourceMacMask() string {
	if t == nil || t.SourceMacMask == nil {
		return ""
	}
	return *t.SourceMacMask
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union ensures that E_OpenconfigPacketMatchTypes_ETHERTYPE
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface.
func (E_OpenconfigPacketMatchTypes_ETHERTYPE) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_ETHERTYPE, uint16]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State struct {
	ΛMetadata           []ygot.Annotation                                                             `path:"@" ygotAnnotation:"true"`
	DestinationMac      *string                                                                       `path:"destination-mac" module:"openconfig-acl"`
	ΛDestinationMac     []ygot.Annotation                                                             `path:"@destination-mac" ygotAnnotation:"true"`
	DestinationMacMask  *string                                                                       `path:"destination-mac-mask" module:"openconfig-acl"`
	ΛDestinationMacMask []ygot.Annotation                                                             `path:"@destination-mac-mask" ygotAnnotation:"true"`
	Ethertype           OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union `path:"ethertype" module:"openconfig-acl"`
	ΛEthertype          []ygot.Annotation                                                             `path:"@ethertype" ygotAnnotation:"true"`
	SourceMac           *string                                                                       `path:"source-mac" module:"openconfig-acl"`
	ΛSourceMac          []ygot.Annotation                                                             `path:"@source-mac" ygotAnnotation:"true"`
	SourceMacMask       *string                                                                       `path:"source-mac-mask" module:"openconfig-acl"`
	ΛSourceMacMask      []ygot.Annotation                                                             `path:"@source-mac-mask" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) IsYANGGoStruct() {}

// GetDestinationMac retrieves the value of the leaf DestinationMac from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationMac is set, it can
// safely use t.GetDestinationMac() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationMac == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) GetDestinationMac() string {
	if t == nil || t.DestinationMac == nil {
		return ""
	}
	return *t.DestinationMac
}

// GetDestinationMacMask retrieves the value of the leaf DestinationMacMask from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationMacMask is set, it can
// safely use t.GetDestinationMacMask() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationMacMask == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) GetDestinationMacMask() string {
	if t == nil || t.DestinationMacMask == nil {
		return ""
	}
	return *t.DestinationMacMask
}

// GetEthertype retrieves the value of the leaf Ethertype from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Ethertype is set, it can
// safely use t.GetEthertype() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Ethertype == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) GetEthertype() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union {
	if t == nil || t.Ethertype == nil {
		return nil
	}
	return t.Ethertype
}

// GetSourceMac retrieves the value of the leaf SourceMac from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceMac is set, it can
// safely use t.GetSourceMac() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceMac == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) GetSourceMac() string {
	if t == nil || t.SourceMac == nil {
		return ""
	}
	return *t.SourceMac
}

// GetSourceMacMask retrieves the value of the leaf SourceMacMask from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceMacMask is set, it can
// safely use t.GetSourceMacMask() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceMacMask == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) GetSourceMacMask() string {
	if t == nil || t.SourceMacMask == nil {
		return ""
	}
	return *t.SourceMacMask
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state/ethertype within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union ensures that E_OpenconfigPacketMatchTypes_ETHERTYPE
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface.
func (E_OpenconfigPacketMatchTypes_ETHERTYPE) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_ETHERTYPE, uint16]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls struct {
	ΛMetadata []ygot.Annotation                                                 `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config `path:"config" module:"openconfig-acl"`
	ΛConfig   []ygot.Annotation                                                 `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State  `path:"state" module:"openconfig-acl"`
	ΛState    []ygot.Annotation                                                 `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config struct {
	ΛMetadata        []ygot.Annotation                                                                      `path:"@" ygotAnnotation:"true"`
	EndLabelValue    OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union   `path:"end-label-value" module:"openconfig-acl"`
	ΛEndLabelValue   []ygot.Annotation                                                                      `path:"@end-label-value" ygotAnnotation:"true"`
	StartLabelValue  OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union `path:"start-label-value" module:"openconfig-acl"`
	ΛStartLabelValue []ygot.Annotation                                                                      `path:"@start-label-value" ygotAnnotation:"true"`
	TrafficClass     *uint8                                                                                 `path:"traffic-class" module:"openconfig-acl"`
	ΛTrafficClass    []ygot.Annotation                                                                      `path:"@traffic-class" ygotAnnotation:"true"`
	TtlValue         *uint8                                                                                 `path:"ttl-value" module:"openconfig-acl"`
	ΛTtlValue        []ygot.Annotation                                                                      `path:"@ttl-value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) IsYANGGoStruct() {}

// GetEndLabelValue retrieves the value of the leaf EndLabelValue from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EndLabelValue is set, it can
// safely use t.GetEndLabelValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EndLabelValue == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) GetEndLabelValue() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union {
	if t == nil || t.EndLabelValue == nil {
		return nil
	}
	return t.EndLabelValue
}

// GetStartLabelValue retrieves the value of the leaf StartLabelValue from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if StartLabelValue is set, it can
// safely use t.GetStartLabelValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.StartLabelValue == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) GetStartLabelValue() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union {
	if t == nil || t.StartLabelValue == nil {
		return nil
	}
	return t.StartLabelValue
}

// GetTrafficClass retrieves the value of the leaf TrafficClass from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TrafficClass is set, it can
// safely use t.GetTrafficClass() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TrafficClass == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) GetTrafficClass() uint8 {
	if t == nil || t.TrafficClass == nil {
		return 0
	}
	return *t.TrafficClass
}

// GetTtlValue retrieves the value of the leaf TtlValue from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TtlValue is set, it can
// safely use t.GetTtlValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TtlValue == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) GetTtlValue() uint8 {
	if t == nil || t.TtlValue == nil {
		return 0
	}
	return *t.TtlValue
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/end-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigMplsTypes_MplsLabel_Enum, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigMplsTypes_MplsLabel_Enum, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union ensures that E_OpenconfigMplsTypes_MplsLabel_Enum
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union interface.
func (E_OpenconfigMplsTypes_MplsLabel_Enum) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigMplsTypes_MplsLabel_Enum, uint32]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/start-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigMplsTypes_MplsLabel_Enum, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigMplsTypes_MplsLabel_Enum, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union ensures that E_OpenconfigMplsTypes_MplsLabel_Enum
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union interface.
func (E_OpenconfigMplsTypes_MplsLabel_Enum) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigMplsTypes_MplsLabel_Enum, uint32]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State struct {
	ΛMetadata        []ygot.Annotation                                                                     `path:"@" ygotAnnotation:"true"`
	EndLabelValue    OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union   `path:"end-label-value" module:"openconfig-acl"`
	ΛEndLabelValue   []ygot.Annotation                                                                     `path:"@end-label-value" ygotAnnotation:"true"`
	StartLabelValue  OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union `path:"start-label-value" module:"openconfig-acl"`
	ΛStartLabelValue []ygot.Annotation                                                                     `path:"@start-label-value" ygotAnnotation:"true"`
	TrafficClass     *uint8                                                                                `path:"traffic-class" module:"openconfig-acl"`
	ΛTrafficClass    []ygot.Annotation                                                                     `path:"@traffic-class" ygotAnnotation:"true"`
	TtlValue         *uint8                                                                                `path:"ttl-value" module:"openconfig-acl"`
	ΛTtlValue        []ygot.Annotation                                                                     `path:"@ttl-value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) IsYANGGoStruct() {}

// GetEndLabelValue retrieves the value of the leaf EndLabelValue from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EndLabelValue is set, it can
// safely use t.GetEndLabelValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EndLabelValue == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) GetEndLabelValue() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union {
	if t == nil || t.EndLabelValue == nil {
		return nil
	}
	return t.EndLabelValue
}

// GetStartLabelValue retrieves the value of the leaf StartLabelValue from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if StartLabelValue is set, it can
// safely use t.GetStartLabelValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.StartLabelValue == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) GetStartLabelValue() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union {
	if t == nil || t.StartLabelValue == nil {
		return nil
	}
	return t.StartLabelValue
}

// GetTrafficClass retrieves the value of the leaf TrafficClass from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TrafficClass is set, it can
// safely use t.GetTrafficClass() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TrafficClass == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) GetTrafficClass() uint8 {
	if t == nil || t.TrafficClass == nil {
		return 0
	}
	return *t.TrafficClass
}

// GetTtlValue retrieves the value of the leaf TtlValue from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TtlValue is set, it can
// safely use t.GetTtlValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TtlValue == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) GetTtlValue() uint8 {
	if t == nil || t.TtlValue == nil {
		return 0
	}
	return *t.TtlValue
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/state/end-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigMplsTypes_MplsLabel_Enum, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigMplsTypes_MplsLabel_Enum, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union ensures that E_OpenconfigMplsTypes_MplsLabel_Enum
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union interface.
func (E_OpenconfigMplsTypes_MplsLabel_Enum) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigMplsTypes_MplsLabel_Enum, uint32]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/state/start-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigMplsTypes_MplsLabel_Enum, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigMplsTypes_MplsLabel_Enum, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union ensures that E_OpenconfigMplsTypes_MplsLabel_Enum
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union interface.
func (E_OpenconfigMplsTypes_MplsLabel_Enum) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigMplsTypes_MplsLabel_Enum, uint32]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State struct {
	ΛMetadata       []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Description     *string           `path:"description" module:"openconfig-acl"`
	ΛDescription    []ygot.Annotation `path:"@description" ygotAnnotation:"true"`
	MatchedOctets   *uint64           `path:"matched-octets" module:"openconfig-acl"`
	ΛMatchedOctets  []ygot.Annotation `path:"@matched-octets" ygotAnnotation:"true"`
	MatchedPackets  *uint64           `path:"matched-packets" module:"openconfig-acl"`
	ΛMatchedPackets []ygot.Annotation `path:"@matched-packets" ygotAnnotation:"true"`
	SequenceId      *uint32           `path:"sequence-id" module:"openconfig-acl"`
	ΛSequenceId     []ygot.Annotation `path:"@sequence-id" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {}

// GetDescription retrieves the value of the leaf Description from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetMatchedOctets retrieves the value of the leaf MatchedOctets from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedOctets is set, it can
// safely use t.GetMatchedOctets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedOctets == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) GetMatchedOctets() uint64 {
	if t == nil || t.MatchedOctets == nil {
		return 0
	}
	return *t.MatchedOctets
}

// GetMatchedPackets retrieves the value of the leaf MatchedPackets from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedPackets is set, it can
// safely use t.GetMatchedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedPackets == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) GetMatchedPackets() uint64 {
	if t == nil || t.MatchedPackets == nil {
		return 0
	}
	return *t.MatchedPackets
}

// GetSequenceId retrieves the value of the leaf SequenceId from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SequenceId is set, it can
// safely use t.GetSequenceId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SequenceId == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) GetSequenceId() uint32 {
	if t == nil || t.SequenceId == nil {
		return 0
	}
	return *t.SequenceId
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport struct {
	ΛMetadata []ygot.Annotation                                                      `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config `path:"config" module:"openconfig-acl"`
	ΛConfig   []ygot.Annotation                                                      `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State  `path:"state" module:"openconfig-acl"`
	ΛState    []ygot.Annotation                                                      `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) GetOrCreateConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) GetOrCreateState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) GetConfig() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) GetState() *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config struct {
	ΛMetadata                []ygot.Annotation                                                                               `path:"@" ygotAnnotation:"true"`
	BuiltinDetail            E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_BuiltinDetail           `path:"builtin-detail" module:"openconfig-acl"`
	ΛBuiltinDetail           []ygot.Annotation                                                                               `path:"@builtin-detail" ygotAnnotation:"true"`
	DestinationPort          OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union     `path:"destination-port" module:"openconfig-acl"`
	ΛDestinationPort         []ygot.Annotation                                                                               `path:"@destination-port" ygotAnnotation:"true"`
	DestinationPortSet       *string                                                                                         `path:"destination-port-set" module:"openconfig-acl"`
	ΛDestinationPortSet      []ygot.Annotation                                                                               `path:"@destination-port-set" ygotAnnotation:"true"`
	DetailMode               E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DetailMode              `path:"detail-mode" module:"openconfig-acl"`
	ΛDetailMode              []ygot.Annotation                                                                               `path:"@detail-mode" ygotAnnotation:"true"`
	ExplicitDetailMatchMode  E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_ExplicitDetailMatchMode `path:"explicit-detail-match-mode" module:"openconfig-acl"`
	ΛExplicitDetailMatchMode []ygot.Annotation                                                                               `path:"@explicit-detail-match-mode" ygotAnnotation:"true"`
	ExplicitTcpFlags         []E_OpenconfigPacketMatchTypes_TCP_FLAGS                                                        `path:"explicit-tcp-flags" module:"openconfig-acl"`
	ΛExplicitTcpFlags        []ygot.Annotation                                                                               `path:"@explicit-tcp-flags" ygotAnnotation:"true"`
	SourcePort               OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union          `path:"source-port" module:"openconfig-acl"`
	ΛSourcePort              []ygot.Annotation                                                                               `path:"@source-port" ygotAnnotation:"true"`
	SourcePortSet            *string                                                                                         `path:"source-port-set" module:"openconfig-acl"`
	ΛSourcePortSet           []ygot.Annotation                                                                               `path:"@source-port-set" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) IsYANGGoStruct() {}

// GetBuiltinDetail retrieves the value of the leaf BuiltinDetail from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if BuiltinDetail is set, it can
// safely use t.GetBuiltinDetail() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.BuiltinDetail == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) GetBuiltinDetail() E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_BuiltinDetail {
	if t == nil || t.BuiltinDetail == 0 {
		return 0
	}
	return t.BuiltinDetail
}

// GetDestinationPort retrieves the value of the leaf DestinationPort from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationPort is set, it can
// safely use t.GetDestinationPort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationPort == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) GetDestinationPort() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union {
	if t == nil || t.DestinationPort == nil {
		return nil
	}
	return t.DestinationPort
}

// GetDestinationPortSet retrieves the value of the leaf DestinationPortSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationPortSet is set, it can
// safely use t.GetDestinationPortSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationPortSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) GetDestinationPortSet() string {
	if t == nil || t.DestinationPortSet == nil {
		return ""
	}
	return *t.DestinationPortSet
}

// GetDetailMode retrieves the value of the leaf DetailMode from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DetailMode is set, it can
// safely use t.GetDetailMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DetailMode == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) GetDetailMode() E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DetailMode {
	if t == nil || t.DetailMode == 0 {
		return 0
	}
	return t.DetailMode
}

// GetExplicitDetailMatchMode retrieves the value of the leaf ExplicitDetailMatchMode from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ExplicitDetailMatchMode is set, it can
// safely use t.GetExplicitDetailMatchMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ExplicitDetailMatchMode == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) GetExplicitDetailMatchMode() E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_ExplicitDetailMatchMode {
	if t == nil || t.ExplicitDetailMatchMode == 0 {
		return 0
	}
	return t.ExplicitDetailMatchMode
}

// GetExplicitTcpFlags retrieves the value of the leaf ExplicitTcpFlags from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ExplicitTcpFlags is set, it can
// safely use t.GetExplicitTcpFlags() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ExplicitTcpFlags == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) GetExplicitTcpFlags() []E_OpenconfigPacketMatchTypes_TCP_FLAGS {
	if t == nil || t.ExplicitTcpFlags == nil {
		return nil
	}
	return t.ExplicitTcpFlags
}

// GetSourcePort retrieves the value of the leaf SourcePort from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourcePort is set, it can
// safely use t.GetSourcePort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourcePort == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) GetSourcePort() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union {
	if t == nil || t.SourcePort == nil {
		return nil
	}
	return t.SourcePort
}

// GetSourcePortSet retrieves the value of the leaf SourcePortSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourcePortSet is set, it can
// safely use t.GetSourcePortSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourcePortSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) GetSourcePortSet() string {
	if t == nil || t.SourcePortSet == nil {
		return ""
	}
	return *t.SourcePortSet
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that E_OpenconfigPacketMatchTypes_PortNumRange_Enum
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (E_OpenconfigPacketMatchTypes_PortNumRange_Enum) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, string, uint16]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that E_OpenconfigPacketMatchTypes_PortNumRange_Enum
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (E_OpenconfigPacketMatchTypes_PortNumRange_Enum) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, string, uint16]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State struct {
	ΛMetadata                []ygot.Annotation                                                                               `path:"@" ygotAnnotation:"true"`
	BuiltinDetail            E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_BuiltinDetail           `path:"builtin-detail" module:"openconfig-acl"`
	ΛBuiltinDetail           []ygot.Annotation                                                                               `path:"@builtin-detail" ygotAnnotation:"true"`
	DestinationPort          OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union      `path:"destination-port" module:"openconfig-acl"`
	ΛDestinationPort         []ygot.Annotation                                                                               `path:"@destination-port" ygotAnnotation:"true"`
	DestinationPortSet       *string                                                                                         `path:"destination-port-set" module:"openconfig-acl"`
	ΛDestinationPortSet      []ygot.Annotation                                                                               `path:"@destination-port-set" ygotAnnotation:"true"`
	DetailMode               E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DetailMode              `path:"detail-mode" module:"openconfig-acl"`
	ΛDetailMode              []ygot.Annotation                                                                               `path:"@detail-mode" ygotAnnotation:"true"`
	ExplicitDetailMatchMode  E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_ExplicitDetailMatchMode `path:"explicit-detail-match-mode" module:"openconfig-acl"`
	ΛExplicitDetailMatchMode []ygot.Annotation                                                                               `path:"@explicit-detail-match-mode" ygotAnnotation:"true"`
	ExplicitTcpFlags         []E_OpenconfigPacketMatchTypes_TCP_FLAGS                                                        `path:"explicit-tcp-flags" module:"openconfig-acl"`
	ΛExplicitTcpFlags        []ygot.Annotation                                                                               `path:"@explicit-tcp-flags" ygotAnnotation:"true"`
	SourcePort               OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union           `path:"source-port" module:"openconfig-acl"`
	ΛSourcePort              []ygot.Annotation                                                                               `path:"@source-port" ygotAnnotation:"true"`
	SourcePortSet            *string                                                                                         `path:"source-port-set" module:"openconfig-acl"`
	ΛSourcePortSet           []ygot.Annotation                                                                               `path:"@source-port-set" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) IsYANGGoStruct() {}

// GetBuiltinDetail retrieves the value of the leaf BuiltinDetail from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if BuiltinDetail is set, it can
// safely use t.GetBuiltinDetail() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.BuiltinDetail == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) GetBuiltinDetail() E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_BuiltinDetail {
	if t == nil || t.BuiltinDetail == 0 {
		return 0
	}
	return t.BuiltinDetail
}

// GetDestinationPort retrieves the value of the leaf DestinationPort from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationPort is set, it can
// safely use t.GetDestinationPort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationPort == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) GetDestinationPort() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union {
	if t == nil || t.DestinationPort == nil {
		return nil
	}
	return t.DestinationPort
}

// GetDestinationPortSet retrieves the value of the leaf DestinationPortSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationPortSet is set, it can
// safely use t.GetDestinationPortSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationPortSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) GetDestinationPortSet() string {
	if t == nil || t.DestinationPortSet == nil {
		return ""
	}
	return *t.DestinationPortSet
}

// GetDetailMode retrieves the value of the leaf DetailMode from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DetailMode is set, it can
// safely use t.GetDetailMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DetailMode == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) GetDetailMode() E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DetailMode {
	if t == nil || t.DetailMode == 0 {
		return 0
	}
	return t.DetailMode
}

// GetExplicitDetailMatchMode retrieves the value of the leaf ExplicitDetailMatchMode from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ExplicitDetailMatchMode is set, it can
// safely use t.GetExplicitDetailMatchMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ExplicitDetailMatchMode == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) GetExplicitDetailMatchMode() E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_ExplicitDetailMatchMode {
	if t == nil || t.ExplicitDetailMatchMode == 0 {
		return 0
	}
	return t.ExplicitDetailMatchMode
}

// GetExplicitTcpFlags retrieves the value of the leaf ExplicitTcpFlags from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ExplicitTcpFlags is set, it can
// safely use t.GetExplicitTcpFlags() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ExplicitTcpFlags == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) GetExplicitTcpFlags() []E_OpenconfigPacketMatchTypes_TCP_FLAGS {
	if t == nil || t.ExplicitTcpFlags == nil {
		return nil
	}
	return t.ExplicitTcpFlags
}

// GetSourcePort retrieves the value of the leaf SourcePort from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourcePort is set, it can
// safely use t.GetSourcePort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourcePort == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) GetSourcePort() OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union {
	if t == nil || t.SourcePort == nil {
		return nil
	}
	return t.SourcePort
}

// GetSourcePortSet retrieves the value of the leaf SourcePortSet from the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourcePortSet is set, it can
// safely use t.GetSourcePortSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourcePortSet == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) GetSourcePortSet() string {
	if t == nil || t.SourcePortSet == nil {
		return ""
	}
	return *t.SourcePortSet
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/destination-port within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that E_OpenconfigPacketMatchTypes_PortNumRange_Enum
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (E_OpenconfigPacketMatchTypes_PortNumRange_Enum) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, string, uint16]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/source-port within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that E_OpenconfigPacketMatchTypes_PortNumRange_Enum
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (E_OpenconfigPacketMatchTypes_PortNumRange_Enum) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, string, uint16]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_Config represents the /openconfig-acl/acl/acl-sets/acl-set/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_Config struct {
	ΛMetadata    []ygot.Annotation        `path:"@" ygotAnnotation:"true"`
	Description  *string                  `path:"description" module:"openconfig-acl"`
	ΛDescription []ygot.Annotation        `path:"@description" ygotAnnotation:"true"`
	Name         *string                  `path:"name" module:"openconfig-acl"`
	ΛName        []ygot.Annotation        `path:"@name" ygotAnnotation:"true"`
	Type         E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
	ΛType        []ygot.Annotation        `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_Config) IsYANGGoStruct() {}

// GetDescription retrieves the value of the leaf Description from the OpenconfigAcl_Acl_AclSets_AclSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetName retrieves the value of the leaf Name from the OpenconfigAcl_Acl_AclSets_AclSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_AclSets_AclSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) GetType() E_OpenconfigAcl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_State represents the /openconfig-acl/acl/acl-sets/acl-set/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_State struct {
	ΛMetadata    []ygot.Annotation        `path:"@" ygotAnnotation:"true"`
	Description  *string                  `path:"description" module:"openconfig-acl"`
	ΛDescription []ygot.Annotation        `path:"@description" ygotAnnotation:"true"`
	Name         *string                  `path:"name" module:"openconfig-acl"`
	ΛName        []ygot.Annotation        `path:"@name" ygotAnnotation:"true"`
	Type         E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
	ΛType        []ygot.Annotation        `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_State) IsYANGGoStruct() {}

// GetDescription retrieves the value of the leaf Description from the OpenconfigAcl_Acl_AclSets_AclSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetName retrieves the value of the leaf Name from the OpenconfigAcl_Acl_AclSets_AclSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_AclSets_AclSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) GetType() E_OpenconfigAcl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_AclSets_AclSet_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Config represents the /openconfig-acl/acl/config YANG schema element.
type OpenconfigAcl_Acl_Config struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Config) IsYANGGoStruct() {}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Config.
func (*OpenconfigAcl_Acl_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces represents the /openconfig-acl/acl/interfaces YANG schema element.
type OpenconfigAcl_Acl_Interfaces struct {
	ΛMetadata  []ygot.Annotation                                  `path:"@" ygotAnnotation:"true"`
	Interface  map[string]*OpenconfigAcl_Acl_Interfaces_Interface `path:"interface" module:"openconfig-acl"`
	ΛInterface []ygot.Annotation                                  `path:"@interface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigAcl_Acl_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces) NewInterface(Id string) (*OpenconfigAcl_Acl_Interfaces_Interface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigAcl_Acl_Interfaces_Interface)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigAcl_Acl_Interfaces_Interface{
		Id: &Id,
	}

	return t.Interface[key], nil
}

// RenameInterface renames an entry in the list Interface within
// the OpenconfigAcl_Acl_Interfaces struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigAcl_Acl_Interfaces) RenameInterface(oldK, newK string) error {
	if _, ok := t.Interface[newK]; ok {
		return fmt.Errorf("key %v already exists in Interface", newK)
	}

	e, ok := t.Interface[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Interface", oldK)
	}
	e.Id = &newK

	t.Interface[newK] = e
	delete(t.Interface, oldK)
	return nil
}

// GetOrCreateInterfaceMap returns the list (map) from OpenconfigAcl_Acl_Interfaces.
//
// It initializes the field if not already initialized.
func (t *OpenconfigAcl_Acl_Interfaces) GetOrCreateInterfaceMap() map[string]*OpenconfigAcl_Acl_Interfaces_Interface {
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigAcl_Acl_Interfaces_Interface)
	}
	return t.Interface
}

// GetOrCreateInterface retrieves the value with the specified keys from
// the receiver OpenconfigAcl_Acl_Interfaces. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigAcl_Acl_Interfaces) GetOrCreateInterface(Id string) *OpenconfigAcl_Acl_Interfaces_Interface {

	key := Id

	if v, ok := t.Interface[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewInterface(Id)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateInterface got unexpected error: %v", err))
	}
	return v
}

// GetInterface retrieves the value with the specified key from
// the Interface map field of OpenconfigAcl_Acl_Interfaces. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces) GetInterface(Id string) *OpenconfigAcl_Acl_Interfaces_Interface {

	if t == nil {
		return nil
	}

	key := Id

	if lm, ok := t.Interface[key]; ok {
		return lm
	}
	return nil
}

// AppendInterface appends the supplied OpenconfigAcl_Acl_Interfaces_Interface struct to the
// list Interface of OpenconfigAcl_Acl_Interfaces. If the key value(s) specified in
// the supplied OpenconfigAcl_Acl_Interfaces_Interface already exist in the list, an error is
// returned.
func (t *OpenconfigAcl_Acl_Interfaces) AppendInterface(v *OpenconfigAcl_Acl_Interfaces_Interface) error {
	if v.Id == nil {
		return fmt.Errorf("invalid nil key received for Id")
	}

	key := *v.Id

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigAcl_Acl_Interfaces_Interface)
	}

	if _, ok := t.Interface[key]; ok {
		return fmt.Errorf("duplicate key for list Interface %v", key)
	}

	t.Interface[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.Interface {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces.
func (*OpenconfigAcl_Acl_Interfaces) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface represents the /openconfig-acl/acl/interfaces/interface YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface struct {
	ΛMetadata       []ygot.Annotation                                      `path:"@" ygotAnnotation:"true"`
	Config          *OpenconfigAcl_Acl_Interfaces_Interface_Config         `path:"config" module:"openconfig-acl"`
	ΛConfig         []ygot.Annotation                                      `path:"@config" ygotAnnotation:"true"`
	EgressAclSets   *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets  `path:"egress-acl-sets" module:"openconfig-acl"`
	ΛEgressAclSets  []ygot.Annotation                                      `path:"@egress-acl-sets" ygotAnnotation:"true"`
	Id              *string                                                `path:"id" module:"openconfig-acl"`
	ΛId             []ygot.Annotation                                      `path:"@id" ygotAnnotation:"true"`
	IngressAclSets  *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets `path:"ingress-acl-sets" module:"openconfig-acl"`
	ΛIngressAclSets []ygot.Annotation                                      `path:"@ingress-acl-sets" ygotAnnotation:"true"`
	InterfaceRef    *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef   `path:"interface-ref" module:"openconfig-acl"`
	ΛInterfaceRef   []ygot.Annotation                                      `path:"@interface-ref" ygotAnnotation:"true"`
	State           *OpenconfigAcl_Acl_Interfaces_Interface_State          `path:"state" module:"openconfig-acl"`
	ΛState          []ygot.Annotation                                      `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) GetOrCreateConfig() *OpenconfigAcl_Acl_Interfaces_Interface_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_Interfaces_Interface_Config{}
	return t.Config
}

// GetOrCreateEgressAclSets retrieves the value of the EgressAclSets field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) GetOrCreateEgressAclSets() *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets {
	if t.EgressAclSets != nil {
		return t.EgressAclSets
	}
	t.EgressAclSets = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets{}
	return t.EgressAclSets
}

// GetOrCreateIngressAclSets retrieves the value of the IngressAclSets field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) GetOrCreateIngressAclSets() *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets {
	if t.IngressAclSets != nil {
		return t.IngressAclSets
	}
	t.IngressAclSets = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets{}
	return t.IngressAclSets
}

// GetOrCreateInterfaceRef retrieves the value of the InterfaceRef field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) GetOrCreateInterfaceRef() *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef {
	if t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	t.InterfaceRef = &OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef{}
	return t.InterfaceRef
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) GetOrCreateState() *OpenconfigAcl_Acl_Interfaces_Interface_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_Interfaces_Interface_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) GetConfig() *OpenconfigAcl_Acl_Interfaces_Interface_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetEgressAclSets returns the value of the EgressAclSets struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface. If the receiver or the field EgressAclSets is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) GetEgressAclSets() *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets {
	if t != nil && t.EgressAclSets != nil {
		return t.EgressAclSets
	}
	return nil
}

// GetIngressAclSets returns the value of the IngressAclSets struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface. If the receiver or the field IngressAclSets is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) GetIngressAclSets() *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets {
	if t != nil && t.IngressAclSets != nil {
		return t.IngressAclSets
	}
	return nil
}

// GetInterfaceRef returns the value of the InterfaceRef struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface. If the receiver or the field InterfaceRef is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) GetInterfaceRef() *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef {
	if t != nil && t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) GetState() *OpenconfigAcl_Acl_Interfaces_Interface_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetId retrieves the value of the leaf Id from the OpenconfigAcl_Acl_Interfaces_Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Id is set, it can
// safely use t.GetId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Id == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) GetId() string {
	if t == nil || t.Id == nil {
		return ""
	}
	return *t.Id
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.EgressAclSets.PopulateDefaults()
	t.IngressAclSets.PopulateDefaults()
	t.InterfaceRef.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface.
func (*OpenconfigAcl_Acl_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_Config represents the /openconfig-acl/acl/interfaces/interface/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_Config struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Id        *string           `path:"id" module:"openconfig-acl"`
	ΛId       []ygot.Annotation `path:"@id" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_Config) IsYANGGoStruct() {}

// GetId retrieves the value of the leaf Id from the OpenconfigAcl_Acl_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Id is set, it can
// safely use t.GetId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Id == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) GetId() string {
	if t == nil || t.Id == nil {
		return ""
	}
	return *t.Id
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets struct {
	ΛMetadata     []ygot.Annotation                                                                                                                            `path:"@" ygotAnnotation:"true"`
	EgressAclSet  map[OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet `path:"egress-acl-set" module:"openconfig-acl"`
	ΛEgressAclSet []ygot.Annotation                                                                                                                            `path:"@egress-acl-set" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key represents the key for list EgressAclSet of element /openconfig-acl/acl/interfaces/interface/egress-acl-sets.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key struct {
	SetName string                   `path:"set-name"`
	Type    E_OpenconfigAcl_ACL_TYPE `path:"type"`
}

// IsYANGGoKeyStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key key struct.
func (t OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"set-name": t.SetName,
		"type":     t.Type,
	}, nil
}

// NewEgressAclSet creates a new entry in the EgressAclSet list of the
// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) NewEgressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.EgressAclSet == nil {
		t.EgressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet)
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.EgressAclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list EgressAclSet", key)
	}

	t.EgressAclSet[key] = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet{
		SetName: &SetName,
		Type:    Type,
	}

	return t.EgressAclSet[key], nil
}

// RenameEgressAclSet renames an entry in the list EgressAclSet within
// the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) RenameEgressAclSet(oldK, newK OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key) error {
	if _, ok := t.EgressAclSet[newK]; ok {
		return fmt.Errorf("key %v already exists in EgressAclSet", newK)
	}

	e, ok := t.EgressAclSet[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in EgressAclSet", oldK)
	}
	e.SetName = &newK.SetName
	e.Type = newK.Type

	t.EgressAclSet[newK] = e
	delete(t.EgressAclSet, oldK)
	return nil
}

// GetOrCreateEgressAclSetMap returns the list (map) from OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets.
//
// It initializes the field if not already initialized.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) GetOrCreateEgressAclSetMap() map[OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet {
	if t.EgressAclSet == nil {
		t.EgressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet)
	}
	return t.EgressAclSet
}

// GetOrCreateEgressAclSet retrieves the value with the specified keys from
// the receiver OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) GetOrCreateEgressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet {

	key := OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	if v, ok := t.EgressAclSet[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewEgressAclSet(SetName, Type)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateEgressAclSet got unexpected error: %v", err))
	}
	return v
}

// GetEgressAclSet retrieves the value with the specified key from
// the EgressAclSet map field of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) GetEgressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet {

	if t == nil {
		return nil
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	if lm, ok := t.EgressAclSet[key]; ok {
		return lm
	}
	return nil
}

// AppendEgressAclSet appends the supplied OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet struct to the
// list EgressAclSet of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets. If the key value(s) specified in
// the supplied OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet already exist in the list, an error is
// returned.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) AppendEgressAclSet(v *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) error {
	if v.SetName == nil {
		return fmt.Errorf("invalid nil key for SetName")
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key{
		SetName: *v.SetName,
		Type:    v.Type,
	}

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.EgressAclSet == nil {
		t.EgressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet)
	}

	if _, ok := t.EgressAclSet[key]; ok {
		return fmt.Errorf("duplicate key for list EgressAclSet %v", key)
	}

	t.EgressAclSet[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.EgressAclSet {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet struct {
	ΛMetadata   []ygot.Annotation                                                             `path:"@" ygotAnnotation:"true"`
	AclEntries  *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries `path:"acl-entries" module:"openconfig-acl"`
	ΛAclEntries []ygot.Annotation                                                             `path:"@acl-entries" ygotAnnotation:"true"`
	Config      *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config     `path:"config" module:"openconfig-acl"`
	ΛConfig     []ygot.Annotation                                                             `path:"@config" ygotAnnotation:"true"`
	SetName     *string                                                                       `path:"set-name" module:"openconfig-acl"`
	ΛSetName    []ygot.Annotation                                                             `path:"@set-name" ygotAnnotation:"true"`
	State       *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State      `path:"state" module:"openconfig-acl"`
	ΛState      []ygot.Annotation                                                             `path:"@state" ygotAnnotation:"true"`
	Type        E_OpenconfigAcl_ACL_TYPE                                                      `path:"type" module:"openconfig-acl"`
	ΛType       []ygot.Annotation                                                             `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) IsYANGGoStruct() {}

// GetOrCreateAclEntries retrieves the value of the AclEntries field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) GetOrCreateAclEntries() *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries {
	if t.AclEntries != nil {
		return t.AclEntries
	}
	t.AclEntries = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries{}
	return t.AclEntries
}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) GetOrCreateConfig() *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) GetOrCreateState() *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State{}
	return t.State
}

// GetAclEntries returns the value of the AclEntries struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet. If the receiver or the field AclEntries is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) GetAclEntries() *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries {
	if t != nil && t.AclEntries != nil {
		return t.AclEntries
	}
	return nil
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) GetConfig() *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) GetState() *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetSetName retrieves the value of the leaf SetName from the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SetName is set, it can
// safely use t.GetSetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SetName == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) GetSetName() string {
	if t == nil || t.SetName == nil {
		return ""
	}
	return *t.SetName
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) GetType() E_OpenconfigAcl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.AclEntries.PopulateDefaults()
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SetName == nil {
		return nil, fmt.Errorf("nil value for key SetName")
	}

	return map[string]interface{}{
		"set-name": *t.SetName,
		"type":     t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries struct {
	ΛMetadata []ygot.Annotation                                                                                 `path:"@" ygotAnnotation:"true"`
	AclEntry  map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry `path:"acl-entry" module:"openconfig-acl"`
	ΛAclEntry []ygot.Annotation                                                                                 `path:"@acl-entry" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) IsYANGGoStruct() {
}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// RenameAclEntry renames an entry in the list AclEntry within
// the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) RenameAclEntry(oldK, newK uint32) error {
	if _, ok := t.AclEntry[newK]; ok {
		return fmt.Errorf("key %v already exists in AclEntry", newK)
	}

	e, ok := t.AclEntry[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in AclEntry", oldK)
	}
	e.SequenceId = &newK

	t.AclEntry[newK] = e
	delete(t.AclEntry, oldK)
	return nil
}

// GetOrCreateAclEntryMap returns the list (map) from OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries.
//
// It initializes the field if not already initialized.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) GetOrCreateAclEntryMap() map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry {
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry)
	}
	return t.AclEntry
}

// GetOrCreateAclEntry retrieves the value with the specified keys from
// the receiver OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) GetOrCreateAclEntry(SequenceId uint32) *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry {

	key := SequenceId

	if v, ok := t.AclEntry[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewAclEntry(SequenceId)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateAclEntry got unexpected error: %v", err))
	}
	return v
}

// GetAclEntry retrieves the value with the specified key from
// the AclEntry map field of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) GetAclEntry(SequenceId uint32) *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry {

	if t == nil {
		return nil
	}

	key := SequenceId

	if lm, ok := t.AclEntry[key]; ok {
		return lm
	}
	return nil
}

// AppendAclEntry appends the supplied OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry struct to the
// list AclEntry of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries. If the key value(s) specified in
// the supplied OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry already exist in the list, an error is
// returned.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) AppendAclEntry(v *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) error {
	if v.SequenceId == nil {
		return fmt.Errorf("invalid nil key received for SequenceId")
	}

	key := *v.SequenceId

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry)
	}

	if _, ok := t.AclEntry[key]; ok {
		return fmt.Errorf("duplicate key for list AclEntry %v", key)
	}

	t.AclEntry[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.AclEntry {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry struct {
	ΛMetadata   []ygot.Annotation                                                                            `path:"@" ygotAnnotation:"true"`
	SequenceId  *uint32                                                                                      `path:"sequence-id" module:"openconfig-acl"`
	ΛSequenceId []ygot.Annotation                                                                            `path:"@sequence-id" ygotAnnotation:"true"`
	State       *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State `path:"state" module:"openconfig-acl"`
	ΛState      []ygot.Annotation                                                                            `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) IsYANGGoStruct() {
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) GetOrCreateState() *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State{}
	return t.State
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) GetState() *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetSequenceId retrieves the value of the leaf SequenceId from the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SequenceId is set, it can
// safely use t.GetSequenceId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SequenceId == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) GetSequenceId() uint32 {
	if t == nil || t.SequenceId == nil {
		return 0
	}
	return *t.SequenceId
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State struct {
	ΛMetadata       []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	MatchedOctets   *uint64           `path:"matched-octets" module:"openconfig-acl"`
	ΛMatchedOctets  []ygot.Annotation `path:"@matched-octets" ygotAnnotation:"true"`
	MatchedPackets  *uint64           `path:"matched-packets" module:"openconfig-acl"`
	ΛMatchedPackets []ygot.Annotation `path:"@matched-packets" ygotAnnotation:"true"`
	SequenceId      *uint32           `path:"sequence-id" module:"openconfig-acl"`
	ΛSequenceId     []ygot.Annotation `path:"@sequence-id" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {
}

// GetMatchedOctets retrieves the value of the leaf MatchedOctets from the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedOctets is set, it can
// safely use t.GetMatchedOctets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedOctets == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) GetMatchedOctets() uint64 {
	if t == nil || t.MatchedOctets == nil {
		return 0
	}
	return *t.MatchedOctets
}

// GetMatchedPackets retrieves the value of the leaf MatchedPackets from the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedPackets is set, it can
// safely use t.GetMatchedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedPackets == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) GetMatchedPackets() uint64 {
	if t == nil || t.MatchedPackets == nil {
		return 0
	}
	return *t.MatchedPackets
}

// GetSequenceId retrieves the value of the leaf SequenceId from the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SequenceId is set, it can
// safely use t.GetSequenceId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SequenceId == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) GetSequenceId() uint32 {
	if t == nil || t.SequenceId == nil {
		return 0
	}
	return *t.SequenceId
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config struct {
	ΛMetadata []ygot.Annotation        `path:"@" ygotAnnotation:"true"`
	SetName   *string                  `path:"set-name" module:"openconfig-acl"`
	ΛSetName  []ygot.Annotation        `path:"@set-name" ygotAnnotation:"true"`
	Type      E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
	ΛType     []ygot.Annotation        `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) IsYANGGoStruct() {}

// GetSetName retrieves the value of the leaf SetName from the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SetName is set, it can
// safely use t.GetSetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SetName == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) GetSetName() string {
	if t == nil || t.SetName == nil {
		return ""
	}
	return *t.SetName
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) GetType() E_OpenconfigAcl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State struct {
	ΛMetadata []ygot.Annotation        `path:"@" ygotAnnotation:"true"`
	SetName   *string                  `path:"set-name" module:"openconfig-acl"`
	ΛSetName  []ygot.Annotation        `path:"@set-name" ygotAnnotation:"true"`
	Type      E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
	ΛType     []ygot.Annotation        `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) IsYANGGoStruct() {}

// GetSetName retrieves the value of the leaf SetName from the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SetName is set, it can
// safely use t.GetSetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SetName == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) GetSetName() string {
	if t == nil || t.SetName == nil {
		return ""
	}
	return *t.SetName
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) GetType() E_OpenconfigAcl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets struct {
	ΛMetadata      []ygot.Annotation                                                                                                                                `path:"@" ygotAnnotation:"true"`
	IngressAclSet  map[OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet `path:"ingress-acl-set" module:"openconfig-acl"`
	ΛIngressAclSet []ygot.Annotation                                                                                                                                `path:"@ingress-acl-set" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key represents the key for list IngressAclSet of element /openconfig-acl/acl/interfaces/interface/ingress-acl-sets.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key struct {
	SetName string                   `path:"set-name"`
	Type    E_OpenconfigAcl_ACL_TYPE `path:"type"`
}

// IsYANGGoKeyStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key key struct.
func (t OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"set-name": t.SetName,
		"type":     t.Type,
	}, nil
}

// NewIngressAclSet creates a new entry in the IngressAclSet list of the
// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) NewIngressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.IngressAclSet == nil {
		t.IngressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet)
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.IngressAclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list IngressAclSet", key)
	}

	t.IngressAclSet[key] = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet{
		SetName: &SetName,
		Type:    Type,
	}

	return t.IngressAclSet[key], nil
}

// RenameIngressAclSet renames an entry in the list IngressAclSet within
// the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) RenameIngressAclSet(oldK, newK OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key) error {
	if _, ok := t.IngressAclSet[newK]; ok {
		return fmt.Errorf("key %v already exists in IngressAclSet", newK)
	}

	e, ok := t.IngressAclSet[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in IngressAclSet", oldK)
	}
	e.SetName = &newK.SetName
	e.Type = newK.Type

	t.IngressAclSet[newK] = e
	delete(t.IngressAclSet, oldK)
	return nil
}

// GetOrCreateIngressAclSetMap returns the list (map) from OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets.
//
// It initializes the field if not already initialized.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) GetOrCreateIngressAclSetMap() map[OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet {
	if t.IngressAclSet == nil {
		t.IngressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet)
	}
	return t.IngressAclSet
}

// GetOrCreateIngressAclSet retrieves the value with the specified keys from
// the receiver OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) GetOrCreateIngressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet {

	key := OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	if v, ok := t.IngressAclSet[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewIngressAclSet(SetName, Type)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateIngressAclSet got unexpected error: %v", err))
	}
	return v
}

// GetIngressAclSet retrieves the value with the specified key from
// the IngressAclSet map field of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) GetIngressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet {

	if t == nil {
		return nil
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	if lm, ok := t.IngressAclSet[key]; ok {
		return lm
	}
	return nil
}

// AppendIngressAclSet appends the supplied OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet struct to the
// list IngressAclSet of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets. If the key value(s) specified in
// the supplied OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet already exist in the list, an error is
// returned.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) AppendIngressAclSet(v *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) error {
	if v.SetName == nil {
		return fmt.Errorf("invalid nil key for SetName")
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key{
		SetName: *v.SetName,
		Type:    v.Type,
	}

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.IngressAclSet == nil {
		t.IngressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet)
	}

	if _, ok := t.IngressAclSet[key]; ok {
		return fmt.Errorf("duplicate key for list IngressAclSet %v", key)
	}

	t.IngressAclSet[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.IngressAclSet {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet struct {
	ΛMetadata   []ygot.Annotation                                                               `path:"@" ygotAnnotation:"true"`
	AclEntries  *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries `path:"acl-entries" module:"openconfig-acl"`
	ΛAclEntries []ygot.Annotation                                                               `path:"@acl-entries" ygotAnnotation:"true"`
	Config      *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config     `path:"config" module:"openconfig-acl"`
	ΛConfig     []ygot.Annotation                                                               `path:"@config" ygotAnnotation:"true"`
	SetName     *string                                                                         `path:"set-name" module:"openconfig-acl"`
	ΛSetName    []ygot.Annotation                                                               `path:"@set-name" ygotAnnotation:"true"`
	State       *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State      `path:"state" module:"openconfig-acl"`
	ΛState      []ygot.Annotation                                                               `path:"@state" ygotAnnotation:"true"`
	Type        E_OpenconfigAcl_ACL_TYPE                                                        `path:"type" module:"openconfig-acl"`
	ΛType       []ygot.Annotation                                                               `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) IsYANGGoStruct() {}

// GetOrCreateAclEntries retrieves the value of the AclEntries field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) GetOrCreateAclEntries() *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries {
	if t.AclEntries != nil {
		return t.AclEntries
	}
	t.AclEntries = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries{}
	return t.AclEntries
}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) GetOrCreateConfig() *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) GetOrCreateState() *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State{}
	return t.State
}

// GetAclEntries returns the value of the AclEntries struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet. If the receiver or the field AclEntries is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) GetAclEntries() *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries {
	if t != nil && t.AclEntries != nil {
		return t.AclEntries
	}
	return nil
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) GetConfig() *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) GetState() *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetSetName retrieves the value of the leaf SetName from the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SetName is set, it can
// safely use t.GetSetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SetName == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) GetSetName() string {
	if t == nil || t.SetName == nil {
		return ""
	}
	return *t.SetName
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) GetType() E_OpenconfigAcl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.AclEntries.PopulateDefaults()
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SetName == nil {
		return nil, fmt.Errorf("nil value for key SetName")
	}

	return map[string]interface{}{
		"set-name": *t.SetName,
		"type":     t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries struct {
	ΛMetadata []ygot.Annotation                                                                                   `path:"@" ygotAnnotation:"true"`
	AclEntry  map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry `path:"acl-entry" module:"openconfig-acl"`
	ΛAclEntry []ygot.Annotation                                                                                   `path:"@acl-entry" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) IsYANGGoStruct() {
}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// RenameAclEntry renames an entry in the list AclEntry within
// the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) RenameAclEntry(oldK, newK uint32) error {
	if _, ok := t.AclEntry[newK]; ok {
		return fmt.Errorf("key %v already exists in AclEntry", newK)
	}

	e, ok := t.AclEntry[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in AclEntry", oldK)
	}
	e.SequenceId = &newK

	t.AclEntry[newK] = e
	delete(t.AclEntry, oldK)
	return nil
}

// GetOrCreateAclEntryMap returns the list (map) from OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries.
//
// It initializes the field if not already initialized.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) GetOrCreateAclEntryMap() map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry {
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry)
	}
	return t.AclEntry
}

// GetOrCreateAclEntry retrieves the value with the specified keys from
// the receiver OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) GetOrCreateAclEntry(SequenceId uint32) *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry {

	key := SequenceId

	if v, ok := t.AclEntry[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewAclEntry(SequenceId)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateAclEntry got unexpected error: %v", err))
	}
	return v
}

// GetAclEntry retrieves the value with the specified key from
// the AclEntry map field of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) GetAclEntry(SequenceId uint32) *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry {

	if t == nil {
		return nil
	}

	key := SequenceId

	if lm, ok := t.AclEntry[key]; ok {
		return lm
	}
	return nil
}

// AppendAclEntry appends the supplied OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry struct to the
// list AclEntry of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries. If the key value(s) specified in
// the supplied OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry already exist in the list, an error is
// returned.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) AppendAclEntry(v *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) error {
	if v.SequenceId == nil {
		return fmt.Errorf("invalid nil key received for SequenceId")
	}

	key := *v.SequenceId

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry)
	}

	if _, ok := t.AclEntry[key]; ok {
		return fmt.Errorf("duplicate key for list AclEntry %v", key)
	}

	t.AclEntry[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.AclEntry {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry struct {
	ΛMetadata   []ygot.Annotation                                                                              `path:"@" ygotAnnotation:"true"`
	SequenceId  *uint32                                                                                        `path:"sequence-id" module:"openconfig-acl"`
	ΛSequenceId []ygot.Annotation                                                                              `path:"@sequence-id" ygotAnnotation:"true"`
	State       *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State `path:"state" module:"openconfig-acl"`
	ΛState      []ygot.Annotation                                                                              `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) IsYANGGoStruct() {
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) GetOrCreateState() *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State{}
	return t.State
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) GetState() *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetSequenceId retrieves the value of the leaf SequenceId from the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SequenceId is set, it can
// safely use t.GetSequenceId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SequenceId == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) GetSequenceId() uint32 {
	if t == nil || t.SequenceId == nil {
		return 0
	}
	return *t.SequenceId
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State struct {
	ΛMetadata       []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	MatchedOctets   *uint64           `path:"matched-octets" module:"openconfig-acl"`
	ΛMatchedOctets  []ygot.Annotation `path:"@matched-octets" ygotAnnotation:"true"`
	MatchedPackets  *uint64           `path:"matched-packets" module:"openconfig-acl"`
	ΛMatchedPackets []ygot.Annotation `path:"@matched-packets" ygotAnnotation:"true"`
	SequenceId      *uint32           `path:"sequence-id" module:"openconfig-acl"`
	ΛSequenceId     []ygot.Annotation `path:"@sequence-id" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {
}

// GetMatchedOctets retrieves the value of the leaf MatchedOctets from the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedOctets is set, it can
// safely use t.GetMatchedOctets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedOctets == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) GetMatchedOctets() uint64 {
	if t == nil || t.MatchedOctets == nil {
		return 0
	}
	return *t.MatchedOctets
}

// GetMatchedPackets retrieves the value of the leaf MatchedPackets from the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedPackets is set, it can
// safely use t.GetMatchedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedPackets == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) GetMatchedPackets() uint64 {
	if t == nil || t.MatchedPackets == nil {
		return 0
	}
	return *t.MatchedPackets
}

// GetSequenceId retrieves the value of the leaf SequenceId from the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SequenceId is set, it can
// safely use t.GetSequenceId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SequenceId == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) GetSequenceId() uint32 {
	if t == nil || t.SequenceId == nil {
		return 0
	}
	return *t.SequenceId
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config struct {
	ΛMetadata []ygot.Annotation        `path:"@" ygotAnnotation:"true"`
	SetName   *string                  `path:"set-name" module:"openconfig-acl"`
	ΛSetName  []ygot.Annotation        `path:"@set-name" ygotAnnotation:"true"`
	Type      E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
	ΛType     []ygot.Annotation        `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) IsYANGGoStruct() {}

// GetSetName retrieves the value of the leaf SetName from the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SetName is set, it can
// safely use t.GetSetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SetName == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) GetSetName() string {
	if t == nil || t.SetName == nil {
		return ""
	}
	return *t.SetName
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) GetType() E_OpenconfigAcl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State struct {
	ΛMetadata []ygot.Annotation        `path:"@" ygotAnnotation:"true"`
	SetName   *string                  `path:"set-name" module:"openconfig-acl"`
	ΛSetName  []ygot.Annotation        `path:"@set-name" ygotAnnotation:"true"`
	Type      E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
	ΛType     []ygot.Annotation        `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) IsYANGGoStruct() {}

// GetSetName retrieves the value of the leaf SetName from the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SetName is set, it can
// safely use t.GetSetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SetName == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) GetSetName() string {
	if t == nil || t.SetName == nil {
		return ""
	}
	return *t.SetName
}

// GetType retrieves the value of the leaf Type from the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) GetType() E_OpenconfigAcl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef represents the /openconfig-acl/acl/interfaces/interface/interface-ref YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef struct {
	ΛMetadata []ygot.Annotation                                           `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config `path:"config" module:"openconfig-acl"`
	ΛConfig   []ygot.Annotation                                           `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State  `path:"state" module:"openconfig-acl"`
	ΛState    []ygot.Annotation                                           `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) GetOrCreateConfig() *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) GetOrCreateState() *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) GetConfig() *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) GetState() *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config represents the /openconfig-acl/acl/interfaces/interface/interface-ref/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config struct {
	ΛMetadata     []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Interface     *string           `path:"interface" module:"openconfig-acl"`
	ΛInterface    []ygot.Annotation `path:"@interface" ygotAnnotation:"true"`
	Subinterface  *uint32           `path:"subinterface" module:"openconfig-acl"`
	ΛSubinterface []ygot.Annotation `path:"@subinterface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) IsYANGGoStruct() {}

// GetInterface retrieves the value of the leaf Interface from the OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interface is set, it can
// safely use t.GetInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interface == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) GetInterface() string {
	if t == nil || t.Interface == nil {
		return ""
	}
	return *t.Interface
}

// GetSubinterface retrieves the value of the leaf Subinterface from the OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Subinterface is set, it can
// safely use t.GetSubinterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Subinterface == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) GetSubinterface() uint32 {
	if t == nil || t.Subinterface == nil {
		return 0
	}
	return *t.Subinterface
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State represents the /openconfig-acl/acl/interfaces/interface/interface-ref/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State struct {
	ΛMetadata     []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Interface     *string           `path:"interface" module:"openconfig-acl"`
	ΛInterface    []ygot.Annotation `path:"@interface" ygotAnnotation:"true"`
	Subinterface  *uint32           `path:"subinterface" module:"openconfig-acl"`
	ΛSubinterface []ygot.Annotation `path:"@subinterface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) IsYANGGoStruct() {}

// GetInterface retrieves the value of the leaf Interface from the OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interface is set, it can
// safely use t.GetInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interface == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) GetInterface() string {
	if t == nil || t.Interface == nil {
		return ""
	}
	return *t.Interface
}

// GetSubinterface retrieves the value of the leaf Subinterface from the OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Subinterface is set, it can
// safely use t.GetSubinterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Subinterface == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) GetSubinterface() uint32 {
	if t == nil || t.Subinterface == nil {
		return 0
	}
	return *t.Subinterface
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_Interfaces_Interface_State represents the /openconfig-acl/acl/interfaces/interface/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_State struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Id        *string           `path:"id" module:"openconfig-acl"`
	ΛId       []ygot.Annotation `path:"@id" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_State) IsYANGGoStruct() {}

// GetId retrieves the value of the leaf Id from the OpenconfigAcl_Acl_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Id is set, it can
// safely use t.GetId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Id == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) GetId() string {
	if t == nil || t.Id == nil {
		return ""
	}
	return *t.Id
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_Interfaces_Interface_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_State represents the /openconfig-acl/acl/state YANG schema element.
type OpenconfigAcl_Acl_State struct {
	ΛMetadata          []ygot.Annotation                      `path:"@" ygotAnnotation:"true"`
	CounterCapability  E_OpenconfigAcl_ACL_COUNTER_CAPABILITY `path:"counter-capability" module:"openconfig-acl"`
	ΛCounterCapability []ygot.Annotation                      `path:"@counter-capability" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_State) IsYANGGoStruct() {}

// GetCounterCapability retrieves the value of the leaf CounterCapability from the OpenconfigAcl_Acl_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if CounterCapability is set, it can
// safely use t.GetCounterCapability() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.CounterCapability == nil' before retrieving the leaf's value.
func (t *OpenconfigAcl_Acl_State) GetCounterCapability() E_OpenconfigAcl_ACL_COUNTER_CAPABILITY {
	if t == nil || t.CounterCapability == 0 {
		return 0
	}
	return t.CounterCapability
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigAcl_Acl_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigAcl_Acl_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_State.
func (*OpenconfigAcl_Acl_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigBfd_Bfd represents the /openconfig-bfd/bfd YANG schema element.
type OpenconfigBfd_Bfd struct {
	ΛMetadata   []ygot.Annotation             `path:"@" ygotAnnotation:"true"`
	Interfaces  *OpenconfigBfd_Bfd_Interfaces `path:"interfaces" module:"openconfig-bfd"`
	ΛInterfaces []ygot.Annotation             `path:"@interfaces" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd) IsYANGGoStruct() {}

// GetOrCreateInterfaces retrieves the value of the Interfaces field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd) GetOrCreateInterfaces() *OpenconfigBfd_Bfd_Interfaces {
	if t.Interfaces != nil {
		return t.Interfaces
	}
	t.Interfaces = &OpenconfigBfd_Bfd_Interfaces{}
	return t.Interfaces
}

// GetInterfaces returns the value of the Interfaces struct pointer
// from OpenconfigBfd_Bfd. If the receiver or the field Interfaces is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd) GetInterfaces() *OpenconfigBfd_Bfd_Interfaces {
	if t != nil && t.Interfaces != nil {
		return t.Interfaces
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Interfaces.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd.
func (*OpenconfigBfd_Bfd) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces represents the /openconfig-bfd/bfd/interfaces YANG schema element.
type OpenconfigBfd_Bfd_Interfaces struct {
	ΛMetadata  []ygot.Annotation                                  `path:"@" ygotAnnotation:"true"`
	Interface  map[string]*OpenconfigBfd_Bfd_Interfaces_Interface `path:"interface" module:"openconfig-bfd"`
	ΛInterface []ygot.Annotation                                  `path:"@interface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigBfd_Bfd_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces) NewInterface(Id string) (*OpenconfigBfd_Bfd_Interfaces_Interface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigBfd_Bfd_Interfaces_Interface{
		Id: &Id,
	}

	return t.Interface[key], nil
}

// RenameInterface renames an entry in the list Interface within
// the OpenconfigBfd_Bfd_Interfaces struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigBfd_Bfd_Interfaces) RenameInterface(oldK, newK string) error {
	if _, ok := t.Interface[newK]; ok {
		return fmt.Errorf("key %v already exists in Interface", newK)
	}

	e, ok := t.Interface[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Interface", oldK)
	}
	e.Id = &newK

	t.Interface[newK] = e
	delete(t.Interface, oldK)
	return nil
}

// GetOrCreateInterfaceMap returns the list (map) from OpenconfigBfd_Bfd_Interfaces.
//
// It initializes the field if not already initialized.
func (t *OpenconfigBfd_Bfd_Interfaces) GetOrCreateInterfaceMap() map[string]*OpenconfigBfd_Bfd_Interfaces_Interface {
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface)
	}
	return t.Interface
}

// GetOrCreateInterface retrieves the value with the specified keys from
// the receiver OpenconfigBfd_Bfd_Interfaces. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigBfd_Bfd_Interfaces) GetOrCreateInterface(Id string) *OpenconfigBfd_Bfd_Interfaces_Interface {

	key := Id

	if v, ok := t.Interface[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewInterface(Id)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateInterface got unexpected error: %v", err))
	}
	return v
}

// GetInterface retrieves the value with the specified key from
// the Interface map field of OpenconfigBfd_Bfd_Interfaces. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces) GetInterface(Id string) *OpenconfigBfd_Bfd_Interfaces_Interface {

	if t == nil {
		return nil
	}

	key := Id

	if lm, ok := t.Interface[key]; ok {
		return lm
	}
	return nil
}

// AppendInterface appends the supplied OpenconfigBfd_Bfd_Interfaces_Interface struct to the
// list Interface of OpenconfigBfd_Bfd_Interfaces. If the key value(s) specified in
// the supplied OpenconfigBfd_Bfd_Interfaces_Interface already exist in the list, an error is
// returned.
func (t *OpenconfigBfd_Bfd_Interfaces) AppendInterface(v *OpenconfigBfd_Bfd_Interfaces_Interface) error {
	if v.Id == nil {
		return fmt.Errorf("invalid nil key received for Id")
	}

	key := *v.Id

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface)
	}

	if _, ok := t.Interface[key]; ok {
		return fmt.Errorf("duplicate key for list Interface %v", key)
	}

	t.Interface[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.Interface {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces.
func (*OpenconfigBfd_Bfd_Interfaces) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface represents the /openconfig-bfd/bfd/interfaces/interface YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface struct {
	ΛMetadata         []ygot.Annotation                                        `path:"@" ygotAnnotation:"true"`
	Config            *OpenconfigBfd_Bfd_Interfaces_Interface_Config           `path:"config" module:"openconfig-bfd"`
	ΛConfig           []ygot.Annotation                                        `path:"@config" ygotAnnotation:"true"`
	Id                *string                                                  `path:"id" module:"openconfig-bfd"`
	ΛId               []ygot.Annotation                                        `path:"@id" ygotAnnotation:"true"`
	InterfaceRef      *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef     `path:"interface-ref" module:"openconfig-bfd"`
	ΛInterfaceRef     []ygot.Annotation                                        `path:"@interface-ref" ygotAnnotation:"true"`
	MicroBfdSessions  *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions `path:"micro-bfd-sessions" module:"openconfig-bfd"`
	ΛMicroBfdSessions []ygot.Annotation                                        `path:"@micro-bfd-sessions" ygotAnnotation:"true"`
	Peers             *OpenconfigBfd_Bfd_Interfaces_Interface_Peers            `path:"peers" module:"openconfig-bfd"`
	ΛPeers            []ygot.Annotation                                        `path:"@peers" ygotAnnotation:"true"`
	State             *OpenconfigBfd_Bfd_Interfaces_Interface_State            `path:"state" module:"openconfig-bfd"`
	ΛState            []ygot.Annotation                                        `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) GetOrCreateConfig() *OpenconfigBfd_Bfd_Interfaces_Interface_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigBfd_Bfd_Interfaces_Interface_Config{}
	return t.Config
}

// GetOrCreateInterfaceRef retrieves the value of the InterfaceRef field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) GetOrCreateInterfaceRef() *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef {
	if t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	t.InterfaceRef = &OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef{}
	return t.InterfaceRef
}

// GetOrCreateMicroBfdSessions retrieves the value of the MicroBfdSessions field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) GetOrCreateMicroBfdSessions() *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions {
	if t.MicroBfdSessions != nil {
		return t.MicroBfdSessions
	}
	t.MicroBfdSessions = &OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions{}
	return t.MicroBfdSessions
}

// GetOrCreatePeers retrieves the value of the Peers field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) GetOrCreatePeers() *OpenconfigBfd_Bfd_Interfaces_Interface_Peers {
	if t.Peers != nil {
		return t.Peers
	}
	t.Peers = &OpenconfigBfd_Bfd_Interfaces_Interface_Peers{}
	return t.Peers
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) GetOrCreateState() *OpenconfigBfd_Bfd_Interfaces_Interface_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigBfd_Bfd_Interfaces_Interface_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) GetConfig() *OpenconfigBfd_Bfd_Interfaces_Interface_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetInterfaceRef returns the value of the InterfaceRef struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface. If the receiver or the field InterfaceRef is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) GetInterfaceRef() *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef {
	if t != nil && t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	return nil
}

// GetMicroBfdSessions returns the value of the MicroBfdSessions struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface. If the receiver or the field MicroBfdSessions is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) GetMicroBfdSessions() *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions {
	if t != nil && t.MicroBfdSessions != nil {
		return t.MicroBfdSessions
	}
	return nil
}

// GetPeers returns the value of the Peers struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface. If the receiver or the field Peers is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) GetPeers() *OpenconfigBfd_Bfd_Interfaces_Interface_Peers {
	if t != nil && t.Peers != nil {
		return t.Peers
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) GetState() *OpenconfigBfd_Bfd_Interfaces_Interface_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetId retrieves the value of the leaf Id from the OpenconfigBfd_Bfd_Interfaces_Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Id is set, it can
// safely use t.GetId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Id == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) GetId() string {
	if t == nil || t.Id == nil {
		return ""
	}
	return *t.Id
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.InterfaceRef.PopulateDefaults()
	t.MicroBfdSessions.PopulateDefaults()
	t.Peers.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface.
func (*OpenconfigBfd_Bfd_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Config represents the /openconfig-bfd/bfd/interfaces/interface/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Config struct {
	ΛMetadata                 []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	DesiredMinimumTxInterval  *uint32           `path:"desired-minimum-tx-interval" module:"openconfig-bfd"`
	ΛDesiredMinimumTxInterval []ygot.Annotation `path:"@desired-minimum-tx-interval" ygotAnnotation:"true"`
	DetectionMultiplier       *uint8            `path:"detection-multiplier" module:"openconfig-bfd"`
	ΛDetectionMultiplier      []ygot.Annotation `path:"@detection-multiplier" ygotAnnotation:"true"`
	EnablePerMemberLink       *bool             `path:"enable-per-member-link" module:"openconfig-bfd"`
	ΛEnablePerMemberLink      []ygot.Annotation `path:"@enable-per-member-link" ygotAnnotation:"true"`
	Enabled                   *bool             `path:"enabled" module:"openconfig-bfd"`
	ΛEnabled                  []ygot.Annotation `path:"@enabled" ygotAnnotation:"true"`
	Id                        *string           `path:"id" module:"openconfig-bfd"`
	ΛId                       []ygot.Annotation `path:"@id" ygotAnnotation:"true"`
	LocalAddress              *string           `path:"local-address" module:"openconfig-bfd"`
	ΛLocalAddress             []ygot.Annotation `path:"@local-address" ygotAnnotation:"true"`
	RequiredMinimumReceive    *uint32           `path:"required-minimum-receive" module:"openconfig-bfd"`
	ΛRequiredMinimumReceive   []ygot.Annotation `path:"@required-minimum-receive" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Config) IsYANGGoStruct() {}

// GetDesiredMinimumTxInterval retrieves the value of the leaf DesiredMinimumTxInterval from the OpenconfigBfd_Bfd_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DesiredMinimumTxInterval is set, it can
// safely use t.GetDesiredMinimumTxInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DesiredMinimumTxInterval == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) GetDesiredMinimumTxInterval() uint32 {
	if t == nil || t.DesiredMinimumTxInterval == nil {
		return 0
	}
	return *t.DesiredMinimumTxInterval
}

// GetDetectionMultiplier retrieves the value of the leaf DetectionMultiplier from the OpenconfigBfd_Bfd_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DetectionMultiplier is set, it can
// safely use t.GetDetectionMultiplier() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DetectionMultiplier == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) GetDetectionMultiplier() uint8 {
	if t == nil || t.DetectionMultiplier == nil {
		return 0
	}
	return *t.DetectionMultiplier
}

// GetEnablePerMemberLink retrieves the value of the leaf EnablePerMemberLink from the OpenconfigBfd_Bfd_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EnablePerMemberLink is set, it can
// safely use t.GetEnablePerMemberLink() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EnablePerMemberLink == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) GetEnablePerMemberLink() bool {
	if t == nil || t.EnablePerMemberLink == nil {
		return false
	}
	return *t.EnablePerMemberLink
}

// GetEnabled retrieves the value of the leaf Enabled from the OpenconfigBfd_Bfd_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return false
	}
	return *t.Enabled
}

// GetId retrieves the value of the leaf Id from the OpenconfigBfd_Bfd_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Id is set, it can
// safely use t.GetId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Id == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) GetId() string {
	if t == nil || t.Id == nil {
		return ""
	}
	return *t.Id
}

// GetLocalAddress retrieves the value of the leaf LocalAddress from the OpenconfigBfd_Bfd_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalAddress is set, it can
// safely use t.GetLocalAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) GetLocalAddress() string {
	if t == nil || t.LocalAddress == nil {
		return ""
	}
	return *t.LocalAddress
}

// GetRequiredMinimumReceive retrieves the value of the leaf RequiredMinimumReceive from the OpenconfigBfd_Bfd_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RequiredMinimumReceive is set, it can
// safely use t.GetRequiredMinimumReceive() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RequiredMinimumReceive == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) GetRequiredMinimumReceive() uint32 {
	if t == nil || t.RequiredMinimumReceive == nil {
		return 0
	}
	return *t.RequiredMinimumReceive
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.EnablePerMemberLink == nil {
		var v bool = false
		t.EnablePerMemberLink = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Config.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef struct {
	ΛMetadata []ygot.Annotation                                           `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config `path:"config" module:"openconfig-bfd"`
	ΛConfig   []ygot.Annotation                                           `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State  `path:"state" module:"openconfig-bfd"`
	ΛState    []ygot.Annotation                                           `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) GetOrCreateConfig() *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) GetOrCreateState() *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) GetConfig() *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) GetState() *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config struct {
	ΛMetadata     []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Interface     *string           `path:"interface" module:"openconfig-bfd"`
	ΛInterface    []ygot.Annotation `path:"@interface" ygotAnnotation:"true"`
	Subinterface  *uint32           `path:"subinterface" module:"openconfig-bfd"`
	ΛSubinterface []ygot.Annotation `path:"@subinterface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) IsYANGGoStruct() {}

// GetInterface retrieves the value of the leaf Interface from the OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interface is set, it can
// safely use t.GetInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interface == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) GetInterface() string {
	if t == nil || t.Interface == nil {
		return ""
	}
	return *t.Interface
}

// GetSubinterface retrieves the value of the leaf Subinterface from the OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Subinterface is set, it can
// safely use t.GetSubinterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Subinterface == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) GetSubinterface() uint32 {
	if t == nil || t.Subinterface == nil {
		return 0
	}
	return *t.Subinterface
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State struct {
	ΛMetadata     []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Interface     *string           `path:"interface" module:"openconfig-bfd"`
	ΛInterface    []ygot.Annotation `path:"@interface" ygotAnnotation:"true"`
	Subinterface  *uint32           `path:"subinterface" module:"openconfig-bfd"`
	ΛSubinterface []ygot.Annotation `path:"@subinterface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) IsYANGGoStruct() {}

// GetInterface retrieves the value of the leaf Interface from the OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interface is set, it can
// safely use t.GetInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interface == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) GetInterface() string {
	if t == nil || t.Interface == nil {
		return ""
	}
	return *t.Interface
}

// GetSubinterface retrieves the value of the leaf Subinterface from the OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Subinterface is set, it can
// safely use t.GetSubinterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Subinterface == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) GetSubinterface() uint32 {
	if t == nil || t.Subinterface == nil {
		return 0
	}
	return *t.Subinterface
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions struct {
	ΛMetadata        []ygot.Annotation                                                                   `path:"@" ygotAnnotation:"true"`
	MicroBfdSession  map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession `path:"micro-bfd-session" module:"openconfig-bfd"`
	ΛMicroBfdSession []ygot.Annotation                                                                   `path:"@micro-bfd-session" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) IsYANGGoStruct() {}

// NewMicroBfdSession creates a new entry in the MicroBfdSession list of the
// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) NewMicroBfdSession(MemberInterface string) (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.MicroBfdSession == nil {
		t.MicroBfdSession = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession)
	}

	key := MemberInterface

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.MicroBfdSession[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list MicroBfdSession", key)
	}

	t.MicroBfdSession[key] = &OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession{
		MemberInterface: &MemberInterface,
	}

	return t.MicroBfdSession[key], nil
}

// RenameMicroBfdSession renames an entry in the list MicroBfdSession within
// the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) RenameMicroBfdSession(oldK, newK string) error {
	if _, ok := t.MicroBfdSession[newK]; ok {
		return fmt.Errorf("key %v already exists in MicroBfdSession", newK)
	}

	e, ok := t.MicroBfdSession[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in MicroBfdSession", oldK)
	}
	e.MemberInterface = &newK

	t.MicroBfdSession[newK] = e
	delete(t.MicroBfdSession, oldK)
	return nil
}

// GetOrCreateMicroBfdSessionMap returns the list (map) from OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions.
//
// It initializes the field if not already initialized.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) GetOrCreateMicroBfdSessionMap() map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession {
	if t.MicroBfdSession == nil {
		t.MicroBfdSession = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession)
	}
	return t.MicroBfdSession
}

// GetOrCreateMicroBfdSession retrieves the value with the specified keys from
// the receiver OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) GetOrCreateMicroBfdSession(MemberInterface string) *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession {

	key := MemberInterface

	if v, ok := t.MicroBfdSession[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewMicroBfdSession(MemberInterface)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateMicroBfdSession got unexpected error: %v", err))
	}
	return v
}

// GetMicroBfdSession retrieves the value with the specified key from
// the MicroBfdSession map field of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) GetMicroBfdSession(MemberInterface string) *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession {

	if t == nil {
		return nil
	}

	key := MemberInterface

	if lm, ok := t.MicroBfdSession[key]; ok {
		return lm
	}
	return nil
}

// AppendMicroBfdSession appends the supplied OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession struct to the
// list MicroBfdSession of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions. If the key value(s) specified in
// the supplied OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession already exist in the list, an error is
// returned.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) AppendMicroBfdSession(v *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) error {
	if v.MemberInterface == nil {
		return fmt.Errorf("invalid nil key received for MemberInterface")
	}

	key := *v.MemberInterface

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.MicroBfdSession == nil {
		t.MicroBfdSession = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession)
	}

	if _, ok := t.MicroBfdSession[key]; ok {
		return fmt.Errorf("duplicate key for list MicroBfdSession %v", key)
	}

	t.MicroBfdSession[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.MicroBfdSession {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession struct {
	ΛMetadata        []ygot.Annotation                                                               `path:"@" ygotAnnotation:"true"`
	Config           *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config `path:"config" module:"openconfig-bfd"`
	ΛConfig          []ygot.Annotation                                                               `path:"@config" ygotAnnotation:"true"`
	MemberInterface  *string                                                                         `path:"member-interface" module:"openconfig-bfd"`
	ΛMemberInterface []ygot.Annotation                                                               `path:"@member-interface" ygotAnnotation:"true"`
	State            *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State  `path:"state" module:"openconfig-bfd"`
	ΛState           []ygot.Annotation                                                               `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) GetOrCreateConfig() *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) GetOrCreateState() *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) GetConfig() *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) GetState() *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetMemberInterface retrieves the value of the leaf MemberInterface from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MemberInterface is set, it can
// safely use t.GetMemberInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MemberInterface == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) GetMemberInterface() string {
	if t == nil || t.MemberInterface == nil {
		return ""
	}
	return *t.MemberInterface
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛListKeyMap() (map[string]interface{}, error) {
	if t.MemberInterface == nil {
		return nil, fmt.Errorf("nil value for key MemberInterface")
	}

	return map[string]interface{}{
		"member-interface": *t.MemberInterface,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config struct {
	ΛMetadata        []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	LocalAddress     *string           `path:"local-address" module:"openconfig-bfd"`
	ΛLocalAddress    []ygot.Annotation `path:"@local-address" ygotAnnotation:"true"`
	MemberInterface  *string           `path:"member-interface" module:"openconfig-bfd"`
	ΛMemberInterface []ygot.Annotation `path:"@member-interface" ygotAnnotation:"true"`
	RemoteAddress    *string           `path:"remote-address" module:"openconfig-bfd"`
	ΛRemoteAddress   []ygot.Annotation `path:"@remote-address" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) IsYANGGoStruct() {
}

// GetLocalAddress retrieves the value of the leaf LocalAddress from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalAddress is set, it can
// safely use t.GetLocalAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) GetLocalAddress() string {
	if t == nil || t.LocalAddress == nil {
		return ""
	}
	return *t.LocalAddress
}

// GetMemberInterface retrieves the value of the leaf MemberInterface from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MemberInterface is set, it can
// safely use t.GetMemberInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MemberInterface == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) GetMemberInterface() string {
	if t == nil || t.MemberInterface == nil {
		return ""
	}
	return *t.MemberInterface
}

// GetRemoteAddress retrieves the value of the leaf RemoteAddress from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteAddress is set, it can
// safely use t.GetRemoteAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) GetRemoteAddress() string {
	if t == nil || t.RemoteAddress == nil {
		return ""
	}
	return *t.RemoteAddress
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State struct {
	ΛMetadata                      []ygot.Annotation                                                                    `path:"@" ygotAnnotation:"true"`
	Async                          *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async `path:"async" module:"openconfig-bfd"`
	ΛAsync                         []ygot.Annotation                                                                    `path:"@async" ygotAnnotation:"true"`
	DemandModeRequested            *bool                                                                                `path:"demand-mode-requested" module:"openconfig-bfd"`
	ΛDemandModeRequested           []ygot.Annotation                                                                    `path:"@demand-mode-requested" ygotAnnotation:"true"`
	FailureTransitions             *uint64                                                                              `path:"failure-transitions" module:"openconfig-bfd"`
	ΛFailureTransitions            []ygot.Annotation                                                                    `path:"@failure-transitions" ygotAnnotation:"true"`
	LastFailureTime                *uint64                                                                              `path:"last-failure-time" module:"openconfig-bfd"`
	ΛLastFailureTime               []ygot.Annotation                                                                    `path:"@last-failure-time" ygotAnnotation:"true"`
	LocalAddress                   *string                                                                              `path:"local-address" module:"openconfig-bfd"`
	ΛLocalAddress                  []ygot.Annotation                                                                    `path:"@local-address" ygotAnnotation:"true"`
	LocalDiagnosticCode            E_OpenconfigBfd_BfdDiagnosticCode                                                    `path:"local-diagnostic-code" module:"openconfig-bfd"`
	ΛLocalDiagnosticCode           []ygot.Annotation                                                                    `path:"@local-diagnostic-code" ygotAnnotation:"true"`
	LocalDiscriminator             *string                                                                              `path:"local-discriminator" module:"openconfig-bfd"`
	ΛLocalDiscriminator            []ygot.Annotation                                                                    `path:"@local-discriminator" ygotAnnotation:"true"`
	MemberInterface                *string                                                                              `path:"member-interface" module:"openconfig-bfd"`
	ΛMemberInterface               []ygot.Annotation                                                                    `path:"@member-interface" ygotAnnotation:"true"`
	RemoteAddress                  *string                                                                              `path:"remote-address" module:"openconfig-bfd"`
	ΛRemoteAddress                 []ygot.Annotation                                                                    `path:"@remote-address" ygotAnnotation:"true"`
	RemoteAuthenticationEnabled    *bool                                                                                `path:"remote-authentication-enabled" module:"openconfig-bfd"`
	ΛRemoteAuthenticationEnabled   []ygot.Annotation                                                                    `path:"@remote-authentication-enabled" ygotAnnotation:"true"`
	RemoteControlPlaneIndependent  *bool                                                                                `path:"remote-control-plane-independent" module:"openconfig-bfd"`
	ΛRemoteControlPlaneIndependent []ygot.Annotation                                                                    `path:"@remote-control-plane-independent" ygotAnnotation:"true"`
	RemoteDiagnosticCode           E_OpenconfigBfd_BfdDiagnosticCode                                                    `path:"remote-diagnostic-code" module:"openconfig-bfd"`
	ΛRemoteDiagnosticCode          []ygot.Annotation                                                                    `path:"@remote-diagnostic-code" ygotAnnotation:"true"`
	RemoteDiscriminator            *string                                                                              `path:"remote-discriminator" module:"openconfig-bfd"`
	ΛRemoteDiscriminator           []ygot.Annotation                                                                    `path:"@remote-discriminator" ygotAnnotation:"true"`
	RemoteMinimumReceiveInterval   *uint32                                                                              `path:"remote-minimum-receive-interval" module:"openconfig-bfd"`
	ΛRemoteMinimumReceiveInterval  []ygot.Annotation                                                                    `path:"@remote-minimum-receive-interval" ygotAnnotation:"true"`
	RemoteSessionState             E_OpenconfigBfd_BfdSessionState                                                      `path:"remote-session-state" module:"openconfig-bfd"`
	ΛRemoteSessionState            []ygot.Annotation                                                                    `path:"@remote-session-state" ygotAnnotation:"true"`
	SessionState                   E_OpenconfigBfd_BfdSessionState                                                      `path:"session-state" module:"openconfig-bfd"`
	ΛSessionState                  []ygot.Annotation                                                                    `path:"@session-state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) IsYANGGoStruct() {
}

// GetOrCreateAsync retrieves the value of the Async field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetOrCreateAsync() *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async {
	if t.Async != nil {
		return t.Async
	}
	t.Async = &OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async{}
	return t.Async
}

// GetAsync returns the value of the Async struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State. If the receiver or the field Async is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetAsync() *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async {
	if t != nil && t.Async != nil {
		return t.Async
	}
	return nil
}

// GetDemandModeRequested retrieves the value of the leaf DemandModeRequested from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DemandModeRequested is set, it can
// safely use t.GetDemandModeRequested() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DemandModeRequested == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetDemandModeRequested() bool {
	if t == nil || t.DemandModeRequested == nil {
		return false
	}
	return *t.DemandModeRequested
}

// GetFailureTransitions retrieves the value of the leaf FailureTransitions from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FailureTransitions is set, it can
// safely use t.GetFailureTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FailureTransitions == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetFailureTransitions() uint64 {
	if t == nil || t.FailureTransitions == nil {
		return 0
	}
	return *t.FailureTransitions
}

// GetLastFailureTime retrieves the value of the leaf LastFailureTime from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastFailureTime is set, it can
// safely use t.GetLastFailureTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastFailureTime == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetLastFailureTime() uint64 {
	if t == nil || t.LastFailureTime == nil {
		return 0
	}
	return *t.LastFailureTime
}

// GetLocalAddress retrieves the value of the leaf LocalAddress from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalAddress is set, it can
// safely use t.GetLocalAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetLocalAddress() string {
	if t == nil || t.LocalAddress == nil {
		return ""
	}
	return *t.LocalAddress
}

// GetLocalDiagnosticCode retrieves the value of the leaf LocalDiagnosticCode from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalDiagnosticCode is set, it can
// safely use t.GetLocalDiagnosticCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalDiagnosticCode == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetLocalDiagnosticCode() E_OpenconfigBfd_BfdDiagnosticCode {
	if t == nil || t.LocalDiagnosticCode == 0 {
		return 0
	}
	return t.LocalDiagnosticCode
}

// GetLocalDiscriminator retrieves the value of the leaf LocalDiscriminator from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalDiscriminator is set, it can
// safely use t.GetLocalDiscriminator() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalDiscriminator == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetLocalDiscriminator() string {
	if t == nil || t.LocalDiscriminator == nil {
		return ""
	}
	return *t.LocalDiscriminator
}

// GetMemberInterface retrieves the value of the leaf MemberInterface from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MemberInterface is set, it can
// safely use t.GetMemberInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MemberInterface == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetMemberInterface() string {
	if t == nil || t.MemberInterface == nil {
		return ""
	}
	return *t.MemberInterface
}

// GetRemoteAddress retrieves the value of the leaf RemoteAddress from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteAddress is set, it can
// safely use t.GetRemoteAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetRemoteAddress() string {
	if t == nil || t.RemoteAddress == nil {
		return ""
	}
	return *t.RemoteAddress
}

// GetRemoteAuthenticationEnabled retrieves the value of the leaf RemoteAuthenticationEnabled from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteAuthenticationEnabled is set, it can
// safely use t.GetRemoteAuthenticationEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteAuthenticationEnabled == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetRemoteAuthenticationEnabled() bool {
	if t == nil || t.RemoteAuthenticationEnabled == nil {
		return false
	}
	return *t.RemoteAuthenticationEnabled
}

// GetRemoteControlPlaneIndependent retrieves the value of the leaf RemoteControlPlaneIndependent from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteControlPlaneIndependent is set, it can
// safely use t.GetRemoteControlPlaneIndependent() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteControlPlaneIndependent == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetRemoteControlPlaneIndependent() bool {
	if t == nil || t.RemoteControlPlaneIndependent == nil {
		return false
	}
	return *t.RemoteControlPlaneIndependent
}

// GetRemoteDiagnosticCode retrieves the value of the leaf RemoteDiagnosticCode from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteDiagnosticCode is set, it can
// safely use t.GetRemoteDiagnosticCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteDiagnosticCode == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetRemoteDiagnosticCode() E_OpenconfigBfd_BfdDiagnosticCode {
	if t == nil || t.RemoteDiagnosticCode == 0 {
		return 0
	}
	return t.RemoteDiagnosticCode
}

// GetRemoteDiscriminator retrieves the value of the leaf RemoteDiscriminator from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteDiscriminator is set, it can
// safely use t.GetRemoteDiscriminator() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteDiscriminator == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetRemoteDiscriminator() string {
	if t == nil || t.RemoteDiscriminator == nil {
		return ""
	}
	return *t.RemoteDiscriminator
}

// GetRemoteMinimumReceiveInterval retrieves the value of the leaf RemoteMinimumReceiveInterval from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteMinimumReceiveInterval is set, it can
// safely use t.GetRemoteMinimumReceiveInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteMinimumReceiveInterval == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetRemoteMinimumReceiveInterval() uint32 {
	if t == nil || t.RemoteMinimumReceiveInterval == nil {
		return 0
	}
	return *t.RemoteMinimumReceiveInterval
}

// GetRemoteSessionState retrieves the value of the leaf RemoteSessionState from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteSessionState is set, it can
// safely use t.GetRemoteSessionState() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteSessionState == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetRemoteSessionState() E_OpenconfigBfd_BfdSessionState {
	if t == nil || t.RemoteSessionState == 0 {
		return 0
	}
	return t.RemoteSessionState
}

// GetSessionState retrieves the value of the leaf SessionState from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SessionState is set, it can
// safely use t.GetSessionState() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SessionState == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) GetSessionState() E_OpenconfigBfd_BfdSessionState {
	if t == nil || t.SessionState == 0 {
		return 0
	}
	return t.SessionState
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Async.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async struct {
	ΛMetadata              []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	LastPacketReceived     *uint64           `path:"last-packet-received" module:"openconfig-bfd"`
	ΛLastPacketReceived    []ygot.Annotation `path:"@last-packet-received" ygotAnnotation:"true"`
	LastPacketTransmitted  *uint64           `path:"last-packet-transmitted" module:"openconfig-bfd"`
	ΛLastPacketTransmitted []ygot.Annotation `path:"@last-packet-transmitted" ygotAnnotation:"true"`
	ReceivedPackets        *uint64           `path:"received-packets" module:"openconfig-bfd"`
	ΛReceivedPackets       []ygot.Annotation `path:"@received-packets" ygotAnnotation:"true"`
	TransmittedPackets     *uint64           `path:"transmitted-packets" module:"openconfig-bfd"`
	ΛTransmittedPackets    []ygot.Annotation `path:"@transmitted-packets" ygotAnnotation:"true"`
	UpTransitions          *uint64           `path:"up-transitions" module:"openconfig-bfd"`
	ΛUpTransitions         []ygot.Annotation `path:"@up-transitions" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) IsYANGGoStruct() {
}

// GetLastPacketReceived retrieves the value of the leaf LastPacketReceived from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketReceived is set, it can
// safely use t.GetLastPacketReceived() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketReceived == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) GetLastPacketReceived() uint64 {
	if t == nil || t.LastPacketReceived == nil {
		return 0
	}
	return *t.LastPacketReceived
}

// GetLastPacketTransmitted retrieves the value of the leaf LastPacketTransmitted from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketTransmitted is set, it can
// safely use t.GetLastPacketTransmitted() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketTransmitted == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) GetLastPacketTransmitted() uint64 {
	if t == nil || t.LastPacketTransmitted == nil {
		return 0
	}
	return *t.LastPacketTransmitted
}

// GetReceivedPackets retrieves the value of the leaf ReceivedPackets from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReceivedPackets is set, it can
// safely use t.GetReceivedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReceivedPackets == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) GetReceivedPackets() uint64 {
	if t == nil || t.ReceivedPackets == nil {
		return 0
	}
	return *t.ReceivedPackets
}

// GetTransmittedPackets retrieves the value of the leaf TransmittedPackets from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TransmittedPackets is set, it can
// safely use t.GetTransmittedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TransmittedPackets == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) GetTransmittedPackets() uint64 {
	if t == nil || t.TransmittedPackets == nil {
		return 0
	}
	return *t.TransmittedPackets
}

// GetUpTransitions retrieves the value of the leaf UpTransitions from the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UpTransitions is set, it can
// safely use t.GetUpTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UpTransitions == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) GetUpTransitions() uint64 {
	if t == nil || t.UpTransitions == nil {
		return 0
	}
	return *t.UpTransitions
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Peers represents the /openconfig-bfd/bfd/interfaces/interface/peers YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers struct {
	ΛMetadata []ygot.Annotation                                             `path:"@" ygotAnnotation:"true"`
	Peer      map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer `path:"peer" module:"openconfig-bfd"`
	ΛPeer     []ygot.Annotation                                             `path:"@peer" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers) IsYANGGoStruct() {}

// NewPeer creates a new entry in the Peer list of the
// OpenconfigBfd_Bfd_Interfaces_Interface_Peers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) NewPeer(LocalDiscriminator string) (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Peer == nil {
		t.Peer = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer)
	}

	key := LocalDiscriminator

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Peer[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Peer", key)
	}

	t.Peer[key] = &OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer{
		LocalDiscriminator: &LocalDiscriminator,
	}

	return t.Peer[key], nil
}

// RenamePeer renames an entry in the list Peer within
// the OpenconfigBfd_Bfd_Interfaces_Interface_Peers struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) RenamePeer(oldK, newK string) error {
	if _, ok := t.Peer[newK]; ok {
		return fmt.Errorf("key %v already exists in Peer", newK)
	}

	e, ok := t.Peer[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Peer", oldK)
	}
	e.LocalDiscriminator = &newK

	t.Peer[newK] = e
	delete(t.Peer, oldK)
	return nil
}

// GetOrCreatePeerMap returns the list (map) from OpenconfigBfd_Bfd_Interfaces_Interface_Peers.
//
// It initializes the field if not already initialized.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) GetOrCreatePeerMap() map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer {
	if t.Peer == nil {
		t.Peer = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer)
	}
	return t.Peer
}

// GetOrCreatePeer retrieves the value with the specified keys from
// the receiver OpenconfigBfd_Bfd_Interfaces_Interface_Peers. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) GetOrCreatePeer(LocalDiscriminator string) *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer {

	key := LocalDiscriminator

	if v, ok := t.Peer[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewPeer(LocalDiscriminator)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreatePeer got unexpected error: %v", err))
	}
	return v
}

// GetPeer retrieves the value with the specified key from
// the Peer map field of OpenconfigBfd_Bfd_Interfaces_Interface_Peers. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) GetPeer(LocalDiscriminator string) *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer {

	if t == nil {
		return nil
	}

	key := LocalDiscriminator

	if lm, ok := t.Peer[key]; ok {
		return lm
	}
	return nil
}

// AppendPeer appends the supplied OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer struct to the
// list Peer of OpenconfigBfd_Bfd_Interfaces_Interface_Peers. If the key value(s) specified in
// the supplied OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer already exist in the list, an error is
// returned.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) AppendPeer(v *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) error {
	if v.LocalDiscriminator == nil {
		return fmt.Errorf("invalid nil key received for LocalDiscriminator")
	}

	key := *v.LocalDiscriminator

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Peer == nil {
		t.Peer = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer)
	}

	if _, ok := t.Peer[key]; ok {
		return fmt.Errorf("duplicate key for list Peer %v", key)
	}

	t.Peer[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_Peers
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.Peer {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer struct {
	ΛMetadata           []ygot.Annotation                                        `path:"@" ygotAnnotation:"true"`
	LocalDiscriminator  *string                                                  `path:"local-discriminator" module:"openconfig-bfd"`
	ΛLocalDiscriminator []ygot.Annotation                                        `path:"@local-discriminator" ygotAnnotation:"true"`
	State               *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State `path:"state" module:"openconfig-bfd"`
	ΛState              []ygot.Annotation                                        `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) IsYANGGoStruct() {}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) GetOrCreateState() *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State{}
	return t.State
}

// GetState returns the value of the State struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) GetState() *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetLocalDiscriminator retrieves the value of the leaf LocalDiscriminator from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalDiscriminator is set, it can
// safely use t.GetLocalDiscriminator() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalDiscriminator == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) GetLocalDiscriminator() string {
	if t == nil || t.LocalDiscriminator == nil {
		return ""
	}
	return *t.LocalDiscriminator
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛListKeyMap() (map[string]interface{}, error) {
	if t.LocalDiscriminator == nil {
		return nil, fmt.Errorf("nil value for key LocalDiscriminator")
	}

	return map[string]interface{}{
		"local-discriminator": *t.LocalDiscriminator,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State struct {
	ΛMetadata                      []ygot.Annotation                                              `path:"@" ygotAnnotation:"true"`
	Async                          *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async `path:"async" module:"openconfig-bfd"`
	ΛAsync                         []ygot.Annotation                                              `path:"@async" ygotAnnotation:"true"`
	DemandModeRequested            *bool                                                          `path:"demand-mode-requested" module:"openconfig-bfd"`
	ΛDemandModeRequested           []ygot.Annotation                                              `path:"@demand-mode-requested" ygotAnnotation:"true"`
	Echo                           *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo  `path:"echo" module:"openconfig-bfd"`
	ΛEcho                          []ygot.Annotation                                              `path:"@echo" ygotAnnotation:"true"`
	FailureTransitions             *uint64                                                        `path:"failure-transitions" module:"openconfig-bfd"`
	ΛFailureTransitions            []ygot.Annotation                                              `path:"@failure-transitions" ygotAnnotation:"true"`
	LastFailureTime                *uint64                                                        `path:"last-failure-time" module:"openconfig-bfd"`
	ΛLastFailureTime               []ygot.Annotation                                              `path:"@last-failure-time" ygotAnnotation:"true"`
	LocalAddress                   *string                                                        `path:"local-address" module:"openconfig-bfd"`
	ΛLocalAddress                  []ygot.Annotation                                              `path:"@local-address" ygotAnnotation:"true"`
	LocalDiagnosticCode            E_OpenconfigBfd_BfdDiagnosticCode                              `path:"local-diagnostic-code" module:"openconfig-bfd"`
	ΛLocalDiagnosticCode           []ygot.Annotation                                              `path:"@local-diagnostic-code" ygotAnnotation:"true"`
	LocalDiscriminator             *string                                                        `path:"local-discriminator" module:"openconfig-bfd"`
	ΛLocalDiscriminator            []ygot.Annotation                                              `path:"@local-discriminator" ygotAnnotation:"true"`
	RemoteAddress                  *string                                                        `path:"remote-address" module:"openconfig-bfd"`
	ΛRemoteAddress                 []ygot.Annotation                                              `path:"@remote-address" ygotAnnotation:"true"`
	RemoteAuthenticationEnabled    *bool                                                          `path:"remote-authentication-enabled" module:"openconfig-bfd"`
	ΛRemoteAuthenticationEnabled   []ygot.Annotation                                              `path:"@remote-authentication-enabled" ygotAnnotation:"true"`
	RemoteControlPlaneIndependent  *bool                                                          `path:"remote-control-plane-independent" module:"openconfig-bfd"`
	ΛRemoteControlPlaneIndependent []ygot.Annotation                                              `path:"@remote-control-plane-independent" ygotAnnotation:"true"`
	RemoteDiagnosticCode           E_OpenconfigBfd_BfdDiagnosticCode                              `path:"remote-diagnostic-code" module:"openconfig-bfd"`
	ΛRemoteDiagnosticCode          []ygot.Annotation                                              `path:"@remote-diagnostic-code" ygotAnnotation:"true"`
	RemoteDiscriminator            *string                                                        `path:"remote-discriminator" module:"openconfig-bfd"`
	ΛRemoteDiscriminator           []ygot.Annotation                                              `path:"@remote-discriminator" ygotAnnotation:"true"`
	RemoteMinimumReceiveInterval   *uint32                                                        `path:"remote-minimum-receive-interval" module:"openconfig-bfd"`
	ΛRemoteMinimumReceiveInterval  []ygot.Annotation                                              `path:"@remote-minimum-receive-interval" ygotAnnotation:"true"`
	RemoteSessionState             E_OpenconfigBfd_BfdSessionState                                `path:"remote-session-state" module:"openconfig-bfd"`
	ΛRemoteSessionState            []ygot.Annotation                                              `path:"@remote-session-state" ygotAnnotation:"true"`
	SessionState                   E_OpenconfigBfd_BfdSessionState                                `path:"session-state" module:"openconfig-bfd"`
	ΛSessionState                  []ygot.Annotation                                              `path:"@session-state" ygotAnnotation:"true"`
	SubscribedProtocols            []E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE                `path:"subscribed-protocols" module:"openconfig-bfd"`
	ΛSubscribedProtocols           []ygot.Annotation                                              `path:"@subscribed-protocols" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) IsYANGGoStruct() {}

// GetOrCreateAsync retrieves the value of the Async field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetOrCreateAsync() *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async {
	if t.Async != nil {
		return t.Async
	}
	t.Async = &OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async{}
	return t.Async
}

// GetOrCreateEcho retrieves the value of the Echo field
// or returns the existing field if it already exists.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetOrCreateEcho() *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo {
	if t.Echo != nil {
		return t.Echo
	}
	t.Echo = &OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo{}
	return t.Echo
}

// GetAsync returns the value of the Async struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State. If the receiver or the field Async is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetAsync() *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async {
	if t != nil && t.Async != nil {
		return t.Async
	}
	return nil
}

// GetEcho returns the value of the Echo struct pointer
// from OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State. If the receiver or the field Echo is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetEcho() *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo {
	if t != nil && t.Echo != nil {
		return t.Echo
	}
	return nil
}

// GetDemandModeRequested retrieves the value of the leaf DemandModeRequested from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DemandModeRequested is set, it can
// safely use t.GetDemandModeRequested() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DemandModeRequested == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetDemandModeRequested() bool {
	if t == nil || t.DemandModeRequested == nil {
		return false
	}
	return *t.DemandModeRequested
}

// GetFailureTransitions retrieves the value of the leaf FailureTransitions from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FailureTransitions is set, it can
// safely use t.GetFailureTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FailureTransitions == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetFailureTransitions() uint64 {
	if t == nil || t.FailureTransitions == nil {
		return 0
	}
	return *t.FailureTransitions
}

// GetLastFailureTime retrieves the value of the leaf LastFailureTime from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastFailureTime is set, it can
// safely use t.GetLastFailureTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastFailureTime == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetLastFailureTime() uint64 {
	if t == nil || t.LastFailureTime == nil {
		return 0
	}
	return *t.LastFailureTime
}

// GetLocalAddress retrieves the value of the leaf LocalAddress from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalAddress is set, it can
// safely use t.GetLocalAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetLocalAddress() string {
	if t == nil || t.LocalAddress == nil {
		return ""
	}
	return *t.LocalAddress
}

// GetLocalDiagnosticCode retrieves the value of the leaf LocalDiagnosticCode from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalDiagnosticCode is set, it can
// safely use t.GetLocalDiagnosticCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalDiagnosticCode == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetLocalDiagnosticCode() E_OpenconfigBfd_BfdDiagnosticCode {
	if t == nil || t.LocalDiagnosticCode == 0 {
		return 0
	}
	return t.LocalDiagnosticCode
}

// GetLocalDiscriminator retrieves the value of the leaf LocalDiscriminator from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalDiscriminator is set, it can
// safely use t.GetLocalDiscriminator() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalDiscriminator == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetLocalDiscriminator() string {
	if t == nil || t.LocalDiscriminator == nil {
		return ""
	}
	return *t.LocalDiscriminator
}

// GetRemoteAddress retrieves the value of the leaf RemoteAddress from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteAddress is set, it can
// safely use t.GetRemoteAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetRemoteAddress() string {
	if t == nil || t.RemoteAddress == nil {
		return ""
	}
	return *t.RemoteAddress
}

// GetRemoteAuthenticationEnabled retrieves the value of the leaf RemoteAuthenticationEnabled from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteAuthenticationEnabled is set, it can
// safely use t.GetRemoteAuthenticationEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteAuthenticationEnabled == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetRemoteAuthenticationEnabled() bool {
	if t == nil || t.RemoteAuthenticationEnabled == nil {
		return false
	}
	return *t.RemoteAuthenticationEnabled
}

// GetRemoteControlPlaneIndependent retrieves the value of the leaf RemoteControlPlaneIndependent from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteControlPlaneIndependent is set, it can
// safely use t.GetRemoteControlPlaneIndependent() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteControlPlaneIndependent == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetRemoteControlPlaneIndependent() bool {
	if t == nil || t.RemoteControlPlaneIndependent == nil {
		return false
	}
	return *t.RemoteControlPlaneIndependent
}

// GetRemoteDiagnosticCode retrieves the value of the leaf RemoteDiagnosticCode from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteDiagnosticCode is set, it can
// safely use t.GetRemoteDiagnosticCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteDiagnosticCode == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetRemoteDiagnosticCode() E_OpenconfigBfd_BfdDiagnosticCode {
	if t == nil || t.RemoteDiagnosticCode == 0 {
		return 0
	}
	return t.RemoteDiagnosticCode
}

// GetRemoteDiscriminator retrieves the value of the leaf RemoteDiscriminator from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteDiscriminator is set, it can
// safely use t.GetRemoteDiscriminator() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteDiscriminator == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetRemoteDiscriminator() string {
	if t == nil || t.RemoteDiscriminator == nil {
		return ""
	}
	return *t.RemoteDiscriminator
}

// GetRemoteMinimumReceiveInterval retrieves the value of the leaf RemoteMinimumReceiveInterval from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteMinimumReceiveInterval is set, it can
// safely use t.GetRemoteMinimumReceiveInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteMinimumReceiveInterval == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetRemoteMinimumReceiveInterval() uint32 {
	if t == nil || t.RemoteMinimumReceiveInterval == nil {
		return 0
	}
	return *t.RemoteMinimumReceiveInterval
}

// GetRemoteSessionState retrieves the value of the leaf RemoteSessionState from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteSessionState is set, it can
// safely use t.GetRemoteSessionState() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteSessionState == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetRemoteSessionState() E_OpenconfigBfd_BfdSessionState {
	if t == nil || t.RemoteSessionState == 0 {
		return 0
	}
	return t.RemoteSessionState
}

// GetSessionState retrieves the value of the leaf SessionState from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SessionState is set, it can
// safely use t.GetSessionState() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SessionState == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetSessionState() E_OpenconfigBfd_BfdSessionState {
	if t == nil || t.SessionState == 0 {
		return 0
	}
	return t.SessionState
}

// GetSubscribedProtocols retrieves the value of the leaf SubscribedProtocols from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SubscribedProtocols is set, it can
// safely use t.GetSubscribedProtocols() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SubscribedProtocols == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) GetSubscribedProtocols() []E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE {
	if t == nil || t.SubscribedProtocols == nil {
		return nil
	}
	return t.SubscribedProtocols
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Async.PopulateDefaults()
	t.Echo.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async struct {
	ΛMetadata              []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	LastPacketReceived     *uint64           `path:"last-packet-received" module:"openconfig-bfd"`
	ΛLastPacketReceived    []ygot.Annotation `path:"@last-packet-received" ygotAnnotation:"true"`
	LastPacketTransmitted  *uint64           `path:"last-packet-transmitted" module:"openconfig-bfd"`
	ΛLastPacketTransmitted []ygot.Annotation `path:"@last-packet-transmitted" ygotAnnotation:"true"`
	ReceivedPackets        *uint64           `path:"received-packets" module:"openconfig-bfd"`
	ΛReceivedPackets       []ygot.Annotation `path:"@received-packets" ygotAnnotation:"true"`
	TransmittedPackets     *uint64           `path:"transmitted-packets" module:"openconfig-bfd"`
	ΛTransmittedPackets    []ygot.Annotation `path:"@transmitted-packets" ygotAnnotation:"true"`
	UpTransitions          *uint64           `path:"up-transitions" module:"openconfig-bfd"`
	ΛUpTransitions         []ygot.Annotation `path:"@up-transitions" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) IsYANGGoStruct() {}

// GetLastPacketReceived retrieves the value of the leaf LastPacketReceived from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketReceived is set, it can
// safely use t.GetLastPacketReceived() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketReceived == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) GetLastPacketReceived() uint64 {
	if t == nil || t.LastPacketReceived == nil {
		return 0
	}
	return *t.LastPacketReceived
}

// GetLastPacketTransmitted retrieves the value of the leaf LastPacketTransmitted from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketTransmitted is set, it can
// safely use t.GetLastPacketTransmitted() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketTransmitted == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) GetLastPacketTransmitted() uint64 {
	if t == nil || t.LastPacketTransmitted == nil {
		return 0
	}
	return *t.LastPacketTransmitted
}

// GetReceivedPackets retrieves the value of the leaf ReceivedPackets from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReceivedPackets is set, it can
// safely use t.GetReceivedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReceivedPackets == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) GetReceivedPackets() uint64 {
	if t == nil || t.ReceivedPackets == nil {
		return 0
	}
	return *t.ReceivedPackets
}

// GetTransmittedPackets retrieves the value of the leaf TransmittedPackets from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TransmittedPackets is set, it can
// safely use t.GetTransmittedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TransmittedPackets == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) GetTransmittedPackets() uint64 {
	if t == nil || t.TransmittedPackets == nil {
		return 0
	}
	return *t.TransmittedPackets
}

// GetUpTransitions retrieves the value of the leaf UpTransitions from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UpTransitions is set, it can
// safely use t.GetUpTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UpTransitions == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) GetUpTransitions() uint64 {
	if t == nil || t.UpTransitions == nil {
		return 0
	}
	return *t.UpTransitions
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo struct {
	ΛMetadata              []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Active                 *bool             `path:"active" module:"openconfig-bfd"`
	ΛActive                []ygot.Annotation `path:"@active" ygotAnnotation:"true"`
	LastPacketReceived     *uint64           `path:"last-packet-received" module:"openconfig-bfd"`
	ΛLastPacketReceived    []ygot.Annotation `path:"@last-packet-received" ygotAnnotation:"true"`
	LastPacketTransmitted  *uint64           `path:"last-packet-transmitted" module:"openconfig-bfd"`
	ΛLastPacketTransmitted []ygot.Annotation `path:"@last-packet-transmitted" ygotAnnotation:"true"`
	ReceivedPackets        *uint64           `path:"received-packets" module:"openconfig-bfd"`
	ΛReceivedPackets       []ygot.Annotation `path:"@received-packets" ygotAnnotation:"true"`
	TransmittedPackets     *uint64           `path:"transmitted-packets" module:"openconfig-bfd"`
	ΛTransmittedPackets    []ygot.Annotation `path:"@transmitted-packets" ygotAnnotation:"true"`
	UpTransitions          *uint64           `path:"up-transitions" module:"openconfig-bfd"`
	ΛUpTransitions         []ygot.Annotation `path:"@up-transitions" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) IsYANGGoStruct() {}

// GetActive retrieves the value of the leaf Active from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Active is set, it can
// safely use t.GetActive() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Active == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) GetActive() bool {
	if t == nil || t.Active == nil {
		return false
	}
	return *t.Active
}

// GetLastPacketReceived retrieves the value of the leaf LastPacketReceived from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketReceived is set, it can
// safely use t.GetLastPacketReceived() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketReceived == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) GetLastPacketReceived() uint64 {
	if t == nil || t.LastPacketReceived == nil {
		return 0
	}
	return *t.LastPacketReceived
}

// GetLastPacketTransmitted retrieves the value of the leaf LastPacketTransmitted from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketTransmitted is set, it can
// safely use t.GetLastPacketTransmitted() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketTransmitted == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) GetLastPacketTransmitted() uint64 {
	if t == nil || t.LastPacketTransmitted == nil {
		return 0
	}
	return *t.LastPacketTransmitted
}

// GetReceivedPackets retrieves the value of the leaf ReceivedPackets from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReceivedPackets is set, it can
// safely use t.GetReceivedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReceivedPackets == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) GetReceivedPackets() uint64 {
	if t == nil || t.ReceivedPackets == nil {
		return 0
	}
	return *t.ReceivedPackets
}

// GetTransmittedPackets retrieves the value of the leaf TransmittedPackets from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TransmittedPackets is set, it can
// safely use t.GetTransmittedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TransmittedPackets == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) GetTransmittedPackets() uint64 {
	if t == nil || t.TransmittedPackets == nil {
		return 0
	}
	return *t.TransmittedPackets
}

// GetUpTransitions retrieves the value of the leaf UpTransitions from the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UpTransitions is set, it can
// safely use t.GetUpTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UpTransitions == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) GetUpTransitions() uint64 {
	if t == nil || t.UpTransitions == nil {
		return 0
	}
	return *t.UpTransitions
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigBfd_Bfd_Interfaces_Interface_State represents the /openconfig-bfd/bfd/interfaces/interface/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_State struct {
	ΛMetadata                 []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	DesiredMinimumTxInterval  *uint32           `path:"desired-minimum-tx-interval" module:"openconfig-bfd"`
	ΛDesiredMinimumTxInterval []ygot.Annotation `path:"@desired-minimum-tx-interval" ygotAnnotation:"true"`
	DetectionMultiplier       *uint8            `path:"detection-multiplier" module:"openconfig-bfd"`
	ΛDetectionMultiplier      []ygot.Annotation `path:"@detection-multiplier" ygotAnnotation:"true"`
	EnablePerMemberLink       *bool             `path:"enable-per-member-link" module:"openconfig-bfd"`
	ΛEnablePerMemberLink      []ygot.Annotation `path:"@enable-per-member-link" ygotAnnotation:"true"`
	Enabled                   *bool             `path:"enabled" module:"openconfig-bfd"`
	ΛEnabled                  []ygot.Annotation `path:"@enabled" ygotAnnotation:"true"`
	Id                        *string           `path:"id" module:"openconfig-bfd"`
	ΛId                       []ygot.Annotation `path:"@id" ygotAnnotation:"true"`
	LocalAddress              *string           `path:"local-address" module:"openconfig-bfd"`
	ΛLocalAddress             []ygot.Annotation `path:"@local-address" ygotAnnotation:"true"`
	RequiredMinimumReceive    *uint32           `path:"required-minimum-receive" module:"openconfig-bfd"`
	ΛRequiredMinimumReceive   []ygot.Annotation `path:"@required-minimum-receive" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_State) IsYANGGoStruct() {}

// GetDesiredMinimumTxInterval retrieves the value of the leaf DesiredMinimumTxInterval from the OpenconfigBfd_Bfd_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DesiredMinimumTxInterval is set, it can
// safely use t.GetDesiredMinimumTxInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DesiredMinimumTxInterval == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) GetDesiredMinimumTxInterval() uint32 {
	if t == nil || t.DesiredMinimumTxInterval == nil {
		return 0
	}
	return *t.DesiredMinimumTxInterval
}

// GetDetectionMultiplier retrieves the value of the leaf DetectionMultiplier from the OpenconfigBfd_Bfd_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DetectionMultiplier is set, it can
// safely use t.GetDetectionMultiplier() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DetectionMultiplier == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) GetDetectionMultiplier() uint8 {
	if t == nil || t.DetectionMultiplier == nil {
		return 0
	}
	return *t.DetectionMultiplier
}

// GetEnablePerMemberLink retrieves the value of the leaf EnablePerMemberLink from the OpenconfigBfd_Bfd_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EnablePerMemberLink is set, it can
// safely use t.GetEnablePerMemberLink() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EnablePerMemberLink == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) GetEnablePerMemberLink() bool {
	if t == nil || t.EnablePerMemberLink == nil {
		return false
	}
	return *t.EnablePerMemberLink
}

// GetEnabled retrieves the value of the leaf Enabled from the OpenconfigBfd_Bfd_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return false
	}
	return *t.Enabled
}

// GetId retrieves the value of the leaf Id from the OpenconfigBfd_Bfd_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Id is set, it can
// safely use t.GetId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Id == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) GetId() string {
	if t == nil || t.Id == nil {
		return ""
	}
	return *t.Id
}

// GetLocalAddress retrieves the value of the leaf LocalAddress from the OpenconfigBfd_Bfd_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalAddress is set, it can
// safely use t.GetLocalAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) GetLocalAddress() string {
	if t == nil || t.LocalAddress == nil {
		return ""
	}
	return *t.LocalAddress
}

// GetRequiredMinimumReceive retrieves the value of the leaf RequiredMinimumReceive from the OpenconfigBfd_Bfd_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RequiredMinimumReceive is set, it can
// safely use t.GetRequiredMinimumReceive() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RequiredMinimumReceive == nil' before retrieving the leaf's value.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) GetRequiredMinimumReceive() uint32 {
	if t == nil || t.RequiredMinimumReceive == nil {
		return 0
	}
	return *t.RequiredMinimumReceive
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigBfd_Bfd_Interfaces_Interface_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.EnablePerMemberLink == nil {
		var v bool = false
		t.EnablePerMemberLink = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// OpenconfigDefinedSets_DefinedSets represents the /openconfig-defined-sets/defined-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets struct {
	ΛMetadata       []ygot.Annotation                                 `path:"@" ygotAnnotation:"true"`
	Ipv4PrefixSets  *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets `path:"ipv4-prefix-sets" module:"openconfig-defined-sets"`
	ΛIpv4PrefixSets []ygot.Annotation                                 `path:"@ipv4-prefix-sets" ygotAnnotation:"true"`
	Ipv6PrefixSets  *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets `path:"ipv6-prefix-sets" module:"openconfig-defined-sets"`
	ΛIpv6PrefixSets []ygot.Annotation                                 `path:"@ipv6-prefix-sets" ygotAnnotation:"true"`
	PortSets        *OpenconfigDefinedSets_DefinedSets_PortSets       `path:"port-sets" module:"openconfig-defined-sets"`
	ΛPortSets       []ygot.Annotation                                 `path:"@port-sets" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets) IsYANGGoStruct() {}

// GetOrCreateIpv4PrefixSets retrieves the value of the Ipv4PrefixSets field
// or returns the existing field if it already exists.
func (t *OpenconfigDefinedSets_DefinedSets) GetOrCreateIpv4PrefixSets() *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets {
	if t.Ipv4PrefixSets != nil {
		return t.Ipv4PrefixSets
	}
	t.Ipv4PrefixSets = &OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets{}
	return t.Ipv4PrefixSets
}

// GetOrCreateIpv6PrefixSets retrieves the value of the Ipv6PrefixSets field
// or returns the existing field if it already exists.
func (t *OpenconfigDefinedSets_DefinedSets) GetOrCreateIpv6PrefixSets() *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets {
	if t.Ipv6PrefixSets != nil {
		return t.Ipv6PrefixSets
	}
	t.Ipv6PrefixSets = &OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets{}
	return t.Ipv6PrefixSets
}

// GetOrCreatePortSets retrieves the value of the PortSets field
// or returns the existing field if it already exists.
func (t *OpenconfigDefinedSets_DefinedSets) GetOrCreatePortSets() *OpenconfigDefinedSets_DefinedSets_PortSets {
	if t.PortSets != nil {
		return t.PortSets
	}
	t.PortSets = &OpenconfigDefinedSets_DefinedSets_PortSets{}
	return t.PortSets
}

// GetIpv4PrefixSets returns the value of the Ipv4PrefixSets struct pointer
// from OpenconfigDefinedSets_DefinedSets. If the receiver or the field Ipv4PrefixSets is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets) GetIpv4PrefixSets() *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets {
	if t != nil && t.Ipv4PrefixSets != nil {
		return t.Ipv4PrefixSets
	}
	return nil
}

// GetIpv6PrefixSets returns the value of the Ipv6PrefixSets struct pointer
// from OpenconfigDefinedSets_DefinedSets. If the receiver or the field Ipv6PrefixSets is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets) GetIpv6PrefixSets() *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets {
	if t != nil && t.Ipv6PrefixSets != nil {
		return t.Ipv6PrefixSets
	}
	return nil
}

// GetPortSets returns the value of the PortSets struct pointer
// from OpenconfigDefinedSets_DefinedSets. If the receiver or the field PortSets is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets) GetPortSets() *OpenconfigDefinedSets_DefinedSets_PortSets {
	if t != nil && t.PortSets != nil {
		return t.PortSets
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Ipv4PrefixSets.PopulateDefaults()
	t.Ipv6PrefixSets.PopulateDefaults()
	t.PortSets.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets.
func (*OpenconfigDefinedSets_DefinedSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets struct {
	ΛMetadata      []ygot.Annotation                                                          `path:"@" ygotAnnotation:"true"`
	Ipv4PrefixSet  map[string]*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet `path:"ipv4-prefix-set" module:"openconfig-defined-sets"`
	ΛIpv4PrefixSet []ygot.Annotation                                                          `path:"@ipv4-prefix-set" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) IsYANGGoStruct() {}

// NewIpv4PrefixSet creates a new entry in the Ipv4PrefixSet list of the
// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) NewIpv4PrefixSet(Name string) (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Ipv4PrefixSet == nil {
		t.Ipv4PrefixSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Ipv4PrefixSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Ipv4PrefixSet", key)
	}

	t.Ipv4PrefixSet[key] = &OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet{
		Name: &Name,
	}

	return t.Ipv4PrefixSet[key], nil
}

// RenameIpv4PrefixSet renames an entry in the list Ipv4PrefixSet within
// the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) RenameIpv4PrefixSet(oldK, newK string) error {
	if _, ok := t.Ipv4PrefixSet[newK]; ok {
		return fmt.Errorf("key %v already exists in Ipv4PrefixSet", newK)
	}

	e, ok := t.Ipv4PrefixSet[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Ipv4PrefixSet", oldK)
	}
	e.Name = &newK

	t.Ipv4PrefixSet[newK] = e
	delete(t.Ipv4PrefixSet, oldK)
	return nil
}

// GetOrCreateIpv4PrefixSetMap returns the list (map) from OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets.
//
// It initializes the field if not already initialized.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) GetOrCreateIpv4PrefixSetMap() map[string]*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet {
	if t.Ipv4PrefixSet == nil {
		t.Ipv4PrefixSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet)
	}
	return t.Ipv4PrefixSet
}

// GetOrCreateIpv4PrefixSet retrieves the value with the specified keys from
// the receiver OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) GetOrCreateIpv4PrefixSet(Name string) *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet {

	key := Name

	if v, ok := t.Ipv4PrefixSet[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewIpv4PrefixSet(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateIpv4PrefixSet got unexpected error: %v", err))
	}
	return v
}

// GetIpv4PrefixSet retrieves the value with the specified key from
// the Ipv4PrefixSet map field of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) GetIpv4PrefixSet(Name string) *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Ipv4PrefixSet[key]; ok {
		return lm
	}
	return nil
}

// AppendIpv4PrefixSet appends the supplied OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet struct to the
// list Ipv4PrefixSet of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets. If the key value(s) specified in
// the supplied OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet already exist in the list, an error is
// returned.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) AppendIpv4PrefixSet(v *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Ipv4PrefixSet == nil {
		t.Ipv4PrefixSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet)
	}

	if _, ok := t.Ipv4PrefixSet[key]; ok {
		return fmt.Errorf("duplicate key for list Ipv4PrefixSet %v", key)
	}

	t.Ipv4PrefixSet[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.Ipv4PrefixSet {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets/ipv4-prefix-set YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet struct {
	ΛMetadata []ygot.Annotation                                                      `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config `path:"config" module:"openconfig-defined-sets"`
	ΛConfig   []ygot.Annotation                                                      `path:"@config" ygotAnnotation:"true"`
	Name      *string                                                                `path:"name" module:"openconfig-defined-sets"`
	ΛName     []ygot.Annotation                                                      `path:"@name" ygotAnnotation:"true"`
	State     *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State  `path:"state" module:"openconfig-defined-sets"`
	ΛState    []ygot.Annotation                                                      `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) GetOrCreateConfig() *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) GetOrCreateState() *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) GetConfig() *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) GetState() *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetName retrieves the value of the leaf Name from the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet struct, which is a YANG list entry.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets/ipv4-prefix-set/config YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config struct {
	ΛMetadata    []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Description  *string           `path:"description" module:"openconfig-defined-sets"`
	ΛDescription []ygot.Annotation `path:"@description" ygotAnnotation:"true"`
	Name         *string           `path:"name" module:"openconfig-defined-sets"`
	ΛName        []ygot.Annotation `path:"@name" ygotAnnotation:"true"`
	Prefix       []string          `path:"prefix" module:"openconfig-defined-sets"`
	ΛPrefix      []ygot.Annotation `path:"@prefix" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) IsYANGGoStruct() {}

// GetDescription retrieves the value of the leaf Description from the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetName retrieves the value of the leaf Name from the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetPrefix retrieves the value of the leaf Prefix from the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Prefix is set, it can
// safely use t.GetPrefix() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Prefix == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) GetPrefix() []string {
	if t == nil || t.Prefix == nil {
		return nil
	}
	return t.Prefix
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets/ipv4-prefix-set/state YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State struct {
	ΛMetadata    []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Description  *string           `path:"description" module:"openconfig-defined-sets"`
	ΛDescription []ygot.Annotation `path:"@description" ygotAnnotation:"true"`
	Name         *string           `path:"name" module:"openconfig-defined-sets"`
	ΛName        []ygot.Annotation `path:"@name" ygotAnnotation:"true"`
	Prefix       []string          `path:"prefix" module:"openconfig-defined-sets"`
	ΛPrefix      []ygot.Annotation `path:"@prefix" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) IsYANGGoStruct() {}

// GetDescription retrieves the value of the leaf Description from the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetName retrieves the value of the leaf Name from the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetPrefix retrieves the value of the leaf Prefix from the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Prefix is set, it can
// safely use t.GetPrefix() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Prefix == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) GetPrefix() []string {
	if t == nil || t.Prefix == nil {
		return nil
	}
	return t.Prefix
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets struct {
	ΛMetadata      []ygot.Annotation                                                          `path:"@" ygotAnnotation:"true"`
	Ipv6PrefixSet  map[string]*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet `path:"ipv6-prefix-set" module:"openconfig-defined-sets"`
	ΛIpv6PrefixSet []ygot.Annotation                                                          `path:"@ipv6-prefix-set" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) IsYANGGoStruct() {}

// NewIpv6PrefixSet creates a new entry in the Ipv6PrefixSet list of the
// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) NewIpv6PrefixSet(Name string) (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Ipv6PrefixSet == nil {
		t.Ipv6PrefixSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Ipv6PrefixSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Ipv6PrefixSet", key)
	}

	t.Ipv6PrefixSet[key] = &OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet{
		Name: &Name,
	}

	return t.Ipv6PrefixSet[key], nil
}

// RenameIpv6PrefixSet renames an entry in the list Ipv6PrefixSet within
// the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) RenameIpv6PrefixSet(oldK, newK string) error {
	if _, ok := t.Ipv6PrefixSet[newK]; ok {
		return fmt.Errorf("key %v already exists in Ipv6PrefixSet", newK)
	}

	e, ok := t.Ipv6PrefixSet[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Ipv6PrefixSet", oldK)
	}
	e.Name = &newK

	t.Ipv6PrefixSet[newK] = e
	delete(t.Ipv6PrefixSet, oldK)
	return nil
}

// GetOrCreateIpv6PrefixSetMap returns the list (map) from OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets.
//
// It initializes the field if not already initialized.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) GetOrCreateIpv6PrefixSetMap() map[string]*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet {
	if t.Ipv6PrefixSet == nil {
		t.Ipv6PrefixSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet)
	}
	return t.Ipv6PrefixSet
}

// GetOrCreateIpv6PrefixSet retrieves the value with the specified keys from
// the receiver OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) GetOrCreateIpv6PrefixSet(Name string) *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet {

	key := Name

	if v, ok := t.Ipv6PrefixSet[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewIpv6PrefixSet(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateIpv6PrefixSet got unexpected error: %v", err))
	}
	return v
}

// GetIpv6PrefixSet retrieves the value with the specified key from
// the Ipv6PrefixSet map field of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) GetIpv6PrefixSet(Name string) *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Ipv6PrefixSet[key]; ok {
		return lm
	}
	return nil
}

// AppendIpv6PrefixSet appends the supplied OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet struct to the
// list Ipv6PrefixSet of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets. If the key value(s) specified in
// the supplied OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet already exist in the list, an error is
// returned.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) AppendIpv6PrefixSet(v *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Ipv6PrefixSet == nil {
		t.Ipv6PrefixSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet)
	}

	if _, ok := t.Ipv6PrefixSet[key]; ok {
		return fmt.Errorf("duplicate key for list Ipv6PrefixSet %v", key)
	}

	t.Ipv6PrefixSet[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.Ipv6PrefixSet {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets/ipv6-prefix-set YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet struct {
	ΛMetadata []ygot.Annotation                                                      `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config `path:"config" module:"openconfig-defined-sets"`
	ΛConfig   []ygot.Annotation                                                      `path:"@config" ygotAnnotation:"true"`
	Name      *string                                                                `path:"name" module:"openconfig-defined-sets"`
	ΛName     []ygot.Annotation                                                      `path:"@name" ygotAnnotation:"true"`
	State     *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State  `path:"state" module:"openconfig-defined-sets"`
	ΛState    []ygot.Annotation                                                      `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) GetOrCreateConfig() *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) GetOrCreateState() *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) GetConfig() *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) GetState() *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetName retrieves the value of the leaf Name from the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet struct, which is a YANG list entry.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets/ipv6-prefix-set/config YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config struct {
	ΛMetadata    []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Description  *string           `path:"description" module:"openconfig-defined-sets"`
	ΛDescription []ygot.Annotation `path:"@description" ygotAnnotation:"true"`
	Name         *string           `path:"name" module:"openconfig-defined-sets"`
	ΛName        []ygot.Annotation `path:"@name" ygotAnnotation:"true"`
	Prefix       []string          `path:"prefix" module:"openconfig-defined-sets"`
	ΛPrefix      []ygot.Annotation `path:"@prefix" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) IsYANGGoStruct() {}

// GetDescription retrieves the value of the leaf Description from the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetName retrieves the value of the leaf Name from the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetPrefix retrieves the value of the leaf Prefix from the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Prefix is set, it can
// safely use t.GetPrefix() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Prefix == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) GetPrefix() []string {
	if t == nil || t.Prefix == nil {
		return nil
	}
	return t.Prefix
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets/ipv6-prefix-set/state YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State struct {
	ΛMetadata    []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Description  *string           `path:"description" module:"openconfig-defined-sets"`
	ΛDescription []ygot.Annotation `path:"@description" ygotAnnotation:"true"`
	Name         *string           `path:"name" module:"openconfig-defined-sets"`
	ΛName        []ygot.Annotation `path:"@name" ygotAnnotation:"true"`
	Prefix       []string          `path:"prefix" module:"openconfig-defined-sets"`
	ΛPrefix      []ygot.Annotation `path:"@prefix" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) IsYANGGoStruct() {}

// GetDescription retrieves the value of the leaf Description from the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetName retrieves the value of the leaf Name from the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetPrefix retrieves the value of the leaf Prefix from the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Prefix is set, it can
// safely use t.GetPrefix() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Prefix == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) GetPrefix() []string {
	if t == nil || t.Prefix == nil {
		return nil
	}
	return t.Prefix
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_PortSets represents the /openconfig-defined-sets/defined-sets/port-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets struct {
	ΛMetadata []ygot.Annotation                                              `path:"@" ygotAnnotation:"true"`
	PortSet   map[string]*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet `path:"port-set" module:"openconfig-defined-sets"`
	ΛPortSet  []ygot.Annotation                                              `path:"@port-set" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets) IsYANGGoStruct() {}

// NewPortSet creates a new entry in the PortSet list of the
// OpenconfigDefinedSets_DefinedSets_PortSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) NewPortSet(Name string) (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.PortSet == nil {
		t.PortSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.PortSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list PortSet", key)
	}

	t.PortSet[key] = &OpenconfigDefinedSets_DefinedSets_PortSets_PortSet{
		Name: &Name,
	}

	return t.PortSet[key], nil
}

// RenamePortSet renames an entry in the list PortSet within
// the OpenconfigDefinedSets_DefinedSets_PortSets struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) RenamePortSet(oldK, newK string) error {
	if _, ok := t.PortSet[newK]; ok {
		return fmt.Errorf("key %v already exists in PortSet", newK)
	}

	e, ok := t.PortSet[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in PortSet", oldK)
	}
	e.Name = &newK

	t.PortSet[newK] = e
	delete(t.PortSet, oldK)
	return nil
}

// GetOrCreatePortSetMap returns the list (map) from OpenconfigDefinedSets_DefinedSets_PortSets.
//
// It initializes the field if not already initialized.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) GetOrCreatePortSetMap() map[string]*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet {
	if t.PortSet == nil {
		t.PortSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet)
	}
	return t.PortSet
}

// GetOrCreatePortSet retrieves the value with the specified keys from
// the receiver OpenconfigDefinedSets_DefinedSets_PortSets. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) GetOrCreatePortSet(Name string) *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet {

	key := Name

	if v, ok := t.PortSet[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewPortSet(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreatePortSet got unexpected error: %v", err))
	}
	return v
}

// GetPortSet retrieves the value with the specified key from
// the PortSet map field of OpenconfigDefinedSets_DefinedSets_PortSets. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) GetPortSet(Name string) *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.PortSet[key]; ok {
		return lm
	}
	return nil
}

// AppendPortSet appends the supplied OpenconfigDefinedSets_DefinedSets_PortSets_PortSet struct to the
// list PortSet of OpenconfigDefinedSets_DefinedSets_PortSets. If the key value(s) specified in
// the supplied OpenconfigDefinedSets_DefinedSets_PortSets_PortSet already exist in the list, an error is
// returned.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) AppendPortSet(v *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.PortSet == nil {
		t.PortSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet)
	}

	if _, ok := t.PortSet[key]; ok {
		return fmt.Errorf("duplicate key for list PortSet %v", key)
	}

	t.PortSet[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_PortSets
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.PortSet {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets.
func (*OpenconfigDefinedSets_DefinedSets_PortSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet represents the /openconfig-defined-sets/defined-sets/port-sets/port-set YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet struct {
	ΛMetadata []ygot.Annotation                                          `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config `path:"config" module:"openconfig-defined-sets"`
	ΛConfig   []ygot.Annotation                                          `path:"@config" ygotAnnotation:"true"`
	Name      *string                                                    `path:"name" module:"openconfig-defined-sets"`
	ΛName     []ygot.Annotation                                          `path:"@name" ygotAnnotation:"true"`
	State     *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State  `path:"state" module:"openconfig-defined-sets"`
	ΛState    []ygot.Annotation                                          `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets_PortSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) GetOrCreateConfig() *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) GetOrCreateState() *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigDefinedSets_DefinedSets_PortSets_PortSet. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) GetConfig() *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigDefinedSets_DefinedSets_PortSets_PortSet. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) GetState() *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetName retrieves the value of the leaf Name from the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet struct, which is a YANG list entry.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets_PortSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets_PortSet.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config represents the /openconfig-defined-sets/defined-sets/port-sets/port-set/config YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config struct {
	ΛMetadata    []ygot.Annotation                                                      `path:"@" ygotAnnotation:"true"`
	Description  *string                                                                `path:"description" module:"openconfig-defined-sets"`
	ΛDescription []ygot.Annotation                                                      `path:"@description" ygotAnnotation:"true"`
	Name         *string                                                                `path:"name" module:"openconfig-defined-sets"`
	ΛName        []ygot.Annotation                                                      `path:"@name" ygotAnnotation:"true"`
	Port         []OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union `path:"port" module:"openconfig-defined-sets"`
	ΛPort        []ygot.Annotation                                                      `path:"@port" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) IsYANGGoStruct() {}

// GetDescription retrieves the value of the leaf Description from the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetName retrieves the value of the leaf Name from the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetPort retrieves the value of the leaf Port from the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Port is set, it can
// safely use t.GetPort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Port == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) GetPort() []OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union {
	if t == nil || t.Port == nil {
		return nil
	}
	return t.Port
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-defined-sets/defined-sets/port-sets/port-set/config/port within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16].
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16]
	Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union()
}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union ensures that E_OpenconfigPacketMatchTypes_PortNumRange_Enum
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface.
func (E_OpenconfigPacketMatchTypes_PortNumRange_Enum) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union() {
}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union ensures that UnionString
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface.
func (UnionString) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union() {
}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union ensures that UnionUint16
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface.
func (UnionUint16) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union() {
}

// To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union(i interface{}) (OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union, error) {
	if v, ok := i.(OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, string, uint16]", i, i)
}

// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State represents the /openconfig-defined-sets/defined-sets/port-sets/port-set/state YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State struct {
	ΛMetadata    []ygot.Annotation                                                     `path:"@" ygotAnnotation:"true"`
	Description  *string                                                               `path:"description" module:"openconfig-defined-sets"`
	ΛDescription []ygot.Annotation                                                     `path:"@description" ygotAnnotation:"true"`
	Name         *string                                                               `path:"name" module:"openconfig-defined-sets"`
	ΛName        []ygot.Annotation                                                     `path:"@name" ygotAnnotation:"true"`
	Port         []OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union `path:"port" module:"openconfig-defined-sets"`
	ΛPort        []ygot.Annotation                                                     `path:"@port" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) IsYANGGoStruct() {}

// GetDescription retrieves the value of the leaf Description from the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetName retrieves the value of the leaf Name from the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetPort retrieves the value of the leaf Port from the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Port is set, it can
// safely use t.GetPort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Port == nil' before retrieving the leaf's value.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) GetPort() []OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union {
	if t == nil || t.Port == nil {
		return nil
	}
	return t.Port
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-defined-sets/defined-sets/port-sets/port-set/state/port within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16].
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, UnionString, UnionUint16]
	Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union()
}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union ensures that E_OpenconfigPacketMatchTypes_PortNumRange_Enum
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface.
func (E_OpenconfigPacketMatchTypes_PortNumRange_Enum) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union() {
}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union ensures that UnionString
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface.
func (UnionString) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union() {
}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union ensures that UnionUint16
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface.
func (UnionUint16) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union() {
}

// To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union(i interface{}) (OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union, error) {
	if v, ok := i.(OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_PortNumRange_Enum, string, uint16]", i, i)
}

// OpenconfigInterfaces_Interfaces represents the /openconfig-interfaces/interfaces YANG schema element.
type OpenconfigInterfaces_Interfaces struct {
	ΛMetadata  []ygot.Annotation                                     `path:"@" ygotAnnotation:"true"`
	Interface  map[string]*OpenconfigInterfaces_Interfaces_Interface `path:"interface" module:"openconfig-interfaces"`
	ΛInterface []ygot.Annotation                                     `path:"@interface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigInterfaces_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces) NewInterface(Name string) (*OpenconfigInterfaces_Interfaces_Interface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigInterfaces_Interfaces_Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigInterfaces_Interfaces_Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// RenameInterface renames an entry in the list Interface within
// the OpenconfigInterfaces_Interfaces struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigInterfaces_Interfaces) RenameInterface(oldK, newK string) error {
	if _, ok := t.Interface[newK]; ok {
		return fmt.Errorf("key %v already exists in Interface", newK)
	}

	e, ok := t.Interface[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Interface", oldK)
	}
	e.Name = &newK

	t.Interface[newK] = e
	delete(t.Interface, oldK)
	return nil
}

// GetOrCreateInterfaceMap returns the list (map) from OpenconfigInterfaces_Interfaces.
//
// It initializes the field if not already initialized.
func (t *OpenconfigInterfaces_Interfaces) GetOrCreateInterfaceMap() map[string]*OpenconfigInterfaces_Interfaces_Interface {
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigInterfaces_Interfaces_Interface)
	}
	return t.Interface
}

// GetOrCreateInterface retrieves the value with the specified keys from
// the receiver OpenconfigInterfaces_Interfaces. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigInterfaces_Interfaces) GetOrCreateInterface(Name string) *OpenconfigInterfaces_Interfaces_Interface {

	key := Name

	if v, ok := t.Interface[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewInterface(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateInterface got unexpected error: %v", err))
	}
	return v
}

// GetInterface retrieves the value with the specified key from
// the Interface map field of OpenconfigInterfaces_Interfaces. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigInterfaces_Interfaces) GetInterface(Name string) *OpenconfigInterfaces_Interfaces_Interface {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Interface[key]; ok {
		return lm
	}
	return nil
}

// AppendInterface appends the supplied OpenconfigInterfaces_Interfaces_Interface struct to the
// list Interface of OpenconfigInterfaces_Interfaces. If the key value(s) specified in
// the supplied OpenconfigInterfaces_Interfaces_Interface already exist in the list, an error is
// returned.
func (t *OpenconfigInterfaces_Interfaces) AppendInterface(v *OpenconfigInterfaces_Interfaces_Interface) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigInterfaces_Interfaces_Interface)
	}

	if _, ok := t.Interface[key]; ok {
		return fmt.Errorf("duplicate key for list Interface %v", key)
	}

	t.Interface[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.Interface {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces.
func (*OpenconfigInterfaces_Interfaces) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface represents the /openconfig-interfaces/interfaces/interface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface struct {
	ΛMetadata         []ygot.Annotation                                           `path:"@" ygotAnnotation:"true"`
	Aggregation       *OpenconfigInterfaces_Interfaces_Interface_Aggregation      `path:"aggregation" module:"openconfig-if-aggregate"`
	ΛAggregation      []ygot.Annotation                                           `path:"@aggregation" ygotAnnotation:"true"`
	Config            *OpenconfigInterfaces_Interfaces_Interface_Config           `path:"config" module:"openconfig-interfaces"`
	ΛConfig           []ygot.Annotation                                           `path:"@config" ygotAnnotation:"true"`
	Ethernet          *OpenconfigInterfaces_Interfaces_Interface_Ethernet         `path:"ethernet" module:"openconfig-if-ethernet"`
	ΛEthernet         []ygot.Annotation                                           `path:"@ethernet" ygotAnnotation:"true"`
	HoldTime          *OpenconfigInterfaces_Interfaces_Interface_HoldTime         `path:"hold-time" module:"openconfig-interfaces"`
	ΛHoldTime         []ygot.Annotation                                           `path:"@hold-time" ygotAnnotation:"true"`
	Name              *string                                                     `path:"name" module:"openconfig-interfaces"`
	ΛName             []ygot.Annotation                                           `path:"@name" ygotAnnotation:"true"`
	PenaltyBasedAied  *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied `path:"penalty-based-aied" module:"openconfig-interfaces"`
	ΛPenaltyBasedAied []ygot.Annotation                                           `path:"@penalty-based-aied" ygotAnnotation:"true"`
	RoutedVlan        *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan       `path:"routed-vlan" module:"openconfig-vlan"`
	ΛRoutedVlan       []ygot.Annotation                                           `path:"@routed-vlan" ygotAnnotation:"true"`
	State             *OpenconfigInterfaces_Interfaces_Interface_State            `path:"state" module:"openconfig-interfaces"`
	ΛState            []ygot.Annotation                                           `path:"@state" ygotAnnotation:"true"`
	Subinterfaces     *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces    `path:"subinterfaces" module:"openconfig-interfaces"`
	ΛSubinterfaces    []ygot.Annotation                                           `path:"@subinterfaces" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface) IsYANGGoStruct() {}

// GetOrCreateAggregation retrieves the value of the Aggregation field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetOrCreateAggregation() *OpenconfigInterfaces_Interfaces_Interface_Aggregation {
	if t.Aggregation != nil {
		return t.Aggregation
	}
	t.Aggregation = &OpenconfigInterfaces_Interfaces_Interface_Aggregation{}
	return t.Aggregation
}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetOrCreateConfig() *OpenconfigInterfaces_Interfaces_Interface_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigInterfaces_Interfaces_Interface_Config{}
	return t.Config
}

// GetOrCreateEthernet retrieves the value of the Ethernet field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetOrCreateEthernet() *OpenconfigInterfaces_Interfaces_Interface_Ethernet {
	if t.Ethernet != nil {
		return t.Ethernet
	}
	t.Ethernet = &OpenconfigInterfaces_Interfaces_Interface_Ethernet{}
	return t.Ethernet
}

// GetOrCreateHoldTime retrieves the value of the HoldTime field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetOrCreateHoldTime() *OpenconfigInterfaces_Interfaces_Interface_HoldTime {
	if t.HoldTime != nil {
		return t.HoldTime
	}
	t.HoldTime = &OpenconfigInterfaces_Interfaces_Interface_HoldTime{}
	return t.HoldTime
}

// GetOrCreatePenaltyBasedAied retrieves the value of the PenaltyBasedAied field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetOrCreatePenaltyBasedAied() *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied {
	if t.PenaltyBasedAied != nil {
		return t.PenaltyBasedAied
	}
	t.PenaltyBasedAied = &OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied{}
	return t.PenaltyBasedAied
}

// GetOrCreateRoutedVlan retrieves the value of the RoutedVlan field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetOrCreateRoutedVlan() *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan {
	if t.RoutedVlan != nil {
		return t.RoutedVlan
	}
	t.RoutedVlan = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan{}
	return t.RoutedVlan
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetOrCreateState() *OpenconfigInterfaces_Interfaces_Interface_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigInterfaces_Interfaces_Interface_State{}
	return t.State
}

// GetOrCreateSubinterfaces retrieves the value of the Subinterfaces field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetOrCreateSubinterfaces() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces {
	if t.Subinterfaces != nil {
		return t.Subinterfaces
	}
	t.Subinterfaces = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces{}
	return t.Subinterfaces
}

// GetAggregation returns the value of the Aggregation struct pointer
// from OpenconfigInterfaces_Interfaces_Interface. If the receiver or the field Aggregation is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetAggregation() *OpenconfigInterfaces_Interfaces_Interface_Aggregation {
	if t != nil && t.Aggregation != nil {
		return t.Aggregation
	}
	return nil
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigInterfaces_Interfaces_Interface. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetConfig() *OpenconfigInterfaces_Interfaces_Interface_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetEthernet returns the value of the Ethernet struct pointer
// from OpenconfigInterfaces_Interfaces_Interface. If the receiver or the field Ethernet is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetEthernet() *OpenconfigInterfaces_Interfaces_Interface_Ethernet {
	if t != nil && t.Ethernet != nil {
		return t.Ethernet
	}
	return nil
}

// GetHoldTime returns the value of the HoldTime struct pointer
// from OpenconfigInterfaces_Interfaces_Interface. If the receiver or the field HoldTime is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetHoldTime() *OpenconfigInterfaces_Interfaces_Interface_HoldTime {
	if t != nil && t.HoldTime != nil {
		return t.HoldTime
	}
	return nil
}

// GetPenaltyBasedAied returns the value of the PenaltyBasedAied struct pointer
// from OpenconfigInterfaces_Interfaces_Interface. If the receiver or the field PenaltyBasedAied is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetPenaltyBasedAied() *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied {
	if t != nil && t.PenaltyBasedAied != nil {
		return t.PenaltyBasedAied
	}
	return nil
}

// GetRoutedVlan returns the value of the RoutedVlan struct pointer
// from OpenconfigInterfaces_Interfaces_Interface. If the receiver or the field RoutedVlan is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetRoutedVlan() *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan {
	if t != nil && t.RoutedVlan != nil {
		return t.RoutedVlan
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigInterfaces_Interfaces_Interface. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetState() *OpenconfigInterfaces_Interfaces_Interface_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetSubinterfaces returns the value of the Subinterfaces struct pointer
// from OpenconfigInterfaces_Interfaces_Interface. If the receiver or the field Subinterfaces is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetSubinterfaces() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces {
	if t != nil && t.Subinterfaces != nil {
		return t.Subinterfaces
	}
	return nil
}

// GetName retrieves the value of the leaf Name from the OpenconfigInterfaces_Interfaces_Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Aggregation.PopulateDefaults()
	t.Config.PopulateDefaults()
	t.Ethernet.PopulateDefaults()
	t.HoldTime.PopulateDefaults()
	t.PenaltyBasedAied.PopulateDefaults()
	t.RoutedVlan.PopulateDefaults()
	t.State.PopulateDefaults()
	t.Subinterfaces.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface.
func (*OpenconfigInterfaces_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation represents the /openconfig-interfaces/interfaces/interface/aggregation YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation struct {
	ΛMetadata     []ygot.Annotation                                                   `path:"@" ygotAnnotation:"true"`
	Config        *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config       `path:"config" module:"openconfig-if-aggregate"`
	ΛConfig       []ygot.Annotation                                                   `path:"@config" ygotAnnotation:"true"`
	State         *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State        `path:"state" module:"openconfig-if-aggregate"`
	ΛState        []ygot.Annotation                                                   `path:"@state" ygotAnnotation:"true"`
	SwitchedVlan  *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan `path:"switched-vlan" module:"openconfig-vlan"`
	ΛSwitchedVlan []ygot.Annotation                                                   `path:"@switched-vlan" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) GetOrCreateConfig() *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) GetOrCreateState() *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigInterfaces_Interfaces_Interface_Aggregation_State{}
	return t.State
}

// GetOrCreateSwitchedVlan retrieves the value of the SwitchedVlan field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) GetOrCreateSwitchedVlan() *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan {
	if t.SwitchedVlan != nil {
		return t.SwitchedVlan
	}
	t.SwitchedVlan = &OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan{}
	return t.SwitchedVlan
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Aggregation. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) GetConfig() *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Aggregation. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) GetState() *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetSwitchedVlan returns the value of the SwitchedVlan struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Aggregation. If the receiver or the field SwitchedVlan is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) GetSwitchedVlan() *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan {
	if t != nil && t.SwitchedVlan != nil {
		return t.SwitchedVlan
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Aggregation
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
	t.SwitchedVlan.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation) ΛBelongingModule() string {
	return "openconfig-if-aggregate"
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config represents the /openconfig-interfaces/interfaces/interface/aggregation/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config struct {
	ΛMetadata []ygot.Annotation                       `path:"@" ygotAnnotation:"true"`
	LagType   E_OpenconfigIfAggregate_AggregationType `path:"lag-type" module:"openconfig-if-aggregate"`
	ΛLagType  []ygot.Annotation                       `path:"@lag-type" ygotAnnotation:"true"`
	MinLinks  *uint16                                 `path:"min-links" module:"openconfig-if-aggregate"`
	ΛMinLinks []ygot.Annotation                       `path:"@min-links" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) IsYANGGoStruct() {}

// GetLagType retrieves the value of the leaf LagType from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LagType is set, it can
// safely use t.GetLagType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LagType == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) GetLagType() E_OpenconfigIfAggregate_AggregationType {
	if t == nil || t.LagType == 0 {
		return 0
	}
	return t.LagType
}

// GetMinLinks retrieves the value of the leaf MinLinks from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinLinks is set, it can
// safely use t.GetMinLinks() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinLinks == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) GetMinLinks() uint16 {
	if t == nil || t.MinLinks == nil {
		return 0
	}
	return *t.MinLinks
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) ΛBelongingModule() string {
	return "openconfig-if-aggregate"
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation_State represents the /openconfig-interfaces/interfaces/interface/aggregation/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_State struct {
	ΛMetadata []ygot.Annotation                       `path:"@" ygotAnnotation:"true"`
	LagSpeed  *uint32                                 `path:"lag-speed" module:"openconfig-if-aggregate"`
	ΛLagSpeed []ygot.Annotation                       `path:"@lag-speed" ygotAnnotation:"true"`
	LagType   E_OpenconfigIfAggregate_AggregationType `path:"lag-type" module:"openconfig-if-aggregate"`
	ΛLagType  []ygot.Annotation                       `path:"@lag-type" ygotAnnotation:"true"`
	Member    []string                                `path:"member" module:"openconfig-if-aggregate"`
	ΛMember   []ygot.Annotation                       `path:"@member" ygotAnnotation:"true"`
	MinLinks  *uint16                                 `path:"min-links" module:"openconfig-if-aggregate"`
	ΛMinLinks []ygot.Annotation                       `path:"@min-links" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) IsYANGGoStruct() {}

// GetLagSpeed retrieves the value of the leaf LagSpeed from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LagSpeed is set, it can
// safely use t.GetLagSpeed() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LagSpeed == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) GetLagSpeed() uint32 {
	if t == nil || t.LagSpeed == nil {
		return 0
	}
	return *t.LagSpeed
}

// GetLagType retrieves the value of the leaf LagType from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LagType is set, it can
// safely use t.GetLagType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LagType == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) GetLagType() E_OpenconfigIfAggregate_AggregationType {
	if t == nil || t.LagType == 0 {
		return 0
	}
	return t.LagType
}

// GetMember retrieves the value of the leaf Member from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Member is set, it can
// safely use t.GetMember() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Member == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) GetMember() []string {
	if t == nil || t.Member == nil {
		return nil
	}
	return t.Member
}

// GetMinLinks retrieves the value of the leaf MinLinks from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinLinks is set, it can
// safely use t.GetMinLinks() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinLinks == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) GetMinLinks() uint16 {
	if t == nil || t.MinLinks == nil {
		return 0
	}
	return *t.MinLinks
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Aggregation_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) ΛBelongingModule() string {
	return "openconfig-if-aggregate"
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan represents the /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan struct {
	ΛMetadata []ygot.Annotation                                                          `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config `path:"config" module:"openconfig-vlan"`
	ΛConfig   []ygot.Annotation                                                          `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State  `path:"state" module:"openconfig-vlan"`
	ΛState    []ygot.Annotation                                                          `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) GetOrCreateConfig() *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) GetOrCreateState() *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) GetConfig() *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) GetState() *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config represents the /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config struct {
	ΛMetadata      []ygot.Annotation                                                                            `path:"@" ygotAnnotation:"true"`
	AccessVlan     *uint16                                                                                      `path:"access-vlan" module:"openconfig-vlan"`
	ΛAccessVlan    []ygot.Annotation                                                                            `path:"@access-vlan" ygotAnnotation:"true"`
	InterfaceMode  E_OpenconfigVlanTypes_VlanModeType                                                           `path:"interface-mode" module:"openconfig-vlan"`
	ΛInterfaceMode []ygot.Annotation                                                                            `path:"@interface-mode" ygotAnnotation:"true"`
	NativeVlan     *uint16                                                                                      `path:"native-vlan" module:"openconfig-vlan"`
	ΛNativeVlan    []ygot.Annotation                                                                            `path:"@native-vlan" ygotAnnotation:"true"`
	TrunkVlans     []OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union `path:"trunk-vlans" module:"openconfig-vlan"`
	ΛTrunkVlans    []ygot.Annotation                                                                            `path:"@trunk-vlans" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) IsYANGGoStruct() {}

// GetAccessVlan retrieves the value of the leaf AccessVlan from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AccessVlan is set, it can
// safely use t.GetAccessVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AccessVlan == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) GetAccessVlan() uint16 {
	if t == nil || t.AccessVlan == nil {
		return 0
	}
	return *t.AccessVlan
}

// GetInterfaceMode retrieves the value of the leaf InterfaceMode from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InterfaceMode is set, it can
// safely use t.GetInterfaceMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InterfaceMode == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) GetInterfaceMode() E_OpenconfigVlanTypes_VlanModeType {
	if t == nil || t.InterfaceMode == 0 {
		return 0
	}
	return t.InterfaceMode
}

// GetNativeVlan retrieves the value of the leaf NativeVlan from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if NativeVlan is set, it can
// safely use t.GetNativeVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.NativeVlan == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) GetNativeVlan() uint16 {
	if t == nil || t.NativeVlan == nil {
		return 0
	}
	return *t.NativeVlan
}

// GetTrunkVlans retrieves the value of the leaf TrunkVlans from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TrunkVlans is set, it can
// safely use t.GetTrunkVlans() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TrunkVlans == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) GetTrunkVlans() []OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union {
	if t == nil || t.TrunkVlans == nil {
		return nil
	}
	return t.TrunkVlans
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/config/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union() {
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union() {
}

// To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State represents the /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State struct {
	ΛMetadata      []ygot.Annotation                                                                           `path:"@" ygotAnnotation:"true"`
	AccessVlan     *uint16                                                                                     `path:"access-vlan" module:"openconfig-vlan"`
	ΛAccessVlan    []ygot.Annotation                                                                           `path:"@access-vlan" ygotAnnotation:"true"`
	InterfaceMode  E_OpenconfigVlanTypes_VlanModeType                                                          `path:"interface-mode" module:"openconfig-vlan"`
	ΛInterfaceMode []ygot.Annotation                                                                           `path:"@interface-mode" ygotAnnotation:"true"`
	NativeVlan     *uint16                                                                                     `path:"native-vlan" module:"openconfig-vlan"`
	ΛNativeVlan    []ygot.Annotation                                                                           `path:"@native-vlan" ygotAnnotation:"true"`
	TrunkVlans     []OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union `path:"trunk-vlans" module:"openconfig-vlan"`
	ΛTrunkVlans    []ygot.Annotation                                                                           `path:"@trunk-vlans" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) IsYANGGoStruct() {}

// GetAccessVlan retrieves the value of the leaf AccessVlan from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AccessVlan is set, it can
// safely use t.GetAccessVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AccessVlan == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) GetAccessVlan() uint16 {
	if t == nil || t.AccessVlan == nil {
		return 0
	}
	return *t.AccessVlan
}

// GetInterfaceMode retrieves the value of the leaf InterfaceMode from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InterfaceMode is set, it can
// safely use t.GetInterfaceMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InterfaceMode == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) GetInterfaceMode() E_OpenconfigVlanTypes_VlanModeType {
	if t == nil || t.InterfaceMode == 0 {
		return 0
	}
	return t.InterfaceMode
}

// GetNativeVlan retrieves the value of the leaf NativeVlan from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if NativeVlan is set, it can
// safely use t.GetNativeVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.NativeVlan == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) GetNativeVlan() uint16 {
	if t == nil || t.NativeVlan == nil {
		return 0
	}
	return *t.NativeVlan
}

// GetTrunkVlans retrieves the value of the leaf TrunkVlans from the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TrunkVlans is set, it can
// safely use t.GetTrunkVlans() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TrunkVlans == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) GetTrunkVlans() []OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union {
	if t == nil || t.TrunkVlans == nil {
		return nil
	}
	return t.TrunkVlans
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/state/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union() {
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union() {
}

// To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}

// OpenconfigInterfaces_Interfaces_Interface_Config represents the /openconfig-interfaces/interfaces/interface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Config struct {
	ΛMetadata     []ygot.Annotation                           `path:"@" ygotAnnotation:"true"`
	Description   *string                                     `path:"description" module:"openconfig-interfaces"`
	ΛDescription  []ygot.Annotation                           `path:"@description" ygotAnnotation:"true"`
	Enabled       *bool                                       `path:"enabled" module:"openconfig-interfaces"`
	ΛEnabled      []ygot.Annotation                           `path:"@enabled" ygotAnnotation:"true"`
	LoopbackMode  E_OpenconfigTransportTypes_LoopbackModeType `path:"loopback-mode" module:"openconfig-interfaces"`
	ΛLoopbackMode []ygot.Annotation                           `path:"@loopback-mode" ygotAnnotation:"true"`
	Mtu           *uint16                                     `path:"mtu" module:"openconfig-interfaces"`
	ΛMtu          []ygot.Annotation                           `path:"@mtu" ygotAnnotation:"true"`
	Name          *string                                     `path:"name" module:"openconfig-interfaces"`
	ΛName         []ygot.Annotation                           `path:"@name" ygotAnnotation:"true"`
	Tpid          E_OpenconfigVlanTypes_TPID_TYPES            `path:"tpid" module:"openconfig-vlan"`
	ΛTpid         []ygot.Annotation                           `path:"@tpid" ygotAnnotation:"true"`
	Type          E_IETFInterfaces_InterfaceType              `path:"type" module:"openconfig-interfaces"`
	ΛType         []ygot.Annotation                           `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Config) IsYANGGoStruct() {}

// GetDescription retrieves the value of the leaf Description from the OpenconfigInterfaces_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetEnabled retrieves the value of the leaf Enabled from the OpenconfigInterfaces_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return true
	}
	return *t.Enabled
}

// GetLoopbackMode retrieves the value of the leaf LoopbackMode from the OpenconfigInterfaces_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LoopbackMode is set, it can
// safely use t.GetLoopbackMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LoopbackMode == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) GetLoopbackMode() E_OpenconfigTransportTypes_LoopbackModeType {
	if t == nil || t.LoopbackMode == 0 {
		return OpenconfigTransportTypes_LoopbackModeType_NONE
	}
	return t.LoopbackMode
}

// GetMtu retrieves the value of the leaf Mtu from the OpenconfigInterfaces_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Mtu is set, it can
// safely use t.GetMtu() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Mtu == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) GetMtu() uint16 {
	if t == nil || t.Mtu == nil {
		return 0
	}
	return *t.Mtu
}

// GetName retrieves the value of the leaf Name from the OpenconfigInterfaces_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetTpid retrieves the value of the leaf Tpid from the OpenconfigInterfaces_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Tpid is set, it can
// safely use t.GetTpid() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Tpid == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) GetTpid() E_OpenconfigVlanTypes_TPID_TYPES {
	if t == nil || t.Tpid == 0 {
		return OpenconfigVlanTypes_TPID_TYPES_TPID_0X8100
	}
	return t.Tpid
}

// GetType retrieves the value of the leaf Type from the OpenconfigInterfaces_Interfaces_Interface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) GetType() E_IETFInterfaces_InterfaceType {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Enabled == nil {
		var v bool = true
		t.Enabled = &v
	}
	if t.LoopbackMode == 0 {
		t.LoopbackMode = OpenconfigTransportTypes_LoopbackModeType_NONE
	}
	if t.Tpid == 0 {
		t.Tpid = OpenconfigVlanTypes_TPID_TYPES_TPID_0X8100
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet represents the /openconfig-interfaces/interfaces/interface/ethernet YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet struct {
	ΛMetadata     []ygot.Annotation                                                `path:"@" ygotAnnotation:"true"`
	Config        *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config       `path:"config" module:"openconfig-if-ethernet"`
	ΛConfig       []ygot.Annotation                                                `path:"@config" ygotAnnotation:"true"`
	State         *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State        `path:"state" module:"openconfig-if-ethernet"`
	ΛState        []ygot.Annotation                                                `path:"@state" ygotAnnotation:"true"`
	SwitchedVlan  *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan `path:"switched-vlan" module:"openconfig-vlan"`
	ΛSwitchedVlan []ygot.Annotation                                                `path:"@switched-vlan" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) GetOrCreateConfig() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) GetOrCreateState() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigInterfaces_Interfaces_Interface_Ethernet_State{}
	return t.State
}

// GetOrCreateSwitchedVlan retrieves the value of the SwitchedVlan field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) GetOrCreateSwitchedVlan() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan {
	if t.SwitchedVlan != nil {
		return t.SwitchedVlan
	}
	t.SwitchedVlan = &OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan{}
	return t.SwitchedVlan
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Ethernet. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) GetConfig() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Ethernet. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) GetState() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetSwitchedVlan returns the value of the SwitchedVlan struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Ethernet. If the receiver or the field SwitchedVlan is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) GetSwitchedVlan() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan {
	if t != nil && t.SwitchedVlan != nil {
		return t.SwitchedVlan
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Ethernet
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
	t.SwitchedVlan.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config represents the /openconfig-interfaces/interfaces/interface/ethernet/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config struct {
	ΛMetadata               []ygot.Annotation                                                      `path:"@" ygotAnnotation:"true"`
	AggregateId             *string                                                                `path:"aggregate-id" module:"openconfig-if-aggregate"`
	ΛAggregateId            []ygot.Annotation                                                      `path:"@aggregate-id" ygotAnnotation:"true"`
	AutoNegotiate           *bool                                                                  `path:"auto-negotiate" module:"openconfig-if-ethernet"`
	ΛAutoNegotiate          []ygot.Annotation                                                      `path:"@auto-negotiate" ygotAnnotation:"true"`
	DuplexMode              E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode `path:"duplex-mode" module:"openconfig-if-ethernet"`
	ΛDuplexMode             []ygot.Annotation                                                      `path:"@duplex-mode" ygotAnnotation:"true"`
	EnableFlowControl       *bool                                                                  `path:"enable-flow-control" module:"openconfig-if-ethernet"`
	ΛEnableFlowControl      []ygot.Annotation                                                      `path:"@enable-flow-control" ygotAnnotation:"true"`
	FecMode                 E_OpenconfigIfEthernet_INTERFACE_FEC                                   `path:"fec-mode" module:"openconfig-if-ethernet"`
	ΛFecMode                []ygot.Annotation                                                      `path:"@fec-mode" ygotAnnotation:"true"`
	MacAddress              *string                                                                `path:"mac-address" module:"openconfig-if-ethernet"`
	ΛMacAddress             []ygot.Annotation                                                      `path:"@mac-address" ygotAnnotation:"true"`
	PortSpeed               E_OpenconfigIfEthernet_ETHERNET_SPEED                                  `path:"port-speed" module:"openconfig-if-ethernet"`
	ΛPortSpeed              []ygot.Annotation                                                      `path:"@port-speed" ygotAnnotation:"true"`
	StandaloneLinkTraining  *bool                                                                  `path:"standalone-link-training" module:"openconfig-if-ethernet"`
	ΛStandaloneLinkTraining []ygot.Annotation                                                      `path:"@standalone-link-training" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) IsYANGGoStruct() {}

// GetAggregateId retrieves the value of the leaf AggregateId from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AggregateId is set, it can
// safely use t.GetAggregateId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AggregateId == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) GetAggregateId() string {
	if t == nil || t.AggregateId == nil {
		return ""
	}
	return *t.AggregateId
}

// GetAutoNegotiate retrieves the value of the leaf AutoNegotiate from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AutoNegotiate is set, it can
// safely use t.GetAutoNegotiate() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AutoNegotiate == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) GetAutoNegotiate() bool {
	if t == nil || t.AutoNegotiate == nil {
		return true
	}
	return *t.AutoNegotiate
}

// GetDuplexMode retrieves the value of the leaf DuplexMode from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DuplexMode is set, it can
// safely use t.GetDuplexMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DuplexMode == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) GetDuplexMode() E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode {
	if t == nil || t.DuplexMode == 0 {
		return 0
	}
	return t.DuplexMode
}

// GetEnableFlowControl retrieves the value of the leaf EnableFlowControl from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EnableFlowControl is set, it can
// safely use t.GetEnableFlowControl() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EnableFlowControl == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) GetEnableFlowControl() bool {
	if t == nil || t.EnableFlowControl == nil {
		return false
	}
	return *t.EnableFlowControl
}

// GetFecMode retrieves the value of the leaf FecMode from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FecMode is set, it can
// safely use t.GetFecMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FecMode == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) GetFecMode() E_OpenconfigIfEthernet_INTERFACE_FEC {
	if t == nil || t.FecMode == 0 {
		return 0
	}
	return t.FecMode
}

// GetMacAddress retrieves the value of the leaf MacAddress from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MacAddress is set, it can
// safely use t.GetMacAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MacAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) GetMacAddress() string {
	if t == nil || t.MacAddress == nil {
		return ""
	}
	return *t.MacAddress
}

// GetPortSpeed retrieves the value of the leaf PortSpeed from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if PortSpeed is set, it can
// safely use t.GetPortSpeed() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.PortSpeed == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) GetPortSpeed() E_OpenconfigIfEthernet_ETHERNET_SPEED {
	if t == nil || t.PortSpeed == 0 {
		return 0
	}
	return t.PortSpeed
}

// GetStandaloneLinkTraining retrieves the value of the leaf StandaloneLinkTraining from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if StandaloneLinkTraining is set, it can
// safely use t.GetStandaloneLinkTraining() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.StandaloneLinkTraining == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) GetStandaloneLinkTraining() bool {
	if t == nil || t.StandaloneLinkTraining == nil {
		return false
	}
	return *t.StandaloneLinkTraining
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.AutoNegotiate == nil {
		var v bool = true
		t.AutoNegotiate = &v
	}
	if t.EnableFlowControl == nil {
		var v bool = false
		t.EnableFlowControl = &v
	}
	if t.StandaloneLinkTraining == nil {
		var v bool = false
		t.StandaloneLinkTraining = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State represents the /openconfig-interfaces/interfaces/interface/ethernet/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_State struct {
	ΛMetadata               []ygot.Annotation                                                               `path:"@" ygotAnnotation:"true"`
	AggregateId             *string                                                                         `path:"aggregate-id" module:"openconfig-if-aggregate"`
	ΛAggregateId            []ygot.Annotation                                                               `path:"@aggregate-id" ygotAnnotation:"true"`
	AutoNegotiate           *bool                                                                           `path:"auto-negotiate" module:"openconfig-if-ethernet"`
	ΛAutoNegotiate          []ygot.Annotation                                                               `path:"@auto-negotiate" ygotAnnotation:"true"`
	Counters                *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters              `path:"counters" module:"openconfig-if-ethernet"`
	ΛCounters               []ygot.Annotation                                                               `path:"@counters" ygotAnnotation:"true"`
	DuplexMode              E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode          `path:"duplex-mode" module:"openconfig-if-ethernet"`
	ΛDuplexMode             []ygot.Annotation                                                               `path:"@duplex-mode" ygotAnnotation:"true"`
	EnableFlowControl       *bool                                                                           `path:"enable-flow-control" module:"openconfig-if-ethernet"`
	ΛEnableFlowControl      []ygot.Annotation                                                               `path:"@enable-flow-control" ygotAnnotation:"true"`
	FecMode                 E_OpenconfigIfEthernet_INTERFACE_FEC                                            `path:"fec-mode" module:"openconfig-if-ethernet"`
	ΛFecMode                []ygot.Annotation                                                               `path:"@fec-mode" ygotAnnotation:"true"`
	HwMacAddress            *string                                                                         `path:"hw-mac-address" module:"openconfig-if-ethernet"`
	ΛHwMacAddress           []ygot.Annotation                                                               `path:"@hw-mac-address" ygotAnnotation:"true"`
	MacAddress              *string                                                                         `path:"mac-address" module:"openconfig-if-ethernet"`
	ΛMacAddress             []ygot.Annotation                                                               `path:"@mac-address" ygotAnnotation:"true"`
	NegotiatedDuplexMode    E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode `path:"negotiated-duplex-mode" module:"openconfig-if-ethernet"`
	ΛNegotiatedDuplexMode   []ygot.Annotation                                                               `path:"@negotiated-duplex-mode" ygotAnnotation:"true"`
	NegotiatedPortSpeed     E_OpenconfigIfEthernet_ETHERNET_SPEED                                           `path:"negotiated-port-speed" module:"openconfig-if-ethernet"`
	ΛNegotiatedPortSpeed    []ygot.Annotation                                                               `path:"@negotiated-port-speed" ygotAnnotation:"true"`
	PortSpeed               E_OpenconfigIfEthernet_ETHERNET_SPEED                                           `path:"port-speed" module:"openconfig-if-ethernet"`
	ΛPortSpeed              []ygot.Annotation                                                               `path:"@port-speed" ygotAnnotation:"true"`
	StandaloneLinkTraining  *bool                                                                           `path:"standalone-link-training" module:"openconfig-if-ethernet"`
	ΛStandaloneLinkTraining []ygot.Annotation                                                               `path:"@standalone-link-training" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) IsYANGGoStruct() {}

// GetOrCreateCounters retrieves the value of the Counters field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetOrCreateCounters() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters {
	if t.Counters != nil {
		return t.Counters
	}
	t.Counters = &OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters{}
	return t.Counters
}

// GetCounters returns the value of the Counters struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Ethernet_State. If the receiver or the field Counters is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetCounters() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters {
	if t != nil && t.Counters != nil {
		return t.Counters
	}
	return nil
}

// GetAggregateId retrieves the value of the leaf AggregateId from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AggregateId is set, it can
// safely use t.GetAggregateId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AggregateId == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetAggregateId() string {
	if t == nil || t.AggregateId == nil {
		return ""
	}
	return *t.AggregateId
}

// GetAutoNegotiate retrieves the value of the leaf AutoNegotiate from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AutoNegotiate is set, it can
// safely use t.GetAutoNegotiate() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AutoNegotiate == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetAutoNegotiate() bool {
	if t == nil || t.AutoNegotiate == nil {
		return true
	}
	return *t.AutoNegotiate
}

// GetDuplexMode retrieves the value of the leaf DuplexMode from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DuplexMode is set, it can
// safely use t.GetDuplexMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DuplexMode == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetDuplexMode() E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode {
	if t == nil || t.DuplexMode == 0 {
		return 0
	}
	return t.DuplexMode
}

// GetEnableFlowControl retrieves the value of the leaf EnableFlowControl from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EnableFlowControl is set, it can
// safely use t.GetEnableFlowControl() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EnableFlowControl == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetEnableFlowControl() bool {
	if t == nil || t.EnableFlowControl == nil {
		return false
	}
	return *t.EnableFlowControl
}

// GetFecMode retrieves the value of the leaf FecMode from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FecMode is set, it can
// safely use t.GetFecMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FecMode == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetFecMode() E_OpenconfigIfEthernet_INTERFACE_FEC {
	if t == nil || t.FecMode == 0 {
		return 0
	}
	return t.FecMode
}

// GetHwMacAddress retrieves the value of the leaf HwMacAddress from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HwMacAddress is set, it can
// safely use t.GetHwMacAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HwMacAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetHwMacAddress() string {
	if t == nil || t.HwMacAddress == nil {
		return ""
	}
	return *t.HwMacAddress
}

// GetMacAddress retrieves the value of the leaf MacAddress from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MacAddress is set, it can
// safely use t.GetMacAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MacAddress == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetMacAddress() string {
	if t == nil || t.MacAddress == nil {
		return ""
	}
	return *t.MacAddress
}

// GetNegotiatedDuplexMode retrieves the value of the leaf NegotiatedDuplexMode from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if NegotiatedDuplexMode is set, it can
// safely use t.GetNegotiatedDuplexMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.NegotiatedDuplexMode == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetNegotiatedDuplexMode() E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode {
	if t == nil || t.NegotiatedDuplexMode == 0 {
		return 0
	}
	return t.NegotiatedDuplexMode
}

// GetNegotiatedPortSpeed retrieves the value of the leaf NegotiatedPortSpeed from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if NegotiatedPortSpeed is set, it can
// safely use t.GetNegotiatedPortSpeed() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.NegotiatedPortSpeed == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetNegotiatedPortSpeed() E_OpenconfigIfEthernet_ETHERNET_SPEED {
	if t == nil || t.NegotiatedPortSpeed == 0 {
		return 0
	}
	return t.NegotiatedPortSpeed
}

// GetPortSpeed retrieves the value of the leaf PortSpeed from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if PortSpeed is set, it can
// safely use t.GetPortSpeed() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.PortSpeed == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetPortSpeed() E_OpenconfigIfEthernet_ETHERNET_SPEED {
	if t == nil || t.PortSpeed == 0 {
		return 0
	}
	return t.PortSpeed
}

// GetStandaloneLinkTraining retrieves the value of the leaf StandaloneLinkTraining from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if StandaloneLinkTraining is set, it can
// safely use t.GetStandaloneLinkTraining() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.StandaloneLinkTraining == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) GetStandaloneLinkTraining() bool {
	if t == nil || t.StandaloneLinkTraining == nil {
		return false
	}
	return *t.StandaloneLinkTraining
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.AutoNegotiate == nil {
		var v bool = true
		t.AutoNegotiate = &v
	}
	if t.EnableFlowControl == nil {
		var v bool = false
		t.EnableFlowControl = &v
	}
	if t.StandaloneLinkTraining == nil {
		var v bool = false
		t.StandaloneLinkTraining = &v
	}
	t.Counters.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters represents the /openconfig-interfaces/interfaces/interface/ethernet/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters struct {
	ΛMetadata            []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	In_8021QFrames       *uint64           `path:"in-8021q-frames" module:"openconfig-if-ethernet"`
	ΛIn_8021QFrames      []ygot.Annotation `path:"@in-8021q-frames" ygotAnnotation:"true"`
	InBlockErrors        *uint64           `path:"in-block-errors" module:"openconfig-if-ethernet"`
	ΛInBlockErrors       []ygot.Annotation `path:"@in-block-errors" ygotAnnotation:"true"`
	InCarrierErrors      *uint64           `path:"in-carrier-errors" module:"openconfig-if-ethernet"`
	ΛInCarrierErrors     []ygot.Annotation `path:"@in-carrier-errors" ygotAnnotation:"true"`
	InCrcErrors          *uint64           `path:"in-crc-errors" module:"openconfig-if-ethernet"`
	ΛInCrcErrors         []ygot.Annotation `path:"@in-crc-errors" ygotAnnotation:"true"`
	InFragmentFrames     *uint64           `path:"in-fragment-frames" module:"openconfig-if-ethernet"`
	ΛInFragmentFrames    []ygot.Annotation `path:"@in-fragment-frames" ygotAnnotation:"true"`
	InInterruptedTx      *uint64           `path:"in-interrupted-tx" module:"openconfig-if-ethernet"`
	ΛInInterruptedTx     []ygot.Annotation `path:"@in-interrupted-tx" ygotAnnotation:"true"`
	InJabberFrames       *uint64           `path:"in-jabber-frames" module:"openconfig-if-ethernet"`
	ΛInJabberFrames      []ygot.Annotation `path:"@in-jabber-frames" ygotAnnotation:"true"`
	InLateCollision      *uint64           `path:"in-late-collision" module:"openconfig-if-ethernet"`
	ΛInLateCollision     []ygot.Annotation `path:"@in-late-collision" ygotAnnotation:"true"`
	InMacControlFrames   *uint64           `path:"in-mac-control-frames" module:"openconfig-if-ethernet"`
	ΛInMacControlFrames  []ygot.Annotation `path:"@in-mac-control-frames" ygotAnnotation:"true"`
	InMacErrorsRx        *uint64           `path:"in-mac-errors-rx" module:"openconfig-if-ethernet"`
	ΛInMacErrorsRx       []ygot.Annotation `path:"@in-mac-errors-rx" ygotAnnotation:"true"`
	InMacPauseFrames     *uint64           `path:"in-mac-pause-frames" module:"openconfig-if-ethernet"`
	ΛInMacPauseFrames    []ygot.Annotation `path:"@in-mac-pause-frames" ygotAnnotation:"true"`
	InMaxsizeExceeded    *uint64           `path:"in-maxsize-exceeded" module:"openconfig-if-ethernet"`
	ΛInMaxsizeExceeded   []ygot.Annotation `path:"@in-maxsize-exceeded" ygotAnnotation:"true"`
	InOversizeFrames     *uint64           `path:"in-oversize-frames" module:"openconfig-if-ethernet"`
	ΛInOversizeFrames    []ygot.Annotation `path:"@in-oversize-frames" ygotAnnotation:"true"`
	InSingleCollision    *uint64           `path:"in-single-collision" module:"openconfig-if-ethernet"`
	ΛInSingleCollision   []ygot.Annotation `path:"@in-single-collision" ygotAnnotation:"true"`
	InSymbolError        *uint64           `path:"in-symbol-error" module:"openconfig-if-ethernet"`
	ΛInSymbolError       []ygot.Annotation `path:"@in-symbol-error" ygotAnnotation:"true"`
	InUndersizeFrames    *uint64           `path:"in-undersize-frames" module:"openconfig-if-ethernet"`
	ΛInUndersizeFrames   []ygot.Annotation `path:"@in-undersize-frames" ygotAnnotation:"true"`
	Out_8021QFrames      *uint64           `path:"out-8021q-frames" module:"openconfig-if-ethernet"`
	ΛOut_8021QFrames     []ygot.Annotation `path:"@out-8021q-frames" ygotAnnotation:"true"`
	OutMacControlFrames  *uint64           `path:"out-mac-control-frames" module:"openconfig-if-ethernet"`
	ΛOutMacControlFrames []ygot.Annotation `path:"@out-mac-control-frames" ygotAnnotation:"true"`
	OutMacErrorsTx       *uint64           `path:"out-mac-errors-tx" module:"openconfig-if-ethernet"`
	ΛOutMacErrorsTx      []ygot.Annotation `path:"@out-mac-errors-tx" ygotAnnotation:"true"`
	OutMacPauseFrames    *uint64           `path:"out-mac-pause-frames" module:"openconfig-if-ethernet"`
	ΛOutMacPauseFrames   []ygot.Annotation `path:"@out-mac-pause-frames" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) IsYANGGoStruct() {}

// GetIn_8021QFrames retrieves the value of the leaf In_8021QFrames from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if In_8021QFrames is set, it can
// safely use t.GetIn_8021QFrames() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.In_8021QFrames == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetIn_8021QFrames() uint64 {
	if t == nil || t.In_8021QFrames == nil {
		return 0
	}
	return *t.In_8021QFrames
}

// GetInBlockErrors retrieves the value of the leaf InBlockErrors from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InBlockErrors is set, it can
// safely use t.GetInBlockErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InBlockErrors == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInBlockErrors() uint64 {
	if t == nil || t.InBlockErrors == nil {
		return 0
	}
	return *t.InBlockErrors
}

// GetInCarrierErrors retrieves the value of the leaf InCarrierErrors from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InCarrierErrors is set, it can
// safely use t.GetInCarrierErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InCarrierErrors == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInCarrierErrors() uint64 {
	if t == nil || t.InCarrierErrors == nil {
		return 0
	}
	return *t.InCarrierErrors
}

// GetInCrcErrors retrieves the value of the leaf InCrcErrors from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InCrcErrors is set, it can
// safely use t.GetInCrcErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InCrcErrors == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInCrcErrors() uint64 {
	if t == nil || t.InCrcErrors == nil {
		return 0
	}
	return *t.InCrcErrors
}

// GetInFragmentFrames retrieves the value of the leaf InFragmentFrames from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InFragmentFrames is set, it can
// safely use t.GetInFragmentFrames() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InFragmentFrames == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInFragmentFrames() uint64 {
	if t == nil || t.InFragmentFrames == nil {
		return 0
	}
	return *t.InFragmentFrames
}

// GetInInterruptedTx retrieves the value of the leaf InInterruptedTx from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InInterruptedTx is set, it can
// safely use t.GetInInterruptedTx() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InInterruptedTx == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInInterruptedTx() uint64 {
	if t == nil || t.InInterruptedTx == nil {
		return 0
	}
	return *t.InInterruptedTx
}

// GetInJabberFrames retrieves the value of the leaf InJabberFrames from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InJabberFrames is set, it can
// safely use t.GetInJabberFrames() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InJabberFrames == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInJabberFrames() uint64 {
	if t == nil || t.InJabberFrames == nil {
		return 0
	}
	return *t.InJabberFrames
}

// GetInLateCollision retrieves the value of the leaf InLateCollision from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InLateCollision is set, it can
// safely use t.GetInLateCollision() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InLateCollision == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInLateCollision() uint64 {
	if t == nil || t.InLateCollision == nil {
		return 0
	}
	return *t.InLateCollision
}

// GetInMacControlFrames retrieves the value of the leaf InMacControlFrames from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InMacControlFrames is set, it can
// safely use t.GetInMacControlFrames() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InMacControlFrames == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInMacControlFrames() uint64 {
	if t == nil || t.InMacControlFrames == nil {
		return 0
	}
	return *t.InMacControlFrames
}

// GetInMacErrorsRx retrieves the value of the leaf InMacErrorsRx from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InMacErrorsRx is set, it can
// safely use t.GetInMacErrorsRx() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InMacErrorsRx == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInMacErrorsRx() uint64 {
	if t == nil || t.InMacErrorsRx == nil {
		return 0
	}
	return *t.InMacErrorsRx
}

// GetInMacPauseFrames retrieves the value of the leaf InMacPauseFrames from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InMacPauseFrames is set, it can
// safely use t.GetInMacPauseFrames() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InMacPauseFrames == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInMacPauseFrames() uint64 {
	if t == nil || t.InMacPauseFrames == nil {
		return 0
	}
	return *t.InMacPauseFrames
}

// GetInMaxsizeExceeded retrieves the value of the leaf InMaxsizeExceeded from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InMaxsizeExceeded is set, it can
// safely use t.GetInMaxsizeExceeded() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InMaxsizeExceeded == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInMaxsizeExceeded() uint64 {
	if t == nil || t.InMaxsizeExceeded == nil {
		return 0
	}
	return *t.InMaxsizeExceeded
}

// GetInOversizeFrames retrieves the value of the leaf InOversizeFrames from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InOversizeFrames is set, it can
// safely use t.GetInOversizeFrames() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InOversizeFrames == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInOversizeFrames() uint64 {
	if t == nil || t.InOversizeFrames == nil {
		return 0
	}
	return *t.InOversizeFrames
}

// GetInSingleCollision retrieves the value of the leaf InSingleCollision from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InSingleCollision is set, it can
// safely use t.GetInSingleCollision() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InSingleCollision == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInSingleCollision() uint64 {
	if t == nil || t.InSingleCollision == nil {
		return 0
	}
	return *t.InSingleCollision
}

// GetInSymbolError retrieves the value of the leaf InSymbolError from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InSymbolError is set, it can
// safely use t.GetInSymbolError() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InSymbolError == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInSymbolError() uint64 {
	if t == nil || t.InSymbolError == nil {
		return 0
	}
	return *t.InSymbolError
}

// GetInUndersizeFrames retrieves the value of the leaf InUndersizeFrames from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InUndersizeFrames is set, it can
// safely use t.GetInUndersizeFrames() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InUndersizeFrames == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetInUndersizeFrames() uint64 {
	if t == nil || t.InUndersizeFrames == nil {
		return 0
	}
	return *t.InUndersizeFrames
}

// GetOut_8021QFrames retrieves the value of the leaf Out_8021QFrames from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Out_8021QFrames is set, it can
// safely use t.GetOut_8021QFrames() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Out_8021QFrames == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetOut_8021QFrames() uint64 {
	if t == nil || t.Out_8021QFrames == nil {
		return 0
	}
	return *t.Out_8021QFrames
}

// GetOutMacControlFrames retrieves the value of the leaf OutMacControlFrames from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutMacControlFrames is set, it can
// safely use t.GetOutMacControlFrames() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutMacControlFrames == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetOutMacControlFrames() uint64 {
	if t == nil || t.OutMacControlFrames == nil {
		return 0
	}
	return *t.OutMacControlFrames
}

// GetOutMacErrorsTx retrieves the value of the leaf OutMacErrorsTx from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutMacErrorsTx is set, it can
// safely use t.GetOutMacErrorsTx() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutMacErrorsTx == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetOutMacErrorsTx() uint64 {
	if t == nil || t.OutMacErrorsTx == nil {
		return 0
	}
	return *t.OutMacErrorsTx
}

// GetOutMacPauseFrames retrieves the value of the leaf OutMacPauseFrames from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutMacPauseFrames is set, it can
// safely use t.GetOutMacPauseFrames() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutMacPauseFrames == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) GetOutMacPauseFrames() uint64 {
	if t == nil || t.OutMacPauseFrames == nil {
		return 0
	}
	return *t.OutMacPauseFrames
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan represents the /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan struct {
	ΛMetadata []ygot.Annotation                                                       `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config `path:"config" module:"openconfig-vlan"`
	ΛConfig   []ygot.Annotation                                                       `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State  `path:"state" module:"openconfig-vlan"`
	ΛState    []ygot.Annotation                                                       `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) GetOrCreateConfig() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) GetOrCreateState() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) GetConfig() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) GetState() *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config represents the /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config struct {
	ΛMetadata      []ygot.Annotation                                                                         `path:"@" ygotAnnotation:"true"`
	AccessVlan     *uint16                                                                                   `path:"access-vlan" module:"openconfig-vlan"`
	ΛAccessVlan    []ygot.Annotation                                                                         `path:"@access-vlan" ygotAnnotation:"true"`
	InterfaceMode  E_OpenconfigVlanTypes_VlanModeType                                                        `path:"interface-mode" module:"openconfig-vlan"`
	ΛInterfaceMode []ygot.Annotation                                                                         `path:"@interface-mode" ygotAnnotation:"true"`
	NativeVlan     *uint16                                                                                   `path:"native-vlan" module:"openconfig-vlan"`
	ΛNativeVlan    []ygot.Annotation                                                                         `path:"@native-vlan" ygotAnnotation:"true"`
	TrunkVlans     []OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union `path:"trunk-vlans" module:"openconfig-vlan"`
	ΛTrunkVlans    []ygot.Annotation                                                                         `path:"@trunk-vlans" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) IsYANGGoStruct() {}

// GetAccessVlan retrieves the value of the leaf AccessVlan from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AccessVlan is set, it can
// safely use t.GetAccessVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AccessVlan == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) GetAccessVlan() uint16 {
	if t == nil || t.AccessVlan == nil {
		return 0
	}
	return *t.AccessVlan
}

// GetInterfaceMode retrieves the value of the leaf InterfaceMode from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InterfaceMode is set, it can
// safely use t.GetInterfaceMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InterfaceMode == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) GetInterfaceMode() E_OpenconfigVlanTypes_VlanModeType {
	if t == nil || t.InterfaceMode == 0 {
		return 0
	}
	return t.InterfaceMode
}

// GetNativeVlan retrieves the value of the leaf NativeVlan from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if NativeVlan is set, it can
// safely use t.GetNativeVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.NativeVlan == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) GetNativeVlan() uint16 {
	if t == nil || t.NativeVlan == nil {
		return 0
	}
	return *t.NativeVlan
}

// GetTrunkVlans retrieves the value of the leaf TrunkVlans from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TrunkVlans is set, it can
// safely use t.GetTrunkVlans() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TrunkVlans == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) GetTrunkVlans() []OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union {
	if t == nil || t.TrunkVlans == nil {
		return nil
	}
	return t.TrunkVlans
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/config/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union() {
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union() {
}

// To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State represents the /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State struct {
	ΛMetadata      []ygot.Annotation                                                                        `path:"@" ygotAnnotation:"true"`
	AccessVlan     *uint16                                                                                  `path:"access-vlan" module:"openconfig-vlan"`
	ΛAccessVlan    []ygot.Annotation                                                                        `path:"@access-vlan" ygotAnnotation:"true"`
	InterfaceMode  E_OpenconfigVlanTypes_VlanModeType                                                       `path:"interface-mode" module:"openconfig-vlan"`
	ΛInterfaceMode []ygot.Annotation                                                                        `path:"@interface-mode" ygotAnnotation:"true"`
	NativeVlan     *uint16                                                                                  `path:"native-vlan" module:"openconfig-vlan"`
	ΛNativeVlan    []ygot.Annotation                                                                        `path:"@native-vlan" ygotAnnotation:"true"`
	TrunkVlans     []OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union `path:"trunk-vlans" module:"openconfig-vlan"`
	ΛTrunkVlans    []ygot.Annotation                                                                        `path:"@trunk-vlans" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) IsYANGGoStruct() {}

// GetAccessVlan retrieves the value of the leaf AccessVlan from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AccessVlan is set, it can
// safely use t.GetAccessVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AccessVlan == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) GetAccessVlan() uint16 {
	if t == nil || t.AccessVlan == nil {
		return 0
	}
	return *t.AccessVlan
}

// GetInterfaceMode retrieves the value of the leaf InterfaceMode from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InterfaceMode is set, it can
// safely use t.GetInterfaceMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InterfaceMode == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) GetInterfaceMode() E_OpenconfigVlanTypes_VlanModeType {
	if t == nil || t.InterfaceMode == 0 {
		return 0
	}
	return t.InterfaceMode
}

// GetNativeVlan retrieves the value of the leaf NativeVlan from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if NativeVlan is set, it can
// safely use t.GetNativeVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.NativeVlan == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) GetNativeVlan() uint16 {
	if t == nil || t.NativeVlan == nil {
		return 0
	}
	return *t.NativeVlan
}

// GetTrunkVlans retrieves the value of the leaf TrunkVlans from the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TrunkVlans is set, it can
// safely use t.GetTrunkVlans() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TrunkVlans == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) GetTrunkVlans() []OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union {
	if t == nil || t.TrunkVlans == nil {
		return nil
	}
	return t.TrunkVlans
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/state/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union() {
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union() {
}

// To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}

// OpenconfigInterfaces_Interfaces_Interface_HoldTime represents the /openconfig-interfaces/interfaces/interface/hold-time YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime struct {
	ΛMetadata []ygot.Annotation                                          `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config `path:"config" module:"openconfig-interfaces"`
	ΛConfig   []ygot.Annotation                                          `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State  `path:"state" module:"openconfig-interfaces"`
	ΛState    []ygot.Annotation                                          `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) GetOrCreateConfig() *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) GetOrCreateState() *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigInterfaces_Interfaces_Interface_HoldTime_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_HoldTime. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) GetConfig() *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_HoldTime. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) GetState() *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_HoldTime
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config represents the /openconfig-interfaces/interfaces/interface/hold-time/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Down      *uint32           `path:"down" module:"openconfig-interfaces"`
	ΛDown     []ygot.Annotation `path:"@down" ygotAnnotation:"true"`
	Up        *uint32           `path:"up" module:"openconfig-interfaces"`
	ΛUp       []ygot.Annotation `path:"@up" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) IsYANGGoStruct() {}

// GetDown retrieves the value of the leaf Down from the OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Down is set, it can
// safely use t.GetDown() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Down == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) GetDown() uint32 {
	if t == nil || t.Down == nil {
		return 0
	}
	return *t.Down
}

// GetUp retrieves the value of the leaf Up from the OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Up is set, it can
// safely use t.GetUp() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Up == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) GetUp() uint32 {
	if t == nil || t.Up == nil {
		return 0
	}
	return *t.Up
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Down == nil {
		var v uint32 = 0
		t.Down = &v
	}
	if t.Up == nil {
		var v uint32 = 0
		t.Up = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_HoldTime_State represents the /openconfig-interfaces/interfaces/interface/hold-time/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime_State struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Down      *uint32           `path:"down" module:"openconfig-interfaces"`
	ΛDown     []ygot.Annotation `path:"@down" ygotAnnotation:"true"`
	Up        *uint32           `path:"up" module:"openconfig-interfaces"`
	ΛUp       []ygot.Annotation `path:"@up" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) IsYANGGoStruct() {}

// GetDown retrieves the value of the leaf Down from the OpenconfigInterfaces_Interfaces_Interface_HoldTime_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Down is set, it can
// safely use t.GetDown() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Down == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) GetDown() uint32 {
	if t == nil || t.Down == nil {
		return 0
	}
	return *t.Down
}

// GetUp retrieves the value of the leaf Up from the OpenconfigInterfaces_Interfaces_Interface_HoldTime_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Up is set, it can
// safely use t.GetUp() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Up == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) GetUp() uint32 {
	if t == nil || t.Up == nil {
		return 0
	}
	return *t.Up
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_HoldTime_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Down == nil {
		var v uint32 = 0
		t.Down = &v
	}
	if t.Up == nil {
		var v uint32 = 0
		t.Up = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime_State.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied represents the /openconfig-interfaces/interfaces/interface/penalty-based-aied YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied struct {
	ΛMetadata []ygot.Annotation                                                  `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config `path:"config" module:"openconfig-interfaces"`
	ΛConfig   []ygot.Annotation                                                  `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State  `path:"state" module:"openconfig-interfaces"`
	ΛState    []ygot.Annotation                                                  `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied) GetOrCreateConfig() *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied) GetOrCreateState() *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied) GetConfig() *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied) GetState() *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied.
func (*OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config represents the /openconfig-interfaces/interfaces/interface/penalty-based-aied/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config struct {
	ΛMetadata          []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	DecayHalfLife      *uint32           `path:"decay-half-life" module:"openconfig-interfaces"`
	ΛDecayHalfLife     []ygot.Annotation `path:"@decay-half-life" ygotAnnotation:"true"`
	FlapPenalty        *uint32           `path:"flap-penalty" module:"openconfig-interfaces"`
	ΛFlapPenalty       []ygot.Annotation `path:"@flap-penalty" ygotAnnotation:"true"`
	MaxSuppressTime    *uint32           `path:"max-suppress-time" module:"openconfig-interfaces"`
	ΛMaxSuppressTime   []ygot.Annotation `path:"@max-suppress-time" ygotAnnotation:"true"`
	ReuseThreshold     *uint32           `path:"reuse-threshold" module:"openconfig-interfaces"`
	ΛReuseThreshold    []ygot.Annotation `path:"@reuse-threshold" ygotAnnotation:"true"`
	SuppressThreshold  *uint32           `path:"suppress-threshold" module:"openconfig-interfaces"`
	ΛSuppressThreshold []ygot.Annotation `path:"@suppress-threshold" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config) IsYANGGoStruct() {}

// GetDecayHalfLife retrieves the value of the leaf DecayHalfLife from the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DecayHalfLife is set, it can
// safely use t.GetDecayHalfLife() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DecayHalfLife == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config) GetDecayHalfLife() uint32 {
	if t == nil || t.DecayHalfLife == nil {
		return 0
	}
	return *t.DecayHalfLife
}

// GetFlapPenalty retrieves the value of the leaf FlapPenalty from the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FlapPenalty is set, it can
// safely use t.GetFlapPenalty() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FlapPenalty == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config) GetFlapPenalty() uint32 {
	if t == nil || t.FlapPenalty == nil {
		return 0
	}
	return *t.FlapPenalty
}

// GetMaxSuppressTime retrieves the value of the leaf MaxSuppressTime from the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxSuppressTime is set, it can
// safely use t.GetMaxSuppressTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxSuppressTime == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config) GetMaxSuppressTime() uint32 {
	if t == nil || t.MaxSuppressTime == nil {
		return 0
	}
	return *t.MaxSuppressTime
}

// GetReuseThreshold retrieves the value of the leaf ReuseThreshold from the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReuseThreshold is set, it can
// safely use t.GetReuseThreshold() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReuseThreshold == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config) GetReuseThreshold() uint32 {
	if t == nil || t.ReuseThreshold == nil {
		return 0
	}
	return *t.ReuseThreshold
}

// GetSuppressThreshold retrieves the value of the leaf SuppressThreshold from the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SuppressThreshold is set, it can
// safely use t.GetSuppressThreshold() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SuppressThreshold == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config) GetSuppressThreshold() uint32 {
	if t == nil || t.SuppressThreshold == nil {
		return 0
	}
	return *t.SuppressThreshold
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.DecayHalfLife == nil {
		var v uint32 = 0
		t.DecayHalfLife = &v
	}
	if t.FlapPenalty == nil {
		var v uint32 = 0
		t.FlapPenalty = &v
	}
	if t.MaxSuppressTime == nil {
		var v uint32 = 0
		t.MaxSuppressTime = &v
	}
	if t.ReuseThreshold == nil {
		var v uint32 = 0
		t.ReuseThreshold = &v
	}
	if t.SuppressThreshold == nil {
		var v uint32 = 0
		t.SuppressThreshold = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State represents the /openconfig-interfaces/interfaces/interface/penalty-based-aied/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State struct {
	ΛMetadata          []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	DecayHalfLife      *uint32           `path:"decay-half-life" module:"openconfig-interfaces"`
	ΛDecayHalfLife     []ygot.Annotation `path:"@decay-half-life" ygotAnnotation:"true"`
	FlapPenalty        *uint32           `path:"flap-penalty" module:"openconfig-interfaces"`
	ΛFlapPenalty       []ygot.Annotation `path:"@flap-penalty" ygotAnnotation:"true"`
	MaxSuppressTime    *uint32           `path:"max-suppress-time" module:"openconfig-interfaces"`
	ΛMaxSuppressTime   []ygot.Annotation `path:"@max-suppress-time" ygotAnnotation:"true"`
	ReuseThreshold     *uint32           `path:"reuse-threshold" module:"openconfig-interfaces"`
	ΛReuseThreshold    []ygot.Annotation `path:"@reuse-threshold" ygotAnnotation:"true"`
	SuppressThreshold  *uint32           `path:"suppress-threshold" module:"openconfig-interfaces"`
	ΛSuppressThreshold []ygot.Annotation `path:"@suppress-threshold" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State) IsYANGGoStruct() {}

// GetDecayHalfLife retrieves the value of the leaf DecayHalfLife from the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DecayHalfLife is set, it can
// safely use t.GetDecayHalfLife() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DecayHalfLife == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State) GetDecayHalfLife() uint32 {
	if t == nil || t.DecayHalfLife == nil {
		return 0
	}
	return *t.DecayHalfLife
}

// GetFlapPenalty retrieves the value of the leaf FlapPenalty from the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FlapPenalty is set, it can
// safely use t.GetFlapPenalty() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FlapPenalty == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State) GetFlapPenalty() uint32 {
	if t == nil || t.FlapPenalty == nil {
		return 0
	}
	return *t.FlapPenalty
}

// GetMaxSuppressTime retrieves the value of the leaf MaxSuppressTime from the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxSuppressTime is set, it can
// safely use t.GetMaxSuppressTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxSuppressTime == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State) GetMaxSuppressTime() uint32 {
	if t == nil || t.MaxSuppressTime == nil {
		return 0
	}
	return *t.MaxSuppressTime
}

// GetReuseThreshold retrieves the value of the leaf ReuseThreshold from the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReuseThreshold is set, it can
// safely use t.GetReuseThreshold() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReuseThreshold == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State) GetReuseThreshold() uint32 {
	if t == nil || t.ReuseThreshold == nil {
		return 0
	}
	return *t.ReuseThreshold
}

// GetSuppressThreshold retrieves the value of the leaf SuppressThreshold from the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SuppressThreshold is set, it can
// safely use t.GetSuppressThreshold() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SuppressThreshold == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State) GetSuppressThreshold() uint32 {
	if t == nil || t.SuppressThreshold == nil {
		return 0
	}
	return *t.SuppressThreshold
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.DecayHalfLife == nil {
		var v uint32 = 0
		t.DecayHalfLife = &v
	}
	if t.FlapPenalty == nil {
		var v uint32 = 0
		t.FlapPenalty = &v
	}
	if t.MaxSuppressTime == nil {
		var v uint32 = 0
		t.MaxSuppressTime = &v
	}
	if t.ReuseThreshold == nil {
		var v uint32 = 0
		t.ReuseThreshold = &v
	}
	if t.SuppressThreshold == nil {
		var v uint32 = 0
		t.SuppressThreshold = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State.
func (*OpenconfigInterfaces_Interfaces_Interface_PenaltyBasedAied_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan represents the /openconfig-interfaces/interfaces/interface/routed-vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan struct {
	ΛMetadata []ygot.Annotation                                            `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config `path:"config" module:"openconfig-vlan"`
	ΛConfig   []ygot.Annotation                                            `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State  `path:"state" module:"openconfig-vlan"`
	ΛState    []ygot.Annotation                                            `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) GetOrCreateConfig() *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) GetOrCreateState() *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_RoutedVlan. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) GetConfig() *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_RoutedVlan. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) GetState() *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config struct {
	ΛMetadata []ygot.Annotation                                                      `path:"@" ygotAnnotation:"true"`
	Vlan      OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union `path:"vlan" module:"openconfig-vlan"`
	ΛVlan     []ygot.Annotation                                                      `path:"@vlan" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) IsYANGGoStruct() {}

// GetVlan retrieves the value of the leaf Vlan from the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Vlan is set, it can
// safely use t.GetVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Vlan == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) GetVlan() OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union {
	if t == nil || t.Vlan == nil {
		return nil
	}
	return t.Vlan
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/routed-vlan/config/vlan within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union() {
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union() {
}

// To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}

// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State struct {
	ΛMetadata []ygot.Annotation                                                     `path:"@" ygotAnnotation:"true"`
	Vlan      OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union `path:"vlan" module:"openconfig-vlan"`
	ΛVlan     []ygot.Annotation                                                     `path:"@vlan" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) IsYANGGoStruct() {}

// GetVlan retrieves the value of the leaf Vlan from the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Vlan is set, it can
// safely use t.GetVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Vlan == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) GetVlan() OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union {
	if t == nil || t.Vlan == nil {
		return nil
	}
	return t.Vlan
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/routed-vlan/state/vlan within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union() {
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union() {
}

// To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}

// OpenconfigInterfaces_Interfaces_Interface_State represents the /openconfig-interfaces/interfaces/interface/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_State struct {
	ΛMetadata        []ygot.Annotation                                             `path:"@" ygotAnnotation:"true"`
	AdminStatus      E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus `path:"admin-status" module:"openconfig-interfaces"`
	ΛAdminStatus     []ygot.Annotation                                             `path:"@admin-status" ygotAnnotation:"true"`
	Counters         *OpenconfigInterfaces_Interfaces_Interface_State_Counters     `path:"counters" module:"openconfig-interfaces"`
	ΛCounters        []ygot.Annotation                                             `path:"@counters" ygotAnnotation:"true"`
	Cpu              *bool                                                         `path:"cpu" module:"openconfig-interfaces"`
	ΛCpu             []ygot.Annotation                                             `path:"@cpu" ygotAnnotation:"true"`
	Description      *string                                                       `path:"description" module:"openconfig-interfaces"`
	ΛDescription     []ygot.Annotation                                             `path:"@description" ygotAnnotation:"true"`
	Enabled          *bool                                                         `path:"enabled" module:"openconfig-interfaces"`
	ΛEnabled         []ygot.Annotation                                             `path:"@enabled" ygotAnnotation:"true"`
	HardwarePort     *string                                                       `path:"hardware-port" module:"openconfig-platform-port"`
	ΛHardwarePort    []ygot.Annotation                                             `path:"@hardware-port" ygotAnnotation:"true"`
	Ifindex          *uint32                                                       `path:"ifindex" module:"openconfig-interfaces"`
	ΛIfindex         []ygot.Annotation                                             `path:"@ifindex" ygotAnnotation:"true"`
	LastChange       *uint64                                                       `path:"last-change" module:"openconfig-interfaces"`
	ΛLastChange      []ygot.Annotation                                             `path:"@last-change" ygotAnnotation:"true"`
	Logical          *bool                                                         `path:"logical" module:"openconfig-interfaces"`
	ΛLogical         []ygot.Annotation                                             `path:"@logical" ygotAnnotation:"true"`
	LoopbackMode     E_OpenconfigTransportTypes_LoopbackModeType                   `path:"loopback-mode" module:"openconfig-interfaces"`
	ΛLoopbackMode    []ygot.Annotation                                             `path:"@loopback-mode" ygotAnnotation:"true"`
	Management       *bool                                                         `path:"management" module:"openconfig-interfaces"`
	ΛManagement      []ygot.Annotation                                             `path:"@management" ygotAnnotation:"true"`
	Mtu              *uint16                                                       `path:"mtu" module:"openconfig-interfaces"`
	ΛMtu             []ygot.Annotation                                             `path:"@mtu" ygotAnnotation:"true"`
	Name             *string                                                       `path:"name" module:"openconfig-interfaces"`
	ΛName            []ygot.Annotation                                             `path:"@name" ygotAnnotation:"true"`
	OperStatus       E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus  `path:"oper-status" module:"openconfig-interfaces"`
	ΛOperStatus      []ygot.Annotation                                             `path:"@oper-status" ygotAnnotation:"true"`
	PhysicalChannel  []uint16                                                      `path:"physical-channel" module:"openconfig-platform-transceiver"`
	ΛPhysicalChannel []ygot.Annotation                                             `path:"@physical-channel" ygotAnnotation:"true"`
	Tpid             E_OpenconfigVlanTypes_TPID_TYPES                              `path:"tpid" module:"openconfig-vlan"`
	ΛTpid            []ygot.Annotation                                             `path:"@tpid" ygotAnnotation:"true"`
	Transceiver      *string                                                       `path:"transceiver" module:"openconfig-platform-transceiver"`
	ΛTransceiver     []ygot.Annotation                                             `path:"@transceiver" ygotAnnotation:"true"`
	Type             E_IETFInterfaces_InterfaceType                                `path:"type" module:"openconfig-interfaces"`
	ΛType            []ygot.Annotation                                             `path:"@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_State) IsYANGGoStruct() {}

// GetOrCreateCounters retrieves the value of the Counters field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetOrCreateCounters() *OpenconfigInterfaces_Interfaces_Interface_State_Counters {
	if t.Counters != nil {
		return t.Counters
	}
	t.Counters = &OpenconfigInterfaces_Interfaces_Interface_State_Counters{}
	return t.Counters
}

// GetCounters returns the value of the Counters struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_State. If the receiver or the field Counters is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetCounters() *OpenconfigInterfaces_Interfaces_Interface_State_Counters {
	if t != nil && t.Counters != nil {
		return t.Counters
	}
	return nil
}

// GetAdminStatus retrieves the value of the leaf AdminStatus from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AdminStatus is set, it can
// safely use t.GetAdminStatus() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AdminStatus == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetAdminStatus() E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus {
	if t == nil || t.AdminStatus == 0 {
		return 0
	}
	return t.AdminStatus
}

// GetCpu retrieves the value of the leaf Cpu from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Cpu is set, it can
// safely use t.GetCpu() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Cpu == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetCpu() bool {
	if t == nil || t.Cpu == nil {
		return false
	}
	return *t.Cpu
}

// GetDescription retrieves the value of the leaf Description from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetEnabled retrieves the value of the leaf Enabled from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return true
	}
	return *t.Enabled
}

// GetHardwarePort retrieves the value of the leaf HardwarePort from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HardwarePort is set, it can
// safely use t.GetHardwarePort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HardwarePort == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetHardwarePort() string {
	if t == nil || t.HardwarePort == nil {
		return ""
	}
	return *t.HardwarePort
}

// GetIfindex retrieves the value of the leaf Ifindex from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Ifindex is set, it can
// safely use t.GetIfindex() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Ifindex == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetIfindex() uint32 {
	if t == nil || t.Ifindex == nil {
		return 0
	}
	return *t.Ifindex
}

// GetLastChange retrieves the value of the leaf LastChange from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastChange is set, it can
// safely use t.GetLastChange() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastChange == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetLastChange() uint64 {
	if t == nil || t.LastChange == nil {
		return 0
	}
	return *t.LastChange
}

// GetLogical retrieves the value of the leaf Logical from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Logical is set, it can
// safely use t.GetLogical() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Logical == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetLogical() bool {
	if t == nil || t.Logical == nil {
		return false
	}
	return *t.Logical
}

// GetLoopbackMode retrieves the value of the leaf LoopbackMode from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LoopbackMode is set, it can
// safely use t.GetLoopbackMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LoopbackMode == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetLoopbackMode() E_OpenconfigTransportTypes_LoopbackModeType {
	if t == nil || t.LoopbackMode == 0 {
		return OpenconfigTransportTypes_LoopbackModeType_NONE
	}
	return t.LoopbackMode
}

// GetManagement retrieves the value of the leaf Management from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Management is set, it can
// safely use t.GetManagement() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Management == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetManagement() bool {
	if t == nil || t.Management == nil {
		return false
	}
	return *t.Management
}

// GetMtu retrieves the value of the leaf Mtu from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Mtu is set, it can
// safely use t.GetMtu() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Mtu == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetMtu() uint16 {
	if t == nil || t.Mtu == nil {
		return 0
	}
	return *t.Mtu
}

// GetName retrieves the value of the leaf Name from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetOperStatus retrieves the value of the leaf OperStatus from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OperStatus is set, it can
// safely use t.GetOperStatus() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OperStatus == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetOperStatus() E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus {
	if t == nil || t.OperStatus == 0 {
		return 0
	}
	return t.OperStatus
}

// GetPhysicalChannel retrieves the value of the leaf PhysicalChannel from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if PhysicalChannel is set, it can
// safely use t.GetPhysicalChannel() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.PhysicalChannel == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetPhysicalChannel() []uint16 {
	if t == nil || t.PhysicalChannel == nil {
		return nil
	}
	return t.PhysicalChannel
}

// GetTpid retrieves the value of the leaf Tpid from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Tpid is set, it can
// safely use t.GetTpid() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Tpid == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetTpid() E_OpenconfigVlanTypes_TPID_TYPES {
	if t == nil || t.Tpid == 0 {
		return OpenconfigVlanTypes_TPID_TYPES_TPID_0X8100
	}
	return t.Tpid
}

// GetTransceiver retrieves the value of the leaf Transceiver from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Transceiver is set, it can
// safely use t.GetTransceiver() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Transceiver == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetTransceiver() string {
	if t == nil || t.Transceiver == nil {
		return ""
	}
	return *t.Transceiver
}

// GetType retrieves the value of the leaf Type from the OpenconfigInterfaces_Interfaces_Interface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) GetType() E_IETFInterfaces_InterfaceType {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Enabled == nil {
		var v bool = true
		t.Enabled = &v
	}
	if t.LoopbackMode == 0 {
		t.LoopbackMode = OpenconfigTransportTypes_LoopbackModeType_NONE
	}
	if t.Tpid == 0 {
		t.Tpid = OpenconfigVlanTypes_TPID_TYPES_TPID_0X8100
	}
	t.Counters.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_State.
func (*OpenconfigInterfaces_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_State_Counters represents the /openconfig-interfaces/interfaces/interface/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_State_Counters struct {
	ΛMetadata           []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	CarrierTransitions  *uint64           `path:"carrier-transitions" module:"openconfig-interfaces"`
	ΛCarrierTransitions []ygot.Annotation `path:"@carrier-transitions" ygotAnnotation:"true"`
	InBroadcastPkts     *uint64           `path:"in-broadcast-pkts" module:"openconfig-interfaces"`
	ΛInBroadcastPkts    []ygot.Annotation `path:"@in-broadcast-pkts" ygotAnnotation:"true"`
	InDiscards          *uint64           `path:"in-discards" module:"openconfig-interfaces"`
	ΛInDiscards         []ygot.Annotation `path:"@in-discards" ygotAnnotation:"true"`
	InErrors            *uint64           `path:"in-errors" module:"openconfig-interfaces"`
	ΛInErrors           []ygot.Annotation `path:"@in-errors" ygotAnnotation:"true"`
	InFcsErrors         *uint64           `path:"in-fcs-errors" module:"openconfig-interfaces"`
	ΛInFcsErrors        []ygot.Annotation `path:"@in-fcs-errors" ygotAnnotation:"true"`
	InMulticastPkts     *uint64           `path:"in-multicast-pkts" module:"openconfig-interfaces"`
	ΛInMulticastPkts    []ygot.Annotation `path:"@in-multicast-pkts" ygotAnnotation:"true"`
	InOctets            *uint64           `path:"in-octets" module:"openconfig-interfaces"`
	ΛInOctets           []ygot.Annotation `path:"@in-octets" ygotAnnotation:"true"`
	InPkts              *uint64           `path:"in-pkts" module:"openconfig-interfaces"`
	ΛInPkts             []ygot.Annotation `path:"@in-pkts" ygotAnnotation:"true"`
	InUnicastPkts       *uint64           `path:"in-unicast-pkts" module:"openconfig-interfaces"`
	ΛInUnicastPkts      []ygot.Annotation `path:"@in-unicast-pkts" ygotAnnotation:"true"`
	InUnknownProtos     *uint64           `path:"in-unknown-protos" module:"openconfig-interfaces"`
	ΛInUnknownProtos    []ygot.Annotation `path:"@in-unknown-protos" ygotAnnotation:"true"`
	LastClear           *uint64           `path:"last-clear" module:"openconfig-interfaces"`
	ΛLastClear          []ygot.Annotation `path:"@last-clear" ygotAnnotation:"true"`
	OutBroadcastPkts    *uint64           `path:"out-broadcast-pkts" module:"openconfig-interfaces"`
	ΛOutBroadcastPkts   []ygot.Annotation `path:"@out-broadcast-pkts" ygotAnnotation:"true"`
	OutDiscards         *uint64           `path:"out-discards" module:"openconfig-interfaces"`
	ΛOutDiscards        []ygot.Annotation `path:"@out-discards" ygotAnnotation:"true"`
	OutErrors           *uint64           `path:"out-errors" module:"openconfig-interfaces"`
	ΛOutErrors          []ygot.Annotation `path:"@out-errors" ygotAnnotation:"true"`
	OutMulticastPkts    *uint64           `path:"out-multicast-pkts" module:"openconfig-interfaces"`
	ΛOutMulticastPkts   []ygot.Annotation `path:"@out-multicast-pkts" ygotAnnotation:"true"`
	OutOctets           *uint64           `path:"out-octets" module:"openconfig-interfaces"`
	ΛOutOctets          []ygot.Annotation `path:"@out-octets" ygotAnnotation:"true"`
	OutPkts             *uint64           `path:"out-pkts" module:"openconfig-interfaces"`
	ΛOutPkts            []ygot.Annotation `path:"@out-pkts" ygotAnnotation:"true"`
	OutUnicastPkts      *uint64           `path:"out-unicast-pkts" module:"openconfig-interfaces"`
	ΛOutUnicastPkts     []ygot.Annotation `path:"@out-unicast-pkts" ygotAnnotation:"true"`
	Resets              *uint64           `path:"resets" module:"openconfig-interfaces"`
	ΛResets             []ygot.Annotation `path:"@resets" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_State_Counters) IsYANGGoStruct() {}

// GetCarrierTransitions retrieves the value of the leaf CarrierTransitions from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if CarrierTransitions is set, it can
// safely use t.GetCarrierTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.CarrierTransitions == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetCarrierTransitions() uint64 {
	if t == nil || t.CarrierTransitions == nil {
		return 0
	}
	return *t.CarrierTransitions
}

// GetInBroadcastPkts retrieves the value of the leaf InBroadcastPkts from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InBroadcastPkts is set, it can
// safely use t.GetInBroadcastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InBroadcastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetInBroadcastPkts() uint64 {
	if t == nil || t.InBroadcastPkts == nil {
		return 0
	}
	return *t.InBroadcastPkts
}

// GetInDiscards retrieves the value of the leaf InDiscards from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InDiscards is set, it can
// safely use t.GetInDiscards() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InDiscards == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetInDiscards() uint64 {
	if t == nil || t.InDiscards == nil {
		return 0
	}
	return *t.InDiscards
}

// GetInErrors retrieves the value of the leaf InErrors from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InErrors is set, it can
// safely use t.GetInErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InErrors == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetInErrors() uint64 {
	if t == nil || t.InErrors == nil {
		return 0
	}
	return *t.InErrors
}

// GetInFcsErrors retrieves the value of the leaf InFcsErrors from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InFcsErrors is set, it can
// safely use t.GetInFcsErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InFcsErrors == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetInFcsErrors() uint64 {
	if t == nil || t.InFcsErrors == nil {
		return 0
	}
	return *t.InFcsErrors
}

// GetInMulticastPkts retrieves the value of the leaf InMulticastPkts from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InMulticastPkts is set, it can
// safely use t.GetInMulticastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InMulticastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetInMulticastPkts() uint64 {
	if t == nil || t.InMulticastPkts == nil {
		return 0
	}
	return *t.InMulticastPkts
}

// GetInOctets retrieves the value of the leaf InOctets from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InOctets is set, it can
// safely use t.GetInOctets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InOctets == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetInOctets() uint64 {
	if t == nil || t.InOctets == nil {
		return 0
	}
	return *t.InOctets
}

// GetInPkts retrieves the value of the leaf InPkts from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InPkts is set, it can
// safely use t.GetInPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetInPkts() uint64 {
	if t == nil || t.InPkts == nil {
		return 0
	}
	return *t.InPkts
}

// GetInUnicastPkts retrieves the value of the leaf InUnicastPkts from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InUnicastPkts is set, it can
// safely use t.GetInUnicastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InUnicastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetInUnicastPkts() uint64 {
	if t == nil || t.InUnicastPkts == nil {
		return 0
	}
	return *t.InUnicastPkts
}

// GetInUnknownProtos retrieves the value of the leaf InUnknownProtos from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InUnknownProtos is set, it can
// safely use t.GetInUnknownProtos() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InUnknownProtos == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetInUnknownProtos() uint64 {
	if t == nil || t.InUnknownProtos == nil {
		return 0
	}
	return *t.InUnknownProtos
}

// GetLastClear retrieves the value of the leaf LastClear from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastClear is set, it can
// safely use t.GetLastClear() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastClear == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetLastClear() uint64 {
	if t == nil || t.LastClear == nil {
		return 0
	}
	return *t.LastClear
}

// GetOutBroadcastPkts retrieves the value of the leaf OutBroadcastPkts from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutBroadcastPkts is set, it can
// safely use t.GetOutBroadcastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutBroadcastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetOutBroadcastPkts() uint64 {
	if t == nil || t.OutBroadcastPkts == nil {
		return 0
	}
	return *t.OutBroadcastPkts
}

// GetOutDiscards retrieves the value of the leaf OutDiscards from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutDiscards is set, it can
// safely use t.GetOutDiscards() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutDiscards == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetOutDiscards() uint64 {
	if t == nil || t.OutDiscards == nil {
		return 0
	}
	return *t.OutDiscards
}

// GetOutErrors retrieves the value of the leaf OutErrors from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutErrors is set, it can
// safely use t.GetOutErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutErrors == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetOutErrors() uint64 {
	if t == nil || t.OutErrors == nil {
		return 0
	}
	return *t.OutErrors
}

// GetOutMulticastPkts retrieves the value of the leaf OutMulticastPkts from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutMulticastPkts is set, it can
// safely use t.GetOutMulticastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutMulticastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetOutMulticastPkts() uint64 {
	if t == nil || t.OutMulticastPkts == nil {
		return 0
	}
	return *t.OutMulticastPkts
}

// GetOutOctets retrieves the value of the leaf OutOctets from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutOctets is set, it can
// safely use t.GetOutOctets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutOctets == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetOutOctets() uint64 {
	if t == nil || t.OutOctets == nil {
		return 0
	}
	return *t.OutOctets
}

// GetOutPkts retrieves the value of the leaf OutPkts from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutPkts is set, it can
// safely use t.GetOutPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetOutPkts() uint64 {
	if t == nil || t.OutPkts == nil {
		return 0
	}
	return *t.OutPkts
}

// GetOutUnicastPkts retrieves the value of the leaf OutUnicastPkts from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutUnicastPkts is set, it can
// safely use t.GetOutUnicastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutUnicastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetOutUnicastPkts() uint64 {
	if t == nil || t.OutUnicastPkts == nil {
		return 0
	}
	return *t.OutUnicastPkts
}

// GetResets retrieves the value of the leaf Resets from the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Resets is set, it can
// safely use t.GetResets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Resets == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) GetResets() uint64 {
	if t == nil || t.Resets == nil {
		return 0
	}
	return *t.Resets
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_State_Counters
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces represents the /openconfig-interfaces/interfaces/interface/subinterfaces YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces struct {
	ΛMetadata     []ygot.Annotation                                                                `path:"@" ygotAnnotation:"true"`
	Subinterface  map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface `path:"subinterface" module:"openconfig-interfaces"`
	ΛSubinterface []ygot.Annotation                                                                `path:"@subinterface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) IsYANGGoStruct() {}

// NewSubinterface creates a new entry in the Subinterface list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) NewSubinterface(Index uint32) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subinterface == nil {
		t.Subinterface = make(map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Subinterface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Subinterface", key)
	}

	t.Subinterface[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface{
		Index: &Index,
	}

	return t.Subinterface[key], nil
}

// RenameSubinterface renames an entry in the list Subinterface within
// the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) RenameSubinterface(oldK, newK uint32) error {
	if _, ok := t.Subinterface[newK]; ok {
		return fmt.Errorf("key %v already exists in Subinterface", newK)
	}

	e, ok := t.Subinterface[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Subinterface", oldK)
	}
	e.Index = &newK

	t.Subinterface[newK] = e
	delete(t.Subinterface, oldK)
	return nil
}

// GetOrCreateSubinterfaceMap returns the list (map) from OpenconfigInterfaces_Interfaces_Interface_Subinterfaces.
//
// It initializes the field if not already initialized.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) GetOrCreateSubinterfaceMap() map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface {
	if t.Subinterface == nil {
		t.Subinterface = make(map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface)
	}
	return t.Subinterface
}

// GetOrCreateSubinterface retrieves the value with the specified keys from
// the receiver OpenconfigInterfaces_Interfaces_Interface_Subinterfaces. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) GetOrCreateSubinterface(Index uint32) *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface {

	key := Index

	if v, ok := t.Subinterface[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewSubinterface(Index)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateSubinterface got unexpected error: %v", err))
	}
	return v
}

// GetSubinterface retrieves the value with the specified key from
// the Subinterface map field of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) GetSubinterface(Index uint32) *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface {

	if t == nil {
		return nil
	}

	key := Index

	if lm, ok := t.Subinterface[key]; ok {
		return lm
	}
	return nil
}

// AppendSubinterface appends the supplied OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface struct to the
// list Subinterface of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces. If the key value(s) specified in
// the supplied OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface already exist in the list, an error is
// returned.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) AppendSubinterface(v *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) error {
	if v.Index == nil {
		return fmt.Errorf("invalid nil key received for Index")
	}

	key := *v.Index

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subinterface == nil {
		t.Subinterface = make(map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface)
	}

	if _, ok := t.Subinterface[key]; ok {
		return fmt.Errorf("duplicate key for list Subinterface %v", key)
	}

	t.Subinterface[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.Subinterface {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface struct {
	ΛMetadata []ygot.Annotation                                                            `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config `path:"config" module:"openconfig-interfaces"`
	ΛConfig   []ygot.Annotation                                                            `path:"@config" ygotAnnotation:"true"`
	Index     *uint32                                                                      `path:"index" module:"openconfig-interfaces"`
	ΛIndex    []ygot.Annotation                                                            `path:"@index" ygotAnnotation:"true"`
	State     *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State  `path:"state" module:"openconfig-interfaces"`
	ΛState    []ygot.Annotation                                                            `path:"@state" ygotAnnotation:"true"`
	Vlan      *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan   `path:"vlan" module:"openconfig-vlan"`
	ΛVlan     []ygot.Annotation                                                            `path:"@vlan" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) GetOrCreateConfig() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) GetOrCreateState() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State{}
	return t.State
}

// GetOrCreateVlan retrieves the value of the Vlan field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) GetOrCreateVlan() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan {
	if t.Vlan != nil {
		return t.Vlan
	}
	t.Vlan = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan{}
	return t.Vlan
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) GetConfig() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) GetState() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetVlan returns the value of the Vlan struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface. If the receiver or the field Vlan is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) GetVlan() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan {
	if t != nil && t.Vlan != nil {
		return t.Vlan
	}
	return nil
}

// GetIndex retrieves the value of the leaf Index from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Index is set, it can
// safely use t.GetIndex() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Index == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) GetIndex() uint32 {
	if t == nil || t.Index == nil {
		return 0
	}
	return *t.Index
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
	t.Vlan.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config struct {
	ΛMetadata    []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Description  *string           `path:"description" module:"openconfig-interfaces"`
	ΛDescription []ygot.Annotation `path:"@description" ygotAnnotation:"true"`
	Enabled      *bool             `path:"enabled" module:"openconfig-interfaces"`
	ΛEnabled     []ygot.Annotation `path:"@enabled" ygotAnnotation:"true"`
	Index        *uint32           `path:"index" module:"openconfig-interfaces"`
	ΛIndex       []ygot.Annotation `path:"@index" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) IsYANGGoStruct() {
}

// GetDescription retrieves the value of the leaf Description from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetEnabled retrieves the value of the leaf Enabled from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return true
	}
	return *t.Enabled
}

// GetIndex retrieves the value of the leaf Index from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Index is set, it can
// safely use t.GetIndex() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Index == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) GetIndex() uint32 {
	if t == nil || t.Index == nil {
		return 0
	}
	return *t.Index
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Enabled == nil {
		var v bool = true
		t.Enabled = &v
	}
	if t.Index == nil {
		var v uint32 = 0
		t.Index = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State struct {
	ΛMetadata    []ygot.Annotation                                                                    `path:"@" ygotAnnotation:"true"`
	AdminStatus  E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus                        `path:"admin-status" module:"openconfig-interfaces"`
	ΛAdminStatus []ygot.Annotation                                                                    `path:"@admin-status" ygotAnnotation:"true"`
	Counters     *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters `path:"counters" module:"openconfig-interfaces"`
	ΛCounters    []ygot.Annotation                                                                    `path:"@counters" ygotAnnotation:"true"`
	Cpu          *bool                                                                                `path:"cpu" module:"openconfig-interfaces"`
	ΛCpu         []ygot.Annotation                                                                    `path:"@cpu" ygotAnnotation:"true"`
	Description  *string                                                                              `path:"description" module:"openconfig-interfaces"`
	ΛDescription []ygot.Annotation                                                                    `path:"@description" ygotAnnotation:"true"`
	Enabled      *bool                                                                                `path:"enabled" module:"openconfig-interfaces"`
	ΛEnabled     []ygot.Annotation                                                                    `path:"@enabled" ygotAnnotation:"true"`
	Ifindex      *uint32                                                                              `path:"ifindex" module:"openconfig-interfaces"`
	ΛIfindex     []ygot.Annotation                                                                    `path:"@ifindex" ygotAnnotation:"true"`
	Index        *uint32                                                                              `path:"index" module:"openconfig-interfaces"`
	ΛIndex       []ygot.Annotation                                                                    `path:"@index" ygotAnnotation:"true"`
	LastChange   *uint64                                                                              `path:"last-change" module:"openconfig-interfaces"`
	ΛLastChange  []ygot.Annotation                                                                    `path:"@last-change" ygotAnnotation:"true"`
	Logical      *bool                                                                                `path:"logical" module:"openconfig-interfaces"`
	ΛLogical     []ygot.Annotation                                                                    `path:"@logical" ygotAnnotation:"true"`
	Management   *bool                                                                                `path:"management" module:"openconfig-interfaces"`
	ΛManagement  []ygot.Annotation                                                                    `path:"@management" ygotAnnotation:"true"`
	Name         *string                                                                              `path:"name" module:"openconfig-interfaces"`
	ΛName        []ygot.Annotation                                                                    `path:"@name" ygotAnnotation:"true"`
	OperStatus   E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus                         `path:"oper-status" module:"openconfig-interfaces"`
	ΛOperStatus  []ygot.Annotation                                                                    `path:"@oper-status" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) IsYANGGoStruct() {}

// GetOrCreateCounters retrieves the value of the Counters field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetOrCreateCounters() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters {
	if t.Counters != nil {
		return t.Counters
	}
	t.Counters = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters{}
	return t.Counters
}

// GetCounters returns the value of the Counters struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State. If the receiver or the field Counters is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetCounters() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters {
	if t != nil && t.Counters != nil {
		return t.Counters
	}
	return nil
}

// GetAdminStatus retrieves the value of the leaf AdminStatus from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AdminStatus is set, it can
// safely use t.GetAdminStatus() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AdminStatus == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetAdminStatus() E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus {
	if t == nil || t.AdminStatus == 0 {
		return 0
	}
	return t.AdminStatus
}

// GetCpu retrieves the value of the leaf Cpu from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Cpu is set, it can
// safely use t.GetCpu() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Cpu == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetCpu() bool {
	if t == nil || t.Cpu == nil {
		return false
	}
	return *t.Cpu
}

// GetDescription retrieves the value of the leaf Description from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetEnabled retrieves the value of the leaf Enabled from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return true
	}
	return *t.Enabled
}

// GetIfindex retrieves the value of the leaf Ifindex from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Ifindex is set, it can
// safely use t.GetIfindex() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Ifindex == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetIfindex() uint32 {
	if t == nil || t.Ifindex == nil {
		return 0
	}
	return *t.Ifindex
}

// GetIndex retrieves the value of the leaf Index from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Index is set, it can
// safely use t.GetIndex() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Index == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetIndex() uint32 {
	if t == nil || t.Index == nil {
		return 0
	}
	return *t.Index
}

// GetLastChange retrieves the value of the leaf LastChange from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastChange is set, it can
// safely use t.GetLastChange() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastChange == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetLastChange() uint64 {
	if t == nil || t.LastChange == nil {
		return 0
	}
	return *t.LastChange
}

// GetLogical retrieves the value of the leaf Logical from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Logical is set, it can
// safely use t.GetLogical() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Logical == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetLogical() bool {
	if t == nil || t.Logical == nil {
		return false
	}
	return *t.Logical
}

// GetManagement retrieves the value of the leaf Management from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Management is set, it can
// safely use t.GetManagement() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Management == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetManagement() bool {
	if t == nil || t.Management == nil {
		return false
	}
	return *t.Management
}

// GetName retrieves the value of the leaf Name from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetOperStatus retrieves the value of the leaf OperStatus from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OperStatus is set, it can
// safely use t.GetOperStatus() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OperStatus == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) GetOperStatus() E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus {
	if t == nil || t.OperStatus == 0 {
		return 0
	}
	return t.OperStatus
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Enabled == nil {
		var v bool = true
		t.Enabled = &v
	}
	if t.Index == nil {
		var v uint32 = 0
		t.Index = &v
	}
	t.Counters.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters struct {
	ΛMetadata           []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	CarrierTransitions  *uint64           `path:"carrier-transitions" module:"openconfig-interfaces"`
	ΛCarrierTransitions []ygot.Annotation `path:"@carrier-transitions" ygotAnnotation:"true"`
	InBroadcastPkts     *uint64           `path:"in-broadcast-pkts" module:"openconfig-interfaces"`
	ΛInBroadcastPkts    []ygot.Annotation `path:"@in-broadcast-pkts" ygotAnnotation:"true"`
	InDiscards          *uint64           `path:"in-discards" module:"openconfig-interfaces"`
	ΛInDiscards         []ygot.Annotation `path:"@in-discards" ygotAnnotation:"true"`
	InErrors            *uint64           `path:"in-errors" module:"openconfig-interfaces"`
	ΛInErrors           []ygot.Annotation `path:"@in-errors" ygotAnnotation:"true"`
	InFcsErrors         *uint64           `path:"in-fcs-errors" module:"openconfig-interfaces"`
	ΛInFcsErrors        []ygot.Annotation `path:"@in-fcs-errors" ygotAnnotation:"true"`
	InMulticastPkts     *uint64           `path:"in-multicast-pkts" module:"openconfig-interfaces"`
	ΛInMulticastPkts    []ygot.Annotation `path:"@in-multicast-pkts" ygotAnnotation:"true"`
	InOctets            *uint64           `path:"in-octets" module:"openconfig-interfaces"`
	ΛInOctets           []ygot.Annotation `path:"@in-octets" ygotAnnotation:"true"`
	InPkts              *uint64           `path:"in-pkts" module:"openconfig-interfaces"`
	ΛInPkts             []ygot.Annotation `path:"@in-pkts" ygotAnnotation:"true"`
	InUnicastPkts       *uint64           `path:"in-unicast-pkts" module:"openconfig-interfaces"`
	ΛInUnicastPkts      []ygot.Annotation `path:"@in-unicast-pkts" ygotAnnotation:"true"`
	InUnknownProtos     *uint64           `path:"in-unknown-protos" module:"openconfig-interfaces"`
	ΛInUnknownProtos    []ygot.Annotation `path:"@in-unknown-protos" ygotAnnotation:"true"`
	LastClear           *uint64           `path:"last-clear" module:"openconfig-interfaces"`
	ΛLastClear          []ygot.Annotation `path:"@last-clear" ygotAnnotation:"true"`
	OutBroadcastPkts    *uint64           `path:"out-broadcast-pkts" module:"openconfig-interfaces"`
	ΛOutBroadcastPkts   []ygot.Annotation `path:"@out-broadcast-pkts" ygotAnnotation:"true"`
	OutDiscards         *uint64           `path:"out-discards" module:"openconfig-interfaces"`
	ΛOutDiscards        []ygot.Annotation `path:"@out-discards" ygotAnnotation:"true"`
	OutErrors           *uint64           `path:"out-errors" module:"openconfig-interfaces"`
	ΛOutErrors          []ygot.Annotation `path:"@out-errors" ygotAnnotation:"true"`
	OutMulticastPkts    *uint64           `path:"out-multicast-pkts" module:"openconfig-interfaces"`
	ΛOutMulticastPkts   []ygot.Annotation `path:"@out-multicast-pkts" ygotAnnotation:"true"`
	OutOctets           *uint64           `path:"out-octets" module:"openconfig-interfaces"`
	ΛOutOctets          []ygot.Annotation `path:"@out-octets" ygotAnnotation:"true"`
	OutPkts             *uint64           `path:"out-pkts" module:"openconfig-interfaces"`
	ΛOutPkts            []ygot.Annotation `path:"@out-pkts" ygotAnnotation:"true"`
	OutUnicastPkts      *uint64           `path:"out-unicast-pkts" module:"openconfig-interfaces"`
	ΛOutUnicastPkts     []ygot.Annotation `path:"@out-unicast-pkts" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) IsYANGGoStruct() {
}

// GetCarrierTransitions retrieves the value of the leaf CarrierTransitions from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if CarrierTransitions is set, it can
// safely use t.GetCarrierTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.CarrierTransitions == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetCarrierTransitions() uint64 {
	if t == nil || t.CarrierTransitions == nil {
		return 0
	}
	return *t.CarrierTransitions
}

// GetInBroadcastPkts retrieves the value of the leaf InBroadcastPkts from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InBroadcastPkts is set, it can
// safely use t.GetInBroadcastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InBroadcastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetInBroadcastPkts() uint64 {
	if t == nil || t.InBroadcastPkts == nil {
		return 0
	}
	return *t.InBroadcastPkts
}

// GetInDiscards retrieves the value of the leaf InDiscards from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InDiscards is set, it can
// safely use t.GetInDiscards() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InDiscards == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetInDiscards() uint64 {
	if t == nil || t.InDiscards == nil {
		return 0
	}
	return *t.InDiscards
}

// GetInErrors retrieves the value of the leaf InErrors from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InErrors is set, it can
// safely use t.GetInErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InErrors == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetInErrors() uint64 {
	if t == nil || t.InErrors == nil {
		return 0
	}
	return *t.InErrors
}

// GetInFcsErrors retrieves the value of the leaf InFcsErrors from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InFcsErrors is set, it can
// safely use t.GetInFcsErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InFcsErrors == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetInFcsErrors() uint64 {
	if t == nil || t.InFcsErrors == nil {
		return 0
	}
	return *t.InFcsErrors
}

// GetInMulticastPkts retrieves the value of the leaf InMulticastPkts from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InMulticastPkts is set, it can
// safely use t.GetInMulticastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InMulticastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetInMulticastPkts() uint64 {
	if t == nil || t.InMulticastPkts == nil {
		return 0
	}
	return *t.InMulticastPkts
}

// GetInOctets retrieves the value of the leaf InOctets from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InOctets is set, it can
// safely use t.GetInOctets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InOctets == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetInOctets() uint64 {
	if t == nil || t.InOctets == nil {
		return 0
	}
	return *t.InOctets
}

// GetInPkts retrieves the value of the leaf InPkts from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InPkts is set, it can
// safely use t.GetInPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetInPkts() uint64 {
	if t == nil || t.InPkts == nil {
		return 0
	}
	return *t.InPkts
}

// GetInUnicastPkts retrieves the value of the leaf InUnicastPkts from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InUnicastPkts is set, it can
// safely use t.GetInUnicastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InUnicastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetInUnicastPkts() uint64 {
	if t == nil || t.InUnicastPkts == nil {
		return 0
	}
	return *t.InUnicastPkts
}

// GetInUnknownProtos retrieves the value of the leaf InUnknownProtos from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InUnknownProtos is set, it can
// safely use t.GetInUnknownProtos() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InUnknownProtos == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetInUnknownProtos() uint64 {
	if t == nil || t.InUnknownProtos == nil {
		return 0
	}
	return *t.InUnknownProtos
}

// GetLastClear retrieves the value of the leaf LastClear from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastClear is set, it can
// safely use t.GetLastClear() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastClear == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetLastClear() uint64 {
	if t == nil || t.LastClear == nil {
		return 0
	}
	return *t.LastClear
}

// GetOutBroadcastPkts retrieves the value of the leaf OutBroadcastPkts from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutBroadcastPkts is set, it can
// safely use t.GetOutBroadcastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutBroadcastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetOutBroadcastPkts() uint64 {
	if t == nil || t.OutBroadcastPkts == nil {
		return 0
	}
	return *t.OutBroadcastPkts
}

// GetOutDiscards retrieves the value of the leaf OutDiscards from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutDiscards is set, it can
// safely use t.GetOutDiscards() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutDiscards == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetOutDiscards() uint64 {
	if t == nil || t.OutDiscards == nil {
		return 0
	}
	return *t.OutDiscards
}

// GetOutErrors retrieves the value of the leaf OutErrors from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutErrors is set, it can
// safely use t.GetOutErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutErrors == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetOutErrors() uint64 {
	if t == nil || t.OutErrors == nil {
		return 0
	}
	return *t.OutErrors
}

// GetOutMulticastPkts retrieves the value of the leaf OutMulticastPkts from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutMulticastPkts is set, it can
// safely use t.GetOutMulticastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutMulticastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetOutMulticastPkts() uint64 {
	if t == nil || t.OutMulticastPkts == nil {
		return 0
	}
	return *t.OutMulticastPkts
}

// GetOutOctets retrieves the value of the leaf OutOctets from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutOctets is set, it can
// safely use t.GetOutOctets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutOctets == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetOutOctets() uint64 {
	if t == nil || t.OutOctets == nil {
		return 0
	}
	return *t.OutOctets
}

// GetOutPkts retrieves the value of the leaf OutPkts from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutPkts is set, it can
// safely use t.GetOutPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetOutPkts() uint64 {
	if t == nil || t.OutPkts == nil {
		return 0
	}
	return *t.OutPkts
}

// GetOutUnicastPkts retrieves the value of the leaf OutUnicastPkts from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutUnicastPkts is set, it can
// safely use t.GetOutUnicastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutUnicastPkts == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) GetOutUnicastPkts() uint64 {
	if t == nil || t.OutUnicastPkts == nil {
		return 0
	}
	return *t.OutUnicastPkts
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan struct {
	ΛMetadata       []ygot.Annotation                                                                         `path:"@" ygotAnnotation:"true"`
	Config          *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config         `path:"config" module:"openconfig-vlan"`
	ΛConfig         []ygot.Annotation                                                                         `path:"@config" ygotAnnotation:"true"`
	EgressMapping   *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping  `path:"egress-mapping" module:"openconfig-vlan"`
	ΛEgressMapping  []ygot.Annotation                                                                         `path:"@egress-mapping" ygotAnnotation:"true"`
	IngressMapping  *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping `path:"ingress-mapping" module:"openconfig-vlan"`
	ΛIngressMapping []ygot.Annotation                                                                         `path:"@ingress-mapping" ygotAnnotation:"true"`
	Match           *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match          `path:"match" module:"openconfig-vlan"`
	ΛMatch          []ygot.Annotation                                                                         `path:"@match" ygotAnnotation:"true"`
	State           *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State          `path:"state" module:"openconfig-vlan"`
	ΛState          []ygot.Annotation                                                                         `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) GetOrCreateConfig() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config{}
	return t.Config
}

// GetOrCreateEgressMapping retrieves the value of the EgressMapping field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) GetOrCreateEgressMapping() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping {
	if t.EgressMapping != nil {
		return t.EgressMapping
	}
	t.EgressMapping = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping{}
	return t.EgressMapping
}

// GetOrCreateIngressMapping retrieves the value of the IngressMapping field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) GetOrCreateIngressMapping() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping {
	if t.IngressMapping != nil {
		return t.IngressMapping
	}
	t.IngressMapping = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping{}
	return t.IngressMapping
}

// GetOrCreateMatch retrieves the value of the Match field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) GetOrCreateMatch() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match {
	if t.Match != nil {
		return t.Match
	}
	t.Match = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match{}
	return t.Match
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) GetOrCreateState() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State {
	if t.State != nil {
		return t.State
	}
	t.State = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) GetConfig() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetEgressMapping returns the value of the EgressMapping struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan. If the receiver or the field EgressMapping is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) GetEgressMapping() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping {
	if t != nil && t.EgressMapping != nil {
		return t.EgressMapping
	}
	return nil
}

// GetIngressMapping returns the value of the IngressMapping struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan. If the receiver or the field IngressMapping is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) GetIngressMapping() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping {
	if t != nil && t.IngressMapping != nil {
		return t.IngressMapping
	}
	return nil
}

// GetMatch returns the value of the Match struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan. If the receiver or the field Match is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) GetMatch() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match {
	if t != nil && t.Match != nil {
		return t.Match
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) GetState() *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.EgressMapping.PopulateDefaults()
	t.IngressMapping.PopulateDefaults()
	t.Match.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config struct {
	ΛMetadata []ygot.Annotation                                                                             `path:"@" ygotAnnotation:"true"`
	VlanId    OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union `path:"vlan-id" module:"openconfig-vlan"`
	ΛVlanId   []ygot.Annotation                                                                             `path:"@vlan-id" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) IsYANGGoStruct() {
}

// GetVlanId retrieves the value of the leaf VlanId from the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if VlanId is set, it can
// safely use t.GetVlanId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.VlanId == nil' before retrieving the leaf's value.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) GetVlanId() OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union {
	if t == nil || t.VlanId == nil {
		return nil
	}
	return t.VlanId
}

// PopulateDefaults recursively populates unset leaf fields in the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/config/vlan-id within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union() {
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union() {
}

// To_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/egress-mapping YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping struct {
	ΛMetadata []ygot.Annotation                                                                               `path:"@" ygotAnnotation:"true"`
	Config    *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config `path:"config" module:"openconfig-vlan"`
	ΛConfig   []ygot.Annotation                                                                               `path:"@config" ygotAnnotation:"true"`
	State     *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State  `path:"state" module:"openconfig-vlan"`
	ΛState    []ygot.Annotation                                                                               `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressM