// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodbstreams

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

const opDescribeStream = "DescribeStream"

// DescribeStreamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStream for more information on using the DescribeStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStreamRequest method.
//	req, resp := client.DescribeStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/DescribeStream
func (c *DynamoDBStreams) DescribeStreamRequest(input *DescribeStreamInput) (req *request.Request, output *DescribeStreamOutput) {
	op := &request.Operation{
		Name:       opDescribeStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStreamInput{}
	}

	output = &DescribeStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStream API operation for Amazon DynamoDB Streams.
//
// Returns information about a stream, including the current status of the stream,
// its Amazon Resource Name (ARN), the composition of its shards, and its corresponding
// DynamoDB table.
//
// You can call DescribeStream at a maximum rate of 10 times per second.
//
// Each shard in the stream has a SequenceNumberRange associated with it. If
// the SequenceNumberRange has a StartingSequenceNumber but no EndingSequenceNumber,
// then the shard is still open (able to receive more stream records). If both
// StartingSequenceNumber and EndingSequenceNumber are present, then that shard
// is closed and can no longer receive more data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Streams's
// API operation DescribeStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent table or index. The resource
//     might not be specified correctly, or its status might not be ACTIVE.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/DescribeStream
func (c *DynamoDBStreams) DescribeStream(input *DescribeStreamInput) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	return out, req.Send()
}

// DescribeStreamWithContext is the same as DescribeStream with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDBStreams) DescribeStreamWithContext(ctx aws.Context, input *DescribeStreamInput, opts ...request.Option) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecords = "GetRecords"

// GetRecordsRequest generates a "aws/request.Request" representing the
// client's request for the GetRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecords for more information on using the GetRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRecordsRequest method.
//	req, resp := client.GetRecordsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/GetRecords
func (c *DynamoDBStreams) GetRecordsRequest(input *GetRecordsInput) (req *request.Request, output *GetRecordsOutput) {
	op := &request.Operation{
		Name:       opGetRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRecordsInput{}
	}

	output = &GetRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecords API operation for Amazon DynamoDB Streams.
//
// Retrieves the stream records from a given shard.
//
// Specify a shard iterator using the ShardIterator parameter. The shard iterator
// specifies the position in the shard from which you want to start reading
// stream records sequentially. If there are no stream records available in
// the portion of the shard that the iterator points to, GetRecords returns
// an empty list. Note that it might take multiple calls to get to a portion
// of the shard that contains stream records.
//
// GetRecords can retrieve a maximum of 1 MB of data or 1000 stream records,
// whichever comes first.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Streams's
// API operation GetRecords for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent table or index. The resource
//     might not be specified correctly, or its status might not be ACTIVE.
//
//   - LimitExceededException
//     There is no limit to the number of daily on-demand backups that can be taken.
//
//     For most purposes, up to 500 simultaneous table operations are allowed per
//     account. These operations include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive,
//     RestoreTableFromBackup, and RestoreTableToPointInTime.
//
//     When you are creating a table with one or more secondary indexes, you can
//     have up to 250 such requests running at a time. However, if the table or
//     index specifications are complex, then DynamoDB might temporarily reduce
//     the number of concurrent operations.
//
//     When importing into DynamoDB, up to 50 simultaneous import table operations
//     are allowed per account.
//
//     There is a soft account quota of 2,500 tables.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ExpiredIteratorException
//     The shard iterator has expired and can no longer be used to retrieve stream
//     records. A shard iterator expires 15 minutes after it is retrieved using
//     the GetShardIterator action.
//
//   - TrimmedDataAccessException
//     The operation attempted to read past the oldest stream record in a shard.
//
//     In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records
//     whose age exceeds this limit are subject to removal (trimming) from the stream.
//     You might receive a TrimmedDataAccessException if:
//
//   - You request a shard iterator with a sequence number older than the trim
//     point (24 hours).
//
//   - You obtain a shard iterator, but before you use the iterator in a GetRecords
//     request, a stream record in the shard exceeds the 24 hour period and is
//     trimmed. This causes the iterator to access a record that no longer exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/GetRecords
func (c *DynamoDBStreams) GetRecords(input *GetRecordsInput) (*GetRecordsOutput, error) {
	req, out := c.GetRecordsRequest(input)
	return out, req.Send()
}

// GetRecordsWithContext is the same as GetRecords with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDBStreams) GetRecordsWithContext(ctx aws.Context, input *GetRecordsInput, opts ...request.Option) (*GetRecordsOutput, error) {
	req, out := c.GetRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetShardIterator = "GetShardIterator"

// GetShardIteratorRequest generates a "aws/request.Request" representing the
// client's request for the GetShardIterator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetShardIterator for more information on using the GetShardIterator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetShardIteratorRequest method.
//	req, resp := client.GetShardIteratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/GetShardIterator
func (c *DynamoDBStreams) GetShardIteratorRequest(input *GetShardIteratorInput) (req *request.Request, output *GetShardIteratorOutput) {
	op := &request.Operation{
		Name:       opGetShardIterator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetShardIteratorInput{}
	}

	output = &GetShardIteratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetShardIterator API operation for Amazon DynamoDB Streams.
//
// Returns a shard iterator. A shard iterator provides information about how
// to retrieve the stream records from within a shard. Use the shard iterator
// in a subsequent GetRecords request to read the stream records from the shard.
//
// A shard iterator expires 15 minutes after it is returned to the requester.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Streams's
// API operation GetShardIterator for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent table or index. The resource
//     might not be specified correctly, or its status might not be ACTIVE.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - TrimmedDataAccessException
//     The operation attempted to read past the oldest stream record in a shard.
//
//     In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records
//     whose age exceeds this limit are subject to removal (trimming) from the stream.
//     You might receive a TrimmedDataAccessException if:
//
//   - You request a shard iterator with a sequence number older than the trim
//     point (24 hours).
//
//   - You obtain a shard iterator, but before you use the iterator in a GetRecords
//     request, a stream record in the shard exceeds the 24 hour period and is
//     trimmed. This causes the iterator to access a record that no longer exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/GetShardIterator
func (c *DynamoDBStreams) GetShardIterator(input *GetShardIteratorInput) (*GetShardIteratorOutput, error) {
	req, out := c.GetShardIteratorRequest(input)
	return out, req.Send()
}

// GetShardIteratorWithContext is the same as GetShardIterator with the addition of
// the ability to pass a context and additional request options.
//
// See GetShardIterator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDBStreams) GetShardIteratorWithContext(ctx aws.Context, input *GetShardIteratorInput, opts ...request.Option) (*GetShardIteratorOutput, error) {
	req, out := c.GetShardIteratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStreams = "ListStreams"

// ListStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreams for more information on using the ListStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStreamsRequest method.
//	req, resp := client.ListStreamsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/ListStreams
func (c *DynamoDBStreams) ListStreamsRequest(input *ListStreamsInput) (req *request.Request, output *ListStreamsOutput) {
	op := &request.Operation{
		Name:       opListStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStreamsInput{}
	}

	output = &ListStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreams API operation for Amazon DynamoDB Streams.
//
// Returns an array of stream ARNs associated with the current account and endpoint.
// If the TableName parameter is present, then ListStreams will return only
// the streams ARNs for that table.
//
// You can call ListStreams at a maximum rate of 5 times per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Streams's
// API operation ListStreams for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent table or index. The resource
//     might not be specified correctly, or its status might not be ACTIVE.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/ListStreams
func (c *DynamoDBStreams) ListStreams(input *ListStreamsInput) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	return out, req.Send()
}

// ListStreamsWithContext is the same as ListStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDBStreams) ListStreamsWithContext(ctx aws.Context, input *ListStreamsInput, opts ...request.Option) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the input of a DescribeStream operation.
type DescribeStreamInput struct {
	_ struct{} `type:"structure"`

	// The shard ID of the first item that this operation will evaluate. Use the
	// value that was returned for LastEvaluatedShardId in the previous operation.
	ExclusiveStartShardId *string `min:"28" type:"string"`

	// The maximum number of shard objects to return. The upper limit is 100.
	Limit *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) for the stream.
	//
	// StreamArn is a required field
	StreamArn *string `min:"37" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStreamInput"}
	if s.ExclusiveStartShardId != nil && len(*s.ExclusiveStartShardId) < 28 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartShardId", 28))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.StreamArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamArn"))
	}
	if s.StreamArn != nil && len(*s.StreamArn) < 37 {
		invalidParams.Add(request.NewErrParamMinLen("StreamArn", 37))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartShardId sets the ExclusiveStartShardId field's value.
func (s *DescribeStreamInput) SetExclusiveStartShardId(v string) *DescribeStreamInput {
	s.ExclusiveStartShardId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeStreamInput) SetLimit(v int64) *DescribeStreamInput {
	s.Limit = &v
	return s
}

// SetStreamArn sets the StreamArn field's value.
func (s *DescribeStreamInput) SetStreamArn(v string) *DescribeStreamInput {
	s.StreamArn = &v
	return s
}

// Represents the output of a DescribeStream operation.
type DescribeStreamOutput struct {
	_ struct{} `type:"structure"`

	// A complete description of the stream, including its creation date and time,
	// the DynamoDB table associated with the stream, the shard IDs within the stream,
	// and the beginning and ending sequence numbers of stream records within the
	// shards.
	StreamDescription *StreamDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamOutput) GoString() string {
	return s.String()
}

// SetStreamDescription sets the StreamDescription field's value.
func (s *DescribeStreamOutput) SetStreamDescription(v *StreamDescription) *DescribeStreamOutput {
	s.StreamDescription = v
	return s
}

// The shard iterator has expired and can no longer be used to retrieve stream
// records. A shard iterator expires 15 minutes after it is retrieved using
// the GetShardIterator action.
type ExpiredIteratorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The provided iterator exceeds the maximum age allowed.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredIteratorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredIteratorException) GoString() string {
	return s.String()
}

func newErrorExpiredIteratorException(v protocol.ResponseMetadata) error {
	return &ExpiredIteratorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExpiredIteratorException) Code() string {
	return "ExpiredIteratorException"
}

// Message returns the exception's message.
func (s *ExpiredIteratorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExpiredIteratorException) OrigErr() error {
	return nil
}

func (s *ExpiredIteratorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExpiredIteratorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExpiredIteratorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input of a GetRecords operation.
type GetRecordsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to return from the shard. The upper limit is
	// 1000.
	Limit *int64 `min:"1" type:"integer"`

	// A shard iterator that was retrieved from a previous GetShardIterator operation.
	// This iterator can be used to access the stream records in this shard.
	//
	// ShardIterator is a required field
	ShardIterator *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecordsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.ShardIterator == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardIterator"))
	}
	if s.ShardIterator != nil && len(*s.ShardIterator) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardIterator", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetRecordsInput) SetLimit(v int64) *GetRecordsInput {
	s.Limit = &v
	return s
}

// SetShardIterator sets the ShardIterator field's value.
func (s *GetRecordsInput) SetShardIterator(v string) *GetRecordsInput {
	s.ShardIterator = &v
	return s
}

// Represents the output of a GetRecords operation.
type GetRecordsOutput struct {
	_ struct{} `type:"structure"`

	// The next position in the shard from which to start sequentially reading stream
	// records. If set to null, the shard has been closed and the requested iterator
	// will not return any more data.
	NextShardIterator *string `min:"1" type:"string"`

	// The stream records from the shard, which were retrieved using the shard iterator.
	Records []*Record `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordsOutput) GoString() string {
	return s.String()
}

// SetNextShardIterator sets the NextShardIterator field's value.
func (s *GetRecordsOutput) SetNextShardIterator(v string) *GetRecordsOutput {
	s.NextShardIterator = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *GetRecordsOutput) SetRecords(v []*Record) *GetRecordsOutput {
	s.Records = v
	return s
}

// Represents the input of a GetShardIterator operation.
type GetShardIteratorInput struct {
	_ struct{} `type:"structure"`

	// The sequence number of a stream record in the shard from which to start reading.
	SequenceNumber *string `min:"21" type:"string"`

	// The identifier of the shard. The iterator will be returned for this shard
	// ID.
	//
	// ShardId is a required field
	ShardId *string `min:"28" type:"string" required:"true"`

	// Determines how the shard iterator is used to start reading stream records
	// from the shard:
	//
	//    * AT_SEQUENCE_NUMBER - Start reading exactly from the position denoted
	//    by a specific sequence number.
	//
	//    * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted
	//    by a specific sequence number.
	//
	//    * TRIM_HORIZON - Start reading at the last (untrimmed) stream record,
	//    which is the oldest record in the shard. In DynamoDB Streams, there is
	//    a 24 hour limit on data retention. Stream records whose age exceeds this
	//    limit are subject to removal (trimming) from the stream.
	//
	//    * LATEST - Start reading just after the most recent stream record in the
	//    shard, so that you always read the most recent data in the shard.
	//
	// ShardIteratorType is a required field
	ShardIteratorType *string `type:"string" required:"true" enum:"ShardIteratorType"`

	// The Amazon Resource Name (ARN) for the stream.
	//
	// StreamArn is a required field
	StreamArn *string `min:"37" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShardIteratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShardIteratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetShardIteratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetShardIteratorInput"}
	if s.SequenceNumber != nil && len(*s.SequenceNumber) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceNumber", 21))
	}
	if s.ShardId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardId"))
	}
	if s.ShardId != nil && len(*s.ShardId) < 28 {
		invalidParams.Add(request.NewErrParamMinLen("ShardId", 28))
	}
	if s.ShardIteratorType == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardIteratorType"))
	}
	if s.StreamArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamArn"))
	}
	if s.StreamArn != nil && len(*s.StreamArn) < 37 {
		invalidParams.Add(request.NewErrParamMinLen("StreamArn", 37))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSequenceNumber sets the SequenceNumber field's value.
func (s *GetShardIteratorInput) SetSequenceNumber(v string) *GetShardIteratorInput {
	s.SequenceNumber = &v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *GetShardIteratorInput) SetShardId(v string) *GetShardIteratorInput {
	s.ShardId = &v
	return s
}

// SetShardIteratorType sets the ShardIteratorType field's value.
func (s *GetShardIteratorInput) SetShardIteratorType(v string) *GetShardIteratorInput {
	s.ShardIteratorType = &v
	return s
}

// SetStreamArn sets the StreamArn field's value.
func (s *GetShardIteratorInput) SetStreamArn(v string) *GetShardIteratorInput {
	s.StreamArn = &v
	return s
}

// Represents the output of a GetShardIterator operation.
type GetShardIteratorOutput struct {
	_ struct{} `type:"structure"`

	// The position in the shard from which to start reading stream records sequentially.
	// A shard iterator specifies this position using the sequence number of a stream
	// record in a shard.
	ShardIterator *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShardIteratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShardIteratorOutput) GoString() string {
	return s.String()
}

// SetShardIterator sets the ShardIterator field's value.
func (s *GetShardIteratorOutput) SetShardIterator(v string) *GetShardIteratorOutput {
	s.ShardIterator = &v
	return s
}

// Contains details about the type of identity that made the request.
type Identity struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the entity that made the call. For Time To Live,
	// the principalId is "dynamodb.amazonaws.com".
	PrincipalId *string `type:"string"`

	// The type of the identity. For Time To Live, the type is "Service".
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) GoString() string {
	return s.String()
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *Identity) SetPrincipalId(v string) *Identity {
	s.PrincipalId = &v
	return s
}

// SetType sets the Type field's value.
func (s *Identity) SetType(v string) *Identity {
	s.Type = &v
	return s
}

// An error occurred on the server side.
type InternalServerError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The server encountered an internal error trying to fulfill the request.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) GoString() string {
	return s.String()
}

func newErrorInternalServerError(v protocol.ResponseMetadata) error {
	return &InternalServerError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerError) Code() string {
	return "InternalServerError"
}

// Message returns the exception's message.
func (s *InternalServerError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerError) OrigErr() error {
	return nil
}

func (s *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerError) RequestID() string {
	return s.RespMetadata.RequestID
}

// There is no limit to the number of daily on-demand backups that can be taken.
//
// For most purposes, up to 500 simultaneous table operations are allowed per
// account. These operations include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive,
// RestoreTableFromBackup, and RestoreTableToPointInTime.
//
// When you are creating a table with one or more secondary indexes, you can
// have up to 250 such requests running at a time. However, if the table or
// index specifications are complex, then DynamoDB might temporarily reduce
// the number of concurrent operations.
//
// When importing into DynamoDB, up to 50 simultaneous import table operations
// are allowed per account.
//
// There is a soft account quota of 2,500 tables.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Too many operations for a given subscriber.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input of a ListStreams operation.
type ListStreamsInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the first item that this operation will
	// evaluate. Use the value that was returned for LastEvaluatedStreamArn in the
	// previous operation.
	ExclusiveStartStreamArn *string `min:"37" type:"string"`

	// The maximum number of streams to return. The upper limit is 100.
	Limit *int64 `min:"1" type:"integer"`

	// If this parameter is provided, then only the streams associated with this
	// table name are returned.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamsInput"}
	if s.ExclusiveStartStreamArn != nil && len(*s.ExclusiveStartStreamArn) < 37 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartStreamArn", 37))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartStreamArn sets the ExclusiveStartStreamArn field's value.
func (s *ListStreamsInput) SetExclusiveStartStreamArn(v string) *ListStreamsInput {
	s.ExclusiveStartStreamArn = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListStreamsInput) SetLimit(v int64) *ListStreamsInput {
	s.Limit = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ListStreamsInput) SetTableName(v string) *ListStreamsInput {
	s.TableName = &v
	return s
}

// Represents the output of a ListStreams operation.
type ListStreamsOutput struct {
	_ struct{} `type:"structure"`

	// The stream ARN of the item where the operation stopped, inclusive of the
	// previous result set. Use this value to start a new operation, excluding this
	// value in the new request.
	//
	// If LastEvaluatedStreamArn is empty, then the "last page" of results has been
	// processed and there is no more data to be retrieved.
	//
	// If LastEvaluatedStreamArn is not empty, it does not necessarily mean that
	// there is more data in the result set. The only way to know when you have
	// reached the end of the result set is when LastEvaluatedStreamArn is empty.
	LastEvaluatedStreamArn *string `min:"37" type:"string"`

	// A list of stream descriptors associated with the current account and endpoint.
	Streams []*Stream `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsOutput) GoString() string {
	return s.String()
}

// SetLastEvaluatedStreamArn sets the LastEvaluatedStreamArn field's value.
func (s *ListStreamsOutput) SetLastEvaluatedStreamArn(v string) *ListStreamsOutput {
	s.LastEvaluatedStreamArn = &v
	return s
}

// SetStreams sets the Streams field's value.
func (s *ListStreamsOutput) SetStreams(v []*Stream) *ListStreamsOutput {
	s.Streams = v
	return s
}

// A description of a unique event within a stream.
type Record struct {
	_ struct{} `type:"structure"`

	// The region in which the GetRecords request was received.
	AwsRegion *string `locationName:"awsRegion" type:"string"`

	// The main body of the stream record, containing all of the DynamoDB-specific
	// fields.
	Dynamodb *StreamRecord `locationName:"dynamodb" type:"structure"`

	// A globally unique identifier for the event that was recorded in this stream
	// record.
	EventID *string `locationName:"eventID" type:"string"`

	// The type of data modification that was performed on the DynamoDB table:
	//
	//    * INSERT - a new item was added to the table.
	//
	//    * MODIFY - one or more of an existing item's attributes were modified.
	//
	//    * REMOVE - the item was deleted from the table
	EventName *string `locationName:"eventName" type:"string" enum:"OperationType"`

	// The AWS service from which the stream record originated. For DynamoDB Streams,
	// this is aws:dynamodb.
	EventSource *string `locationName:"eventSource" type:"string"`

	// The version number of the stream record format. This number is updated whenever
	// the structure of Record is modified.
	//
	// Client applications must not assume that eventVersion will remain at a particular
	// value, as this number is subject to change at any time. In general, eventVersion
	// will only increase as the low-level DynamoDB Streams API evolves.
	EventVersion *string `locationName:"eventVersion" type:"string"`

	// Items that are deleted by the Time to Live process after expiration have
	// the following fields:
	//
	//    * Records[].userIdentity.type "Service"
	//
	//    * Records[].userIdentity.principalId "dynamodb.amazonaws.com"
	UserIdentity *Identity `locationName:"userIdentity" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) GoString() string {
	return s.String()
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *Record) SetAwsRegion(v string) *Record {
	s.AwsRegion = &v
	return s
}

// SetDynamodb sets the Dynamodb field's value.
func (s *Record) SetDynamodb(v *StreamRecord) *Record {
	s.Dynamodb = v
	return s
}

// SetEventID sets the EventID field's value.
func (s *Record) SetEventID(v string) *Record {
	s.EventID = &v
	return s
}

// SetEventName sets the EventName field's value.
func (s *Record) SetEventName(v string) *Record {
	s.EventName = &v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *Record) SetEventSource(v string) *Record {
	s.EventSource = &v
	return s
}

// SetEventVersion sets the EventVersion field's value.
func (s *Record) SetEventVersion(v string) *Record {
	s.EventVersion = &v
	return s
}

// SetUserIdentity sets the UserIdentity field's value.
func (s *Record) SetUserIdentity(v *Identity) *Record {
	s.UserIdentity = v
	return s
}

// The operation tried to access a nonexistent table or index. The resource
// might not be specified correctly, or its status might not be ACTIVE.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The resource which is being requested does not exist.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The beginning and ending sequence numbers for the stream records contained
// within a shard.
type SequenceNumberRange struct {
	_ struct{} `type:"structure"`

	// The last sequence number for the stream records contained within a shard.
	// String contains numeric characters only.
	EndingSequenceNumber *string `min:"21" type:"string"`

	// The first sequence number for the stream records contained within a shard.
	// String contains numeric characters only.
	StartingSequenceNumber *string `min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SequenceNumberRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SequenceNumberRange) GoString() string {
	return s.String()
}

// SetEndingSequenceNumber sets the EndingSequenceNumber field's value.
func (s *SequenceNumberRange) SetEndingSequenceNumber(v string) *SequenceNumberRange {
	s.EndingSequenceNumber = &v
	return s
}

// SetStartingSequenceNumber sets the StartingSequenceNumber field's value.
func (s *SequenceNumberRange) SetStartingSequenceNumber(v string) *SequenceNumberRange {
	s.StartingSequenceNumber = &v
	return s
}

// A uniquely identified group of stream records within a stream.
type Shard struct {
	_ struct{} `type:"structure"`

	// The shard ID of the current shard's parent.
	ParentShardId *string `min:"28" type:"string"`

	// The range of possible sequence numbers for the shard.
	SequenceNumberRange *SequenceNumberRange `type:"structure"`

	// The system-generated identifier for this shard.
	ShardId *string `min:"28" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Shard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Shard) GoString() string {
	return s.String()
}

// SetParentShardId sets the ParentShardId field's value.
func (s *Shard) SetParentShardId(v string) *Shard {
	s.ParentShardId = &v
	return s
}

// SetSequenceNumberRange sets the SequenceNumberRange field's value.
func (s *Shard) SetSequenceNumberRange(v *SequenceNumberRange) *Shard {
	s.SequenceNumberRange = v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *Shard) SetShardId(v string) *Shard {
	s.ShardId = &v
	return s
}

// Represents all of the data describing a particular stream.
type Stream struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the stream.
	StreamArn *string `min:"37" type:"string"`

	// A timestamp, in ISO 8601 format, for this stream.
	//
	// Note that LatestStreamLabel is not a unique identifier for the stream, because
	// it is possible that a stream from another table might have the same timestamp.
	// However, the combination of the following three elements is guaranteed to
	// be unique:
	//
	//    * the AWS customer ID.
	//
	//    * the table name
	//
	//    * the StreamLabel
	StreamLabel *string `type:"string"`

	// The DynamoDB table with which the stream is associated.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stream) GoString() string {
	return s.String()
}

// SetStreamArn sets the StreamArn field's value.
func (s *Stream) SetStreamArn(v string) *Stream {
	s.StreamArn = &v
	return s
}

// SetStreamLabel sets the StreamLabel field's value.
func (s *Stream) SetStreamLabel(v string) *Stream {
	s.StreamLabel = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *Stream) SetTableName(v string) *Stream {
	s.TableName = &v
	return s
}

// Represents all of the data describing a particular stream.
type StreamDescription struct {
	_ struct{} `type:"structure"`

	// The date and time when the request to create this stream was issued.
	CreationRequestDateTime *time.Time `type:"timestamp"`

	// The key attribute(s) of the stream's DynamoDB table.
	KeySchema []*dynamodb.KeySchemaElement `min:"1" type:"list"`

	// The shard ID of the item where the operation stopped, inclusive of the previous
	// result set. Use this value to start a new operation, excluding this value
	// in the new request.
	//
	// If LastEvaluatedShardId is empty, then the "last page" of results has been
	// processed and there is currently no more data to be retrieved.
	//
	// If LastEvaluatedShardId is not empty, it does not necessarily mean that there
	// is more data in the result set. The only way to know when you have reached
	// the end of the result set is when LastEvaluatedShardId is empty.
	LastEvaluatedShardId *string `min:"28" type:"string"`

	// The shards that comprise the stream.
	Shards []*Shard `type:"list"`

	// The Amazon Resource Name (ARN) for the stream.
	StreamArn *string `min:"37" type:"string"`

	// A timestamp, in ISO 8601 format, for this stream.
	//
	// Note that LatestStreamLabel is not a unique identifier for the stream, because
	// it is possible that a stream from another table might have the same timestamp.
	// However, the combination of the following three elements is guaranteed to
	// be unique:
	//
	//    * the AWS customer ID.
	//
	//    * the table name
	//
	//    * the StreamLabel
	StreamLabel *string `type:"string"`

	// Indicates the current status of the stream:
	//
	//    * ENABLING - Streams is currently being enabled on the DynamoDB table.
	//
	//    * ENABLED - the stream is enabled.
	//
	//    * DISABLING - Streams is currently being disabled on the DynamoDB table.
	//
	//    * DISABLED - the stream is disabled.
	StreamStatus *string `type:"string" enum:"StreamStatus"`

	// Indicates the format of the records within this stream:
	//
	//    * KEYS_ONLY - only the key attributes of items that were modified in the
	//    DynamoDB table.
	//
	//    * NEW_IMAGE - entire items from the table, as they appeared after they
	//    were modified.
	//
	//    * OLD_IMAGE - entire items from the table, as they appeared before they
	//    were modified.
	//
	//    * NEW_AND_OLD_IMAGES - both the new and the old images of the items from
	//    the table.
	StreamViewType *string `type:"string" enum:"StreamViewType"`

	// The DynamoDB table with which the stream is associated.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamDescription) GoString() string {
	return s.String()
}

// SetCreationRequestDateTime sets the CreationRequestDateTime field's value.
func (s *StreamDescription) SetCreationRequestDateTime(v time.Time) *StreamDescription {
	s.CreationRequestDateTime = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *StreamDescription) SetKeySchema(v []*dynamodb.KeySchemaElement) *StreamDescription {
	s.KeySchema = v
	return s
}

// SetLastEvaluatedShardId sets the LastEvaluatedShardId field's value.
func (s *StreamDescription) SetLastEvaluatedShardId(v string) *StreamDescription {
	s.LastEvaluatedShardId = &v
	return s
}

// SetShards sets the Shards field's value.
func (s *StreamDescription) SetShards(v []*Shard) *StreamDescription {
	s.Shards = v
	return s
}

// SetStreamArn sets the StreamArn field's value.
func (s *StreamDescription) SetStreamArn(v string) *StreamDescription {
	s.StreamArn = &v
	return s
}

// SetStreamLabel sets the StreamLabel field's value.
func (s *StreamDescription) SetStreamLabel(v string) *StreamDescription {
	s.StreamLabel = &v
	return s
}

// SetStreamStatus sets the StreamStatus field's value.
func (s *StreamDescription) SetStreamStatus(v string) *StreamDescription {
	s.StreamStatus = &v
	return s
}

// SetStreamViewType sets the StreamViewType field's value.
func (s *StreamDescription) SetStreamViewType(v string) *StreamDescription {
	s.StreamViewType = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *StreamDescription) SetTableName(v string) *StreamDescription {
	s.TableName = &v
	return s
}

// A description of a single data modification that was performed on an item
// in a DynamoDB table.
type StreamRecord struct {
	_ struct{} `type:"structure"`

	// The approximate date and time when the stream record was created, in UNIX
	// epoch time (http://www.epochconverter.com/) format.
	ApproximateCreationDateTime *time.Time `type:"timestamp"`

	// The primary key attribute(s) for the DynamoDB item that was modified.
	Keys map[string]*dynamodb.AttributeValue `type:"map"`

	// The item in the DynamoDB table as it appeared after it was modified.
	NewImage map[string]*dynamodb.AttributeValue `type:"map"`

	// The item in the DynamoDB table as it appeared before it was modified.
	OldImage map[string]*dynamodb.AttributeValue `type:"map"`

	// The sequence number of the stream record.
	SequenceNumber *string `min:"21" type:"string"`

	// The size of the stream record, in bytes.
	SizeBytes *int64 `min:"1" type:"long"`

	// The type of data from the modified DynamoDB item that was captured in this
	// stream record:
	//
	//    * KEYS_ONLY - only the key attributes of the modified item.
	//
	//    * NEW_IMAGE - the entire item, as it appeared after it was modified.
	//
	//    * OLD_IMAGE - the entire item, as it appeared before it was modified.
	//
	//    * NEW_AND_OLD_IMAGES - both the new and the old item images of the item.
	StreamViewType *string `type:"string" enum:"StreamViewType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamRecord) GoString() string {
	return s.String()
}

// SetApproximateCreationDateTime sets the ApproximateCreationDateTime field's value.
func (s *StreamRecord) SetApproximateCreationDateTime(v time.Time) *StreamRecord {
	s.ApproximateCreationDateTime = &v
	return s
}

// SetKeys sets the Keys field's value.
func (s *StreamRecord) SetKeys(v map[string]*dynamodb.AttributeValue) *StreamRecord {
	s.Keys = v
	return s
}

// SetNewImage sets the NewImage field's value.
func (s *StreamRecord) SetNewImage(v map[string]*dynamodb.AttributeValue) *StreamRecord {
	s.NewImage = v
	return s
}

// SetOldImage sets the OldImage field's value.
func (s *StreamRecord) SetOldImage(v map[string]*dynamodb.AttributeValue) *StreamRecord {
	s.OldImage = v
	return s
}

// SetSequenceNumber sets the SequenceNumber field's value.
func (s *StreamRecord) SetSequenceNumber(v string) *StreamRecord {
	s.SequenceNumber = &v
	return s
}

// SetSizeBytes sets the SizeBytes field's value.
func (s *StreamRecord) SetSizeBytes(v int64) *StreamRecord {
	s.SizeBytes = &v
	return s
}

// SetStreamViewType sets the StreamViewType field's value.
func (s *StreamRecord) SetStreamViewType(v string) *StreamRecord {
	s.StreamViewType = &v
	return s
}

// The operation attempted to read past the oldest stream record in a shard.
//
// In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records
// whose age exceeds this limit are subject to removal (trimming) from the stream.
// You might receive a TrimmedDataAccessException if:
//
//   - You request a shard iterator with a sequence number older than the trim
//     point (24 hours).
//
//   - You obtain a shard iterator, but before you use the iterator in a GetRecords
//     request, a stream record in the shard exceeds the 24 hour period and is
//     trimmed. This causes the iterator to access a record that no longer exists.
type TrimmedDataAccessException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// "The data you are trying to access has been trimmed.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrimmedDataAccessException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrimmedDataAccessException) GoString() string {
	return s.String()
}

func newErrorTrimmedDataAccessException(v protocol.ResponseMetadata) error {
	return &TrimmedDataAccessException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TrimmedDataAccessException) Code() string {
	return "TrimmedDataAccessException"
}

// Message returns the exception's message.
func (s *TrimmedDataAccessException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TrimmedDataAccessException) OrigErr() error {
	return nil
}

func (s *TrimmedDataAccessException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TrimmedDataAccessException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TrimmedDataAccessException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// KeyTypeHash is a KeyType enum value
	KeyTypeHash = "HASH"

	// KeyTypeRange is a KeyType enum value
	KeyTypeRange = "RANGE"
)

// KeyType_Values returns all elements of the KeyType enum
func KeyType_Values() []string {
	return []string{
		KeyTypeHash,
		KeyTypeRange,
	}
}

const (
	// OperationTypeInsert is a OperationType enum value
	OperationTypeInsert = "INSERT"

	// OperationTypeModify is a OperationType enum value
	OperationTypeModify = "MODIFY"

	// OperationTypeRemove is a OperationType enum value
	OperationTypeRemove = "REMOVE"
)

// OperationType_Values returns all elements of the OperationType enum
func OperationType_Values() []string {
	return []string{
		OperationTypeInsert,
		OperationTypeModify,
		OperationTypeRemove,
	}
}

const (
	// ShardIteratorTypeTrimHorizon is a ShardIteratorType enum value
	ShardIteratorTypeTrimHorizon = "TRIM_HORIZON"

	// ShardIteratorTypeLatest is a ShardIteratorType enum value
	ShardIteratorTypeLatest = "LATEST"

	// ShardIteratorTypeAtSequenceNumber is a ShardIteratorType enum value
	ShardIteratorTypeAtSequenceNumber = "AT_SEQUENCE_NUMBER"

	// ShardIteratorTypeAfterSequenceNumber is a ShardIteratorType enum value
	ShardIteratorTypeAfterSequenceNumber = "AFTER_SEQUENCE_NUMBER"
)

// ShardIteratorType_Values returns all elements of the ShardIteratorType enum
func ShardIteratorType_Values() []string {
	return []string{
		ShardIteratorTypeTrimHorizon,
		ShardIteratorTypeLatest,
		ShardIteratorTypeAtSequenceNumber,
		ShardIteratorTypeAfterSequenceNumber,
	}
}

const (
	// StreamStatusEnabling is a StreamStatus enum value
	StreamStatusEnabling = "ENABLING"

	// StreamStatusEnabled is a StreamStatus enum value
	StreamStatusEnabled = "ENABLED"

	// StreamStatusDisabling is a StreamStatus enum value
	StreamStatusDisabling = "DISABLING"

	// StreamStatusDisabled is a StreamStatus enum value
	StreamStatusDisabled = "DISABLED"
)

// StreamStatus_Values returns all elements of the StreamStatus enum
func StreamStatus_Values() []string {
	return []string{
		StreamStatusEnabling,
		StreamStatusEnabled,
		StreamStatusDisabling,
		StreamStatusDisabled,
	}
}

const (
	// StreamViewTypeNewImage is a StreamViewType enum value
	StreamViewTypeNewImage = "NEW_IMAGE"

	// StreamViewTypeOldImage is a StreamViewType enum value
	StreamViewTypeOldImage = "OLD_IMAGE"

	// StreamViewTypeNewAndOldImages is a StreamViewType enum value
	StreamViewTypeNewAndOldImages = "NEW_AND_OLD_IMAGES"

	// StreamViewTypeKeysOnly is a StreamViewType enum value
	StreamViewTypeKeysOnly = "KEYS_ONLY"
)

// StreamViewType_Values returns all elements of the StreamViewType enum
func StreamViewType_Values() []string {
	return []string{
		StreamViewTypeNewImage,
		StreamViewTypeOldImage,
		StreamViewTypeNewAndOldImages,
		StreamViewTypeKeysOnly,
	}
}
