// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilEnvironmentExists uses the Elastic Beanstalk API operation
// DescribeEnvironments to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *ElasticBeanstalk) WaitUntilEnvironmentExists(input *DescribeEnvironmentsInput) error {
	return c.WaitUntilEnvironmentExistsWithContext(aws.BackgroundContext(), input)
}

// WaitUntilEnvironmentExistsWithContext is an extended version of WaitUntilEnvironmentExists.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) WaitUntilEnvironmentExistsWithContext(ctx aws.Context, input *DescribeEnvironmentsInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilEnvironmentExists",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(20 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Ready",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Launching",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilEnvironmentTerminated uses the Elastic Beanstalk API operation
// DescribeEnvironments to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *ElasticBeanstalk) WaitUntilEnvironmentTerminated(input *DescribeEnvironmentsInput) error {
	return c.WaitUntilEnvironmentTerminatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilEnvironmentTerminatedWithContext is an extended version of WaitUntilEnvironmentTerminated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) WaitUntilEnvironmentTerminatedWithContext(ctx aws.Context, input *DescribeEnvironmentsInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilEnvironmentTerminated",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(20 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Terminated",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Terminating",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilEnvironmentUpdated uses the Elastic Beanstalk API operation
// DescribeEnvironments to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *ElasticBeanstalk) WaitUntilEnvironmentUpdated(input *DescribeEnvironmentsInput) error {
	return c.WaitUntilEnvironmentUpdatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilEnvironmentUpdatedWithContext is an extended version of WaitUntilEnvironmentUpdated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) WaitUntilEnvironmentUpdatedWithContext(ctx aws.Context, input *DescribeEnvironmentsInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilEnvironmentUpdated",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(20 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Ready",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Updating",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
