// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package finspaceiface provides an interface to enable mocking the FinSpace User Environment Management service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package finspaceiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/finspace"
)

// FinspaceAPI provides an interface to enable mocking the
// finspace.Finspace service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// FinSpace User Environment Management service.
//	func myFunc(svc finspaceiface.FinspaceAPI) bool {
//	    // Make svc.CreateEnvironment request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := finspace.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockFinspaceClient struct {
//	    finspaceiface.FinspaceAPI
//	}
//	func (m *mockFinspaceClient) CreateEnvironment(input *finspace.CreateEnvironmentInput) (*finspace.CreateEnvironmentOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockFinspaceClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type FinspaceAPI interface {
	CreateEnvironment(*finspace.CreateEnvironmentInput) (*finspace.CreateEnvironmentOutput, error)
	CreateEnvironmentWithContext(aws.Context, *finspace.CreateEnvironmentInput, ...request.Option) (*finspace.CreateEnvironmentOutput, error)
	CreateEnvironmentRequest(*finspace.CreateEnvironmentInput) (*request.Request, *finspace.CreateEnvironmentOutput)

	DeleteEnvironment(*finspace.DeleteEnvironmentInput) (*finspace.DeleteEnvironmentOutput, error)
	DeleteEnvironmentWithContext(aws.Context, *finspace.DeleteEnvironmentInput, ...request.Option) (*finspace.DeleteEnvironmentOutput, error)
	DeleteEnvironmentRequest(*finspace.DeleteEnvironmentInput) (*request.Request, *finspace.DeleteEnvironmentOutput)

	GetEnvironment(*finspace.GetEnvironmentInput) (*finspace.GetEnvironmentOutput, error)
	GetEnvironmentWithContext(aws.Context, *finspace.GetEnvironmentInput, ...request.Option) (*finspace.GetEnvironmentOutput, error)
	GetEnvironmentRequest(*finspace.GetEnvironmentInput) (*request.Request, *finspace.GetEnvironmentOutput)

	ListEnvironments(*finspace.ListEnvironmentsInput) (*finspace.ListEnvironmentsOutput, error)
	ListEnvironmentsWithContext(aws.Context, *finspace.ListEnvironmentsInput, ...request.Option) (*finspace.ListEnvironmentsOutput, error)
	ListEnvironmentsRequest(*finspace.ListEnvironmentsInput) (*request.Request, *finspace.ListEnvironmentsOutput)

	ListTagsForResource(*finspace.ListTagsForResourceInput) (*finspace.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *finspace.ListTagsForResourceInput, ...request.Option) (*finspace.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*finspace.ListTagsForResourceInput) (*request.Request, *finspace.ListTagsForResourceOutput)

	TagResource(*finspace.TagResourceInput) (*finspace.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *finspace.TagResourceInput, ...request.Option) (*finspace.TagResourceOutput, error)
	TagResourceRequest(*finspace.TagResourceInput) (*request.Request, *finspace.TagResourceOutput)

	UntagResource(*finspace.UntagResourceInput) (*finspace.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *finspace.UntagResourceInput, ...request.Option) (*finspace.UntagResourceOutput, error)
	UntagResourceRequest(*finspace.UntagResourceInput) (*request.Request, *finspace.UntagResourceOutput)

	UpdateEnvironment(*finspace.UpdateEnvironmentInput) (*finspace.UpdateEnvironmentOutput, error)
	UpdateEnvironmentWithContext(aws.Context, *finspace.UpdateEnvironmentInput, ...request.Option) (*finspace.UpdateEnvironmentOutput, error)
	UpdateEnvironmentRequest(*finspace.UpdateEnvironmentInput) (*request.Request, *finspace.UpdateEnvironmentOutput)
}

var _ FinspaceAPI = (*finspace.Finspace)(nil)
