// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivschat

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateChatToken = "CreateChatToken"

// CreateChatTokenRequest generates a "aws/request.Request" representing the
// client's request for the CreateChatToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChatToken for more information on using the CreateChatToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChatTokenRequest method.
//	req, resp := client.CreateChatTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/CreateChatToken
func (c *Ivschat) CreateChatTokenRequest(input *CreateChatTokenInput) (req *request.Request, output *CreateChatTokenOutput) {
	op := &request.Operation{
		Name:       opCreateChatToken,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateChatToken",
	}

	if input == nil {
		input = &CreateChatTokenInput{}
	}

	output = &CreateChatTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChatToken API operation for Amazon Interactive Video Service Chat.
//
// Creates an encrypted token that is used by a chat participant to establish
// an individual WebSocket chat connection to a room. When the token is used
// to connect to chat, the connection is valid for the session duration specified
// in the request. The token becomes invalid at the token-expiration timestamp
// included in the response.
//
// Use the capabilities field to permit an end user to send messages or moderate
// a room.
//
// The attributes field securely attaches structured data to the chat session;
// the data is included within each message sent by the end user and received
// by other participants in the room. Common use cases for attributes include
// passing end-user profile data like an icon, display name, colors, badges,
// and other display features.
//
// Encryption keys are owned by Amazon IVS Chat and never used directly by your
// application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation CreateChatToken for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - PendingVerification
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/CreateChatToken
func (c *Ivschat) CreateChatToken(input *CreateChatTokenInput) (*CreateChatTokenOutput, error) {
	req, out := c.CreateChatTokenRequest(input)
	return out, req.Send()
}

// CreateChatTokenWithContext is the same as CreateChatToken with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChatToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) CreateChatTokenWithContext(ctx aws.Context, input *CreateChatTokenInput, opts ...request.Option) (*CreateChatTokenOutput, error) {
	req, out := c.CreateChatTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLoggingConfiguration = "CreateLoggingConfiguration"

// CreateLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLoggingConfiguration for more information on using the CreateLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLoggingConfigurationRequest method.
//	req, resp := client.CreateLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/CreateLoggingConfiguration
func (c *Ivschat) CreateLoggingConfigurationRequest(input *CreateLoggingConfigurationInput) (req *request.Request, output *CreateLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateLoggingConfiguration",
	}

	if input == nil {
		input = &CreateLoggingConfigurationInput{}
	}

	output = &CreateLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLoggingConfiguration API operation for Amazon Interactive Video Service Chat.
//
// Creates a logging configuration that allows clients to store and record sent
// messages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation CreateLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - ServiceQuotaExceededException
//
//   - PendingVerification
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/CreateLoggingConfiguration
func (c *Ivschat) CreateLoggingConfiguration(input *CreateLoggingConfigurationInput) (*CreateLoggingConfigurationOutput, error) {
	req, out := c.CreateLoggingConfigurationRequest(input)
	return out, req.Send()
}

// CreateLoggingConfigurationWithContext is the same as CreateLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) CreateLoggingConfigurationWithContext(ctx aws.Context, input *CreateLoggingConfigurationInput, opts ...request.Option) (*CreateLoggingConfigurationOutput, error) {
	req, out := c.CreateLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoom = "CreateRoom"

// CreateRoomRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoom for more information on using the CreateRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRoomRequest method.
//	req, resp := client.CreateRoomRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/CreateRoom
func (c *Ivschat) CreateRoomRequest(input *CreateRoomInput) (req *request.Request, output *CreateRoomOutput) {
	op := &request.Operation{
		Name:       opCreateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateRoom",
	}

	if input == nil {
		input = &CreateRoomInput{}
	}

	output = &CreateRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoom API operation for Amazon Interactive Video Service Chat.
//
// Creates a room that allows clients to connect and pass messages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation CreateRoom for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - ServiceQuotaExceededException
//
//   - PendingVerification
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/CreateRoom
func (c *Ivschat) CreateRoom(input *CreateRoomInput) (*CreateRoomOutput, error) {
	req, out := c.CreateRoomRequest(input)
	return out, req.Send()
}

// CreateRoomWithContext is the same as CreateRoom with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) CreateRoomWithContext(ctx aws.Context, input *CreateRoomInput, opts ...request.Option) (*CreateRoomOutput, error) {
	req, out := c.CreateRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLoggingConfiguration = "DeleteLoggingConfiguration"

// DeleteLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLoggingConfiguration for more information on using the DeleteLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLoggingConfigurationRequest method.
//	req, resp := client.DeleteLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/DeleteLoggingConfiguration
func (c *Ivschat) DeleteLoggingConfigurationRequest(input *DeleteLoggingConfigurationInput) (req *request.Request, output *DeleteLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteLoggingConfiguration",
	}

	if input == nil {
		input = &DeleteLoggingConfigurationInput{}
	}

	output = &DeleteLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLoggingConfiguration API operation for Amazon Interactive Video Service Chat.
//
// Deletes the specified logging configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation DeleteLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - PendingVerification
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/DeleteLoggingConfiguration
func (c *Ivschat) DeleteLoggingConfiguration(input *DeleteLoggingConfigurationInput) (*DeleteLoggingConfigurationOutput, error) {
	req, out := c.DeleteLoggingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteLoggingConfigurationWithContext is the same as DeleteLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) DeleteLoggingConfigurationWithContext(ctx aws.Context, input *DeleteLoggingConfigurationInput, opts ...request.Option) (*DeleteLoggingConfigurationOutput, error) {
	req, out := c.DeleteLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMessage = "DeleteMessage"

// DeleteMessageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMessage for more information on using the DeleteMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMessageRequest method.
//	req, resp := client.DeleteMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/DeleteMessage
func (c *Ivschat) DeleteMessageRequest(input *DeleteMessageInput) (req *request.Request, output *DeleteMessageOutput) {
	op := &request.Operation{
		Name:       opDeleteMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteMessage",
	}

	if input == nil {
		input = &DeleteMessageInput{}
	}

	output = &DeleteMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMessage API operation for Amazon Interactive Video Service Chat.
//
// Sends an event to a specific room which directs clients to delete a specific
// message; that is, unrender it from view and delete it from the client’s
// chat history. This event’s EventName is aws:DELETE_MESSAGE. This replicates
// the DeleteMessage (https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html)
// WebSocket operation in the Amazon IVS Chat Messaging API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation DeleteMessage for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - PendingVerification
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/DeleteMessage
func (c *Ivschat) DeleteMessage(input *DeleteMessageInput) (*DeleteMessageOutput, error) {
	req, out := c.DeleteMessageRequest(input)
	return out, req.Send()
}

// DeleteMessageWithContext is the same as DeleteMessage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) DeleteMessageWithContext(ctx aws.Context, input *DeleteMessageInput, opts ...request.Option) (*DeleteMessageOutput, error) {
	req, out := c.DeleteMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoom = "DeleteRoom"

// DeleteRoomRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoom for more information on using the DeleteRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRoomRequest method.
//	req, resp := client.DeleteRoomRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/DeleteRoom
func (c *Ivschat) DeleteRoomRequest(input *DeleteRoomInput) (req *request.Request, output *DeleteRoomOutput) {
	op := &request.Operation{
		Name:       opDeleteRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteRoom",
	}

	if input == nil {
		input = &DeleteRoomInput{}
	}

	output = &DeleteRoomOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoom API operation for Amazon Interactive Video Service Chat.
//
// Deletes the specified room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation DeleteRoom for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - PendingVerification
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/DeleteRoom
func (c *Ivschat) DeleteRoom(input *DeleteRoomInput) (*DeleteRoomOutput, error) {
	req, out := c.DeleteRoomRequest(input)
	return out, req.Send()
}

// DeleteRoomWithContext is the same as DeleteRoom with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) DeleteRoomWithContext(ctx aws.Context, input *DeleteRoomInput, opts ...request.Option) (*DeleteRoomOutput, error) {
	req, out := c.DeleteRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisconnectUser = "DisconnectUser"

// DisconnectUserRequest generates a "aws/request.Request" representing the
// client's request for the DisconnectUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisconnectUser for more information on using the DisconnectUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisconnectUserRequest method.
//	req, resp := client.DisconnectUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/DisconnectUser
func (c *Ivschat) DisconnectUserRequest(input *DisconnectUserInput) (req *request.Request, output *DisconnectUserOutput) {
	op := &request.Operation{
		Name:       opDisconnectUser,
		HTTPMethod: "POST",
		HTTPPath:   "/DisconnectUser",
	}

	if input == nil {
		input = &DisconnectUserInput{}
	}

	output = &DisconnectUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisconnectUser API operation for Amazon Interactive Video Service Chat.
//
// Disconnects all connections using a specified user ID from a room. This replicates
// the DisconnectUser (https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html)
// WebSocket operation in the Amazon IVS Chat Messaging API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation DisconnectUser for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - PendingVerification
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/DisconnectUser
func (c *Ivschat) DisconnectUser(input *DisconnectUserInput) (*DisconnectUserOutput, error) {
	req, out := c.DisconnectUserRequest(input)
	return out, req.Send()
}

// DisconnectUserWithContext is the same as DisconnectUser with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) DisconnectUserWithContext(ctx aws.Context, input *DisconnectUserInput, opts ...request.Option) (*DisconnectUserOutput, error) {
	req, out := c.DisconnectUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggingConfiguration = "GetLoggingConfiguration"

// GetLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoggingConfiguration for more information on using the GetLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLoggingConfigurationRequest method.
//	req, resp := client.GetLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/GetLoggingConfiguration
func (c *Ivschat) GetLoggingConfigurationRequest(input *GetLoggingConfigurationInput) (req *request.Request, output *GetLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetLoggingConfiguration",
	}

	if input == nil {
		input = &GetLoggingConfigurationInput{}
	}

	output = &GetLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggingConfiguration API operation for Amazon Interactive Video Service Chat.
//
// Gets the specified logging configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation GetLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/GetLoggingConfiguration
func (c *Ivschat) GetLoggingConfiguration(input *GetLoggingConfigurationInput) (*GetLoggingConfigurationOutput, error) {
	req, out := c.GetLoggingConfigurationRequest(input)
	return out, req.Send()
}

// GetLoggingConfigurationWithContext is the same as GetLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) GetLoggingConfigurationWithContext(ctx aws.Context, input *GetLoggingConfigurationInput, opts ...request.Option) (*GetLoggingConfigurationOutput, error) {
	req, out := c.GetLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRoom = "GetRoom"

// GetRoomRequest generates a "aws/request.Request" representing the
// client's request for the GetRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoom for more information on using the GetRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRoomRequest method.
//	req, resp := client.GetRoomRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/GetRoom
func (c *Ivschat) GetRoomRequest(input *GetRoomInput) (req *request.Request, output *GetRoomOutput) {
	op := &request.Operation{
		Name:       opGetRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/GetRoom",
	}

	if input == nil {
		input = &GetRoomInput{}
	}

	output = &GetRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoom API operation for Amazon Interactive Video Service Chat.
//
// Gets the specified room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation GetRoom for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/GetRoom
func (c *Ivschat) GetRoom(input *GetRoomInput) (*GetRoomOutput, error) {
	req, out := c.GetRoomRequest(input)
	return out, req.Send()
}

// GetRoomWithContext is the same as GetRoom with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) GetRoomWithContext(ctx aws.Context, input *GetRoomInput, opts ...request.Option) (*GetRoomOutput, error) {
	req, out := c.GetRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLoggingConfigurations = "ListLoggingConfigurations"

// ListLoggingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListLoggingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLoggingConfigurations for more information on using the ListLoggingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLoggingConfigurationsRequest method.
//	req, resp := client.ListLoggingConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/ListLoggingConfigurations
func (c *Ivschat) ListLoggingConfigurationsRequest(input *ListLoggingConfigurationsInput) (req *request.Request, output *ListLoggingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListLoggingConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/ListLoggingConfigurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLoggingConfigurationsInput{}
	}

	output = &ListLoggingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLoggingConfigurations API operation for Amazon Interactive Video Service Chat.
//
// Gets summary information about all your logging configurations in the AWS
// region where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation ListLoggingConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/ListLoggingConfigurations
func (c *Ivschat) ListLoggingConfigurations(input *ListLoggingConfigurationsInput) (*ListLoggingConfigurationsOutput, error) {
	req, out := c.ListLoggingConfigurationsRequest(input)
	return out, req.Send()
}

// ListLoggingConfigurationsWithContext is the same as ListLoggingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListLoggingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) ListLoggingConfigurationsWithContext(ctx aws.Context, input *ListLoggingConfigurationsInput, opts ...request.Option) (*ListLoggingConfigurationsOutput, error) {
	req, out := c.ListLoggingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLoggingConfigurationsPages iterates over the pages of a ListLoggingConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLoggingConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLoggingConfigurations operation.
//	pageNum := 0
//	err := client.ListLoggingConfigurationsPages(params,
//	    func(page *ivschat.ListLoggingConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Ivschat) ListLoggingConfigurationsPages(input *ListLoggingConfigurationsInput, fn func(*ListLoggingConfigurationsOutput, bool) bool) error {
	return c.ListLoggingConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLoggingConfigurationsPagesWithContext same as ListLoggingConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) ListLoggingConfigurationsPagesWithContext(ctx aws.Context, input *ListLoggingConfigurationsInput, fn func(*ListLoggingConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLoggingConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLoggingConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLoggingConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRooms = "ListRooms"

// ListRoomsRequest generates a "aws/request.Request" representing the
// client's request for the ListRooms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRooms for more information on using the ListRooms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRoomsRequest method.
//	req, resp := client.ListRoomsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/ListRooms
func (c *Ivschat) ListRoomsRequest(input *ListRoomsInput) (req *request.Request, output *ListRoomsOutput) {
	op := &request.Operation{
		Name:       opListRooms,
		HTTPMethod: "POST",
		HTTPPath:   "/ListRooms",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoomsInput{}
	}

	output = &ListRoomsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRooms API operation for Amazon Interactive Video Service Chat.
//
// Gets summary information about all your rooms in the AWS region where the
// API request is processed. Results are sorted in descending order of updateTime.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation ListRooms for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/ListRooms
func (c *Ivschat) ListRooms(input *ListRoomsInput) (*ListRoomsOutput, error) {
	req, out := c.ListRoomsRequest(input)
	return out, req.Send()
}

// ListRoomsWithContext is the same as ListRooms with the addition of
// the ability to pass a context and additional request options.
//
// See ListRooms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) ListRoomsWithContext(ctx aws.Context, input *ListRoomsInput, opts ...request.Option) (*ListRoomsOutput, error) {
	req, out := c.ListRoomsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoomsPages iterates over the pages of a ListRooms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRooms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRooms operation.
//	pageNum := 0
//	err := client.ListRoomsPages(params,
//	    func(page *ivschat.ListRoomsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Ivschat) ListRoomsPages(input *ListRoomsInput, fn func(*ListRoomsOutput, bool) bool) error {
	return c.ListRoomsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoomsPagesWithContext same as ListRoomsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) ListRoomsPagesWithContext(ctx aws.Context, input *ListRoomsInput, fn func(*ListRoomsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoomsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoomsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoomsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/ListTagsForResource
func (c *Ivschat) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Interactive Video Service Chat.
//
// Gets information about AWS tags for the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/ListTagsForResource
func (c *Ivschat) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendEvent = "SendEvent"

// SendEventRequest generates a "aws/request.Request" representing the
// client's request for the SendEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendEvent for more information on using the SendEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendEventRequest method.
//	req, resp := client.SendEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/SendEvent
func (c *Ivschat) SendEventRequest(input *SendEventInput) (req *request.Request, output *SendEventOutput) {
	op := &request.Operation{
		Name:       opSendEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/SendEvent",
	}

	if input == nil {
		input = &SendEventInput{}
	}

	output = &SendEventOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendEvent API operation for Amazon Interactive Video Service Chat.
//
// Sends an event to a room. Use this within your application’s business logic
// to send events to clients of a room; e.g., to notify clients to change the
// way the chat UI is rendered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation SendEvent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - PendingVerification
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/SendEvent
func (c *Ivschat) SendEvent(input *SendEventInput) (*SendEventOutput, error) {
	req, out := c.SendEventRequest(input)
	return out, req.Send()
}

// SendEventWithContext is the same as SendEvent with the addition of
// the ability to pass a context and additional request options.
//
// See SendEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) SendEventWithContext(ctx aws.Context, input *SendEventInput, opts ...request.Option) (*SendEventOutput, error) {
	req, out := c.SendEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/TagResource
func (c *Ivschat) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Interactive Video Service Chat.
//
// Adds or updates tags for the AWS resource with the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/TagResource
func (c *Ivschat) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/UntagResource
func (c *Ivschat) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Interactive Video Service Chat.
//
// Removes tags from the resource with the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/UntagResource
func (c *Ivschat) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLoggingConfiguration = "UpdateLoggingConfiguration"

// UpdateLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLoggingConfiguration for more information on using the UpdateLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLoggingConfigurationRequest method.
//	req, resp := client.UpdateLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/UpdateLoggingConfiguration
func (c *Ivschat) UpdateLoggingConfigurationRequest(input *UpdateLoggingConfigurationInput) (req *request.Request, output *UpdateLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateLoggingConfiguration",
	}

	if input == nil {
		input = &UpdateLoggingConfigurationInput{}
	}

	output = &UpdateLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLoggingConfiguration API operation for Amazon Interactive Video Service Chat.
//
// Updates a specified logging configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation UpdateLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - PendingVerification
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/UpdateLoggingConfiguration
func (c *Ivschat) UpdateLoggingConfiguration(input *UpdateLoggingConfigurationInput) (*UpdateLoggingConfigurationOutput, error) {
	req, out := c.UpdateLoggingConfigurationRequest(input)
	return out, req.Send()
}

// UpdateLoggingConfigurationWithContext is the same as UpdateLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) UpdateLoggingConfigurationWithContext(ctx aws.Context, input *UpdateLoggingConfigurationInput, opts ...request.Option) (*UpdateLoggingConfigurationOutput, error) {
	req, out := c.UpdateLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoom = "UpdateRoom"

// UpdateRoomRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoom for more information on using the UpdateRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRoomRequest method.
//	req, resp := client.UpdateRoomRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/UpdateRoom
func (c *Ivschat) UpdateRoomRequest(input *UpdateRoomInput) (req *request.Request, output *UpdateRoomOutput) {
	op := &request.Operation{
		Name:       opUpdateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateRoom",
	}

	if input == nil {
		input = &UpdateRoomInput{}
	}

	output = &UpdateRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoom API operation for Amazon Interactive Video Service Chat.
//
// Updates a room’s configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service Chat's
// API operation UpdateRoom for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//
//   - ResourceNotFoundException
//
//   - PendingVerification
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/UpdateRoom
func (c *Ivschat) UpdateRoom(input *UpdateRoomInput) (*UpdateRoomOutput, error) {
	req, out := c.UpdateRoomRequest(input)
	return out, req.Send()
}

// UpdateRoomWithContext is the same as UpdateRoom with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Ivschat) UpdateRoomWithContext(ctx aws.Context, input *UpdateRoomInput, opts ...request.Option) (*UpdateRoomOutput, error) {
	req, out := c.UpdateRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies a CloudWatch Logs location where chat logs will be stored.
type CloudWatchLogsDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// Name of the Amazon Cloudwatch Logs destination where chat activity will be
	// logged.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogsDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLogsDestinationConfiguration"}
	if s.LogGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CloudWatchLogsDestinationConfiguration) SetLogGroupName(v string) *CloudWatchLogsDestinationConfiguration {
	s.LogGroupName = &v
	return s
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateChatTokenInput struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the token and attach to a
	// chat session. Map keys and values can contain UTF-8 encoded text. The maximum
	// length of this field is 1 KB total.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Set of capabilities that the user is allowed to perform in the room. Default:
	// None (the capability to view messages is implicitly included in all requests).
	Capabilities []*string `locationName:"capabilities" type:"list" enum:"ChatTokenCapability"`

	// Identifier of the room that the client is trying to access. Currently this
	// must be an ARN.
	//
	// RoomIdentifier is a required field
	RoomIdentifier *string `locationName:"roomIdentifier" min:"1" type:"string" required:"true"`

	// Session duration (in minutes), after which the session expires. Default:
	// 60 (1 hour).
	SessionDurationInMinutes *int64 `locationName:"sessionDurationInMinutes" min:"1" type:"integer"`

	// Application-provided ID that uniquely identifies the user associated with
	// this token. This can be any UTF-8 encoded text.
	//
	// UserId is a required field
	UserId *string `locationName:"userId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChatTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChatTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChatTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChatTokenInput"}
	if s.RoomIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomIdentifier"))
	}
	if s.RoomIdentifier != nil && len(*s.RoomIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomIdentifier", 1))
	}
	if s.SessionDurationInMinutes != nil && *s.SessionDurationInMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SessionDurationInMinutes", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreateChatTokenInput) SetAttributes(v map[string]*string) *CreateChatTokenInput {
	s.Attributes = v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateChatTokenInput) SetCapabilities(v []*string) *CreateChatTokenInput {
	s.Capabilities = v
	return s
}

// SetRoomIdentifier sets the RoomIdentifier field's value.
func (s *CreateChatTokenInput) SetRoomIdentifier(v string) *CreateChatTokenInput {
	s.RoomIdentifier = &v
	return s
}

// SetSessionDurationInMinutes sets the SessionDurationInMinutes field's value.
func (s *CreateChatTokenInput) SetSessionDurationInMinutes(v int64) *CreateChatTokenInput {
	s.SessionDurationInMinutes = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateChatTokenInput) SetUserId(v string) *CreateChatTokenInput {
	s.UserId = &v
	return s
}

type CreateChatTokenOutput struct {
	_ struct{} `type:"structure"`

	// Time after which an end user's session is no longer valid. This is an ISO
	// 8601 timestamp; note that this is returned as a string.
	SessionExpirationTime *time.Time `locationName:"sessionExpirationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The issued client token, encrypted.
	Token *string `locationName:"token" type:"string"`

	// Time after which the token is no longer valid and cannot be used to connect
	// to a room. This is an ISO 8601 timestamp; note that this is returned as a
	// string.
	TokenExpirationTime *time.Time `locationName:"tokenExpirationTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChatTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChatTokenOutput) GoString() string {
	return s.String()
}

// SetSessionExpirationTime sets the SessionExpirationTime field's value.
func (s *CreateChatTokenOutput) SetSessionExpirationTime(v time.Time) *CreateChatTokenOutput {
	s.SessionExpirationTime = &v
	return s
}

// SetToken sets the Token field's value.
func (s *CreateChatTokenOutput) SetToken(v string) *CreateChatTokenOutput {
	s.Token = &v
	return s
}

// SetTokenExpirationTime sets the TokenExpirationTime field's value.
func (s *CreateChatTokenOutput) SetTokenExpirationTime(v time.Time) *CreateChatTokenOutput {
	s.TokenExpirationTime = &v
	return s
}

type CreateLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a destination configuration for where chat content
	// will be logged. There can be only one type of destination (cloudWatchLogs,
	// firehose, or s3) in a destinationConfiguration.
	//
	// DestinationConfiguration is a required field
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure" required:"true"`

	// Logging-configuration name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// Tags to attach to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS Chat has no constraints on tags beyond what
	// is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLoggingConfigurationInput"}
	if s.DestinationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationConfiguration"))
	}
	if s.DestinationConfiguration != nil {
		if err := s.DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *CreateLoggingConfigurationInput) SetDestinationConfiguration(v *DestinationConfiguration) *CreateLoggingConfigurationInput {
	s.DestinationConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLoggingConfigurationInput) SetName(v string) *CreateLoggingConfigurationInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLoggingConfigurationInput) SetTags(v map[string]*string) *CreateLoggingConfigurationInput {
	s.Tags = v
	return s
}

type CreateLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Logging-configuration ARN, assigned by the system.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Time when the logging configuration was created. This is an ISO 8601 timestamp;
	// note that this is returned as a string.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// A complex type that contains a destination configuration for where chat content
	// will be logged, from the request. There is only one type of destination (cloudWatchLogs,
	// firehose, or s3) in a destinationConfiguration.
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure"`

	// Logging-configuration ID, generated by the system. This is a relative identifier,
	// the part of the ARN that uniquely identifies the logging configuration.
	Id *string `locationName:"id" min:"12" type:"string"`

	// Logging-configuration name, from the request (if specified).
	Name *string `locationName:"name" type:"string"`

	// The state of the logging configuration. When the state is ACTIVE, the configuration
	// is ready to log chat content.
	State *string `locationName:"state" type:"string" enum:"CreateLoggingConfigurationState"`

	// Tags attached to the resource, from the request (if specified). Array of
	// maps, each of the form string:string (key:value).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Time of the logging configuration’s last update. This is an ISO 8601 timestamp;
	// note that this is returned as a string.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateLoggingConfigurationOutput) SetArn(v string) *CreateLoggingConfigurationOutput {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreateLoggingConfigurationOutput) SetCreateTime(v time.Time) *CreateLoggingConfigurationOutput {
	s.CreateTime = &v
	return s
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *CreateLoggingConfigurationOutput) SetDestinationConfiguration(v *DestinationConfiguration) *CreateLoggingConfigurationOutput {
	s.DestinationConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateLoggingConfigurationOutput) SetId(v string) *CreateLoggingConfigurationOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLoggingConfigurationOutput) SetName(v string) *CreateLoggingConfigurationOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateLoggingConfigurationOutput) SetState(v string) *CreateLoggingConfigurationOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLoggingConfigurationOutput) SetTags(v map[string]*string) *CreateLoggingConfigurationOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *CreateLoggingConfigurationOutput) SetUpdateTime(v time.Time) *CreateLoggingConfigurationOutput {
	s.UpdateTime = &v
	return s
}

type CreateRoomInput struct {
	_ struct{} `type:"structure"`

	// Array of logging-configuration identifiers attached to the room.
	LoggingConfigurationIdentifiers []*string `locationName:"loggingConfigurationIdentifiers" type:"list"`

	// Maximum number of characters in a single message. Messages are expected to
	// be UTF-8 encoded and this limit applies specifically to rune/code-point count,
	// not number of bytes. Default: 500.
	MaximumMessageLength *int64 `locationName:"maximumMessageLength" min:"1" type:"integer"`

	// Maximum number of messages per second that can be sent to the room (by all
	// clients). Default: 10.
	MaximumMessageRatePerSecond *int64 `locationName:"maximumMessageRatePerSecond" min:"1" type:"integer"`

	// Configuration information for optional review of messages.
	MessageReviewHandler *MessageReviewHandler `locationName:"messageReviewHandler" type:"structure"`

	// Room name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// Tags to attach to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS Chat has no constraints beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRoomInput"}
	if s.MaximumMessageLength != nil && *s.MaximumMessageLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumMessageLength", 1))
	}
	if s.MaximumMessageRatePerSecond != nil && *s.MaximumMessageRatePerSecond < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumMessageRatePerSecond", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingConfigurationIdentifiers sets the LoggingConfigurationIdentifiers field's value.
func (s *CreateRoomInput) SetLoggingConfigurationIdentifiers(v []*string) *CreateRoomInput {
	s.LoggingConfigurationIdentifiers = v
	return s
}

// SetMaximumMessageLength sets the MaximumMessageLength field's value.
func (s *CreateRoomInput) SetMaximumMessageLength(v int64) *CreateRoomInput {
	s.MaximumMessageLength = &v
	return s
}

// SetMaximumMessageRatePerSecond sets the MaximumMessageRatePerSecond field's value.
func (s *CreateRoomInput) SetMaximumMessageRatePerSecond(v int64) *CreateRoomInput {
	s.MaximumMessageRatePerSecond = &v
	return s
}

// SetMessageReviewHandler sets the MessageReviewHandler field's value.
func (s *CreateRoomInput) SetMessageReviewHandler(v *MessageReviewHandler) *CreateRoomInput {
	s.MessageReviewHandler = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRoomInput) SetName(v string) *CreateRoomInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRoomInput) SetTags(v map[string]*string) *CreateRoomInput {
	s.Tags = v
	return s
}

type CreateRoomOutput struct {
	_ struct{} `type:"structure"`

	// Room ARN, assigned by the system.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Time when the room was created. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// Room ID, generated by the system. This is a relative identifier, the part
	// of the ARN that uniquely identifies the room.
	Id *string `locationName:"id" min:"12" type:"string"`

	// Array of logging configurations attached to the room, from the request (if
	// specified).
	LoggingConfigurationIdentifiers []*string `locationName:"loggingConfigurationIdentifiers" type:"list"`

	// Maximum number of characters in a single message, from the request (if specified).
	MaximumMessageLength *int64 `locationName:"maximumMessageLength" min:"1" type:"integer"`

	// Maximum number of messages per second that can be sent to the room (by all
	// clients), from the request (if specified).
	MaximumMessageRatePerSecond *int64 `locationName:"maximumMessageRatePerSecond" min:"1" type:"integer"`

	// Configuration information for optional review of messages.
	MessageReviewHandler *MessageReviewHandler `locationName:"messageReviewHandler" type:"structure"`

	// Room name, from the request (if specified).
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource, from the request (if specified).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Time of the room’s last update. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoomOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateRoomOutput) SetArn(v string) *CreateRoomOutput {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreateRoomOutput) SetCreateTime(v time.Time) *CreateRoomOutput {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateRoomOutput) SetId(v string) *CreateRoomOutput {
	s.Id = &v
	return s
}

// SetLoggingConfigurationIdentifiers sets the LoggingConfigurationIdentifiers field's value.
func (s *CreateRoomOutput) SetLoggingConfigurationIdentifiers(v []*string) *CreateRoomOutput {
	s.LoggingConfigurationIdentifiers = v
	return s
}

// SetMaximumMessageLength sets the MaximumMessageLength field's value.
func (s *CreateRoomOutput) SetMaximumMessageLength(v int64) *CreateRoomOutput {
	s.MaximumMessageLength = &v
	return s
}

// SetMaximumMessageRatePerSecond sets the MaximumMessageRatePerSecond field's value.
func (s *CreateRoomOutput) SetMaximumMessageRatePerSecond(v int64) *CreateRoomOutput {
	s.MaximumMessageRatePerSecond = &v
	return s
}

// SetMessageReviewHandler sets the MessageReviewHandler field's value.
func (s *CreateRoomOutput) SetMessageReviewHandler(v *MessageReviewHandler) *CreateRoomOutput {
	s.MessageReviewHandler = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRoomOutput) SetName(v string) *CreateRoomOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRoomOutput) SetTags(v map[string]*string) *CreateRoomOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *CreateRoomOutput) SetUpdateTime(v time.Time) *CreateRoomOutput {
	s.UpdateTime = &v
	return s
}

type DeleteLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the logging configuration to be deleted.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoggingConfigurationInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteLoggingConfigurationInput) SetIdentifier(v string) *DeleteLoggingConfigurationInput {
	s.Identifier = &v
	return s
}

type DeleteLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLoggingConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteMessageInput struct {
	_ struct{} `type:"structure"`

	// ID of the message to be deleted. This is the Id field in the received message
	// (see Message (Subscribe) (https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-message-subscribe.html)
	// in the Chat Messaging API).
	//
	// Id is a required field
	Id *string `locationName:"id" min:"12" type:"string" required:"true"`

	// Reason for deleting the message.
	Reason *string `locationName:"reason" min:"1" type:"string"`

	// Identifier of the room where the message should be deleted. Currently this
	// must be an ARN.
	//
	// RoomIdentifier is a required field
	RoomIdentifier *string `locationName:"roomIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMessageInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 12))
	}
	if s.Reason != nil && len(*s.Reason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Reason", 1))
	}
	if s.RoomIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomIdentifier"))
	}
	if s.RoomIdentifier != nil && len(*s.RoomIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteMessageInput) SetId(v string) *DeleteMessageInput {
	s.Id = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *DeleteMessageInput) SetReason(v string) *DeleteMessageInput {
	s.Reason = &v
	return s
}

// SetRoomIdentifier sets the RoomIdentifier field's value.
func (s *DeleteMessageInput) SetRoomIdentifier(v string) *DeleteMessageInput {
	s.RoomIdentifier = &v
	return s
}

type DeleteMessageOutput struct {
	_ struct{} `type:"structure"`

	// Operation identifier, generated by Amazon IVS Chat.
	Id *string `locationName:"id" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMessageOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DeleteMessageOutput) SetId(v string) *DeleteMessageOutput {
	s.Id = &v
	return s
}

type DeleteRoomInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the room to be deleted. Currently this must be an ARN.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRoomInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteRoomInput) SetIdentifier(v string) *DeleteRoomInput {
	s.Identifier = &v
	return s
}

type DeleteRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomOutput) GoString() string {
	return s.String()
}

// A complex type that describes a location where chat logs will be stored.
// Each member represents the configuration of one log destination. For logging,
// you define only one type of destination (for CloudWatch Logs, Kinesis Firehose,
// or S3).
type DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// An Amazon CloudWatch Logs destination configuration where chat activity will
	// be logged.
	CloudWatchLogs *CloudWatchLogsDestinationConfiguration `locationName:"cloudWatchLogs" type:"structure"`

	// An Amazon Kinesis Data Firehose destination configuration where chat activity
	// will be logged.
	Firehose *FirehoseDestinationConfiguration `locationName:"firehose" type:"structure"`

	// An Amazon S3 destination configuration where chat activity will be logged.
	S3 *S3DestinationConfiguration `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationConfiguration"}
	if s.CloudWatchLogs != nil {
		if err := s.CloudWatchLogs.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.Firehose != nil {
		if err := s.Firehose.Validate(); err != nil {
			invalidParams.AddNested("Firehose", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *DestinationConfiguration) SetCloudWatchLogs(v *CloudWatchLogsDestinationConfiguration) *DestinationConfiguration {
	s.CloudWatchLogs = v
	return s
}

// SetFirehose sets the Firehose field's value.
func (s *DestinationConfiguration) SetFirehose(v *FirehoseDestinationConfiguration) *DestinationConfiguration {
	s.Firehose = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *DestinationConfiguration) SetS3(v *S3DestinationConfiguration) *DestinationConfiguration {
	s.S3 = v
	return s
}

type DisconnectUserInput struct {
	_ struct{} `type:"structure"`

	// Reason for disconnecting the user.
	Reason *string `locationName:"reason" min:"1" type:"string"`

	// Identifier of the room from which the user's clients should be disconnected.
	// Currently this must be an ARN.
	//
	// RoomIdentifier is a required field
	RoomIdentifier *string `locationName:"roomIdentifier" min:"1" type:"string" required:"true"`

	// ID of the user (connection) to disconnect from the room.
	//
	// UserId is a required field
	UserId *string `locationName:"userId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectUserInput"}
	if s.Reason != nil && len(*s.Reason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Reason", 1))
	}
	if s.RoomIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomIdentifier"))
	}
	if s.RoomIdentifier != nil && len(*s.RoomIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomIdentifier", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReason sets the Reason field's value.
func (s *DisconnectUserInput) SetReason(v string) *DisconnectUserInput {
	s.Reason = &v
	return s
}

// SetRoomIdentifier sets the RoomIdentifier field's value.
func (s *DisconnectUserInput) SetRoomIdentifier(v string) *DisconnectUserInput {
	s.RoomIdentifier = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DisconnectUserInput) SetUserId(v string) *DisconnectUserInput {
	s.UserId = &v
	return s
}

type DisconnectUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectUserOutput) GoString() string {
	return s.String()
}

// Specifies a Kinesis Firehose location where chat logs will be stored.
type FirehoseDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// Name of the Amazon Kinesis Firehose delivery stream where chat activity will
	// be logged.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `locationName:"deliveryStreamName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FirehoseDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FirehoseDestinationConfiguration"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *FirehoseDestinationConfiguration) SetDeliveryStreamName(v string) *FirehoseDestinationConfiguration {
	s.DeliveryStreamName = &v
	return s
}

type GetLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the logging configuration to be retrieved.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLoggingConfigurationInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetLoggingConfigurationInput) SetIdentifier(v string) *GetLoggingConfigurationInput {
	s.Identifier = &v
	return s
}

type GetLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Logging-configuration ARN, from the request (if identifier was an ARN).
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Time when the logging configuration was created. This is an ISO 8601 timestamp;
	// note that this is returned as a string.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// A complex type that contains a destination configuration for where chat content
	// will be logged. There is only one type of destination (cloudWatchLogs, firehose,
	// or s3) in a destinationConfiguration.
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure"`

	// Logging-configuration ID, generated by the system. This is a relative identifier,
	// the part of the ARN that uniquely identifies the logging configuration.
	Id *string `locationName:"id" min:"12" type:"string"`

	// Logging-configuration name. This value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// The state of the logging configuration. When the state is ACTIVE, the configuration
	// is ready to log chat content.
	State *string `locationName:"state" type:"string" enum:"LoggingConfigurationState"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Time of the logging configuration’s last update. This is an ISO 8601 timestamp;
	// note that this is returned as a string.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetLoggingConfigurationOutput) SetArn(v string) *GetLoggingConfigurationOutput {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetLoggingConfigurationOutput) SetCreateTime(v time.Time) *GetLoggingConfigurationOutput {
	s.CreateTime = &v
	return s
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *GetLoggingConfigurationOutput) SetDestinationConfiguration(v *DestinationConfiguration) *GetLoggingConfigurationOutput {
	s.DestinationConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *GetLoggingConfigurationOutput) SetId(v string) *GetLoggingConfigurationOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetLoggingConfigurationOutput) SetName(v string) *GetLoggingConfigurationOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *GetLoggingConfigurationOutput) SetState(v string) *GetLoggingConfigurationOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetLoggingConfigurationOutput) SetTags(v map[string]*string) *GetLoggingConfigurationOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetLoggingConfigurationOutput) SetUpdateTime(v time.Time) *GetLoggingConfigurationOutput {
	s.UpdateTime = &v
	return s
}

type GetRoomInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the room for which the configuration is to be retrieved. Currently
	// this must be an ARN.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRoomInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetRoomInput) SetIdentifier(v string) *GetRoomInput {
	s.Identifier = &v
	return s
}

type GetRoomOutput struct {
	_ struct{} `type:"structure"`

	// Room ARN, from the request (if identifier was an ARN).
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Time when the room was created. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// Room ID, generated by the system. This is a relative identifier, the part
	// of the ARN that uniquely identifies the room.
	Id *string `locationName:"id" min:"12" type:"string"`

	// Array of logging configurations attached to the room.
	LoggingConfigurationIdentifiers []*string `locationName:"loggingConfigurationIdentifiers" type:"list"`

	// Maximum number of characters in a single message. Messages are expected to
	// be UTF-8 encoded and this limit applies specifically to rune/code-point count,
	// not number of bytes. Default: 500.
	MaximumMessageLength *int64 `locationName:"maximumMessageLength" min:"1" type:"integer"`

	// Maximum number of messages per second that can be sent to the room (by all
	// clients). Default: 10.
	MaximumMessageRatePerSecond *int64 `locationName:"maximumMessageRatePerSecond" min:"1" type:"integer"`

	// Configuration information for optional review of messages.
	MessageReviewHandler *MessageReviewHandler `locationName:"messageReviewHandler" type:"structure"`

	// Room name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Time of the room’s last update. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetRoomOutput) SetArn(v string) *GetRoomOutput {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetRoomOutput) SetCreateTime(v time.Time) *GetRoomOutput {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetRoomOutput) SetId(v string) *GetRoomOutput {
	s.Id = &v
	return s
}

// SetLoggingConfigurationIdentifiers sets the LoggingConfigurationIdentifiers field's value.
func (s *GetRoomOutput) SetLoggingConfigurationIdentifiers(v []*string) *GetRoomOutput {
	s.LoggingConfigurationIdentifiers = v
	return s
}

// SetMaximumMessageLength sets the MaximumMessageLength field's value.
func (s *GetRoomOutput) SetMaximumMessageLength(v int64) *GetRoomOutput {
	s.MaximumMessageLength = &v
	return s
}

// SetMaximumMessageRatePerSecond sets the MaximumMessageRatePerSecond field's value.
func (s *GetRoomOutput) SetMaximumMessageRatePerSecond(v int64) *GetRoomOutput {
	s.MaximumMessageRatePerSecond = &v
	return s
}

// SetMessageReviewHandler sets the MessageReviewHandler field's value.
func (s *GetRoomOutput) SetMessageReviewHandler(v *MessageReviewHandler) *GetRoomOutput {
	s.MessageReviewHandler = v
	return s
}

// SetName sets the Name field's value.
func (s *GetRoomOutput) SetName(v string) *GetRoomOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetRoomOutput) SetTags(v map[string]*string) *GetRoomOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetRoomOutput) SetUpdateTime(v time.Time) *GetRoomOutput {
	s.UpdateTime = &v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListLoggingConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of logging configurations to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first logging configurations to retrieve. This is used for pagination;
	// see the nextToken response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLoggingConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLoggingConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLoggingConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLoggingConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLoggingConfigurationsInput) SetMaxResults(v int64) *ListLoggingConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLoggingConfigurationsInput) SetNextToken(v string) *ListLoggingConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListLoggingConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// List of the matching logging configurations (summary information only). There
	// is only one type of destination (cloudWatchLogs, firehose, or s3) in a destinationConfiguration.
	//
	// LoggingConfigurations is a required field
	LoggingConfigurations []*LoggingConfigurationSummary `locationName:"loggingConfigurations" type:"list" required:"true"`

	// If there are more logging configurations than maxResults, use nextToken in
	// the request to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLoggingConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLoggingConfigurationsOutput) GoString() string {
	return s.String()
}

// SetLoggingConfigurations sets the LoggingConfigurations field's value.
func (s *ListLoggingConfigurationsOutput) SetLoggingConfigurations(v []*LoggingConfigurationSummary) *ListLoggingConfigurationsOutput {
	s.LoggingConfigurations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLoggingConfigurationsOutput) SetNextToken(v string) *ListLoggingConfigurationsOutput {
	s.NextToken = &v
	return s
}

type ListRoomsInput struct {
	_ struct{} `type:"structure"`

	// Logging-configuration identifier.
	LoggingConfigurationIdentifier *string `locationName:"loggingConfigurationIdentifier" min:"1" type:"string"`

	// Maximum number of rooms to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Filters the list to match the specified message review handler URI.
	MessageReviewHandlerUri *string `locationName:"messageReviewHandlerUri" type:"string"`

	// Filters the list to match the specified room name.
	Name *string `locationName:"name" type:"string"`

	// The first room to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoomsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoomsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoomsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoomsInput"}
	if s.LoggingConfigurationIdentifier != nil && len(*s.LoggingConfigurationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LoggingConfigurationIdentifier", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingConfigurationIdentifier sets the LoggingConfigurationIdentifier field's value.
func (s *ListRoomsInput) SetLoggingConfigurationIdentifier(v string) *ListRoomsInput {
	s.LoggingConfigurationIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRoomsInput) SetMaxResults(v int64) *ListRoomsInput {
	s.MaxResults = &v
	return s
}

// SetMessageReviewHandlerUri sets the MessageReviewHandlerUri field's value.
func (s *ListRoomsInput) SetMessageReviewHandlerUri(v string) *ListRoomsInput {
	s.MessageReviewHandlerUri = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListRoomsInput) SetName(v string) *ListRoomsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoomsInput) SetNextToken(v string) *ListRoomsInput {
	s.NextToken = &v
	return s
}

type ListRoomsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more rooms than maxResults, use nextToken in the request to
	// get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of the matching rooms (summary information only).
	//
	// Rooms is a required field
	Rooms []*RoomSummary `locationName:"rooms" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoomsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoomsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoomsOutput) SetNextToken(v string) *ListRoomsOutput {
	s.NextToken = &v
	return s
}

// SetRooms sets the Rooms field's value.
func (s *ListRoomsOutput) SetRooms(v []*RoomSummary) *ListRoomsOutput {
	s.Rooms = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource to be retrieved. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value).
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Summary information about a logging configuration.
type LoggingConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// Logging-configuration ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Time when the logging configuration was created. This is an ISO 8601 timestamp;
	// note that this is returned as a string.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// A complex type that contains a destination configuration for where chat content
	// will be logged.
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure"`

	// Logging-configuration ID, generated by the system. This is a relative identifier,
	// the part of the ARN that uniquely identifies the room.
	Id *string `locationName:"id" min:"12" type:"string"`

	// Logging-configuration name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// The state of the logging configuration. When this is ACTIVE, the configuration
	// is ready for logging chat content.
	State *string `locationName:"state" type:"string" enum:"LoggingConfigurationState"`

	// Tags to attach to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS Chat has no constraints on tags beyond what
	// is documented there.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Time of the logging configuration’s last update. This is an ISO 8601 timestamp;
	// note that this is returned as a string.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfigurationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *LoggingConfigurationSummary) SetArn(v string) *LoggingConfigurationSummary {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *LoggingConfigurationSummary) SetCreateTime(v time.Time) *LoggingConfigurationSummary {
	s.CreateTime = &v
	return s
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *LoggingConfigurationSummary) SetDestinationConfiguration(v *DestinationConfiguration) *LoggingConfigurationSummary {
	s.DestinationConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *LoggingConfigurationSummary) SetId(v string) *LoggingConfigurationSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *LoggingConfigurationSummary) SetName(v string) *LoggingConfigurationSummary {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *LoggingConfigurationSummary) SetState(v string) *LoggingConfigurationSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *LoggingConfigurationSummary) SetTags(v map[string]*string) *LoggingConfigurationSummary {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *LoggingConfigurationSummary) SetUpdateTime(v time.Time) *LoggingConfigurationSummary {
	s.UpdateTime = &v
	return s
}

// Configuration information for optional message review.
type MessageReviewHandler struct {
	_ struct{} `type:"structure"`

	// Specifies the fallback behavior (whether the message is allowed or denied)
	// if the handler does not return a valid response, encounters an error, or
	// times out. (For the timeout period, see Service Quotas (https://docs.aws.amazon.com/ivs/latest/userguide/service-quotas.html).)
	// If allowed, the message is delivered with returned content to all users connected
	// to the room. If denied, the message is not delivered to any user. Default:
	// ALLOW.
	FallbackResult *string `locationName:"fallbackResult" type:"string" enum:"FallbackResult"`

	// Identifier of the message review handler. Currently this must be an ARN of
	// a lambda function.
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageReviewHandler) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageReviewHandler) GoString() string {
	return s.String()
}

// SetFallbackResult sets the FallbackResult field's value.
func (s *MessageReviewHandler) SetFallbackResult(v string) *MessageReviewHandler {
	s.FallbackResult = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *MessageReviewHandler) SetUri(v string) *MessageReviewHandler {
	s.Uri = &v
	return s
}

type PendingVerification struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingVerification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingVerification) GoString() string {
	return s.String()
}

func newErrorPendingVerification(v protocol.ResponseMetadata) error {
	return &PendingVerification{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PendingVerification) Code() string {
	return "PendingVerification"
}

// Message returns the exception's message.
func (s *PendingVerification) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PendingVerification) OrigErr() error {
	return nil
}

func (s *PendingVerification) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PendingVerification) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PendingVerification) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Summary information about a room.
type RoomSummary struct {
	_ struct{} `type:"structure"`

	// Room ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Time when the room was created. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// Room ID, generated by the system. This is a relative identifier, the part
	// of the ARN that uniquely identifies the room.
	Id *string `locationName:"id" min:"12" type:"string"`

	// List of logging-configuration identifiers attached to the room.
	LoggingConfigurationIdentifiers []*string `locationName:"loggingConfigurationIdentifiers" type:"list"`

	// Configuration information for optional review of messages.
	MessageReviewHandler *MessageReviewHandler `locationName:"messageReviewHandler" type:"structure"`

	// Room name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS Chat has no constraints beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Time of the room’s last update. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoomSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoomSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RoomSummary) SetArn(v string) *RoomSummary {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *RoomSummary) SetCreateTime(v time.Time) *RoomSummary {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *RoomSummary) SetId(v string) *RoomSummary {
	s.Id = &v
	return s
}

// SetLoggingConfigurationIdentifiers sets the LoggingConfigurationIdentifiers field's value.
func (s *RoomSummary) SetLoggingConfigurationIdentifiers(v []*string) *RoomSummary {
	s.LoggingConfigurationIdentifiers = v
	return s
}

// SetMessageReviewHandler sets the MessageReviewHandler field's value.
func (s *RoomSummary) SetMessageReviewHandler(v *MessageReviewHandler) *RoomSummary {
	s.MessageReviewHandler = v
	return s
}

// SetName sets the Name field's value.
func (s *RoomSummary) SetName(v string) *RoomSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RoomSummary) SetTags(v map[string]*string) *RoomSummary {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *RoomSummary) SetUpdateTime(v time.Time) *RoomSummary {
	s.UpdateTime = &v
	return s
}

// Specifies an S3 location where chat logs will be stored.
type S3DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// Name of the Amazon S3 bucket where chat activity will be logged.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DestinationConfiguration"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3DestinationConfiguration) SetBucketName(v string) *S3DestinationConfiguration {
	s.BucketName = &v
	return s
}

type SendEventInput struct {
	_ struct{} `type:"structure"`

	// Application-defined metadata to attach to the event sent to clients. The
	// maximum length of the metadata is 1 KB total.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Application-defined name of the event to send to clients.
	//
	// EventName is a required field
	EventName *string `locationName:"eventName" min:"1" type:"string" required:"true"`

	// Identifier of the room to which the event will be sent. Currently this must
	// be an ARN.
	//
	// RoomIdentifier is a required field
	RoomIdentifier *string `locationName:"roomIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendEventInput"}
	if s.EventName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventName"))
	}
	if s.EventName != nil && len(*s.EventName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventName", 1))
	}
	if s.RoomIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomIdentifier"))
	}
	if s.RoomIdentifier != nil && len(*s.RoomIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *SendEventInput) SetAttributes(v map[string]*string) *SendEventInput {
	s.Attributes = v
	return s
}

// SetEventName sets the EventName field's value.
func (s *SendEventInput) SetEventName(v string) *SendEventInput {
	s.EventName = &v
	return s
}

// SetRoomIdentifier sets the RoomIdentifier field's value.
func (s *SendEventInput) SetRoomIdentifier(v string) *SendEventInput {
	s.RoomIdentifier = &v
	return s
}

type SendEventOutput struct {
	_ struct{} `type:"structure"`

	// An identifier generated by Amazon IVS Chat. This identifier must be used
	// in subsequent operations for this message, such as DeleteMessage.
	Id *string `locationName:"id" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *SendEventOutput) SetId(v string) *SendEventOutput {
	s.Id = &v
	return s
}

type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Limit is a required field
	Limit *int64 `locationName:"limit" type:"integer" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to be tagged. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be added or updated. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS Chat has no constraints beyond what is documented
	// there.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Limit is a required field
	Limit *int64 `locationName:"limit" type:"integer" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource to be untagged. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be removed. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS Chat has no constraints beyond what is documented
	// there.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a destination configuration for where chat content
	// will be logged. There can be only one type of destination (cloudWatchLogs,
	// firehose, or s3) in a destinationConfiguration.
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure"`

	// Identifier of the logging configuration to be updated.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"1" type:"string" required:"true"`

	// Logging-configuration name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLoggingConfigurationInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.DestinationConfiguration != nil {
		if err := s.DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *UpdateLoggingConfigurationInput) SetDestinationConfiguration(v *DestinationConfiguration) *UpdateLoggingConfigurationInput {
	s.DestinationConfiguration = v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *UpdateLoggingConfigurationInput) SetIdentifier(v string) *UpdateLoggingConfigurationInput {
	s.Identifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLoggingConfigurationInput) SetName(v string) *UpdateLoggingConfigurationInput {
	s.Name = &v
	return s
}

type UpdateLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Logging-configuration ARN, from the request (if identifier was an ARN).
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Time when the logging configuration was created. This is an ISO 8601 timestamp;
	// note that this is returned as a string.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// A complex type that contains a destination configuration for where chat content
	// will be logged, from the request. There is only one type of destination (cloudWatchLogs,
	// firehose, or s3) in a destinationConfiguration.
	DestinationConfiguration *DestinationConfiguration `locationName:"destinationConfiguration" type:"structure"`

	// Logging-configuration ID, generated by the system. This is a relative identifier,
	// the part of the ARN that uniquely identifies the room.
	Id *string `locationName:"id" min:"12" type:"string"`

	// Logging-configuration name, from the request (if specified).
	Name *string `locationName:"name" type:"string"`

	// The state of the logging configuration. When the state is ACTIVE, the configuration
	// is ready to log chat content.
	State *string `locationName:"state" type:"string" enum:"UpdateLoggingConfigurationState"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Time of the logging configuration’s last update. This is an ISO 8601 timestamp;
	// note that this is returned as a string.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateLoggingConfigurationOutput) SetArn(v string) *UpdateLoggingConfigurationOutput {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *UpdateLoggingConfigurationOutput) SetCreateTime(v time.Time) *UpdateLoggingConfigurationOutput {
	s.CreateTime = &v
	return s
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *UpdateLoggingConfigurationOutput) SetDestinationConfiguration(v *DestinationConfiguration) *UpdateLoggingConfigurationOutput {
	s.DestinationConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateLoggingConfigurationOutput) SetId(v string) *UpdateLoggingConfigurationOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLoggingConfigurationOutput) SetName(v string) *UpdateLoggingConfigurationOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateLoggingConfigurationOutput) SetState(v string) *UpdateLoggingConfigurationOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateLoggingConfigurationOutput) SetTags(v map[string]*string) *UpdateLoggingConfigurationOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdateLoggingConfigurationOutput) SetUpdateTime(v time.Time) *UpdateLoggingConfigurationOutput {
	s.UpdateTime = &v
	return s
}

type UpdateRoomInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the room to be updated. Currently this must be an ARN.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"1" type:"string" required:"true"`

	// Array of logging-configuration identifiers attached to the room.
	LoggingConfigurationIdentifiers []*string `locationName:"loggingConfigurationIdentifiers" type:"list"`

	// The maximum number of characters in a single message. Messages are expected
	// to be UTF-8 encoded and this limit applies specifically to rune/code-point
	// count, not number of bytes. Default: 500.
	MaximumMessageLength *int64 `locationName:"maximumMessageLength" min:"1" type:"integer"`

	// Maximum number of messages per second that can be sent to the room (by all
	// clients). Default: 10.
	MaximumMessageRatePerSecond *int64 `locationName:"maximumMessageRatePerSecond" min:"1" type:"integer"`

	// Configuration information for optional review of messages. Specify an empty
	// uri string to disassociate a message review handler from the specified room.
	MessageReviewHandler *MessageReviewHandler `locationName:"messageReviewHandler" type:"structure"`

	// Room name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoomInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.MaximumMessageLength != nil && *s.MaximumMessageLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumMessageLength", 1))
	}
	if s.MaximumMessageRatePerSecond != nil && *s.MaximumMessageRatePerSecond < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumMessageRatePerSecond", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *UpdateRoomInput) SetIdentifier(v string) *UpdateRoomInput {
	s.Identifier = &v
	return s
}

// SetLoggingConfigurationIdentifiers sets the LoggingConfigurationIdentifiers field's value.
func (s *UpdateRoomInput) SetLoggingConfigurationIdentifiers(v []*string) *UpdateRoomInput {
	s.LoggingConfigurationIdentifiers = v
	return s
}

// SetMaximumMessageLength sets the MaximumMessageLength field's value.
func (s *UpdateRoomInput) SetMaximumMessageLength(v int64) *UpdateRoomInput {
	s.MaximumMessageLength = &v
	return s
}

// SetMaximumMessageRatePerSecond sets the MaximumMessageRatePerSecond field's value.
func (s *UpdateRoomInput) SetMaximumMessageRatePerSecond(v int64) *UpdateRoomInput {
	s.MaximumMessageRatePerSecond = &v
	return s
}

// SetMessageReviewHandler sets the MessageReviewHandler field's value.
func (s *UpdateRoomInput) SetMessageReviewHandler(v *MessageReviewHandler) *UpdateRoomInput {
	s.MessageReviewHandler = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRoomInput) SetName(v string) *UpdateRoomInput {
	s.Name = &v
	return s
}

type UpdateRoomOutput struct {
	_ struct{} `type:"structure"`

	// Room ARN, from the request (if identifier was an ARN).
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Time when the room was created. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601"`

	// Room ID, generated by the system. This is a relative identifier, the part
	// of the ARN that uniquely identifies the room.
	Id *string `locationName:"id" min:"12" type:"string"`

	// Array of logging configurations attached to the room, from the request (if
	// specified).
	LoggingConfigurationIdentifiers []*string `locationName:"loggingConfigurationIdentifiers" type:"list"`

	// Maximum number of characters in a single message, from the request (if specified).
	MaximumMessageLength *int64 `locationName:"maximumMessageLength" min:"1" type:"integer"`

	// Maximum number of messages per second that can be sent to the room (by all
	// clients), from the request (if specified).
	MaximumMessageRatePerSecond *int64 `locationName:"maximumMessageRatePerSecond" min:"1" type:"integer"`

	// Configuration information for optional review of messages.
	MessageReviewHandler *MessageReviewHandler `locationName:"messageReviewHandler" type:"structure"`

	// Room name, from the request (if specified).
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Time of the room’s last update. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoomOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateRoomOutput) SetArn(v string) *UpdateRoomOutput {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *UpdateRoomOutput) SetCreateTime(v time.Time) *UpdateRoomOutput {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateRoomOutput) SetId(v string) *UpdateRoomOutput {
	s.Id = &v
	return s
}

// SetLoggingConfigurationIdentifiers sets the LoggingConfigurationIdentifiers field's value.
func (s *UpdateRoomOutput) SetLoggingConfigurationIdentifiers(v []*string) *UpdateRoomOutput {
	s.LoggingConfigurationIdentifiers = v
	return s
}

// SetMaximumMessageLength sets the MaximumMessageLength field's value.
func (s *UpdateRoomOutput) SetMaximumMessageLength(v int64) *UpdateRoomOutput {
	s.MaximumMessageLength = &v
	return s
}

// SetMaximumMessageRatePerSecond sets the MaximumMessageRatePerSecond field's value.
func (s *UpdateRoomOutput) SetMaximumMessageRatePerSecond(v int64) *UpdateRoomOutput {
	s.MaximumMessageRatePerSecond = &v
	return s
}

// SetMessageReviewHandler sets the MessageReviewHandler field's value.
func (s *UpdateRoomOutput) SetMessageReviewHandler(v *MessageReviewHandler) *UpdateRoomOutput {
	s.MessageReviewHandler = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRoomOutput) SetName(v string) *UpdateRoomOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateRoomOutput) SetTags(v map[string]*string) *UpdateRoomOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdateRoomOutput) SetUpdateTime(v time.Time) *UpdateRoomOutput {
	s.UpdateTime = &v
	return s
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This object is used in the ValidationException error.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Explanation of the reason for the validation error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// Name of the field which failed validation.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// ChatTokenCapabilitySendMessage is a ChatTokenCapability enum value
	ChatTokenCapabilitySendMessage = "SEND_MESSAGE"

	// ChatTokenCapabilityDisconnectUser is a ChatTokenCapability enum value
	ChatTokenCapabilityDisconnectUser = "DISCONNECT_USER"

	// ChatTokenCapabilityDeleteMessage is a ChatTokenCapability enum value
	ChatTokenCapabilityDeleteMessage = "DELETE_MESSAGE"
)

// ChatTokenCapability_Values returns all elements of the ChatTokenCapability enum
func ChatTokenCapability_Values() []string {
	return []string{
		ChatTokenCapabilitySendMessage,
		ChatTokenCapabilityDisconnectUser,
		ChatTokenCapabilityDeleteMessage,
	}
}

const (
	// CreateLoggingConfigurationStateActive is a CreateLoggingConfigurationState enum value
	CreateLoggingConfigurationStateActive = "ACTIVE"
)

// CreateLoggingConfigurationState_Values returns all elements of the CreateLoggingConfigurationState enum
func CreateLoggingConfigurationState_Values() []string {
	return []string{
		CreateLoggingConfigurationStateActive,
	}
}

const (
	// FallbackResultAllow is a FallbackResult enum value
	FallbackResultAllow = "ALLOW"

	// FallbackResultDeny is a FallbackResult enum value
	FallbackResultDeny = "DENY"
)

// FallbackResult_Values returns all elements of the FallbackResult enum
func FallbackResult_Values() []string {
	return []string{
		FallbackResultAllow,
		FallbackResultDeny,
	}
}

const (
	// LoggingConfigurationStateCreating is a LoggingConfigurationState enum value
	LoggingConfigurationStateCreating = "CREATING"

	// LoggingConfigurationStateCreateFailed is a LoggingConfigurationState enum value
	LoggingConfigurationStateCreateFailed = "CREATE_FAILED"

	// LoggingConfigurationStateDeleting is a LoggingConfigurationState enum value
	LoggingConfigurationStateDeleting = "DELETING"

	// LoggingConfigurationStateDeleteFailed is a LoggingConfigurationState enum value
	LoggingConfigurationStateDeleteFailed = "DELETE_FAILED"

	// LoggingConfigurationStateUpdating is a LoggingConfigurationState enum value
	LoggingConfigurationStateUpdating = "UPDATING"

	// LoggingConfigurationStateUpdateFailed is a LoggingConfigurationState enum value
	LoggingConfigurationStateUpdateFailed = "UPDATE_FAILED"

	// LoggingConfigurationStateActive is a LoggingConfigurationState enum value
	LoggingConfigurationStateActive = "ACTIVE"
)

// LoggingConfigurationState_Values returns all elements of the LoggingConfigurationState enum
func LoggingConfigurationState_Values() []string {
	return []string{
		LoggingConfigurationStateCreating,
		LoggingConfigurationStateCreateFailed,
		LoggingConfigurationStateDeleting,
		LoggingConfigurationStateDeleteFailed,
		LoggingConfigurationStateUpdating,
		LoggingConfigurationStateUpdateFailed,
		LoggingConfigurationStateActive,
	}
}

const (
	// ResourceTypeRoom is a ResourceType enum value
	ResourceTypeRoom = "ROOM"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeRoom,
	}
}

const (
	// UpdateLoggingConfigurationStateActive is a UpdateLoggingConfigurationState enum value
	UpdateLoggingConfigurationStateActive = "ACTIVE"
)

// UpdateLoggingConfigurationState_Values returns all elements of the UpdateLoggingConfigurationState enum
func UpdateLoggingConfigurationState_Values() []string {
	return []string{
		UpdateLoggingConfigurationStateActive,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
