// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package syntheticsiface provides an interface to enable mocking the Synthetics service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package syntheticsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/synthetics"
)

// SyntheticsAPI provides an interface to enable mocking the
// synthetics.Synthetics service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Synthetics.
//	func myFunc(svc syntheticsiface.SyntheticsAPI) bool {
//	    // Make svc.AssociateResource request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := synthetics.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockSyntheticsClient struct {
//	    syntheticsiface.SyntheticsAPI
//	}
//	func (m *mockSyntheticsClient) AssociateResource(input *synthetics.AssociateResourceInput) (*synthetics.AssociateResourceOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockSyntheticsClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SyntheticsAPI interface {
	AssociateResource(*synthetics.AssociateResourceInput) (*synthetics.AssociateResourceOutput, error)
	AssociateResourceWithContext(aws.Context, *synthetics.AssociateResourceInput, ...request.Option) (*synthetics.AssociateResourceOutput, error)
	AssociateResourceRequest(*synthetics.AssociateResourceInput) (*request.Request, *synthetics.AssociateResourceOutput)

	CreateCanary(*synthetics.CreateCanaryInput) (*synthetics.CreateCanaryOutput, error)
	CreateCanaryWithContext(aws.Context, *synthetics.CreateCanaryInput, ...request.Option) (*synthetics.CreateCanaryOutput, error)
	CreateCanaryRequest(*synthetics.CreateCanaryInput) (*request.Request, *synthetics.CreateCanaryOutput)

	CreateGroup(*synthetics.CreateGroupInput) (*synthetics.CreateGroupOutput, error)
	CreateGroupWithContext(aws.Context, *synthetics.CreateGroupInput, ...request.Option) (*synthetics.CreateGroupOutput, error)
	CreateGroupRequest(*synthetics.CreateGroupInput) (*request.Request, *synthetics.CreateGroupOutput)

	DeleteCanary(*synthetics.DeleteCanaryInput) (*synthetics.DeleteCanaryOutput, error)
	DeleteCanaryWithContext(aws.Context, *synthetics.DeleteCanaryInput, ...request.Option) (*synthetics.DeleteCanaryOutput, error)
	DeleteCanaryRequest(*synthetics.DeleteCanaryInput) (*request.Request, *synthetics.DeleteCanaryOutput)

	DeleteGroup(*synthetics.DeleteGroupInput) (*synthetics.DeleteGroupOutput, error)
	DeleteGroupWithContext(aws.Context, *synthetics.DeleteGroupInput, ...request.Option) (*synthetics.DeleteGroupOutput, error)
	DeleteGroupRequest(*synthetics.DeleteGroupInput) (*request.Request, *synthetics.DeleteGroupOutput)

	DescribeCanaries(*synthetics.DescribeCanariesInput) (*synthetics.DescribeCanariesOutput, error)
	DescribeCanariesWithContext(aws.Context, *synthetics.DescribeCanariesInput, ...request.Option) (*synthetics.DescribeCanariesOutput, error)
	DescribeCanariesRequest(*synthetics.DescribeCanariesInput) (*request.Request, *synthetics.DescribeCanariesOutput)

	DescribeCanariesPages(*synthetics.DescribeCanariesInput, func(*synthetics.DescribeCanariesOutput, bool) bool) error
	DescribeCanariesPagesWithContext(aws.Context, *synthetics.DescribeCanariesInput, func(*synthetics.DescribeCanariesOutput, bool) bool, ...request.Option) error

	DescribeCanariesLastRun(*synthetics.DescribeCanariesLastRunInput) (*synthetics.DescribeCanariesLastRunOutput, error)
	DescribeCanariesLastRunWithContext(aws.Context, *synthetics.DescribeCanariesLastRunInput, ...request.Option) (*synthetics.DescribeCanariesLastRunOutput, error)
	DescribeCanariesLastRunRequest(*synthetics.DescribeCanariesLastRunInput) (*request.Request, *synthetics.DescribeCanariesLastRunOutput)

	DescribeCanariesLastRunPages(*synthetics.DescribeCanariesLastRunInput, func(*synthetics.DescribeCanariesLastRunOutput, bool) bool) error
	DescribeCanariesLastRunPagesWithContext(aws.Context, *synthetics.DescribeCanariesLastRunInput, func(*synthetics.DescribeCanariesLastRunOutput, bool) bool, ...request.Option) error

	DescribeRuntimeVersions(*synthetics.DescribeRuntimeVersionsInput) (*synthetics.DescribeRuntimeVersionsOutput, error)
	DescribeRuntimeVersionsWithContext(aws.Context, *synthetics.DescribeRuntimeVersionsInput, ...request.Option) (*synthetics.DescribeRuntimeVersionsOutput, error)
	DescribeRuntimeVersionsRequest(*synthetics.DescribeRuntimeVersionsInput) (*request.Request, *synthetics.DescribeRuntimeVersionsOutput)

	DescribeRuntimeVersionsPages(*synthetics.DescribeRuntimeVersionsInput, func(*synthetics.DescribeRuntimeVersionsOutput, bool) bool) error
	DescribeRuntimeVersionsPagesWithContext(aws.Context, *synthetics.DescribeRuntimeVersionsInput, func(*synthetics.DescribeRuntimeVersionsOutput, bool) bool, ...request.Option) error

	DisassociateResource(*synthetics.DisassociateResourceInput) (*synthetics.DisassociateResourceOutput, error)
	DisassociateResourceWithContext(aws.Context, *synthetics.DisassociateResourceInput, ...request.Option) (*synthetics.DisassociateResourceOutput, error)
	DisassociateResourceRequest(*synthetics.DisassociateResourceInput) (*request.Request, *synthetics.DisassociateResourceOutput)

	GetCanary(*synthetics.GetCanaryInput) (*synthetics.GetCanaryOutput, error)
	GetCanaryWithContext(aws.Context, *synthetics.GetCanaryInput, ...request.Option) (*synthetics.GetCanaryOutput, error)
	GetCanaryRequest(*synthetics.GetCanaryInput) (*request.Request, *synthetics.GetCanaryOutput)

	GetCanaryRuns(*synthetics.GetCanaryRunsInput) (*synthetics.GetCanaryRunsOutput, error)
	GetCanaryRunsWithContext(aws.Context, *synthetics.GetCanaryRunsInput, ...request.Option) (*synthetics.GetCanaryRunsOutput, error)
	GetCanaryRunsRequest(*synthetics.GetCanaryRunsInput) (*request.Request, *synthetics.GetCanaryRunsOutput)

	GetCanaryRunsPages(*synthetics.GetCanaryRunsInput, func(*synthetics.GetCanaryRunsOutput, bool) bool) error
	GetCanaryRunsPagesWithContext(aws.Context, *synthetics.GetCanaryRunsInput, func(*synthetics.GetCanaryRunsOutput, bool) bool, ...request.Option) error

	GetGroup(*synthetics.GetGroupInput) (*synthetics.GetGroupOutput, error)
	GetGroupWithContext(aws.Context, *synthetics.GetGroupInput, ...request.Option) (*synthetics.GetGroupOutput, error)
	GetGroupRequest(*synthetics.GetGroupInput) (*request.Request, *synthetics.GetGroupOutput)

	ListAssociatedGroups(*synthetics.ListAssociatedGroupsInput) (*synthetics.ListAssociatedGroupsOutput, error)
	ListAssociatedGroupsWithContext(aws.Context, *synthetics.ListAssociatedGroupsInput, ...request.Option) (*synthetics.ListAssociatedGroupsOutput, error)
	ListAssociatedGroupsRequest(*synthetics.ListAssociatedGroupsInput) (*request.Request, *synthetics.ListAssociatedGroupsOutput)

	ListAssociatedGroupsPages(*synthetics.ListAssociatedGroupsInput, func(*synthetics.ListAssociatedGroupsOutput, bool) bool) error
	ListAssociatedGroupsPagesWithContext(aws.Context, *synthetics.ListAssociatedGroupsInput, func(*synthetics.ListAssociatedGroupsOutput, bool) bool, ...request.Option) error

	ListGroupResources(*synthetics.ListGroupResourcesInput) (*synthetics.ListGroupResourcesOutput, error)
	ListGroupResourcesWithContext(aws.Context, *synthetics.ListGroupResourcesInput, ...request.Option) (*synthetics.ListGroupResourcesOutput, error)
	ListGroupResourcesRequest(*synthetics.ListGroupResourcesInput) (*request.Request, *synthetics.ListGroupResourcesOutput)

	ListGroupResourcesPages(*synthetics.ListGroupResourcesInput, func(*synthetics.ListGroupResourcesOutput, bool) bool) error
	ListGroupResourcesPagesWithContext(aws.Context, *synthetics.ListGroupResourcesInput, func(*synthetics.ListGroupResourcesOutput, bool) bool, ...request.Option) error

	ListGroups(*synthetics.ListGroupsInput) (*synthetics.ListGroupsOutput, error)
	ListGroupsWithContext(aws.Context, *synthetics.ListGroupsInput, ...request.Option) (*synthetics.ListGroupsOutput, error)
	ListGroupsRequest(*synthetics.ListGroupsInput) (*request.Request, *synthetics.ListGroupsOutput)

	ListGroupsPages(*synthetics.ListGroupsInput, func(*synthetics.ListGroupsOutput, bool) bool) error
	ListGroupsPagesWithContext(aws.Context, *synthetics.ListGroupsInput, func(*synthetics.ListGroupsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*synthetics.ListTagsForResourceInput) (*synthetics.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *synthetics.ListTagsForResourceInput, ...request.Option) (*synthetics.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*synthetics.ListTagsForResourceInput) (*request.Request, *synthetics.ListTagsForResourceOutput)

	StartCanary(*synthetics.StartCanaryInput) (*synthetics.StartCanaryOutput, error)
	StartCanaryWithContext(aws.Context, *synthetics.StartCanaryInput, ...request.Option) (*synthetics.StartCanaryOutput, error)
	StartCanaryRequest(*synthetics.StartCanaryInput) (*request.Request, *synthetics.StartCanaryOutput)

	StopCanary(*synthetics.StopCanaryInput) (*synthetics.StopCanaryOutput, error)
	StopCanaryWithContext(aws.Context, *synthetics.StopCanaryInput, ...request.Option) (*synthetics.StopCanaryOutput, error)
	StopCanaryRequest(*synthetics.StopCanaryInput) (*request.Request, *synthetics.StopCanaryOutput)

	TagResource(*synthetics.TagResourceInput) (*synthetics.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *synthetics.TagResourceInput, ...request.Option) (*synthetics.TagResourceOutput, error)
	TagResourceRequest(*synthetics.TagResourceInput) (*request.Request, *synthetics.TagResourceOutput)

	UntagResource(*synthetics.UntagResourceInput) (*synthetics.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *synthetics.UntagResourceInput, ...request.Option) (*synthetics.UntagResourceOutput, error)
	UntagResourceRequest(*synthetics.UntagResourceInput) (*request.Request, *synthetics.UntagResourceOutput)

	UpdateCanary(*synthetics.UpdateCanaryInput) (*synthetics.UpdateCanaryOutput, error)
	UpdateCanaryWithContext(aws.Context, *synthetics.UpdateCanaryInput, ...request.Option) (*synthetics.UpdateCanaryOutput, error)
	UpdateCanaryRequest(*synthetics.UpdateCanaryInput) (*request.Request, *synthetics.UpdateCanaryOutput)
}

var _ SyntheticsAPI = (*synthetics.Synthetics)(nil)
