// Copyright (c) 2017-2020 The Iris Authors. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Iris nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/*
Package iris implements the highest realistic performance, easy to learn Go web framework.
Iris provides a beautifully expressive and easy to use foundation for your next website, API, or distributed app.
Low-level handlers compatible with `net/http` and high-level fastest MVC implementation and handlers dependency injection.
Easy to learn for new gophers and advanced features for experienced, it goes as far as you dive into it!

Source code and other details for the project are available at GitHub:

   https://github.com/kataras/iris

Current Version

12.1.8

Installation

The only requirement is the Go Programming Language, at least version 1.13.

    $ go get github.com/kataras/iris/v12@latest

Wiki:

    https://github.com/kataras/iris/wiki

Examples:

    https://github.com/kataras/iris/tree/master/_examples

Middleware:

    https://github.com/kataras/iris/tree/master/middleware
    https://github.com/iris-contrib/middleware

Home Page:

    https://iris-go.com

*/
package iris
