/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Phenotype;
import io.jenetics.ProbabilitySelector;
import io.jenetics.internal.math.DoubleAdder;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.stat.DoubleSummary;
import io.jenetics.util.Seq;
import java.util.Arrays;

public class RouletteWheelSelector<G extends Gene<?, G>, N extends Number>
extends ProbabilitySelector<G, N> {
    public RouletteWheelSelector() {
        this(false);
    }

    protected RouletteWheelSelector(boolean sorted) {
        super(sorted);
    }

    @Override
    protected double[] probabilities(Seq<Phenotype<G, N>> population, int count) {
        assert (population != null) : "Population must not be null. ";
        assert (population.nonEmpty()) : "Population is empty.";
        assert (count > 0) : "Population to select must be greater than zero. ";
        double[] fitness = new double[population.size()];
        int i = population.size();
        while (--i >= 0) {
            fitness[i] = ((Number)population.get(i).getFitness()).doubleValue();
        }
        double worst = Math.min(DoubleSummary.min(fitness), 0.0);
        double sum = DoubleAdder.sum(fitness) - worst * (double)population.size();
        if (RouletteWheelSelector.eq(sum, 0.0)) {
            Arrays.fill(fitness, 1.0 / (double)population.size());
        } else {
            int i2 = population.size();
            while (--i2 >= 0) {
                fitness[i2] = (fitness[i2] - worst) / sum;
            }
        }
        return fitness;
    }

    public int hashCode() {
        return Hash.of(this.getClass()).value();
    }

    public boolean equals(Object obj) {
        return Equality.ofType(this, obj);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

