/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.grammar.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vinniks.parsla.grammar.Grammar;
import org.vinniks.parsla.grammar.GrammarBuilder;
import org.vinniks.parsla.grammar.Item;
import org.vinniks.parsla.grammar.Option;
import org.vinniks.parsla.grammar.RuleItem;
import org.vinniks.parsla.syntaxtree.SyntaxTreeNode;
import org.vinniks.parsla.tokenizer.text.TextPosition;

class ExtendedGrammarBuilder {
    private final SyntaxTreeNode<TextPosition> syntaxTree;
    private final Collection<Option> options;
    private final Map<String, Integer> subOptionCounters;

    static Grammar build(SyntaxTreeNode<TextPosition> syntaxTree) {
        return new ExtendedGrammarBuilder(syntaxTree).build();
    }

    private ExtendedGrammarBuilder(SyntaxTreeNode<TextPosition> syntaxTree) {
        this.syntaxTree = syntaxTree;
        this.options = new ArrayList<Option>();
        this.subOptionCounters = new HashMap<String, Integer>();
    }

    private Grammar build() {
        this.syntaxTree.children().forEach(this::buildOption);
        return GrammarBuilder.grammar(this.options);
    }

    private void buildOption(SyntaxTreeNode<TextPosition> optionNode) {
        String ruleName = optionNode.singular("rule-name");
        boolean output = optionNode.hasChild("output");
        optionNode.child("sequences").children().stream().map(sequenceNode -> this.buildSequence(ruleName, output, (SyntaxTreeNode<TextPosition>)sequenceNode)).forEach(this.options::add);
    }

    private Option buildSequence(String ruleName, boolean output, SyntaxTreeNode<TextPosition> sequenceNode) {
        return sequenceNode.valueIs("caret") ? GrammarBuilder.option(ruleName, output) : GrammarBuilder.option(ruleName, output, sequenceNode.children().stream().map(itemNode -> this.buildItem(ruleName, (SyntaxTreeNode<TextPosition>)itemNode)).toList());
    }

    private Item buildItem(String ruleName, SyntaxTreeNode<TextPosition> itemNode) {
        String quantifier = itemNode.optionalSingular("quantifier").orElse("one");
        Item item = this.buildBody(ruleName, itemNode.child("body"));
        if (quantifier.equals("one")) {
            return item;
        }
        String subOptionRuleName = this.generateSubOptionRuleName(ruleName);
        RuleItem subOptionRuleItem = GrammarBuilder.rule(subOptionRuleName);
        if (quantifier.startsWith("zero")) {
            this.options.add(GrammarBuilder.option(subOptionRuleName));
        }
        ArrayList<Item> subOptionItems = new ArrayList<Item>();
        subOptionItems.add(item);
        if (quantifier.equals("zero-or-many")) {
            subOptionItems.add(GrammarBuilder.rule(subOptionRuleName));
        } else if (quantifier.equals("one-or-many")) {
            String tailOptionRuleName = String.format("%s_", subOptionRuleName);
            subOptionItems.add(GrammarBuilder.rule(tailOptionRuleName));
            this.options.add(GrammarBuilder.option(tailOptionRuleName));
            this.options.add(GrammarBuilder.option(tailOptionRuleName, List.of(item, GrammarBuilder.rule(tailOptionRuleName))));
        }
        this.options.add(GrammarBuilder.option(subOptionRuleName, subOptionItems));
        return subOptionRuleItem;
    }

    private Item buildBody(String ruleName, SyntaxTreeNode<TextPosition> bodyNode) {
        SyntaxTreeNode<TextPosition> contentNode = bodyNode.child();
        if (contentNode.valueIs("token")) {
            return GrammarBuilder.token(contentNode.child("elevations").children().size(), contentNode.optionalSingular("type").orElse(null), contentNode.hasChild("output-type"), contentNode.optionalSingular("value").orElse(null), contentNode.hasChild("output-value"));
        }
        if (contentNode.valueIs("rule")) {
            return GrammarBuilder.rule(contentNode.singular("name"), contentNode.hasChild("output"));
        }
        String subOptionRuleName = this.generateSubOptionRuleName(ruleName);
        contentNode.child("sequences").children().stream().map(sequenceNode -> this.buildSequence(subOptionRuleName, false, (SyntaxTreeNode<TextPosition>)sequenceNode)).forEach(this.options::add);
        return GrammarBuilder.rule(subOptionRuleName);
    }

    private String generateSubOptionRuleName(String ruleName) {
        Integer subOptionNumber = this.subOptionCounters.compute(ruleName, (key, value) -> value == null ? 1 : value + 1);
        return String.format("%s#%d", ruleName, subOptionNumber);
    }
}

