/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dashboard;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.model.api.device.DeviceDetailsDto;
import com.ubnt.return.C;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Comparator;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Value.Immutable
@C
public abstract class ActiveApDto
implements Comparable<ActiveApDto> {
    @JsonProperty(value="mac")
    @Schema(name="MAC address")
    public abstract String mac();

    @JsonProperty(value="ap_details")
    public abstract Optional<DeviceDetailsDto> deviceDetails();

    @JsonProperty(value="received_bytes")
    public abstract long receivedBytes();

    @JsonProperty(value="transmitted_bytes")
    public abstract long transmittedBytes();

    @JsonProperty(value="satisfaction")
    public abstract int satisfaction();

    @JsonProperty(value="total_bytes")
    @Value.Derived
    @Value.Auxiliary
    public long totalBytes() {
        return this.receivedBytes() + this.transmittedBytes();
    }

    @Override
    public int compareTo(@Nonnull ActiveApDto activeApDto) {
        return Comparator.comparingLong(ActiveApDto::totalBytes).reversed().compare(this, activeApDto);
    }
}

