/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.lcm;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.X;
import com.ubnt.model.api.lcm.ImmutablePsuStat;
import com.ubnt.return.H;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Value.Immutable
@H
public interface PsuStat {
    @JsonProperty(value="label")
    public String label();

    @JsonProperty(value="index")
    public int index();

    @JsonProperty(value="online")
    public boolean online();

    @JsonProperty(value="psuType")
    public int psuType();

    @JsonProperty(value="psuCaps")
    public int psuCaps();

    @JsonProperty(value="voltage")
    public double voltage();

    @JsonProperty(value="current")
    public double current();

    @JsonProperty(value="power")
    public double power();

    @JsonProperty(value="powerNominalDesign")
    public double powerNominalDesign();

    @JsonProperty(value="temperature")
    public double temperature();

    @JsonProperty(value="chargeStatus")
    public Optional<String> chargeStatus();

    @JsonProperty(value="energyFullDesign")
    public Optional<Double> energyFullDesign();

    @JsonProperty(value="capacity")
    public Optional<Integer> capacity();

    @JsonProperty(value="health")
    public Optional<String> health();

    public static ImmutablePsuStat.Builder builder() {
        return ImmutablePsuStat.builder();
    }

    public static PsuStat of(X x2) {
        return PsuStat.builder().label(x2.getString("label")).index(x2.getInt("index")).online(x2.is("online", false)).psuType(x2.getInt("psu_type")).psuCaps(x2.getInt("psu_caps")).voltage(x2.getDouble("voltage")).current(x2.getDouble("current")).power(x2.getDouble("power")).powerNominalDesign(x2.getDouble("power_nominal_design")).temperature(x2.getDouble("temperature")).chargeStatus(x2.getOptionalString("charge_status")).energyFullDesign(x2.getOptionalDouble("energy_full_design")).capacity(x2.getOptionalInt("capacity")).health(x2.getOptionalString("health")).build();
    }
}

