/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.radutil;

import com.axlradius.misc.b;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.radutil.DumpPacket;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SnoopRecord {
    private static final SimpleDateFormat a = new SimpleDateFormat("HH:mm:ss");
    private byte[] af;
    private int aF;
    private byte[] ag;
    private int aG;
    public int originalLength;
    public int includedLength;
    public int packetRecordLength;
    public int cumulativeDrops;
    public int seconds;
    public int microseconds;
    private DumpPacket a;
    private byte[] data;
    private byte[] ah;

    protected SnoopRecord(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.originalLength = n2;
        this.includedLength = n3;
        this.packetRecordLength = n4;
        this.cumulativeDrops = n5;
        this.seconds = n6;
        this.microseconds = n7;
    }

    public InetAddress getSourceIP() {
        return AttributeList.parseIP(this.af);
    }

    public int getSourcePort() {
        return this.aF;
    }

    public InetAddress getDestinationIP() {
        return AttributeList.parseIP(this.ag);
    }

    public int getDestinationPort() {
        return this.aG;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMicroseconds() {
        return this.microseconds;
    }

    public long getTimeStamp() {
        return (long)this.seconds * 100000L + (long)this.microseconds;
    }

    public DumpPacket getDumpPacket() {
        this.a = new DumpPacket(this.ah);
        return this.a;
    }

    public String toString() {
        Object object = new Date(this.seconds);
        object = "SnoopRecord:\n    Original Length " + this.originalLength + '\n' + "    Included Length " + this.includedLength + '\n' + "    Packet Record Length " + this.packetRecordLength + '\n' + "    Cumulative Drops " + this.cumulativeDrops + '\n' + "    Timestamp " + a.format((Date)object) + "." + this.microseconds + "\n";
        object = (String)object + "Source " + this.getSourceIP().getHostAddress() + ":" + this.getSourcePort() + "\n";
        object = (String)object + "Destination " + this.getDestinationIP().getHostAddress() + ":" + this.getDestinationPort() + "\n";
        if (this.ah == null) {
            return object;
        }
        object = (String)object + this.getDumpPacket().toString();
        return (String)object + "Raw Packet:\n" + new b(this.ah).a(0, this.ah.length);
    }

    public byte[] getRADIUSPacket() {
        return this.ah;
    }

    protected final void setData(byte[] object) throws IOException {
        this.data = object;
        object = this;
        b b2 = new b(object.data);
        b2.seek(14);
        int n2 = b2.readByte() & 0xFF;
        if (n2 >>> 4 != 4) {
            throw new IOException("Datagram is not version 4");
        }
        n2 &= 0xF;
        b2.d();
        b2.readShort();
        b2.c();
        b2.c();
        b2.d();
        if ((b2.readByte() & 0xFF) != 17) {
            throw new IOException("Packet is not UDP");
        }
        b2.c();
        object.af = new byte[4];
        b2.read(object.af);
        object.ag = new byte[4];
        b2.read(object.ag);
        b2.seek(14 + (n2 << 2));
        object.aF = b2.readShort() & 0xFFFF;
        object.aG = b2.readShort() & 0xFFFF;
        b2.readShort();
        b2.c();
        n2 = object.includedLength - b2.current();
        object.ah = new byte[n2];
        b2.read(object.ah);
    }
}

