/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.model;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxCellPath;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUndoableEdit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxGraphModel
extends mxEventSource
implements mxIGraphModel,
Serializable {
    protected mxICell root;
    protected Map<String, Object> cells;
    protected boolean maintainEdgeParent = true;
    protected boolean createIds = true;
    protected int nextId = 0;
    protected transient mxUndoableEdit currentEdit = this.createUndoableEdit();
    protected transient int updateLevel = 0;
    protected transient boolean endingUpdate = false;

    public mxGraphModel() {
        this(null);
    }

    public mxGraphModel(Object root) {
        if (root != null) {
            this.setRoot(root);
        } else {
            this.clear();
        }
    }

    public void clear() {
        this.setRoot(this.createRoot());
    }

    public int getUpdateLevel() {
        return this.updateLevel;
    }

    public Object createRoot() {
        mxCell root = new mxCell();
        root.insert(new mxCell());
        return root;
    }

    public Map<String, Object> getCells() {
        return this.cells;
    }

    public Object getCell(String id) {
        Object result = null;
        if (this.cells != null) {
            result = this.cells.get(id);
        }
        return result;
    }

    public boolean isMaintainEdgeParent() {
        return this.maintainEdgeParent;
    }

    public void setMaintainEdgeParent(boolean maintainEdgeParent) {
        this.maintainEdgeParent = maintainEdgeParent;
    }

    public boolean isCreateIds() {
        return this.createIds;
    }

    public void setCreateIds(boolean value) {
        this.createIds = value;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object setRoot(Object root) {
        this.execute(new mxRootChange(this, root));
        return root;
    }

    protected Object rootChanged(Object root) {
        mxICell oldRoot = this.root;
        this.root = (mxICell)root;
        this.nextId = 0;
        this.cells = null;
        this.cellAdded(root);
        return oldRoot;
    }

    protected mxUndoableEdit createUndoableEdit() {
        return new mxUndoableEdit(this){

            public void dispatch() {
                ((mxGraphModel)this.source).fireEvent(new mxEventObject("change", "edit", this, "changes", this.changes));
            }
        };
    }

    @Override
    public Object[] cloneCells(Object[] cells, boolean includeChildren) {
        int i;
        Hashtable<Object, Object> mapping = new Hashtable<Object, Object>();
        Object[] clones = new Object[cells.length];
        for (i = 0; i < cells.length; ++i) {
            try {
                clones[i] = this.cloneCell(cells[i], mapping, includeChildren);
                continue;
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        for (i = 0; i < cells.length; ++i) {
            this.restoreClone(clones[i], cells[i], mapping);
        }
        return clones;
    }

    protected Object cloneCell(Object cell, Map<Object, Object> mapping, boolean includeChildren) throws CloneNotSupportedException {
        if (cell instanceof mxICell) {
            mxICell mxc = (mxICell)((mxICell)cell).clone();
            mapping.put(cell, mxc);
            if (includeChildren) {
                int childCount = this.getChildCount(cell);
                for (int i = 0; i < childCount; ++i) {
                    Object clone = this.cloneCell(this.getChildAt(cell, i), mapping, true);
                    mxc.insert((mxICell)clone);
                }
            }
            return mxc;
        }
        return null;
    }

    protected void restoreClone(Object clone, Object cell, Map<Object, Object> mapping) {
        if (clone instanceof mxICell) {
            mxICell tmp;
            Object target;
            mxICell tmp2;
            mxICell mxc = (mxICell)clone;
            Object source = this.getTerminal(cell, true);
            if (source instanceof mxICell && (tmp2 = (mxICell)mapping.get(source)) != null) {
                tmp2.insertEdge(mxc, true);
            }
            if ((target = this.getTerminal(cell, false)) instanceof mxICell && (tmp = (mxICell)mapping.get(target)) != null) {
                tmp.insertEdge(mxc, false);
            }
        }
        int childCount = this.getChildCount(clone);
        for (int i = 0; i < childCount; ++i) {
            this.restoreClone(this.getChildAt(clone, i), this.getChildAt(cell, i), mapping);
        }
    }

    @Override
    public boolean isAncestor(Object parent, Object child) {
        while (child != null && child != parent) {
            child = this.getParent(child);
        }
        return child == parent;
    }

    @Override
    public boolean contains(Object cell) {
        return this.isAncestor(this.getRoot(), cell);
    }

    @Override
    public Object getParent(Object child) {
        return child instanceof mxICell ? ((mxICell)child).getParent() : null;
    }

    @Override
    public Object add(Object parent, Object child, int index) {
        if (child != parent && parent != null && child != null) {
            boolean parentChanged = parent != this.getParent(child);
            this.execute(new mxChildChange(this, parent, child, index));
            if (this.maintainEdgeParent && parentChanged) {
                this.updateEdgeParents(child);
            }
        }
        return child;
    }

    protected void cellAdded(Object cell) {
        if (cell instanceof mxICell) {
            Object collision;
            mxICell mxc = (mxICell)cell;
            if (mxc.getId() == null && this.isCreateIds()) {
                mxc.setId(this.createId(cell));
            }
            if (mxc.getId() != null && (collision = this.getCell(mxc.getId())) != cell) {
                while (collision != null) {
                    mxc.setId(this.createId(cell));
                    collision = this.getCell(mxc.getId());
                }
                if (this.cells == null) {
                    this.cells = new Hashtable<String, Object>();
                }
                this.cells.put(mxc.getId(), cell);
            }
            try {
                int id = Integer.parseInt(mxc.getId());
                this.nextId = Math.max(this.nextId, id + 1);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            int childCount = mxc.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.cellAdded(mxc.getChildAt(i));
            }
        }
    }

    public String createId(Object cell) {
        String id = String.valueOf(this.nextId);
        ++this.nextId;
        return id;
    }

    @Override
    public Object remove(Object cell) {
        if (cell == this.root) {
            this.setRoot(null);
        } else if (this.getParent(cell) != null) {
            this.execute(new mxChildChange(this, null, cell));
        }
        return cell;
    }

    protected void cellRemoved(Object cell) {
        if (cell instanceof mxICell) {
            mxICell mxc = (mxICell)cell;
            int childCount = mxc.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.cellRemoved(mxc.getChildAt(i));
            }
            if (this.cells != null && mxc.getId() != null) {
                this.cells.remove(mxc.getId());
            }
        }
    }

    protected Object parentForCellChanged(Object cell, Object parent, int index) {
        mxICell child = (mxICell)cell;
        mxICell previous = (mxICell)this.getParent(cell);
        if (parent != null) {
            if (parent != previous || previous.getIndex(child) != index) {
                ((mxICell)parent).insert(child, index);
            }
        } else if (previous != null) {
            int oldIndex = previous.getIndex(child);
            previous.remove(oldIndex);
        }
        if (!this.contains(previous) && parent != null) {
            this.cellAdded(cell);
        } else if (parent == null) {
            this.cellRemoved(cell);
        }
        return previous;
    }

    @Override
    public int getChildCount(Object cell) {
        return cell instanceof mxICell ? ((mxICell)cell).getChildCount() : 0;
    }

    @Override
    public Object getChildAt(Object parent, int index) {
        return parent instanceof mxICell ? ((mxICell)parent).getChildAt(index) : null;
    }

    @Override
    public Object getTerminal(Object edge, boolean isSource) {
        return edge instanceof mxICell ? ((mxICell)edge).getTerminal(isSource) : null;
    }

    @Override
    public Object setTerminal(Object edge, Object terminal, boolean isSource) {
        boolean terminalChanged = terminal != this.getTerminal(edge, isSource);
        this.execute(new mxTerminalChange(this, edge, terminal, isSource));
        if (this.maintainEdgeParent && terminalChanged) {
            this.updateEdgeParent(edge, this.getRoot());
        }
        return terminal;
    }

    protected Object terminalForCellChanged(Object edge, Object terminal, boolean isSource) {
        mxICell previous = (mxICell)this.getTerminal(edge, isSource);
        if (terminal != null) {
            ((mxICell)terminal).insertEdge((mxICell)edge, isSource);
        } else if (previous != null) {
            previous.removeEdge((mxICell)edge, isSource);
        }
        return previous;
    }

    public void updateEdgeParents(Object cell) {
        this.updateEdgeParents(cell, this.getRoot());
    }

    public void updateEdgeParents(Object cell, Object root) {
        int childCount = this.getChildCount(cell);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.getChildAt(cell, i);
            this.updateEdgeParents(child, root);
        }
        int edgeCount = this.getEdgeCount(cell);
        ArrayList<Object> edges = new ArrayList<Object>(edgeCount);
        for (int i = 0; i < edgeCount; ++i) {
            edges.add(this.getEdgeAt(cell, i));
        }
        for (Object e : edges) {
            if (!this.isAncestor(root, e)) continue;
            this.updateEdgeParent(e, root);
        }
    }

    public void updateEdgeParent(Object edge, Object root) {
        Object source = this.getTerminal(edge, true);
        Object target = this.getTerminal(edge, false);
        Object cell = null;
        while (source != null && !this.isEdge(source) && this.getGeometry(source) != null && this.getGeometry(source).isRelative()) {
            source = this.getParent(source);
        }
        while (target != null && !this.isEdge(target) && this.getGeometry(target) != null && this.getGeometry(target).isRelative()) {
            target = this.getParent(target);
        }
        if (this.isAncestor(root, source) && this.isAncestor(root, target) && (cell = source == target ? this.getParent(source) : this.getNearestCommonAncestor(source, target)) != null && (this.getParent(cell) != root || this.isAncestor(cell, edge)) && this.getParent(edge) != cell) {
            mxGeometry geo = this.getGeometry(edge);
            if (geo != null) {
                mxPoint origin1 = this.getOrigin(this.getParent(edge));
                mxPoint origin2 = this.getOrigin(cell);
                double dx = origin2.getX() - origin1.getX();
                double dy = origin2.getY() - origin1.getY();
                geo = (mxGeometry)geo.clone();
                geo.translate(-dx, -dy);
                this.setGeometry(edge, geo);
            }
            this.add(cell, edge, this.getChildCount(cell));
        }
    }

    public mxPoint getOrigin(Object cell) {
        mxPoint result = null;
        if (cell != null) {
            mxGeometry geo;
            result = this.getOrigin(this.getParent(cell));
            if (!this.isEdge(cell) && (geo = this.getGeometry(cell)) != null) {
                result.setX(result.getX() + geo.getX());
                result.setY(result.getY() + geo.getY());
            }
        } else {
            result = new mxPoint();
        }
        return result;
    }

    public Object getNearestCommonAncestor(Object cell1, Object cell2) {
        String path;
        if (cell1 != null && cell2 != null && (path = mxCellPath.create((mxICell)cell2)) != null && path.length() > 0) {
            Object cell = cell1;
            String current = mxCellPath.create((mxICell)cell);
            while (cell != null) {
                Object parent = this.getParent(cell);
                if (path.indexOf(current + mxCellPath.PATH_SEPARATOR) == 0 && parent != null) {
                    return cell;
                }
                current = mxCellPath.getParentPath(current);
                cell = parent;
            }
        }
        return null;
    }

    @Override
    public int getEdgeCount(Object cell) {
        return cell instanceof mxICell ? ((mxICell)cell).getEdgeCount() : 0;
    }

    @Override
    public Object getEdgeAt(Object parent, int index) {
        return parent instanceof mxICell ? ((mxICell)parent).getEdgeAt(index) : null;
    }

    @Override
    public boolean isVertex(Object cell) {
        return cell instanceof mxICell ? ((mxICell)cell).isVertex() : false;
    }

    @Override
    public boolean isEdge(Object cell) {
        return cell instanceof mxICell ? ((mxICell)cell).isEdge() : false;
    }

    @Override
    public boolean isConnectable(Object cell) {
        return cell instanceof mxICell ? ((mxICell)cell).isConnectable() : true;
    }

    @Override
    public Object getValue(Object cell) {
        return cell instanceof mxICell ? ((mxICell)cell).getValue() : null;
    }

    @Override
    public Object setValue(Object cell, Object value) {
        this.execute(new mxValueChange(this, cell, value));
        return value;
    }

    protected Object valueForCellChanged(Object cell, Object value) {
        Object oldValue = ((mxICell)cell).getValue();
        ((mxICell)cell).setValue(value);
        return oldValue;
    }

    @Override
    public mxGeometry getGeometry(Object cell) {
        return cell instanceof mxICell ? ((mxICell)cell).getGeometry() : null;
    }

    @Override
    public mxGeometry setGeometry(Object cell, mxGeometry geometry) {
        if (geometry != this.getGeometry(cell)) {
            this.execute(new mxGeometryChange(this, cell, geometry));
        }
        return geometry;
    }

    protected mxGeometry geometryForCellChanged(Object cell, mxGeometry geometry) {
        mxGeometry previous = this.getGeometry(cell);
        ((mxICell)cell).setGeometry(geometry);
        return previous;
    }

    @Override
    public String getStyle(Object cell) {
        return cell instanceof mxICell ? ((mxICell)cell).getStyle() : null;
    }

    @Override
    public String setStyle(Object cell, String style) {
        if (style == null || !style.equals(this.getStyle(cell))) {
            this.execute(new mxStyleChange(this, cell, style));
        }
        return style;
    }

    protected String styleForCellChanged(Object cell, String style) {
        String previous = this.getStyle(cell);
        ((mxICell)cell).setStyle(style);
        return previous;
    }

    @Override
    public boolean isCollapsed(Object cell) {
        return cell instanceof mxICell ? ((mxICell)cell).isCollapsed() : false;
    }

    @Override
    public boolean setCollapsed(Object cell, boolean collapsed) {
        if (collapsed != this.isCollapsed(cell)) {
            this.execute(new mxCollapseChange(this, cell, collapsed));
        }
        return collapsed;
    }

    protected boolean collapsedStateForCellChanged(Object cell, boolean collapsed) {
        boolean previous = this.isCollapsed(cell);
        ((mxICell)cell).setCollapsed(collapsed);
        return previous;
    }

    @Override
    public boolean isVisible(Object cell) {
        return cell instanceof mxICell ? ((mxICell)cell).isVisible() : false;
    }

    @Override
    public boolean setVisible(Object cell, boolean visible) {
        if (visible != this.isVisible(cell)) {
            this.execute(new mxVisibleChange(this, cell, visible));
        }
        return visible;
    }

    protected boolean visibleStateForCellChanged(Object cell, boolean visible) {
        boolean previous = this.isVisible(cell);
        ((mxICell)cell).setVisible(visible);
        return previous;
    }

    public void execute(mxIGraphModel.mxAtomicGraphModelChange change) {
        change.execute();
        this.beginUpdate();
        this.currentEdit.add(change);
        this.fireEvent(new mxEventObject("execute", "change", change));
        this.endUpdate();
    }

    @Override
    public void beginUpdate() {
        ++this.updateLevel;
        this.fireEvent(new mxEventObject("beginUpdate"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endUpdate() {
        --this.updateLevel;
        if (!this.endingUpdate) {
            this.endingUpdate = this.updateLevel == 0;
            this.fireEvent(new mxEventObject("endUpdate", "edit", this.currentEdit));
            try {
                if (this.endingUpdate && !this.currentEdit.isEmpty()) {
                    this.fireEvent(new mxEventObject("beforeUndo", "edit", this.currentEdit));
                    mxUndoableEdit tmp = this.currentEdit;
                    this.currentEdit = this.createUndoableEdit();
                    tmp.dispatch();
                    this.fireEvent(new mxEventObject("undo", "edit", tmp));
                }
            }
            finally {
                this.endingUpdate = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChildren(mxICell from, mxICell to, boolean cloneAllEdges) throws CloneNotSupportedException {
        this.beginUpdate();
        try {
            Hashtable<Object, Object> mapping = new Hashtable<Object, Object>();
            this.mergeChildrenImpl(from, to, cloneAllEdges, mapping);
            for (Object edge : mapping.keySet()) {
                Object cell = mapping.get(edge);
                Object terminal = this.getTerminal(edge, true);
                if (terminal != null) {
                    terminal = mapping.get(terminal);
                    this.setTerminal(cell, terminal, true);
                }
                if ((terminal = this.getTerminal(edge, false)) == null) continue;
                terminal = mapping.get(terminal);
                this.setTerminal(cell, terminal, false);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeChildrenImpl(mxICell from, mxICell to, boolean cloneAllEdges, Hashtable<Object, Object> mapping) throws CloneNotSupportedException {
        this.beginUpdate();
        try {
            int childCount = from.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                mxICell cell = from.getChildAt(i);
                String id = cell.getId();
                mxICell target = (mxICell)(id != null && (!this.isEdge(cell) || !cloneAllEdges) ? this.getCell(id) : null);
                if (target == null) {
                    mxCell clone = (mxCell)cell.clone();
                    clone.setId(id);
                    target = to.insert(clone);
                    this.cellAdded(target);
                }
                mapping.put(cell, target);
                this.mergeChildrenImpl(cell, target, cloneAllEdges, mapping);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.currentEdit = this.createUndoableEdit();
    }

    public static int getDirectedEdgeCount(mxIGraphModel model, Object cell, boolean outgoing) {
        return mxGraphModel.getDirectedEdgeCount(model, cell, outgoing, null);
    }

    public static int getDirectedEdgeCount(mxIGraphModel model, Object cell, boolean outgoing, Object ignoredEdge) {
        int count = 0;
        int edgeCount = model.getEdgeCount(cell);
        for (int i = 0; i < edgeCount; ++i) {
            Object edge = model.getEdgeAt(cell, i);
            if (edge == ignoredEdge || model.getTerminal(edge, outgoing) != cell) continue;
            ++count;
        }
        return count;
    }

    public static Object[] getEdges(mxIGraphModel model, Object cell) {
        return mxGraphModel.getEdges(model, cell, true, true, true);
    }

    public static Object[] getConnections(mxIGraphModel model, Object cell) {
        return mxGraphModel.getEdges(model, cell, true, true, false);
    }

    public static Object[] getIncomingEdges(mxIGraphModel model, Object cell) {
        return mxGraphModel.getEdges(model, cell, true, false, false);
    }

    public static Object[] getOutgoingEdges(mxIGraphModel model, Object cell) {
        return mxGraphModel.getEdges(model, cell, false, true, false);
    }

    public static Object[] getEdges(mxIGraphModel model, Object cell, boolean incoming, boolean outgoing, boolean includeLoops) {
        int edgeCount = model.getEdgeCount(cell);
        ArrayList<Object> result = new ArrayList<Object>(edgeCount);
        for (int i = 0; i < edgeCount; ++i) {
            Object edge = model.getEdgeAt(cell, i);
            Object source = model.getTerminal(edge, true);
            Object target = model.getTerminal(edge, false);
            if ((!includeLoops || source != target) && (source == target || (!incoming || target != cell) && (!outgoing || source != cell))) continue;
            result.add(edge);
        }
        return result.toArray();
    }

    public static Object[] getEdgesBetween(mxIGraphModel model, Object source, Object target) {
        return mxGraphModel.getEdgesBetween(model, source, target, false);
    }

    public static Object[] getEdgesBetween(mxIGraphModel model, Object source, Object target, boolean directed) {
        int tmp1 = model.getEdgeCount(source);
        int tmp2 = model.getEdgeCount(target);
        Object terminal = source;
        int edgeCount = tmp1;
        if (tmp2 < tmp1) {
            edgeCount = tmp2;
            terminal = target;
        }
        ArrayList<Object> result = new ArrayList<Object>(edgeCount);
        for (int i = 0; i < edgeCount; ++i) {
            boolean oppositeMatch;
            Object edge = model.getEdgeAt(terminal, i);
            Object src = model.getTerminal(edge, true);
            Object trg = model.getTerminal(edge, false);
            boolean directedMatch = src == source && trg == target;
            boolean bl = oppositeMatch = trg == source && src == target;
            if (!directedMatch && (directed || !oppositeMatch)) continue;
            result.add(edge);
        }
        return result.toArray();
    }

    public static Object[] getOpposites(mxIGraphModel model, Object[] edges, Object terminal) {
        return mxGraphModel.getOpposites(model, edges, terminal, true, true);
    }

    public static Object[] getOpposites(mxIGraphModel model, Object[] edges, Object terminal, boolean sources, boolean targets) {
        ArrayList<Object> terminals = new ArrayList<Object>();
        if (edges != null) {
            for (int i = 0; i < edges.length; ++i) {
                Object source = model.getTerminal(edges[i], true);
                Object target = model.getTerminal(edges[i], false);
                if (targets && source == terminal && target != null && target != terminal) {
                    terminals.add(target);
                    continue;
                }
                if (!sources || target != terminal || source == null || source == terminal) continue;
                terminals.add(source);
            }
        }
        return terminals.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTerminals(mxIGraphModel model, Object edge, Object source, Object target) {
        model.beginUpdate();
        try {
            model.setTerminal(edge, source, true);
            model.setTerminal(edge, target, false);
        }
        finally {
            model.endUpdate();
        }
    }

    public static Object[] getChildren(mxIGraphModel model, Object parent) {
        return mxGraphModel.getChildCells(model, parent, false, false);
    }

    public static Object[] getChildVertices(mxIGraphModel model, Object parent) {
        return mxGraphModel.getChildCells(model, parent, true, false);
    }

    public static Object[] getChildEdges(mxIGraphModel model, Object parent) {
        return mxGraphModel.getChildCells(model, parent, false, true);
    }

    public static Object[] getChildCells(mxIGraphModel model, Object parent, boolean vertices, boolean edges) {
        int childCount = model.getChildCount(parent);
        ArrayList<Object> result = new ArrayList<Object>(childCount);
        for (int i = 0; i < childCount; ++i) {
            Object child = model.getChildAt(parent, i);
            if (!(!edges && !vertices || edges && model.isEdge(child)) && (!vertices || !model.isVertex(child))) continue;
            result.add(child);
        }
        return result.toArray();
    }

    public static Object[] getParents(mxIGraphModel model, Object[] cells) {
        HashSet<Object> parents = new HashSet<Object>();
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                Object parent = model.getParent(cells[i]);
                if (parent == null) continue;
                parents.add(parent);
            }
        }
        return parents.toArray();
    }

    public static Object[] filterCells(Object[] cells, Filter filter) {
        ArrayList<Object> result = null;
        if (cells != null) {
            result = new ArrayList<Object>(cells.length);
            for (int i = 0; i < cells.length; ++i) {
                if (!filter.filter(cells[i])) continue;
                result.add(cells[i]);
            }
        }
        return result != null ? result.toArray() : null;
    }

    public static Collection<Object> getDescendants(mxIGraphModel model, Object parent) {
        return mxGraphModel.filterDescendants(model, null, parent);
    }

    public static Collection<Object> filterDescendants(mxIGraphModel model, Filter filter) {
        return mxGraphModel.filterDescendants(model, filter, model.getRoot());
    }

    public static Collection<Object> filterDescendants(mxIGraphModel model, Filter filter, Object parent) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (filter == null || filter.filter(parent)) {
            result.add(parent);
        }
        int childCount = model.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            Object child = model.getChildAt(parent, i);
            result.addAll(mxGraphModel.filterDescendants(model, filter, child));
        }
        return result;
    }

    public static Object[] getTopmostCells(mxIGraphModel model, Object[] cells) {
        HashSet<Object> hash = new HashSet<Object>();
        hash.addAll(Arrays.asList(cells));
        ArrayList<Object> result = new ArrayList<Object>(cells.length);
        for (int i = 0; i < cells.length; ++i) {
            Object cell = cells[i];
            boolean topmost = true;
            Object parent = model.getParent(cell);
            while (parent != null) {
                if (hash.contains(parent)) {
                    topmost = false;
                    break;
                }
                parent = model.getParent(parent);
            }
            if (!topmost) continue;
            result.add(cell);
        }
        return result.toArray();
    }

    public static class mxVisibleChange
    extends mxIGraphModel.mxAtomicGraphModelChange {
        protected Object cell;
        protected boolean visible;
        protected boolean previous;

        public mxVisibleChange() {
            this(null, null, false);
        }

        public mxVisibleChange(mxGraphModel model, Object cell, boolean visible) {
            super(model);
            this.cell = cell;
            this.previous = this.visible = visible;
        }

        public void setCell(Object value) {
            this.cell = value;
        }

        public Object getCell() {
            return this.cell;
        }

        public void setVisible(boolean value) {
            this.visible = value;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setPrevious(boolean value) {
            this.previous = value;
        }

        public boolean getPrevious() {
            return this.previous;
        }

        public void execute() {
            this.visible = this.previous;
            this.previous = ((mxGraphModel)this.model).visibleStateForCellChanged(this.cell, this.previous);
        }
    }

    public static class mxCollapseChange
    extends mxIGraphModel.mxAtomicGraphModelChange {
        protected Object cell;
        protected boolean collapsed;
        protected boolean previous;

        public mxCollapseChange() {
            this(null, null, false);
        }

        public mxCollapseChange(mxGraphModel model, Object cell, boolean collapsed) {
            super(model);
            this.cell = cell;
            this.previous = this.collapsed = collapsed;
        }

        public void setCell(Object value) {
            this.cell = value;
        }

        public Object getCell() {
            return this.cell;
        }

        public void setCollapsed(boolean value) {
            this.collapsed = value;
        }

        public boolean isCollapsed() {
            return this.collapsed;
        }

        public void setPrevious(boolean value) {
            this.previous = value;
        }

        public boolean getPrevious() {
            return this.previous;
        }

        public void execute() {
            this.collapsed = this.previous;
            this.previous = ((mxGraphModel)this.model).collapsedStateForCellChanged(this.cell, this.previous);
        }
    }

    public static class mxGeometryChange
    extends mxIGraphModel.mxAtomicGraphModelChange {
        protected Object cell;
        protected mxGeometry geometry;
        protected mxGeometry previous;

        public mxGeometryChange() {
            this(null, null, null);
        }

        public mxGeometryChange(mxGraphModel model, Object cell, mxGeometry geometry) {
            super(model);
            this.cell = cell;
            this.previous = this.geometry = geometry;
        }

        public void setCell(Object value) {
            this.cell = value;
        }

        public Object getCell() {
            return this.cell;
        }

        public void setGeometry(mxGeometry value) {
            this.geometry = value;
        }

        public mxGeometry getGeometry() {
            return this.geometry;
        }

        public void setPrevious(mxGeometry value) {
            this.previous = value;
        }

        public mxGeometry getPrevious() {
            return this.previous;
        }

        public void execute() {
            this.geometry = this.previous;
            this.previous = ((mxGraphModel)this.model).geometryForCellChanged(this.cell, this.previous);
        }
    }

    public static class mxStyleChange
    extends mxIGraphModel.mxAtomicGraphModelChange {
        protected Object cell;
        protected String style;
        protected String previous;

        public mxStyleChange() {
            this(null, null, null);
        }

        public mxStyleChange(mxGraphModel model, Object cell, String style) {
            super(model);
            this.cell = cell;
            this.previous = this.style = style;
        }

        public void setCell(Object value) {
            this.cell = value;
        }

        public Object getCell() {
            return this.cell;
        }

        public void setStyle(String value) {
            this.style = value;
        }

        public String getStyle() {
            return this.style;
        }

        public void setPrevious(String value) {
            this.previous = value;
        }

        public String getPrevious() {
            return this.previous;
        }

        public void execute() {
            this.style = this.previous;
            this.previous = ((mxGraphModel)this.model).styleForCellChanged(this.cell, this.previous);
        }
    }

    public static class mxValueChange
    extends mxIGraphModel.mxAtomicGraphModelChange {
        protected Object cell;
        protected Object value;
        protected Object previous;

        public mxValueChange() {
            this(null, null, null);
        }

        public mxValueChange(mxGraphModel model, Object cell, Object value) {
            super(model);
            this.cell = cell;
            this.previous = this.value = value;
        }

        public void setCell(Object value) {
            this.cell = value;
        }

        public Object getCell() {
            return this.cell;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setPrevious(Object value) {
            this.previous = value;
        }

        public Object getPrevious() {
            return this.previous;
        }

        public void execute() {
            this.value = this.previous;
            this.previous = ((mxGraphModel)this.model).valueForCellChanged(this.cell, this.previous);
        }
    }

    public static class mxTerminalChange
    extends mxIGraphModel.mxAtomicGraphModelChange {
        protected Object cell;
        protected Object terminal;
        protected Object previous;
        protected boolean source;

        public mxTerminalChange() {
            this(null, null, null, false);
        }

        public mxTerminalChange(mxGraphModel model, Object cell, Object terminal, boolean source) {
            super(model);
            this.cell = cell;
            this.previous = this.terminal = terminal;
            this.source = source;
        }

        public void setCell(Object value) {
            this.cell = value;
        }

        public Object getCell() {
            return this.cell;
        }

        public void setTerminal(Object value) {
            this.terminal = value;
        }

        public Object getTerminal() {
            return this.terminal;
        }

        public void setPrevious(Object value) {
            this.previous = value;
        }

        public Object getPrevious() {
            return this.previous;
        }

        public void setSource(boolean value) {
            this.source = value;
        }

        public boolean isSource() {
            return this.source;
        }

        public void execute() {
            this.terminal = this.previous;
            this.previous = ((mxGraphModel)this.model).terminalForCellChanged(this.cell, this.previous, this.source);
        }
    }

    public static class mxChildChange
    extends mxIGraphModel.mxAtomicGraphModelChange {
        protected Object parent;
        protected Object previous;
        protected Object child;
        protected int index;
        protected int previousIndex;

        public mxChildChange() {
            this(null, null, null, 0);
        }

        public mxChildChange(mxGraphModel model, Object parent, Object child) {
            this(model, parent, child, 0);
        }

        public mxChildChange(mxGraphModel model, Object parent, Object child, int index) {
            super(model);
            this.previous = this.parent = parent;
            this.child = child;
            this.index = index;
            this.previousIndex = index;
        }

        public void setParent(Object value) {
            this.parent = value;
        }

        public Object getParent() {
            return this.parent;
        }

        public void setPrevious(Object value) {
            this.previous = value;
        }

        public Object getPrevious() {
            return this.previous;
        }

        public void setChild(Object value) {
            this.child = value;
        }

        public Object getChild() {
            return this.child;
        }

        public void setIndex(int value) {
            this.index = value;
        }

        public int getIndex() {
            return this.index;
        }

        public void setPreviousIndex(int value) {
            this.previousIndex = value;
        }

        public int getPreviousIndex() {
            return this.previousIndex;
        }

        protected Object getTerminal(Object edge, boolean source) {
            return this.model.getTerminal(edge, source);
        }

        protected void setTerminal(Object edge, Object terminal, boolean source) {
            ((mxICell)edge).setTerminal((mxICell)terminal, source);
        }

        protected void connect(Object cell, boolean isConnect) {
            Object source = this.getTerminal(cell, true);
            Object target = this.getTerminal(cell, false);
            if (source != null) {
                if (isConnect) {
                    ((mxGraphModel)this.model).terminalForCellChanged(cell, source, true);
                } else {
                    ((mxGraphModel)this.model).terminalForCellChanged(cell, null, true);
                }
            }
            if (target != null) {
                if (isConnect) {
                    ((mxGraphModel)this.model).terminalForCellChanged(cell, target, false);
                } else {
                    ((mxGraphModel)this.model).terminalForCellChanged(cell, null, false);
                }
            }
            this.setTerminal(cell, source, true);
            this.setTerminal(cell, target, false);
            int childCount = this.model.getChildCount(cell);
            for (int i = 0; i < childCount; ++i) {
                this.connect(this.model.getChildAt(cell, i), isConnect);
            }
        }

        protected int getChildIndex(Object parent, Object child) {
            return parent instanceof mxICell && child instanceof mxICell ? ((mxICell)parent).getIndex((mxICell)child) : 0;
        }

        public void execute() {
            Object tmp = this.model.getParent(this.child);
            int tmp2 = this.getChildIndex(tmp, this.child);
            if (this.previous == null) {
                this.connect(this.child, false);
            }
            tmp = ((mxGraphModel)this.model).parentForCellChanged(this.child, this.previous, this.previousIndex);
            if (this.previous != null) {
                this.connect(this.child, true);
            }
            this.parent = this.previous;
            this.previous = tmp;
            this.index = this.previousIndex;
            this.previousIndex = tmp2;
        }
    }

    public static class mxRootChange
    extends mxIGraphModel.mxAtomicGraphModelChange {
        protected Object root;
        protected Object previous;

        public mxRootChange() {
            this(null, null);
        }

        public mxRootChange(mxGraphModel model, Object root) {
            super(model);
            this.root = root;
            this.previous = root;
        }

        public void setRoot(Object value) {
            this.root = value;
        }

        public Object getRoot() {
            return this.root;
        }

        public void setPrevious(Object value) {
            this.previous = value;
        }

        public Object getPrevious() {
            return this.previous;
        }

        public void execute() {
            this.root = this.previous;
            this.previous = ((mxGraphModel)this.model).rootChanged(this.previous);
        }
    }

    public static interface Filter {
        public boolean filter(Object var1);
    }
}

