/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Phenotype;
import io.jenetics.util.ISeq;
import java.io.Serializable;
import java.util.Objects;

public final class AltererResult<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ISeq<Phenotype<G, C>> _population;
    private final int _alterations;

    private AltererResult(ISeq<Phenotype<G, C>> population, int alterations) {
        if (alterations < 0) {
            throw new IllegalArgumentException("Alterations must not be negative: " + alterations);
        }
        this._population = Objects.requireNonNull(population);
        this._alterations = alterations;
    }

    public ISeq<Phenotype<G, C>> getPopulation() {
        return this._population;
    }

    public int getAlterations() {
        return this._alterations;
    }

    public int hashCode() {
        int hash = 17;
        hash += 31 * this._population.hashCode() + 37;
        return hash += 31 * this._alterations + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AltererResult && this._alterations == ((AltererResult)obj)._alterations && this._population.equals(((AltererResult)obj)._population);
    }

    public String toString() {
        return String.format("[%s, %s]", this._population, this._alterations);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> AltererResult<G, C> of(ISeq<Phenotype<G, C>> population, int alterations) {
        return new AltererResult<G, C>(population, alterations);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> AltererResult<G, C> of(ISeq<Phenotype<G, C>> population) {
        return new AltererResult<G, C>(population, 0);
    }
}

