/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.internal.math.random;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class AnyGene<A>
implements Gene<A, AnyGene<A>> {
    private final A _allele;
    private final Supplier<? extends A> _supplier;
    private final Predicate<? super A> _validator;

    private AnyGene(A allele, Supplier<? extends A> supplier, Predicate<? super A> validator) {
        this._allele = allele;
        this._supplier = Objects.requireNonNull(supplier);
        this._validator = Objects.requireNonNull(validator);
    }

    @Override
    public A getAllele() {
        return this._allele;
    }

    @Override
    public AnyGene<A> newInstance() {
        return new AnyGene<A>(this._supplier.get(), this._supplier, this._validator);
    }

    @Override
    public AnyGene<A> newInstance(A value) {
        return new AnyGene<A>(value, this._supplier, this._validator);
    }

    @Override
    public boolean isValid() {
        return this._validator.test(this._allele);
    }

    public int hashCode() {
        return Objects.hashCode(this._allele);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AnyGene && Objects.equals(((AnyGene)obj)._allele, this._allele);
    }

    public String toString() {
        return Objects.toString(this._allele);
    }

    public static <A> AnyGene<A> of(A allele, Supplier<? extends A> supplier, Predicate<? super A> validator) {
        return new AnyGene<A>(allele, supplier, validator);
    }

    public static <A> AnyGene<A> of(A allele, Supplier<? extends A> supplier) {
        return new AnyGene<Object>(allele, supplier, a -> true);
    }

    public static <A> AnyGene<A> of(Supplier<? extends A> supplier) {
        return new AnyGene<Object>(supplier.get(), supplier, a -> true);
    }

    public static <A> AnyGene<A> of(Supplier<? extends A> supplier, Predicate<? super A> validator) {
        return new AnyGene<A>(supplier.get(), supplier, validator);
    }

    static <A> ISeq<AnyGene<A>> seq(IntRange lengthRange, Supplier<? extends A> supplier, Predicate<? super A> validator) {
        return MSeq.ofLength(random.nextInt(lengthRange, RandomRegistry.getRandom())).fill(() -> AnyGene.of(supplier.get(), supplier, validator)).toISeq();
    }
}

