/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.internal.math.random;
import io.jenetics.util.CharSeq;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import java.io.Serializable;
import java.util.Objects;
import java.util.Random;

public final class CharacterGene
implements Gene<Character, CharacterGene>,
Comparable<CharacterGene>,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final CharSeq DEFAULT_CHARACTERS = new CharSeq("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ !\"$%&/()=?`{[]}\\+~*#';.:,-_<>|@^'");
    private final Character _character;
    private final CharSeq _validCharacters;

    private CharacterGene(CharSeq chars, int index) {
        this._character = (Character)chars.get(index);
        this._validCharacters = chars;
    }

    CharacterGene(Character character, CharSeq validChars) {
        this._character = Objects.requireNonNull(character);
        this._validCharacters = Objects.requireNonNull(validChars);
    }

    @Override
    public boolean isValid() {
        return this._validCharacters.contains(this._character);
    }

    @Override
    public Character getAllele() {
        return this._character;
    }

    public char charValue() {
        return this._character.charValue();
    }

    public boolean isValidCharacter(Character character) {
        return this._validCharacters.contains(character);
    }

    public CharSeq getValidCharacters() {
        return this._validCharacters;
    }

    @Override
    public int compareTo(CharacterGene that) {
        return this.getAllele().compareTo(that.getAllele());
    }

    public int hashCode() {
        int hash = 17;
        hash += 31 * Objects.hashCode(this._character) + 37;
        return hash += 31 * Objects.hashCode(this._validCharacters) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharacterGene && Objects.equals(((CharacterGene)obj)._character, this._character) && Objects.equals(((CharacterGene)obj)._validCharacters, this._validCharacters);
    }

    public String toString() {
        return this._character.toString();
    }

    @Override
    public CharacterGene newInstance() {
        return CharacterGene.of(this._validCharacters);
    }

    @Override
    public CharacterGene newInstance(Character character) {
        return CharacterGene.of(character.charValue(), this._validCharacters);
    }

    public static CharacterGene of(CharSeq validCharacters) {
        return new CharacterGene(validCharacters, RandomRegistry.getRandom().nextInt(validCharacters.length()));
    }

    public static CharacterGene of(Character character) {
        return new CharacterGene(character, DEFAULT_CHARACTERS);
    }

    public static CharacterGene of() {
        return new CharacterGene(DEFAULT_CHARACTERS, RandomRegistry.getRandom().nextInt(DEFAULT_CHARACTERS.length()));
    }

    public static CharacterGene of(char character, CharSeq validCharacters) {
        return new CharacterGene(Character.valueOf(character), validCharacters);
    }

    static ISeq<CharacterGene> seq(CharSeq chars, IntRange lengthRange) {
        Random r = RandomRegistry.getRandom();
        return MSeq.ofLength(random.nextInt(lengthRange, r)).fill(() -> new CharacterGene(chars, r.nextInt(chars.length()))).toISeq();
    }
}

