/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.engine.EvolutionResult;
import java.util.Objects;
import java.util.function.Predicate;

final class FitnessThresholdLimit<C extends Comparable<? super C>>
implements Predicate<EvolutionResult<?, C>> {
    private final C _threshold;

    FitnessThresholdLimit(C threshold) {
        this._threshold = (Comparable)Objects.requireNonNull(threshold);
    }

    @Override
    public boolean test(EvolutionResult<?, C> result) {
        return result.getTotalGenerations() <= 1L || result.getOptimize().compare(this._threshold, result.getBestFitness()) >= 0;
    }
}

