/*
 * Decompiled with CFR 0.152.
 */
package ca.ryangreen.apigateway.generic;

import ca.ryangreen.apigateway.generic.GenericApiGatewayClient;
import ca.ryangreen.apigateway.util.Validate;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.regions.Region;

public class GenericApiGatewayClientBuilder {
    private String endpoint;
    private Region region;
    private AWSCredentialsProvider credentials;
    private ClientConfiguration clientConfiguration;
    private String apiKey;
    private AmazonHttpClient httpClient;

    public GenericApiGatewayClientBuilder withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public GenericApiGatewayClientBuilder withRegion(Region region) {
        this.region = region;
        return this;
    }

    public GenericApiGatewayClientBuilder withClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        return this;
    }

    public GenericApiGatewayClientBuilder withCredentials(AWSCredentialsProvider credentials) {
        this.credentials = credentials;
        return this;
    }

    public GenericApiGatewayClientBuilder withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public GenericApiGatewayClientBuilder withHttpClient(AmazonHttpClient client) {
        this.httpClient = client;
        return this;
    }

    public AWSCredentialsProvider getCredentials() {
        return this.credentials;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public AmazonHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Region getRegion() {
        return this.region;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public GenericApiGatewayClient build() {
        Validate.notEmpty(this.endpoint, "Endpoint");
        Validate.notNull(this.region, "Region");
        return new GenericApiGatewayClient(this.clientConfiguration, this.endpoint, this.region, this.credentials, this.apiKey, this.httpClient);
    }
}

