/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.alert;

import com.ubnt.repository.C;
import com.ubnt.repository.W;
import com.ubnt.return.E;
import com.ubnt.service.alert.A;
import com.ubnt.service.alert.B;
import com.ubnt.service.alert.GenericParameterDataDocumentPart;
import com.ubnt.service.alert.ParameterDataDocumentPart;
import com.ubnt.service.alert.RenderParameterDataDocumentPart;
import com.ubnt.service.alert.VA;
import com.ubnt.service.alert.Y;
import com.ubnt.service.alert.interfaceObject;
import com.ubnt.service.alert.o0O0;
import com.ubnt.service.alert.x;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.immutables.builder.Builder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Immutable;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Immutable
@Document(collection="alert")
@CompoundIndexes(value={@CompoundIndex(name="time_-1_key_1_site_id_1_status_1", def="{'time': -1, 'key': 1, 'site_id': 1, 'status': 1}"), @CompoundIndex(name="parameters_device_target_id_1_port_name_1", def="{'parameters.DEVICE.target_id': 1, 'parameters.PORT.name': 1}")})
@E
public class AlertDocument
implements C,
W {
    public static final String COLLECTION_NAME = "alert";
    @Id
    private String id;
    @Field(value="site_id")
    private final String siteId;
    @Field(value="key")
    private final B key;
    @Field(value="time")
    private final Long timestamp;
    @Field(value="status")
    private final VA status;
    @Field(value="parameters")
    private final Map<x, ParameterDataDocumentPart> parameters;
    @Field(value="severity")
    private final o0O0 severity;
    @Field(value="metadata")
    private final Map<A, String> metadata;
    @Field(value="render_parameters")
    @Deprecated
    private final Map<interfaceObject, RenderParameterDataDocumentPart> renderParameters;

    @Builder.Constructor
    public AlertDocument(@Value(value="_id") @Nullable String string, @Value(value="site_id") String string2, @Value(value="key") B b2, @Value(value="time") Long l2, @Value(value="status") VA vA2, @Value(value="parameters") Map<x, ParameterDataDocumentPart> map, @Value(value="severity") @Nullable o0O0 o0O02, @Value(value="metadata") @Nullable Map<A, String> map2, @Value(value="render_parameters") @Nullable Map<interfaceObject, RenderParameterDataDocumentPart> map3) {
        this.id = string;
        this.siteId = string2;
        this.key = b2;
        this.timestamp = l2;
        this.status = vA2;
        this.parameters = map;
        this.severity = o0O02;
        this.metadata = map2;
        this.renderParameters = map3;
    }

    @Override
    public String getCollectionName() {
        return COLLECTION_NAME;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSiteId() {
        return this.siteId;
    }

    public B getKey() {
        return this.key;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public VA getStatus() {
        return Optional.ofNullable(this.status).orElse(VA.\u00d200000);
    }

    public Map<x, ParameterDataDocumentPart> getParameters() {
        return this.parameters;
    }

    public ParameterDataDocumentPart getTargetParameterData() {
        return this.parameters.getOrDefault(this.key.dosuper(), GenericParameterDataDocumentPart.EMPTY);
    }

    public Optional<o0O0> getDbSeverity() {
        return Optional.ofNullable(this.severity);
    }

    public o0O0 getSeverity() {
        return Optional.ofNullable(this.key.\u00d2O0000()).or(() -> Optional.ofNullable(this.severity)).orElse(o0O0.\u00f500000);
    }

    public int getCefSeverity() {
        if (this.key.\u00d6o0000() != 0) {
            return this.key.\u00d6o0000();
        }
        return this.getDbSeverity().map(o0O0::\u00d300000).orElse(0);
    }

    public Map<A, String> getMetadata() {
        if (this.metadata == null) {
            return Map.of();
        }
        return this.metadata;
    }

    public Map<interfaceObject, RenderParameterDataDocumentPart> getRenderParameters() {
        return this.renderParameters;
    }

    public AlertDocument withMetadata(Map<A, String> map) {
        return new AlertDocument(this.id, this.siteId, this.key, this.timestamp, this.status, this.parameters, this.severity, map, this.renderParameters);
    }

    public AlertDocument withStatus(VA vA2) {
        return new AlertDocument(this.id, this.siteId, this.key, this.timestamp, vA2, this.parameters, this.severity, this.metadata, this.renderParameters);
    }

    public AlertDocument withTimestamp(Long l2) {
        return new AlertDocument(this.id, this.siteId, this.key, l2, this.status, this.parameters, this.severity, this.metadata, this.renderParameters);
    }

    public static Y builderForNewAlert() {
        return new Y().\u00d500000(VA.\u00d200000);
    }

    public static final class _o {
        public static final String \u00d500000 = "time";
        public static final String \u00d300000 = "key";
        public static final String \u00d800000 = "parameters";
        public static final String \u00d600000 = "render_parameters";
        public static final String o00000 = "status";
        public static final String \u00d200000 = "severity";
        public static final String String = "metadata";

        @Generated
        private _o() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

