// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Generative AI Agents Client API
//
// OCI Generative AI Agents is a fully managed service that combines the power of large language models (LLMs) with an intelligent retrieval system to create contextually relevant answers by searching your knowledge base, making your AI applications smart and efficient.
// OCI Generative AI Agents supports several ways to onboard your data and then allows you and your customers to interact with your data using a chat interface or API.
// Use the Generative AI Agents Client API to create and manage client chat sessions. A session represents an interactive conversation initiated by a user through an API to engage with an agent. It involves a series of exchanges where the user sends queries or prompts, and the agent responds with relevant information, actions, or assistance based on the user's input. The session persists for the duration of the interaction, maintaining context and continuity to provide coherent and meaningful responses throughout the conversation.
// For creating and managing agents, knowledge bases, data sources, endpoints, and data ingestion jobs see the /EN/generative-ai-agents/latest/.
// To learn more about the service, see the Generative AI Agents documentation (https://docs.oracle.com/iaas/Content/generative-ai-agents/home.htm).
//

package generativeaiagentruntime

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// Message The Message resource generated by the agent.
type Message struct {

	// The role of the sender of this message.
	Role MessageRoleEnum `mandatory:"true" json:"role"`

	Content *MessageContent `mandatory:"true" json:"content"`

	// The date and time that the message was created in the format of an RFC3339 datetime string.
	TimeCreated *common.SDKTime `mandatory:"false" json:"timeCreated"`
}

func (m Message) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m Message) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingMessageRoleEnum(string(m.Role)); !ok && m.Role != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Role: %s. Supported values are: %s.", m.Role, strings.Join(GetMessageRoleEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// MessageRoleEnum Enum with underlying type: string
type MessageRoleEnum string

// Set of constants representing the allowable values for MessageRoleEnum
const (
	MessageRoleUser  MessageRoleEnum = "USER"
	MessageRoleAgent MessageRoleEnum = "AGENT"
)

var mappingMessageRoleEnum = map[string]MessageRoleEnum{
	"USER":  MessageRoleUser,
	"AGENT": MessageRoleAgent,
}

var mappingMessageRoleEnumLowerCase = map[string]MessageRoleEnum{
	"user":  MessageRoleUser,
	"agent": MessageRoleAgent,
}

// GetMessageRoleEnumValues Enumerates the set of values for MessageRoleEnum
func GetMessageRoleEnumValues() []MessageRoleEnum {
	values := make([]MessageRoleEnum, 0)
	for _, v := range mappingMessageRoleEnum {
		values = append(values, v)
	}
	return values
}

// GetMessageRoleEnumStringValues Enumerates the set of values in String for MessageRoleEnum
func GetMessageRoleEnumStringValues() []string {
	return []string{
		"USER",
		"AGENT",
	}
}

// GetMappingMessageRoleEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingMessageRoleEnum(val string) (MessageRoleEnum, bool) {
	enum, ok := mappingMessageRoleEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
