// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/stable/2021-12-21/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// BoundaryServiceResetControllerConfigurationReader is a Reader for the BoundaryServiceResetControllerConfiguration structure.
type BoundaryServiceResetControllerConfigurationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BoundaryServiceResetControllerConfigurationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBoundaryServiceResetControllerConfigurationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBoundaryServiceResetControllerConfigurationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBoundaryServiceResetControllerConfigurationOK creates a BoundaryServiceResetControllerConfigurationOK with default headers values
func NewBoundaryServiceResetControllerConfigurationOK() *BoundaryServiceResetControllerConfigurationOK {
	return &BoundaryServiceResetControllerConfigurationOK{}
}

/*
BoundaryServiceResetControllerConfigurationOK describes a response with status code 200, with default header values.

A successful response.
*/
type BoundaryServiceResetControllerConfigurationOK struct {
	Payload models.HashicorpCloudBoundary20211221ResetControllerConfigurationResponse
}

// IsSuccess returns true when this boundary service reset controller configuration o k response has a 2xx status code
func (o *BoundaryServiceResetControllerConfigurationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this boundary service reset controller configuration o k response has a 3xx status code
func (o *BoundaryServiceResetControllerConfigurationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this boundary service reset controller configuration o k response has a 4xx status code
func (o *BoundaryServiceResetControllerConfigurationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this boundary service reset controller configuration o k response has a 5xx status code
func (o *BoundaryServiceResetControllerConfigurationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this boundary service reset controller configuration o k response a status code equal to that given
func (o *BoundaryServiceResetControllerConfigurationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the boundary service reset controller configuration o k response
func (o *BoundaryServiceResetControllerConfigurationOK) Code() int {
	return 200
}

func (o *BoundaryServiceResetControllerConfigurationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/controller-configuration][%d] boundaryServiceResetControllerConfigurationOK %s", 200, payload)
}

func (o *BoundaryServiceResetControllerConfigurationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/controller-configuration][%d] boundaryServiceResetControllerConfigurationOK %s", 200, payload)
}

func (o *BoundaryServiceResetControllerConfigurationOK) GetPayload() models.HashicorpCloudBoundary20211221ResetControllerConfigurationResponse {
	return o.Payload
}

func (o *BoundaryServiceResetControllerConfigurationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBoundaryServiceResetControllerConfigurationDefault creates a BoundaryServiceResetControllerConfigurationDefault with default headers values
func NewBoundaryServiceResetControllerConfigurationDefault(code int) *BoundaryServiceResetControllerConfigurationDefault {
	return &BoundaryServiceResetControllerConfigurationDefault{
		_statusCode: code,
	}
}

/*
BoundaryServiceResetControllerConfigurationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BoundaryServiceResetControllerConfigurationDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this boundary service reset controller configuration default response has a 2xx status code
func (o *BoundaryServiceResetControllerConfigurationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this boundary service reset controller configuration default response has a 3xx status code
func (o *BoundaryServiceResetControllerConfigurationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this boundary service reset controller configuration default response has a 4xx status code
func (o *BoundaryServiceResetControllerConfigurationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this boundary service reset controller configuration default response has a 5xx status code
func (o *BoundaryServiceResetControllerConfigurationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this boundary service reset controller configuration default response a status code equal to that given
func (o *BoundaryServiceResetControllerConfigurationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the boundary service reset controller configuration default response
func (o *BoundaryServiceResetControllerConfigurationDefault) Code() int {
	return o._statusCode
}

func (o *BoundaryServiceResetControllerConfigurationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/controller-configuration][%d] BoundaryService_ResetControllerConfiguration default %s", o._statusCode, payload)
}

func (o *BoundaryServiceResetControllerConfigurationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/controller-configuration][%d] BoundaryService_ResetControllerConfiguration default %s", o._statusCode, payload)
}

func (o *BoundaryServiceResetControllerConfigurationDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *BoundaryServiceResetControllerConfigurationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
