// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceUploadSbomReader is a Reader for the PackerServiceUploadSbom structure.
type PackerServiceUploadSbomReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceUploadSbomReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceUploadSbomOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceUploadSbomDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceUploadSbomOK creates a PackerServiceUploadSbomOK with default headers values
func NewPackerServiceUploadSbomOK() *PackerServiceUploadSbomOK {
	return &PackerServiceUploadSbomOK{}
}

/*
PackerServiceUploadSbomOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceUploadSbomOK struct {
	Payload *models.HashicorpCloudPacker20230101UploadSbomResponse
}

// IsSuccess returns true when this packer service upload sbom o k response has a 2xx status code
func (o *PackerServiceUploadSbomOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service upload sbom o k response has a 3xx status code
func (o *PackerServiceUploadSbomOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service upload sbom o k response has a 4xx status code
func (o *PackerServiceUploadSbomOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service upload sbom o k response has a 5xx status code
func (o *PackerServiceUploadSbomOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service upload sbom o k response a status code equal to that given
func (o *PackerServiceUploadSbomOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service upload sbom o k response
func (o *PackerServiceUploadSbomOK) Code() int {
	return 200
}

func (o *PackerServiceUploadSbomOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms][%d] packerServiceUploadSbomOK %s", 200, payload)
}

func (o *PackerServiceUploadSbomOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms][%d] packerServiceUploadSbomOK %s", 200, payload)
}

func (o *PackerServiceUploadSbomOK) GetPayload() *models.HashicorpCloudPacker20230101UploadSbomResponse {
	return o.Payload
}

func (o *PackerServiceUploadSbomOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101UploadSbomResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceUploadSbomDefault creates a PackerServiceUploadSbomDefault with default headers values
func NewPackerServiceUploadSbomDefault(code int) *PackerServiceUploadSbomDefault {
	return &PackerServiceUploadSbomDefault{
		_statusCode: code,
	}
}

/*
PackerServiceUploadSbomDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceUploadSbomDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service upload sbom default response has a 2xx status code
func (o *PackerServiceUploadSbomDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service upload sbom default response has a 3xx status code
func (o *PackerServiceUploadSbomDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service upload sbom default response has a 4xx status code
func (o *PackerServiceUploadSbomDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service upload sbom default response has a 5xx status code
func (o *PackerServiceUploadSbomDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service upload sbom default response a status code equal to that given
func (o *PackerServiceUploadSbomDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service upload sbom default response
func (o *PackerServiceUploadSbomDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceUploadSbomDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms][%d] PackerService_UploadSbom default %s", o._statusCode, payload)
}

func (o *PackerServiceUploadSbomDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms][%d] PackerService_UploadSbom default %s", o._statusCode, payload)
}

func (o *PackerServiceUploadSbomDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceUploadSbomDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
