// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// DeactivateRegistryReader is a Reader for the DeactivateRegistry structure.
type DeactivateRegistryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeactivateRegistryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeactivateRegistryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeactivateRegistryDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeactivateRegistryOK creates a DeactivateRegistryOK with default headers values
func NewDeactivateRegistryOK() *DeactivateRegistryOK {
	return &DeactivateRegistryOK{}
}

/*
DeactivateRegistryOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeactivateRegistryOK struct {
	Payload models.HashicorpCloudVagrant20220930DeactivateRegistryResponse
}

// IsSuccess returns true when this deactivate registry o k response has a 2xx status code
func (o *DeactivateRegistryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this deactivate registry o k response has a 3xx status code
func (o *DeactivateRegistryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this deactivate registry o k response has a 4xx status code
func (o *DeactivateRegistryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this deactivate registry o k response has a 5xx status code
func (o *DeactivateRegistryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this deactivate registry o k response a status code equal to that given
func (o *DeactivateRegistryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the deactivate registry o k response
func (o *DeactivateRegistryOK) Code() int {
	return 200
}

func (o *DeactivateRegistryOK) Error() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/deactivate][%d] deactivateRegistryOK  %+v", 200, o.Payload)
}

func (o *DeactivateRegistryOK) String() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/deactivate][%d] deactivateRegistryOK  %+v", 200, o.Payload)
}

func (o *DeactivateRegistryOK) GetPayload() models.HashicorpCloudVagrant20220930DeactivateRegistryResponse {
	return o.Payload
}

func (o *DeactivateRegistryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeactivateRegistryDefault creates a DeactivateRegistryDefault with default headers values
func NewDeactivateRegistryDefault(code int) *DeactivateRegistryDefault {
	return &DeactivateRegistryDefault{
		_statusCode: code,
	}
}

/*
DeactivateRegistryDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeactivateRegistryDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this deactivate registry default response has a 2xx status code
func (o *DeactivateRegistryDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this deactivate registry default response has a 3xx status code
func (o *DeactivateRegistryDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this deactivate registry default response has a 4xx status code
func (o *DeactivateRegistryDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this deactivate registry default response has a 5xx status code
func (o *DeactivateRegistryDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this deactivate registry default response a status code equal to that given
func (o *DeactivateRegistryDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the deactivate registry default response
func (o *DeactivateRegistryDefault) Code() int {
	return o._statusCode
}

func (o *DeactivateRegistryDefault) Error() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/deactivate][%d] DeactivateRegistry default  %+v", o._statusCode, o.Payload)
}

func (o *DeactivateRegistryDefault) String() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/deactivate][%d] DeactivateRegistry default  %+v", o._statusCode, o.Payload)
}

func (o *DeactivateRegistryDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *DeactivateRegistryDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
