// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewListAppSecretsParams creates a new ListAppSecretsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListAppSecretsParams() *ListAppSecretsParams {
	return &ListAppSecretsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListAppSecretsParamsWithTimeout creates a new ListAppSecretsParams object
// with the ability to set a timeout on a request.
func NewListAppSecretsParamsWithTimeout(timeout time.Duration) *ListAppSecretsParams {
	return &ListAppSecretsParams{
		timeout: timeout,
	}
}

// NewListAppSecretsParamsWithContext creates a new ListAppSecretsParams object
// with the ability to set a context for a request.
func NewListAppSecretsParamsWithContext(ctx context.Context) *ListAppSecretsParams {
	return &ListAppSecretsParams{
		Context: ctx,
	}
}

// NewListAppSecretsParamsWithHTTPClient creates a new ListAppSecretsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListAppSecretsParamsWithHTTPClient(client *http.Client) *ListAppSecretsParams {
	return &ListAppSecretsParams{
		HTTPClient: client,
	}
}

/*
ListAppSecretsParams contains all the parameters to send to the API endpoint

	for the list app secrets operation.

	Typically these are written to a http.Request.
*/
type ListAppSecretsParams struct {

	// AppName.
	AppName string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list app secrets params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListAppSecretsParams) WithDefaults() *ListAppSecretsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list app secrets params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListAppSecretsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list app secrets params
func (o *ListAppSecretsParams) WithTimeout(timeout time.Duration) *ListAppSecretsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list app secrets params
func (o *ListAppSecretsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list app secrets params
func (o *ListAppSecretsParams) WithContext(ctx context.Context) *ListAppSecretsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list app secrets params
func (o *ListAppSecretsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list app secrets params
func (o *ListAppSecretsParams) WithHTTPClient(client *http.Client) *ListAppSecretsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list app secrets params
func (o *ListAppSecretsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the list app secrets params
func (o *ListAppSecretsParams) WithAppName(appName string) *ListAppSecretsParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the list app secrets params
func (o *ListAppSecretsParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithLocationOrganizationID adds the locationOrganizationID to the list app secrets params
func (o *ListAppSecretsParams) WithLocationOrganizationID(locationOrganizationID string) *ListAppSecretsParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the list app secrets params
func (o *ListAppSecretsParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the list app secrets params
func (o *ListAppSecretsParams) WithLocationProjectID(locationProjectID string) *ListAppSecretsParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the list app secrets params
func (o *ListAppSecretsParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the list app secrets params
func (o *ListAppSecretsParams) WithLocationRegionProvider(locationRegionProvider *string) *ListAppSecretsParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the list app secrets params
func (o *ListAppSecretsParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the list app secrets params
func (o *ListAppSecretsParams) WithLocationRegionRegion(locationRegionRegion *string) *ListAppSecretsParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the list app secrets params
func (o *ListAppSecretsParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *ListAppSecretsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
