// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewUnlockProjectParams creates a new UnlockProjectParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnlockProjectParams() *UnlockProjectParams {
	return &UnlockProjectParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnlockProjectParamsWithTimeout creates a new UnlockProjectParams object
// with the ability to set a timeout on a request.
func NewUnlockProjectParamsWithTimeout(timeout time.Duration) *UnlockProjectParams {
	return &UnlockProjectParams{
		timeout: timeout,
	}
}

// NewUnlockProjectParamsWithContext creates a new UnlockProjectParams object
// with the ability to set a context for a request.
func NewUnlockProjectParamsWithContext(ctx context.Context) *UnlockProjectParams {
	return &UnlockProjectParams{
		Context: ctx,
	}
}

// NewUnlockProjectParamsWithHTTPClient creates a new UnlockProjectParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnlockProjectParamsWithHTTPClient(client *http.Client) *UnlockProjectParams {
	return &UnlockProjectParams{
		HTTPClient: client,
	}
}

/*
UnlockProjectParams contains all the parameters to send to the API endpoint

	for the unlock project operation.

	Typically these are written to a http.Request.
*/
type UnlockProjectParams struct {

	// Body.
	Body models.SecretServiceUnlockProjectBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unlock project params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnlockProjectParams) WithDefaults() *UnlockProjectParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unlock project params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnlockProjectParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the unlock project params
func (o *UnlockProjectParams) WithTimeout(timeout time.Duration) *UnlockProjectParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unlock project params
func (o *UnlockProjectParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unlock project params
func (o *UnlockProjectParams) WithContext(ctx context.Context) *UnlockProjectParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unlock project params
func (o *UnlockProjectParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unlock project params
func (o *UnlockProjectParams) WithHTTPClient(client *http.Client) *UnlockProjectParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unlock project params
func (o *UnlockProjectParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the unlock project params
func (o *UnlockProjectParams) WithBody(body models.SecretServiceUnlockProjectBody) *UnlockProjectParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the unlock project params
func (o *UnlockProjectParams) SetBody(body models.SecretServiceUnlockProjectBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the unlock project params
func (o *UnlockProjectParams) WithOrganizationID(organizationID string) *UnlockProjectParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the unlock project params
func (o *UnlockProjectParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the unlock project params
func (o *UnlockProjectParams) WithProjectID(projectID string) *UnlockProjectParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the unlock project params
func (o *UnlockProjectParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *UnlockProjectParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
