// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceGetAddOnDefinitionParams creates a new WaypointServiceGetAddOnDefinitionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceGetAddOnDefinitionParams() *WaypointServiceGetAddOnDefinitionParams {
	return &WaypointServiceGetAddOnDefinitionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceGetAddOnDefinitionParamsWithTimeout creates a new WaypointServiceGetAddOnDefinitionParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceGetAddOnDefinitionParamsWithTimeout(timeout time.Duration) *WaypointServiceGetAddOnDefinitionParams {
	return &WaypointServiceGetAddOnDefinitionParams{
		timeout: timeout,
	}
}

// NewWaypointServiceGetAddOnDefinitionParamsWithContext creates a new WaypointServiceGetAddOnDefinitionParams object
// with the ability to set a context for a request.
func NewWaypointServiceGetAddOnDefinitionParamsWithContext(ctx context.Context) *WaypointServiceGetAddOnDefinitionParams {
	return &WaypointServiceGetAddOnDefinitionParams{
		Context: ctx,
	}
}

// NewWaypointServiceGetAddOnDefinitionParamsWithHTTPClient creates a new WaypointServiceGetAddOnDefinitionParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceGetAddOnDefinitionParamsWithHTTPClient(client *http.Client) *WaypointServiceGetAddOnDefinitionParams {
	return &WaypointServiceGetAddOnDefinitionParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceGetAddOnDefinitionParams contains all the parameters to send to the API endpoint

	for the waypoint service get add on definition operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceGetAddOnDefinitionParams struct {

	// AddOnDefinitionID.
	AddOnDefinitionID string

	// AddOnDefinitionName.
	AddOnDefinitionName *string

	// NamespaceID.
	NamespaceID *string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service get add on definition params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetAddOnDefinitionParams) WithDefaults() *WaypointServiceGetAddOnDefinitionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service get add on definition params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetAddOnDefinitionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) WithTimeout(timeout time.Duration) *WaypointServiceGetAddOnDefinitionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) WithContext(ctx context.Context) *WaypointServiceGetAddOnDefinitionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) WithHTTPClient(client *http.Client) *WaypointServiceGetAddOnDefinitionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddOnDefinitionID adds the addOnDefinitionID to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) WithAddOnDefinitionID(addOnDefinitionID string) *WaypointServiceGetAddOnDefinitionParams {
	o.SetAddOnDefinitionID(addOnDefinitionID)
	return o
}

// SetAddOnDefinitionID adds the addOnDefinitionId to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) SetAddOnDefinitionID(addOnDefinitionID string) {
	o.AddOnDefinitionID = addOnDefinitionID
}

// WithAddOnDefinitionName adds the addOnDefinitionName to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) WithAddOnDefinitionName(addOnDefinitionName *string) *WaypointServiceGetAddOnDefinitionParams {
	o.SetAddOnDefinitionName(addOnDefinitionName)
	return o
}

// SetAddOnDefinitionName adds the addOnDefinitionName to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) SetAddOnDefinitionName(addOnDefinitionName *string) {
	o.AddOnDefinitionName = addOnDefinitionName
}

// WithNamespaceID adds the namespaceID to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) WithNamespaceID(namespaceID *string) *WaypointServiceGetAddOnDefinitionParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) SetNamespaceID(namespaceID *string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) *WaypointServiceGetAddOnDefinitionParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) WithNamespaceLocationProjectID(namespaceLocationProjectID string) *WaypointServiceGetAddOnDefinitionParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) SetNamespaceLocationProjectID(namespaceLocationProjectID string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceGetAddOnDefinitionParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceGetAddOnDefinitionParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get add on definition params
func (o *WaypointServiceGetAddOnDefinitionParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceGetAddOnDefinitionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param add_on_definition.id
	if err := r.SetPathParam("add_on_definition.id", o.AddOnDefinitionID); err != nil {
		return err
	}

	if o.AddOnDefinitionName != nil {

		// query param add_on_definition.name
		var qrAddOnDefinitionName string

		if o.AddOnDefinitionName != nil {
			qrAddOnDefinitionName = *o.AddOnDefinitionName
		}
		qAddOnDefinitionName := qrAddOnDefinitionName
		if qAddOnDefinitionName != "" {

			if err := r.SetQueryParam("add_on_definition.name", qAddOnDefinitionName); err != nil {
				return err
			}
		}
	}

	if o.NamespaceID != nil {

		// query param namespace.id
		var qrNamespaceID string

		if o.NamespaceID != nil {
			qrNamespaceID = *o.NamespaceID
		}
		qNamespaceID := qrNamespaceID
		if qNamespaceID != "" {

			if err := r.SetQueryParam("namespace.id", qNamespaceID); err != nil {
				return err
			}
		}
	}

	// path param namespace.location.organization_id
	if err := r.SetPathParam("namespace.location.organization_id", o.NamespaceLocationOrganizationID); err != nil {
		return err
	}

	// path param namespace.location.project_id
	if err := r.SetPathParam("namespace.location.project_id", o.NamespaceLocationProjectID); err != nil {
		return err
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
