// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceGetApplicationParams creates a new WaypointServiceGetApplicationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceGetApplicationParams() *WaypointServiceGetApplicationParams {
	return &WaypointServiceGetApplicationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceGetApplicationParamsWithTimeout creates a new WaypointServiceGetApplicationParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceGetApplicationParamsWithTimeout(timeout time.Duration) *WaypointServiceGetApplicationParams {
	return &WaypointServiceGetApplicationParams{
		timeout: timeout,
	}
}

// NewWaypointServiceGetApplicationParamsWithContext creates a new WaypointServiceGetApplicationParams object
// with the ability to set a context for a request.
func NewWaypointServiceGetApplicationParamsWithContext(ctx context.Context) *WaypointServiceGetApplicationParams {
	return &WaypointServiceGetApplicationParams{
		Context: ctx,
	}
}

// NewWaypointServiceGetApplicationParamsWithHTTPClient creates a new WaypointServiceGetApplicationParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceGetApplicationParamsWithHTTPClient(client *http.Client) *WaypointServiceGetApplicationParams {
	return &WaypointServiceGetApplicationParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceGetApplicationParams contains all the parameters to send to the API endpoint

	for the waypoint service get application operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceGetApplicationParams struct {

	// ApplicationID.
	ApplicationID string

	// ApplicationName.
	ApplicationName *string

	// NamespaceID.
	NamespaceID *string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service get application params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetApplicationParams) WithDefaults() *WaypointServiceGetApplicationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service get application params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetApplicationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) WithTimeout(timeout time.Duration) *WaypointServiceGetApplicationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) WithContext(ctx context.Context) *WaypointServiceGetApplicationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) WithHTTPClient(client *http.Client) *WaypointServiceGetApplicationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationID adds the applicationID to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) WithApplicationID(applicationID string) *WaypointServiceGetApplicationParams {
	o.SetApplicationID(applicationID)
	return o
}

// SetApplicationID adds the applicationId to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) SetApplicationID(applicationID string) {
	o.ApplicationID = applicationID
}

// WithApplicationName adds the applicationName to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) WithApplicationName(applicationName *string) *WaypointServiceGetApplicationParams {
	o.SetApplicationName(applicationName)
	return o
}

// SetApplicationName adds the applicationName to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) SetApplicationName(applicationName *string) {
	o.ApplicationName = applicationName
}

// WithNamespaceID adds the namespaceID to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) WithNamespaceID(namespaceID *string) *WaypointServiceGetApplicationParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) SetNamespaceID(namespaceID *string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) *WaypointServiceGetApplicationParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) WithNamespaceLocationProjectID(namespaceLocationProjectID string) *WaypointServiceGetApplicationParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) SetNamespaceLocationProjectID(namespaceLocationProjectID string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceGetApplicationParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceGetApplicationParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get application params
func (o *WaypointServiceGetApplicationParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceGetApplicationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.id
	if err := r.SetPathParam("application.id", o.ApplicationID); err != nil {
		return err
	}

	if o.ApplicationName != nil {

		// query param application.name
		var qrApplicationName string

		if o.ApplicationName != nil {
			qrApplicationName = *o.ApplicationName
		}
		qApplicationName := qrApplicationName
		if qApplicationName != "" {

			if err := r.SetQueryParam("application.name", qApplicationName); err != nil {
				return err
			}
		}
	}

	if o.NamespaceID != nil {

		// query param namespace.id
		var qrNamespaceID string

		if o.NamespaceID != nil {
			qrNamespaceID = *o.NamespaceID
		}
		qNamespaceID := qrNamespaceID
		if qNamespaceID != "" {

			if err := r.SetQueryParam("namespace.id", qNamespaceID); err != nil {
				return err
			}
		}
	}

	// path param namespace.location.organization_id
	if err := r.SetPathParam("namespace.location.organization_id", o.NamespaceLocationOrganizationID); err != nil {
		return err
	}

	// path param namespace.location.project_id
	if err := r.SetPathParam("namespace.location.project_id", o.NamespaceLocationProjectID); err != nil {
		return err
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
