// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type AttachSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// The security profile that is attached.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`

	// The ARN of the target (thing group) to which the security profile is attached.
	//
	// SecurityProfileTargetArn is a required field
	SecurityProfileTargetArn *string `location:"querystring" locationName:"securityProfileTargetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachSecurityProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttachSecurityProfileInput"}

	if s.SecurityProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityProfileName", 1))
	}

	if s.SecurityProfileTargetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityProfileTargetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttachSecurityProfileInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.SecurityProfileName != nil {
		v := *s.SecurityProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "securityProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityProfileTargetArn != nil {
		v := *s.SecurityProfileTargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "securityProfileTargetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AttachSecurityProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttachSecurityProfileOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opAttachSecurityProfile = "AttachSecurityProfile"

// AttachSecurityProfileRequest returns a request value for making API operation for
// AWS IoT.
//
// Associates a Device Defender security profile with a thing group or this
// account. Each thing group or account can have up to five security profiles
// associated with it.
//
//    // Example sending a request using AttachSecurityProfileRequest.
//    req := client.AttachSecurityProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) AttachSecurityProfileRequest(input *AttachSecurityProfileInput) AttachSecurityProfileRequest {
	op := &aws.Operation{
		Name:       opAttachSecurityProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/security-profiles/{securityProfileName}/targets",
	}

	if input == nil {
		input = &AttachSecurityProfileInput{}
	}

	req := c.newRequest(op, input, &AttachSecurityProfileOutput{})
	return AttachSecurityProfileRequest{Request: req, Input: input, Copy: c.AttachSecurityProfileRequest}
}

// AttachSecurityProfileRequest is the request type for the
// AttachSecurityProfile API operation.
type AttachSecurityProfileRequest struct {
	*aws.Request
	Input *AttachSecurityProfileInput
	Copy  func(*AttachSecurityProfileInput) AttachSecurityProfileRequest
}

// Send marshals and sends the AttachSecurityProfile API request.
func (r AttachSecurityProfileRequest) Send(ctx context.Context) (*AttachSecurityProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AttachSecurityProfileResponse{
		AttachSecurityProfileOutput: r.Request.Data.(*AttachSecurityProfileOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AttachSecurityProfileResponse is the response type for the
// AttachSecurityProfile API operation.
type AttachSecurityProfileResponse struct {
	*AttachSecurityProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AttachSecurityProfile request.
func (r *AttachSecurityProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
